// components/autofill/core/common/mojom/autofill_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/autofill/core/common/mojom/autofill_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/autofill/core/common/mojom/autofill_types.mojom-params-data.h"
namespace autofill {
namespace mojom {

NOINLINE static const char* FormControlTypeToStringHelper(FormControlType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FormControlType::kContentEditable:
      return "kContentEditable";
    case FormControlType::kInputCheckbox:
      return "kInputCheckbox";
    case FormControlType::kInputEmail:
      return "kInputEmail";
    case FormControlType::kInputMonth:
      return "kInputMonth";
    case FormControlType::kInputNumber:
      return "kInputNumber";
    case FormControlType::kInputPassword:
      return "kInputPassword";
    case FormControlType::kInputRadio:
      return "kInputRadio";
    case FormControlType::kInputSearch:
      return "kInputSearch";
    case FormControlType::kInputTelephone:
      return "kInputTelephone";
    case FormControlType::kInputText:
      return "kInputText";
    case FormControlType::kInputUrl:
      return "kInputUrl";
    case FormControlType::kSelectOne:
      return "kSelectOne";
    case FormControlType::kTextArea:
      return "kTextArea";
    case FormControlType::kInputDate:
      return "kInputDate";
    default:
      return nullptr;
  }
}

std::string FormControlTypeToString(FormControlType value) {
  const char *str = FormControlTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FormControlType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FormControlType value) {
  return os << FormControlTypeToString(value);
}

NOINLINE static const char* HtmlFieldModeToStringHelper(HtmlFieldMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case HtmlFieldMode::kNone:
      return "kNone";
    case HtmlFieldMode::kBilling:
      return "kBilling";
    case HtmlFieldMode::kShipping:
      return "kShipping";
    default:
      return nullptr;
  }
}

std::string HtmlFieldModeToString(HtmlFieldMode value) {
  const char *str = HtmlFieldModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown HtmlFieldMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, HtmlFieldMode value) {
  return os << HtmlFieldModeToString(value);
}

NOINLINE static const char* HtmlFieldTypeToStringHelper(HtmlFieldType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case HtmlFieldType::kUnspecified:
      return "kUnspecified";
    case HtmlFieldType::kName:
      return "kName";
    case HtmlFieldType::kHonorificPrefix:
      return "kHonorificPrefix";
    case HtmlFieldType::kGivenName:
      return "kGivenName";
    case HtmlFieldType::kAdditionalName:
      return "kAdditionalName";
    case HtmlFieldType::kFamilyName:
      return "kFamilyName";
    case HtmlFieldType::kOrganization:
      return "kOrganization";
    case HtmlFieldType::kStreetAddress:
      return "kStreetAddress";
    case HtmlFieldType::kAddressLine1:
      return "kAddressLine1";
    case HtmlFieldType::kAddressLine2:
      return "kAddressLine2";
    case HtmlFieldType::kAddressLine3:
      return "kAddressLine3";
    case HtmlFieldType::kAddressLevel1:
      return "kAddressLevel1";
    case HtmlFieldType::kAddressLevel2:
      return "kAddressLevel2";
    case HtmlFieldType::kAddressLevel3:
      return "kAddressLevel3";
    case HtmlFieldType::kCountryCode:
      return "kCountryCode";
    case HtmlFieldType::kCountryName:
      return "kCountryName";
    case HtmlFieldType::kPostalCode:
      return "kPostalCode";
    case HtmlFieldType::kCreditCardNameFull:
      return "kCreditCardNameFull";
    case HtmlFieldType::kCreditCardNameFirst:
      return "kCreditCardNameFirst";
    case HtmlFieldType::kCreditCardNameLast:
      return "kCreditCardNameLast";
    case HtmlFieldType::kCreditCardNumber:
      return "kCreditCardNumber";
    case HtmlFieldType::kCreditCardExp:
      return "kCreditCardExp";
    case HtmlFieldType::kCreditCardExpMonth:
      return "kCreditCardExpMonth";
    case HtmlFieldType::kCreditCardExpYear:
      return "kCreditCardExpYear";
    case HtmlFieldType::kCreditCardVerificationCode:
      return "kCreditCardVerificationCode";
    case HtmlFieldType::kCreditCardType:
      return "kCreditCardType";
    case HtmlFieldType::kTel:
      return "kTel";
    case HtmlFieldType::kTelCountryCode:
      return "kTelCountryCode";
    case HtmlFieldType::kTelNational:
      return "kTelNational";
    case HtmlFieldType::kTelAreaCode:
      return "kTelAreaCode";
    case HtmlFieldType::kTelLocal:
      return "kTelLocal";
    case HtmlFieldType::kTelLocalPrefix:
      return "kTelLocalPrefix";
    case HtmlFieldType::kTelLocalSuffix:
      return "kTelLocalSuffix";
    case HtmlFieldType::kTelExtension:
      return "kTelExtension";
    case HtmlFieldType::kEmail:
      return "kEmail";
    case HtmlFieldType::kBirthdateDay:
      return "kBirthdateDay";
    case HtmlFieldType::kBirthdateMonth:
      return "kBirthdateMonth";
    case HtmlFieldType::kBirthdateYear:
      return "kBirthdateYear";
    case HtmlFieldType::kTransactionAmount:
      return "kTransactionAmount";
    case HtmlFieldType::kTransactionCurrency:
      return "kTransactionCurrency";
    case HtmlFieldType::kAdditionalNameInitial:
      return "kAdditionalNameInitial";
    case HtmlFieldType::kCreditCardExpDate2DigitYear:
      return "kCreditCardExpDate2DigitYear";
    case HtmlFieldType::kCreditCardExpDate4DigitYear:
      return "kCreditCardExpDate4DigitYear";
    case HtmlFieldType::kCreditCardExp2DigitYear:
      return "kCreditCardExp2DigitYear";
    case HtmlFieldType::kCreditCardExp4DigitYear:
      return "kCreditCardExp4DigitYear";
    case HtmlFieldType::kOneTimeCode:
      return "kOneTimeCode";
    case HtmlFieldType::kMerchantPromoCode:
      return "kMerchantPromoCode";
    case HtmlFieldType::kIban:
      return "kIban";
    case HtmlFieldType::kUnrecognized:
      return "kUnrecognized";
    default:
      return nullptr;
  }
}

std::string HtmlFieldTypeToString(HtmlFieldType value) {
  const char *str = HtmlFieldTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown HtmlFieldType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, HtmlFieldType value) {
  return os << HtmlFieldTypeToString(value);
}

NOINLINE static const char* SubmissionIndicatorEventToStringHelper(SubmissionIndicatorEvent value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SubmissionIndicatorEvent::NONE:
      return "NONE";
    case SubmissionIndicatorEvent::HTML_FORM_SUBMISSION:
      return "HTML_FORM_SUBMISSION";
    case SubmissionIndicatorEvent::SAME_DOCUMENT_NAVIGATION:
      return "SAME_DOCUMENT_NAVIGATION";
    case SubmissionIndicatorEvent::XHR_SUCCEEDED:
      return "XHR_SUCCEEDED";
    case SubmissionIndicatorEvent::FRAME_DETACHED:
      return "FRAME_DETACHED";
    case SubmissionIndicatorEvent::PROBABLE_FORM_SUBMISSION:
      return "PROBABLE_FORM_SUBMISSION";
    case SubmissionIndicatorEvent::CHANGE_PASSWORD_FORM_CLEARED:
      return "CHANGE_PASSWORD_FORM_CLEARED";
    case SubmissionIndicatorEvent::DOM_MUTATION_AFTER_AUTOFILL:
      return "DOM_MUTATION_AFTER_AUTOFILL";
    default:
      return nullptr;
  }
}

std::string SubmissionIndicatorEventToString(SubmissionIndicatorEvent value) {
  const char *str = SubmissionIndicatorEventToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SubmissionIndicatorEvent value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SubmissionIndicatorEvent value) {
  return os << SubmissionIndicatorEventToString(value);
}

NOINLINE static const char* SubmissionSourceToStringHelper(SubmissionSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SubmissionSource::NONE:
      return "NONE";
    case SubmissionSource::SAME_DOCUMENT_NAVIGATION:
      return "SAME_DOCUMENT_NAVIGATION";
    case SubmissionSource::XHR_SUCCEEDED:
      return "XHR_SUCCEEDED";
    case SubmissionSource::FRAME_DETACHED:
      return "FRAME_DETACHED";
    case SubmissionSource::PROBABLY_FORM_SUBMITTED:
      return "PROBABLY_FORM_SUBMITTED";
    case SubmissionSource::FORM_SUBMISSION:
      return "FORM_SUBMISSION";
    case SubmissionSource::DOM_MUTATION_AFTER_AUTOFILL:
      return "DOM_MUTATION_AFTER_AUTOFILL";
    default:
      return nullptr;
  }
}

std::string SubmissionSourceToString(SubmissionSource value) {
  const char *str = SubmissionSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SubmissionSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SubmissionSource value) {
  return os << SubmissionSourceToString(value);
}

NOINLINE static const char* FocusedFieldTypeToStringHelper(FocusedFieldType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FocusedFieldType::kUnknown:
      return "kUnknown";
    case FocusedFieldType::kUnfillableElement:
      return "kUnfillableElement";
    case FocusedFieldType::kFillableTextArea:
      return "kFillableTextArea";
    case FocusedFieldType::kFillableSearchField:
      return "kFillableSearchField";
    case FocusedFieldType::kFillableNonSearchField:
      return "kFillableNonSearchField";
    case FocusedFieldType::kFillableWebauthnTaggedField:
      return "kFillableWebauthnTaggedField";
    case FocusedFieldType::kFillableUsernameField:
      return "kFillableUsernameField";
    case FocusedFieldType::kFillablePasswordField:
      return "kFillablePasswordField";
    default:
      return nullptr;
  }
}

std::string FocusedFieldTypeToString(FocusedFieldType value) {
  const char *str = FocusedFieldTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FocusedFieldType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FocusedFieldType value) {
  return os << FocusedFieldTypeToString(value);
}

NOINLINE static const char* ButtonTitleTypeToStringHelper(ButtonTitleType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ButtonTitleType::NONE:
      return "NONE";
    case ButtonTitleType::BUTTON_ELEMENT_SUBMIT_TYPE:
      return "BUTTON_ELEMENT_SUBMIT_TYPE";
    case ButtonTitleType::BUTTON_ELEMENT_BUTTON_TYPE:
      return "BUTTON_ELEMENT_BUTTON_TYPE";
    case ButtonTitleType::INPUT_ELEMENT_SUBMIT_TYPE:
      return "INPUT_ELEMENT_SUBMIT_TYPE";
    case ButtonTitleType::INPUT_ELEMENT_BUTTON_TYPE:
      return "INPUT_ELEMENT_BUTTON_TYPE";
    case ButtonTitleType::HYPERLINK:
      return "HYPERLINK";
    case ButtonTitleType::DIV:
      return "DIV";
    case ButtonTitleType::SPAN:
      return "SPAN";
    default:
      return nullptr;
  }
}

std::string ButtonTitleTypeToString(ButtonTitleType value) {
  const char *str = ButtonTitleTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ButtonTitleType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ButtonTitleType value) {
  return os << ButtonTitleTypeToString(value);
}

NOINLINE static const char* SubmissionReadinessStateToStringHelper(SubmissionReadinessState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SubmissionReadinessState::kNoInformation:
      return "kNoInformation";
    case SubmissionReadinessState::kError:
      return "kError";
    case SubmissionReadinessState::kNoUsernameField:
      return "kNoUsernameField";
    case SubmissionReadinessState::kFieldBetweenUsernameAndPassword:
      return "kFieldBetweenUsernameAndPassword";
    case SubmissionReadinessState::kFieldAfterPasswordField:
      return "kFieldAfterPasswordField";
    case SubmissionReadinessState::kEmptyFields:
      return "kEmptyFields";
    case SubmissionReadinessState::kMoreThanTwoFields:
      return "kMoreThanTwoFields";
    case SubmissionReadinessState::kTwoFields:
      return "kTwoFields";
    case SubmissionReadinessState::kNoPasswordField:
      return "kNoPasswordField";
    case SubmissionReadinessState::kLikelyHasCaptcha:
      return "kLikelyHasCaptcha";
    default:
      return nullptr;
  }
}

std::string SubmissionReadinessStateToString(SubmissionReadinessState value) {
  const char *str = SubmissionReadinessStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SubmissionReadinessState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SubmissionReadinessState value) {
  return os << SubmissionReadinessStateToString(value);
}

NOINLINE static const char* AutofillSuggestionAvailabilityToStringHelper(AutofillSuggestionAvailability value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AutofillSuggestionAvailability::kNoSuggestions:
      return "kNoSuggestions";
    case AutofillSuggestionAvailability::kAutofillAvailable:
      return "kAutofillAvailable";
    case AutofillSuggestionAvailability::kAutocompleteAvailable:
      return "kAutocompleteAvailable";
    default:
      return nullptr;
  }
}

std::string AutofillSuggestionAvailabilityToString(AutofillSuggestionAvailability value) {
  const char *str = AutofillSuggestionAvailabilityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AutofillSuggestionAvailability value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AutofillSuggestionAvailability value) {
  return os << AutofillSuggestionAvailabilityToString(value);
}

NOINLINE static const char* ActionPersistenceToStringHelper(ActionPersistence value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ActionPersistence::kFill:
      return "kFill";
    case ActionPersistence::kPreview:
      return "kPreview";
    default:
      return nullptr;
  }
}

std::string ActionPersistenceToString(ActionPersistence value) {
  const char *str = ActionPersistenceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ActionPersistence value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ActionPersistence value) {
  return os << ActionPersistenceToString(value);
}

NOINLINE static const char* FormActionTypeToStringHelper(FormActionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FormActionType::kFill:
      return "kFill";
    case FormActionType::kUndo:
      return "kUndo";
    default:
      return nullptr;
  }
}

std::string FormActionTypeToString(FormActionType value) {
  const char *str = FormActionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FormActionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FormActionType value) {
  return os << FormActionTypeToString(value);
}

NOINLINE static const char* FieldActionTypeToStringHelper(FieldActionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FieldActionType::kReplaceAll:
      return "kReplaceAll";
    case FieldActionType::kReplaceSelection:
      return "kReplaceSelection";
    case FieldActionType::kSelectAll:
      return "kSelectAll";
    default:
      return nullptr;
  }
}

std::string FieldActionTypeToString(FieldActionType value) {
  const char *str = FieldActionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FieldActionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FieldActionType value) {
  return os << FieldActionTypeToString(value);
}

NOINLINE static const char* AutofillSuggestionTriggerSourceToStringHelper(AutofillSuggestionTriggerSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AutofillSuggestionTriggerSource::kUnspecified:
      return "kUnspecified";
    case AutofillSuggestionTriggerSource::kFormControlElementClicked:
      return "kFormControlElementClicked";
    case AutofillSuggestionTriggerSource::kTextareaFocusedWithoutClick:
      return "kTextareaFocusedWithoutClick";
    case AutofillSuggestionTriggerSource::kContentEditableClicked:
      return "kContentEditableClicked";
    case AutofillSuggestionTriggerSource::kTextFieldValueChanged:
      return "kTextFieldValueChanged";
    case AutofillSuggestionTriggerSource::kTextFieldDidReceiveKeyDown:
      return "kTextFieldDidReceiveKeyDown";
    case AutofillSuggestionTriggerSource::kOpenTextDataListChooser:
      return "kOpenTextDataListChooser";
    case AutofillSuggestionTriggerSource::kPasswordManager:
      return "kPasswordManager";
    case AutofillSuggestionTriggerSource::kiOS:
      return "kiOS";
    case AutofillSuggestionTriggerSource::kManualFallbackPasswords:
      return "kManualFallbackPasswords";
    case AutofillSuggestionTriggerSource::kManualFallbackPlusAddresses:
      return "kManualFallbackPlusAddresses";
    case AutofillSuggestionTriggerSource::kShowPromptAfterDialogClosedNonManualFallback:
      return "kShowPromptAfterDialogClosedNonManualFallback";
    case AutofillSuggestionTriggerSource::kComposeDialogLostFocus:
      return "kComposeDialogLostFocus";
    case AutofillSuggestionTriggerSource::kComposeDelayedProactiveNudge:
      return "kComposeDelayedProactiveNudge";
    case AutofillSuggestionTriggerSource::kPasswordManagerProcessedFocusedField:
      return "kPasswordManagerProcessedFocusedField";
    case AutofillSuggestionTriggerSource::kAutofillAi:
      return "kAutofillAi";
    case AutofillSuggestionTriggerSource::kPlusAddressUpdatedInBrowserProcess:
      return "kPlusAddressUpdatedInBrowserProcess";
    case AutofillSuggestionTriggerSource::kProactivePasswordRecovery:
      return "kProactivePasswordRecovery";
    default:
      return nullptr;
  }
}

std::string AutofillSuggestionTriggerSourceToString(AutofillSuggestionTriggerSource value) {
  const char *str = AutofillSuggestionTriggerSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AutofillSuggestionTriggerSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AutofillSuggestionTriggerSource value) {
  return os << AutofillSuggestionTriggerSourceToString(value);
}

NOINLINE static const char* FormFieldData_CheckStatusToStringHelper(FormFieldData_CheckStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FormFieldData_CheckStatus::kNotCheckable:
      return "kNotCheckable";
    case FormFieldData_CheckStatus::kCheckableButUnchecked:
      return "kCheckableButUnchecked";
    case FormFieldData_CheckStatus::kChecked:
      return "kChecked";
    default:
      return nullptr;
  }
}

std::string FormFieldData_CheckStatusToString(FormFieldData_CheckStatus value) {
  const char *str = FormFieldData_CheckStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FormFieldData_CheckStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FormFieldData_CheckStatus value) {
  return os << FormFieldData_CheckStatusToString(value);
}

NOINLINE static const char* FormFieldData_RoleAttributeToStringHelper(FormFieldData_RoleAttribute value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FormFieldData_RoleAttribute::kPresentation:
      return "kPresentation";
    case FormFieldData_RoleAttribute::kOther:
      return "kOther";
    default:
      return nullptr;
  }
}

std::string FormFieldData_RoleAttributeToString(FormFieldData_RoleAttribute value) {
  const char *str = FormFieldData_RoleAttributeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FormFieldData_RoleAttribute value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FormFieldData_RoleAttribute value) {
  return os << FormFieldData_RoleAttributeToString(value);
}

NOINLINE static const char* FormFieldData_LabelSourceToStringHelper(FormFieldData_LabelSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FormFieldData_LabelSource::kUnknown:
      return "kUnknown";
    case FormFieldData_LabelSource::kLabelTag:
      return "kLabelTag";
    case FormFieldData_LabelSource::kPTag:
      return "kPTag";
    case FormFieldData_LabelSource::kDivTable:
      return "kDivTable";
    case FormFieldData_LabelSource::kTdTag:
      return "kTdTag";
    case FormFieldData_LabelSource::kDdTag:
      return "kDdTag";
    case FormFieldData_LabelSource::kLiTag:
      return "kLiTag";
    case FormFieldData_LabelSource::kPlaceHolder:
      return "kPlaceHolder";
    case FormFieldData_LabelSource::kAriaLabel:
      return "kAriaLabel";
    case FormFieldData_LabelSource::kCombined:
      return "kCombined";
    case FormFieldData_LabelSource::kValue:
      return "kValue";
    case FormFieldData_LabelSource::kForId:
      return "kForId";
    case FormFieldData_LabelSource::kForName:
      return "kForName";
    case FormFieldData_LabelSource::kForShadowHostId:
      return "kForShadowHostId";
    case FormFieldData_LabelSource::kForShadowHostName:
      return "kForShadowHostName";
    case FormFieldData_LabelSource::kOverlayingLabel:
      return "kOverlayingLabel";
    default:
      return nullptr;
  }
}

std::string FormFieldData_LabelSourceToString(FormFieldData_LabelSource value) {
  const char *str = FormFieldData_LabelSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FormFieldData_LabelSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FormFieldData_LabelSource value) {
  return os << FormFieldData_LabelSourceToString(value);
}

namespace internal {


// static
bool FrameToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameToken_Data* object =
      static_cast<const FrameToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  return true;
}

FrameToken_Data::FrameToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FrameTokenWithPredecessor_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FrameTokenWithPredecessor_Data* object =
      static_cast<const FrameTokenWithPredecessor_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  return true;
}

FrameTokenWithPredecessor_Data::FrameTokenWithPredecessor_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FormRendererId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FormRendererId_Data* object =
      static_cast<const FormRendererId_Data*>(data);

  return true;
}

FormRendererId_Data::FormRendererId_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FieldRendererId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FieldRendererId_Data* object =
      static_cast<const FieldRendererId_Data*>(data);

  return true;
}

FieldRendererId_Data::FieldRendererId_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SelectOption_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SelectOption_Data* object =
      static_cast<const SelectOption_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  return true;
}

SelectOption_Data::SelectOption_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutocompleteParsingResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutocompleteParsingResult_Data* object =
      static_cast<const AutocompleteParsingResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->section, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& section_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->section, validation_context,
                                         &section_validate_params)) {
    return false;
  }


  if (!::autofill::mojom::internal::HtmlFieldMode_Data
        ::Validate(object->mode, validation_context))
    return false;


  if (!::autofill::mojom::internal::HtmlFieldType_Data
        ::Validate(object->field_type, validation_context))
    return false;

  return true;
}

AutocompleteParsingResult_Data::AutocompleteParsingResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FormFieldData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 200, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FormFieldData_Data* object =
      static_cast<const FormFieldData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->label, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id_attribute, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id_attribute, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name_attribute, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name_attribute, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selected_text, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->selected_text, validation_context))
    return false;


  if (!::autofill::mojom::internal::FormControlType_Data
        ::Validate(object->form_control_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->autocomplete_attribute, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& autocomplete_attribute_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->autocomplete_attribute, validation_context,
                                         &autocomplete_attribute_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->parsed_autocomplete, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pattern, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pattern, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->placeholder, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->placeholder, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->css_classes, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->css_classes, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aria_label, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->aria_label, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aria_description, 14, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->aria_description, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->renderer_id, 15, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host_form_id, 16, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->host_form_id, validation_context))
    return false;


  if (!::autofill::mojom::internal::FormFieldData_CheckStatus_Data
        ::Validate(object->check_status, validation_context))
    return false;


  if (!::autofill::mojom::internal::FormFieldData_RoleAttribute_Data
        ::Validate(object->role, validation_context))
    return false;


  if (!::mojo_base::mojom::internal::TextDirection_Data
        ::Validate(object->text_direction, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_input, 30, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->user_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 32, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& options_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->options, validation_context,
                                         &options_validate_params)) {
    return false;
  }


  if (!::autofill::mojom::internal::FormFieldData_LabelSource_Data
        ::Validate(object->label_source, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 34, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->datalist_options, 35, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& datalist_options_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->datalist_options, validation_context,
                                         &datalist_options_validate_params)) {
    return false;
  }

  return true;
}

FormFieldData_Data::FormFieldData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FormFieldData_FillData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FormFieldData_FillData_Data* object =
      static_cast<const FormFieldData_FillData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->renderer_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host_form_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->host_form_id, validation_context))
    return false;

  return true;
}

FormFieldData_FillData_Data::FormFieldData_FillData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ButtonTitleInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ButtonTitleInfo_Data* object =
      static_cast<const ButtonTitleInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;


  if (!::autofill::mojom::internal::ButtonTitleType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

ButtonTitleInfo_Data::ButtonTitleInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FormData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FormData_Data* object =
      static_cast<const FormData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id_attribute, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id_attribute, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name_attribute, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name_attribute, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->name, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->button_titles, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& button_titles_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->button_titles, validation_context,
                                         &button_titles_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->action, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->action, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->renderer_id, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->child_frames, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& child_frames_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->child_frames, validation_context,
                                         &child_frames_validate_params)) {
    return false;
  }


  if (!::autofill::mojom::internal::SubmissionIndicatorEvent_Data
        ::Validate(object->submission_event, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fields, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& fields_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->fields, validation_context,
                                         &fields_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username_predictions, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& username_predictions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->username_predictions, validation_context,
                                         &username_predictions_validate_params)) {
    return false;
  }

  return true;
}

FormData_Data::FormData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FormFieldDataPredictions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 112, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FormFieldDataPredictions_Data* object =
      static_cast<const FormFieldDataPredictions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host_form_signature, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& host_form_signature_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->host_form_signature, validation_context,
                                         &host_form_signature_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signature, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& signature_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->signature, validation_context,
                                         &signature_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->heuristic_type, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& heuristic_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->heuristic_type, validation_context,
                                         &heuristic_type_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& server_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->server_type, validation_context,
                                         &server_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->html_type, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& html_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->html_type, validation_context,
                                         &html_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->overall_type, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& overall_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->overall_type, validation_context,
                                         &overall_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attribute_types, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& attribute_types_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->attribute_types, validation_context,
                                         &attribute_types_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->format_string, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& format_string_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->format_string, validation_context,
                                         &format_string_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parseable_name, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& parseable_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->parseable_name, validation_context,
                                         &parseable_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parseable_label, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& parseable_label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->parseable_label, validation_context,
                                         &parseable_label_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->section, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& section_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->section, validation_context,
                                         &section_validate_params)) {
    return false;
  }

  return true;
}

FormFieldDataPredictions_Data::FormFieldDataPredictions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FormDataPredictions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FormDataPredictions_Data* object =
      static_cast<const FormDataPredictions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signature, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& signature_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->signature, validation_context,
                                         &signature_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alternative_signature, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& alternative_signature_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->alternative_signature, validation_context,
                                         &alternative_signature_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fields, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& fields_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->fields, validation_context,
                                         &fields_validate_params)) {
    return false;
  }

  return true;
}

FormDataPredictions_Data::FormDataPredictions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordAndMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordAndMetadata_Data* object =
      static_cast<const PasswordAndMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username_value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->username_value, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password_value, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->password_value, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->realm, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& realm_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->realm, validation_context,
                                         &realm_validate_params)) {
    return false;
  }

  return true;
}

PasswordAndMetadata_Data::PasswordAndMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordFormFillData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordFormFillData_Data* object =
      static_cast<const PasswordFormFillData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_renderer_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username_element_renderer_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->username_element_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password_element_renderer_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->password_element_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->preferred_login, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->preferred_login, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->additional_logins, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& additional_logins_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->additional_logins, validation_context,
                                         &additional_logins_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->suggestion_banned_fields, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& suggestion_banned_fields_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->suggestion_banned_fields, validation_context,
                                         &suggestion_banned_fields_validate_params)) {
    return false;
  }

  return true;
}

PasswordFormFillData_Data::PasswordFormFillData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordFormGenerationData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordFormGenerationData_Data* object =
      static_cast<const PasswordFormGenerationData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_password_renderer_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_password_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->confirmation_password_renderer_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->confirmation_password_renderer_id, validation_context))
    return false;

  return true;
}

PasswordFormGenerationData_Data::PasswordFormGenerationData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordGenerationUIData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordGenerationUIData_Data* object =
      static_cast<const PasswordGenerationUIData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->generation_element, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->generation_element, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->generation_element_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->generation_element_id, validation_context))
    return false;


  if (!::mojo_base::mojom::internal::TextDirection_Data
        ::Validate(object->text_direction, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_data, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form_data, validation_context))
    return false;

  return true;
}

PasswordGenerationUIData_Data::PasswordGenerationUIData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TriggeringField_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TriggeringField_Data* object =
      static_cast<const TriggeringField_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->element_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->element_id, validation_context))
    return false;


  if (!::autofill::mojom::internal::AutofillSuggestionTriggerSource_Data
        ::Validate(object->trigger_source, validation_context))
    return false;


  if (!::mojo_base::mojom::internal::TextDirection_Data
        ::Validate(object->text_direction, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->typed_username, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->typed_username, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  return true;
}

TriggeringField_Data::TriggeringField_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PasswordSuggestionRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PasswordSuggestionRequest_Data* object =
      static_cast<const PasswordSuggestionRequest_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->field, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->field, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->form_data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->form_data, validation_context))
    return false;

  return true;
}

PasswordSuggestionRequest_Data::PasswordSuggestionRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ParsingResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ParsingResult_Data* object =
      static_cast<const ParsingResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username_renderer_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->username_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password_renderer_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->password_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_password_renderer_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_password_renderer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->confirm_password_renderer_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->confirm_password_renderer_id, validation_context))
    return false;

  return true;
}

ParsingResult_Data::ParsingResult_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace autofill

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::FormControlType>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::FormControlType value) {
  return std::move(context).WriteString(::autofill::mojom::FormControlTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::HtmlFieldMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::HtmlFieldMode value) {
  return std::move(context).WriteString(::autofill::mojom::HtmlFieldModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::HtmlFieldType>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::HtmlFieldType value) {
  return std::move(context).WriteString(::autofill::mojom::HtmlFieldTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::SubmissionIndicatorEvent>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::SubmissionIndicatorEvent value) {
  return std::move(context).WriteString(::autofill::mojom::SubmissionIndicatorEventToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::SubmissionSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::SubmissionSource value) {
  return std::move(context).WriteString(::autofill::mojom::SubmissionSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::FocusedFieldType>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::FocusedFieldType value) {
  return std::move(context).WriteString(::autofill::mojom::FocusedFieldTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::ButtonTitleType>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::ButtonTitleType value) {
  return std::move(context).WriteString(::autofill::mojom::ButtonTitleTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::SubmissionReadinessState>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::SubmissionReadinessState value) {
  return std::move(context).WriteString(::autofill::mojom::SubmissionReadinessStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::AutofillSuggestionAvailability>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::AutofillSuggestionAvailability value) {
  return std::move(context).WriteString(::autofill::mojom::AutofillSuggestionAvailabilityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::ActionPersistence>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::ActionPersistence value) {
  return std::move(context).WriteString(::autofill::mojom::ActionPersistenceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::FormActionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::FormActionType value) {
  return std::move(context).WriteString(::autofill::mojom::FormActionTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::FieldActionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::FieldActionType value) {
  return std::move(context).WriteString(::autofill::mojom::FieldActionTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::AutofillSuggestionTriggerSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::AutofillSuggestionTriggerSource value) {
  return std::move(context).WriteString(::autofill::mojom::AutofillSuggestionTriggerSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::FormFieldData_CheckStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::FormFieldData_CheckStatus value) {
  return std::move(context).WriteString(::autofill::mojom::FormFieldData_CheckStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::FormFieldData_RoleAttribute>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::FormFieldData_RoleAttribute value) {
  return std::move(context).WriteString(::autofill::mojom::FormFieldData_RoleAttributeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::autofill::mojom::FormFieldData_LabelSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::autofill::mojom::FormFieldData_LabelSource value) {
  return std::move(context).WriteString(::autofill::mojom::FormFieldData_LabelSourceToString(value));
}

} // namespace perfetto