// components/ip_protection/mojom/data_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/ip_protection/mojom/data_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/ip_protection/mojom/data_types.mojom-params-data.h"
namespace ip_protection {
namespace mojom {

NOINLINE static const char* ProxyLayerToStringHelper(ProxyLayer value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ProxyLayer::kProxyA:
      return "kProxyA";
    case ProxyLayer::kProxyB:
      return "kProxyB";
    default:
      return nullptr;
  }
}

std::string ProxyLayerToString(ProxyLayer value) {
  const char *str = ProxyLayerToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ProxyLayer value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ProxyLayer value) {
  return os << ProxyLayerToString(value);
}

NOINLINE static const char* TryGetProbabilisticRevealTokensStatusToStringHelper(TryGetProbabilisticRevealTokensStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TryGetProbabilisticRevealTokensStatus::kSuccess:
      return "kSuccess";
    case TryGetProbabilisticRevealTokensStatus::kNetNotOk:
      return "kNetNotOk";
    case TryGetProbabilisticRevealTokensStatus::kNetOkNullResponse:
      return "kNetOkNullResponse";
    case TryGetProbabilisticRevealTokensStatus::kNullResponse:
      return "kNullResponse";
    case TryGetProbabilisticRevealTokensStatus::kResponseParsingFailed:
      return "kResponseParsingFailed";
    case TryGetProbabilisticRevealTokensStatus::kInvalidTokenVersion:
      return "kInvalidTokenVersion";
    case TryGetProbabilisticRevealTokensStatus::kInvalidTokenSize:
      return "kInvalidTokenSize";
    case TryGetProbabilisticRevealTokensStatus::kTooFewTokens:
      return "kTooFewTokens";
    case TryGetProbabilisticRevealTokensStatus::kTooManyTokens:
      return "kTooManyTokens";
    case TryGetProbabilisticRevealTokensStatus::kExpirationTooSoon:
      return "kExpirationTooSoon";
    case TryGetProbabilisticRevealTokensStatus::kExpirationTooLate:
      return "kExpirationTooLate";
    case TryGetProbabilisticRevealTokensStatus::kInvalidPublicKey:
      return "kInvalidPublicKey";
    case TryGetProbabilisticRevealTokensStatus::kInvalidNumTokensWithSignal:
      return "kInvalidNumTokensWithSignal";
    case TryGetProbabilisticRevealTokensStatus::kRequestBackedOff:
      return "kRequestBackedOff";
    case TryGetProbabilisticRevealTokensStatus::kNoGoogleChromeBranding:
      return "kNoGoogleChromeBranding";
    case TryGetProbabilisticRevealTokensStatus::kInvalidEpochIdSize:
      return "kInvalidEpochIdSize";
    default:
      return nullptr;
  }
}

std::string TryGetProbabilisticRevealTokensStatusToString(TryGetProbabilisticRevealTokensStatus value) {
  const char *str = TryGetProbabilisticRevealTokensStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TryGetProbabilisticRevealTokensStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TryGetProbabilisticRevealTokensStatus value) {
  return os << TryGetProbabilisticRevealTokensStatusToString(value);
}

namespace internal {


// static
bool GeoHint_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GeoHint_Data* object =
      static_cast<const GeoHint_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->country_code, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& country_code_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->country_code, validation_context,
                                         &country_code_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->iso_region, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& iso_region_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->iso_region, validation_context,
                                         &iso_region_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->city_name, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& city_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->city_name, validation_context,
                                         &city_name_validate_params)) {
    return false;
  }

  return true;
}

GeoHint_Data::GeoHint_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BlindSignedAuthToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BlindSignedAuthToken_Data* object =
      static_cast<const BlindSignedAuthToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->token, validation_context,
                                         &token_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expiration, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expiration, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->geo_hint, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->geo_hint, validation_context))
    return false;

  return true;
}

BlindSignedAuthToken_Data::BlindSignedAuthToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProbabilisticRevealToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProbabilisticRevealToken_Data* object =
      static_cast<const ProbabilisticRevealToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->u, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& u_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->u, validation_context,
                                         &u_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->e, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& e_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->e, validation_context,
                                         &e_validate_params)) {
    return false;
  }

  return true;
}

ProbabilisticRevealToken_Data::ProbabilisticRevealToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TryGetProbabilisticRevealTokensResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TryGetProbabilisticRevealTokensResult_Data* object =
      static_cast<const TryGetProbabilisticRevealTokensResult_Data*>(data);


  if (!::ip_protection::mojom::internal::TryGetProbabilisticRevealTokensStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->try_again_after, validation_context))
    return false;

  return true;
}

TryGetProbabilisticRevealTokensResult_Data::TryGetProbabilisticRevealTokensResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TryGetProbabilisticRevealTokensOutcome_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TryGetProbabilisticRevealTokensOutcome_Data* object =
      static_cast<const TryGetProbabilisticRevealTokensOutcome_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tokens, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tokens_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tokens, validation_context,
                                         &tokens_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->public_key, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& public_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->public_key, validation_context,
                                         &public_key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->epoch_id, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& epoch_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->epoch_id, validation_context,
                                         &epoch_id_validate_params)) {
    return false;
  }

  return true;
}

TryGetProbabilisticRevealTokensOutcome_Data::TryGetProbabilisticRevealTokensOutcome_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ip_protection

namespace perfetto {

// static
void TraceFormatTraits<::ip_protection::mojom::ProxyLayer>::WriteIntoTrace(
   perfetto::TracedValue context, ::ip_protection::mojom::ProxyLayer value) {
  return std::move(context).WriteString(::ip_protection::mojom::ProxyLayerToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ip_protection::mojom::TryGetProbabilisticRevealTokensStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::ip_protection::mojom::TryGetProbabilisticRevealTokensStatus value) {
  return std::move(context).WriteString(::ip_protection::mojom::TryGetProbabilisticRevealTokensStatusToString(value));
}

} // namespace perfetto