// components/services/filesystem/public/mojom/directory.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_DIRECTORY_MOJOM_DATA_VIEW_H_
#define COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_DIRECTORY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/services/filesystem/public/mojom/directory.mojom-shared-internal.h"
#include "components/services/filesystem/public/mojom/types.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_error.mojom-shared.h"


namespace filesystem::mojom {
class FileOpenDetailsDataView;

class FileOpenResultDataView;



}  // filesystem::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::filesystem::mojom::FileOpenDetailsDataView> {
  using Data = ::filesystem::mojom::internal::FileOpenDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::filesystem::mojom::FileOpenResultDataView> {
  using Data = ::filesystem::mojom::internal::FileOpenResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace filesystem::mojom {
// Interface base classes. They are used for type safety check.
class DirectoryInterfaceBase {};

using DirectoryPtrDataView =
    mojo::InterfacePtrDataView<DirectoryInterfaceBase>;
using DirectoryRequestDataView =
    mojo::InterfaceRequestDataView<DirectoryInterfaceBase>;
using DirectoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DirectoryInterfaceBase>;
using DirectoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DirectoryInterfaceBase>;


class FileOpenDetailsDataView {
 public:
  FileOpenDetailsDataView() = default;

  FileOpenDetailsDataView(
      internal::FileOpenDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t open_flags() const {
    return data_->open_flags;
  }
 private:
  internal::FileOpenDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileOpenResultDataView {
 public:
  FileOpenResultDataView() = default;

  FileOpenResultDataView(
      internal::FileOpenResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
  inline void GetFileHandleDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileHandle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FileDataView, UserType>(),
    "Attempting to read the optional `file_handle` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFileHandle` instead "
    "of `ReadFileHandle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file_handle.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
 private:
  internal::FileOpenResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // filesystem::mojom

#endif  // COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_DIRECTORY_MOJOM_DATA_VIEW_H_