// components/services/filesystem/public/mojom/directory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/filesystem/public/mojom/directory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/filesystem/public/mojom/directory.mojom-params-data.h"
#include "components/services/filesystem/public/mojom/directory.mojom-shared-message-ids.h"

#include "components/services/filesystem/public/mojom/directory.mojom-import-headers.h"
#include "components/services/filesystem/public/mojom/directory.mojom-test-utils.h"


namespace filesystem::mojom {
FileOpenDetails::FileOpenDetails()
    : path(),
      open_flags() {}

FileOpenDetails::FileOpenDetails(
    const std::string& path_in,
    uint32_t open_flags_in)
    : path(std::move(path_in)),
      open_flags(std::move(open_flags_in)) {}

FileOpenDetails::~FileOpenDetails() = default;
size_t FileOpenDetails::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->path);
  seed = mojo::internal::Hash(seed, this->open_flags);
  return seed;
}

void FileOpenDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "open_flags"), this->open_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileOpenDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileOpenResult::FileOpenResult()
    : path(),
      error(),
      file_handle() {}

FileOpenResult::FileOpenResult(
    const std::string& path_in,
    ::base::File::Error error_in,
    ::base::File file_handle_in)
    : path(std::move(path_in)),
      error(std::move(error_in)),
      file_handle(std::move(file_handle_in)) {}

FileOpenResult::~FileOpenResult() = default;

void FileOpenResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error"), this->error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File::Error>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_handle"), this->file_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileOpenResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

Directory::IPCStableHashFunction Directory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Directory>(message.name())) {
    case messages::Directory::kRead: {
      return &Directory::Read_Sym::IPCStableHash;
    }
    case messages::Directory::kOpenFileHandle: {
      return &Directory::OpenFileHandle_Sym::IPCStableHash;
    }
    case messages::Directory::kOpenFileHandles: {
      return &Directory::OpenFileHandles_Sym::IPCStableHash;
    }
    case messages::Directory::kOpenDirectory: {
      return &Directory::OpenDirectory_Sym::IPCStableHash;
    }
    case messages::Directory::kRename: {
      return &Directory::Rename_Sym::IPCStableHash;
    }
    case messages::Directory::kReplace: {
      return &Directory::Replace_Sym::IPCStableHash;
    }
    case messages::Directory::kDelete: {
      return &Directory::Delete_Sym::IPCStableHash;
    }
    case messages::Directory::kExists: {
      return &Directory::Exists_Sym::IPCStableHash;
    }
    case messages::Directory::kIsWritable: {
      return &Directory::IsWritable_Sym::IPCStableHash;
    }
    case messages::Directory::kFlush: {
      return &Directory::Flush_Sym::IPCStableHash;
    }
    case messages::Directory::kStatFile: {
      return &Directory::StatFile_Sym::IPCStableHash;
    }
    case messages::Directory::kClone: {
      return &Directory::Clone_Sym::IPCStableHash;
    }
    case messages::Directory::kReadEntireFile: {
      return &Directory::ReadEntireFile_Sym::IPCStableHash;
    }
    case messages::Directory::kWriteFile: {
      return &Directory::WriteFile_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Directory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Directory>(message.name())) {
      case messages::Directory::kRead:
            return "Receive filesystem::mojom::Directory::Read";
      case messages::Directory::kOpenFileHandle:
            return "Receive filesystem::mojom::Directory::OpenFileHandle";
      case messages::Directory::kOpenFileHandles:
            return "Receive filesystem::mojom::Directory::OpenFileHandles";
      case messages::Directory::kOpenDirectory:
            return "Receive filesystem::mojom::Directory::OpenDirectory";
      case messages::Directory::kRename:
            return "Receive filesystem::mojom::Directory::Rename";
      case messages::Directory::kReplace:
            return "Receive filesystem::mojom::Directory::Replace";
      case messages::Directory::kDelete:
            return "Receive filesystem::mojom::Directory::Delete";
      case messages::Directory::kExists:
            return "Receive filesystem::mojom::Directory::Exists";
      case messages::Directory::kIsWritable:
            return "Receive filesystem::mojom::Directory::IsWritable";
      case messages::Directory::kFlush:
            return "Receive filesystem::mojom::Directory::Flush";
      case messages::Directory::kStatFile:
            return "Receive filesystem::mojom::Directory::StatFile";
      case messages::Directory::kClone:
            return "Receive filesystem::mojom::Directory::Clone";
      case messages::Directory::kReadEntireFile:
            return "Receive filesystem::mojom::Directory::ReadEntireFile";
      case messages::Directory::kWriteFile:
            return "Receive filesystem::mojom::Directory::WriteFile";
    }
  } else {
    switch (static_cast<messages::Directory>(message.name())) {
      case messages::Directory::kRead:
            return "Receive reply filesystem::mojom::Directory::Read";
      case messages::Directory::kOpenFileHandle:
            return "Receive reply filesystem::mojom::Directory::OpenFileHandle";
      case messages::Directory::kOpenFileHandles:
            return "Receive reply filesystem::mojom::Directory::OpenFileHandles";
      case messages::Directory::kOpenDirectory:
            return "Receive reply filesystem::mojom::Directory::OpenDirectory";
      case messages::Directory::kRename:
            return "Receive reply filesystem::mojom::Directory::Rename";
      case messages::Directory::kReplace:
            return "Receive reply filesystem::mojom::Directory::Replace";
      case messages::Directory::kDelete:
            return "Receive reply filesystem::mojom::Directory::Delete";
      case messages::Directory::kExists:
            return "Receive reply filesystem::mojom::Directory::Exists";
      case messages::Directory::kIsWritable:
            return "Receive reply filesystem::mojom::Directory::IsWritable";
      case messages::Directory::kFlush:
            return "Receive reply filesystem::mojom::Directory::Flush";
      case messages::Directory::kStatFile:
            return "Receive reply filesystem::mojom::Directory::StatFile";
      case messages::Directory::kClone:
            return "Receive reply filesystem::mojom::Directory::Clone";
      case messages::Directory::kReadEntireFile:
            return "Receive reply filesystem::mojom::Directory::ReadEntireFile";
      case messages::Directory::kWriteFile:
            return "Receive reply filesystem::mojom::Directory::WriteFile";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Directory::Read_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe3cb68a2;  // IPCStableHash for filesystem::mojom::Directory::Read
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::OpenFileHandle_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x08083582;  // IPCStableHash for filesystem::mojom::Directory::OpenFileHandle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::OpenFileHandles_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7dfb708b;  // IPCStableHash for filesystem::mojom::Directory::OpenFileHandles
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::OpenDirectory_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x88852bd1;  // IPCStableHash for filesystem::mojom::Directory::OpenDirectory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::Rename_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x12a27c9d;  // IPCStableHash for filesystem::mojom::Directory::Rename
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::Replace_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x464994e0;  // IPCStableHash for filesystem::mojom::Directory::Replace
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::Delete_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5c9c8f19;  // IPCStableHash for filesystem::mojom::Directory::Delete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::Exists_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5a4b40cf;  // IPCStableHash for filesystem::mojom::Directory::Exists
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::IsWritable_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf26c1bb1;  // IPCStableHash for filesystem::mojom::Directory::IsWritable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::Flush_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x75a52aeb;  // IPCStableHash for filesystem::mojom::Directory::Flush
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::StatFile_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5b4d8507;  // IPCStableHash for filesystem::mojom::Directory::StatFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf9346351;  // IPCStableHash for filesystem::mojom::Directory::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::ReadEntireFile_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd832b658;  // IPCStableHash for filesystem::mojom::Directory::ReadEntireFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::WriteFile_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x24fceec8;  // IPCStableHash for filesystem::mojom::Directory::WriteFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool Directory::Read(::base::File::Error* out_error, std::optional<std::vector<::filesystem::mojom::DirectoryEntryPtr>>* out_directory_contents) {
  NOTREACHED();
}
bool Directory::OpenFileHandle(const std::string& path, uint32_t open_flags, ::base::File::Error* out_error, ::base::File* out_file_handle) {
  NOTREACHED();
}
bool Directory::OpenFileHandles(std::vector<FileOpenDetailsPtr> files, std::vector<FileOpenResultPtr>* out_results) {
  NOTREACHED();
}
bool Directory::OpenDirectory(const std::string& path, ::mojo::PendingReceiver<Directory> directory, uint32_t open_flags, ::base::File::Error* out_error) {
  NOTREACHED();
}
bool Directory::Rename(const std::string& path, const std::string& new_path, ::base::File::Error* out_error) {
  NOTREACHED();
}
bool Directory::Replace(const std::string& path, const std::string& new_path, ::base::File::Error* out_error) {
  NOTREACHED();
}
bool Directory::Delete(const std::string& path, uint32_t delete_flags, ::base::File::Error* out_error) {
  NOTREACHED();
}
bool Directory::Exists(const std::string& path, ::base::File::Error* out_error, bool* out_exists) {
  NOTREACHED();
}
bool Directory::IsWritable(const std::string& path, ::base::File::Error* out_error, bool* out_is_writable) {
  NOTREACHED();
}
bool Directory::Flush(::base::File::Error* out_error) {
  NOTREACHED();
}
bool Directory::StatFile(const std::string& path, ::base::File::Error* out_error, ::filesystem::mojom::FileInformationPtr* out_file_information) {
  NOTREACHED();
}
bool Directory::ReadEntireFile(const std::string& path, ::base::File::Error* out_error, std::vector<uint8_t>* out_data) {
  NOTREACHED();
}
bool Directory::WriteFile(const std::string& path, const std::vector<uint8_t>& data, ::base::File::Error* out_error) {
  NOTREACHED();
}
class Directory_Read_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_Read_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, std::optional<std::vector<::filesystem::mojom::DirectoryEntryPtr>>* out_directory_contents)
      : result_(result), out_error_(out_error), out_directory_contents_(out_directory_contents) {
    DCHECK(!*result_);
  }

  Directory_Read_HandleSyncResponse(const Directory_Read_HandleSyncResponse&) = delete;
  Directory_Read_HandleSyncResponse& operator=(const Directory_Read_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  std::optional<std::vector<::filesystem::mojom::DirectoryEntryPtr>>* out_directory_contents_;};

class Directory_Read_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_Read_ForwardToCallback(
      Directory::ReadCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_Read_ForwardToCallback(const Directory_Read_ForwardToCallback&) = delete;
  Directory_Read_ForwardToCallback& operator=(const Directory_Read_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::ReadCallback callback_;
};
class Directory_OpenFileHandle_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_OpenFileHandle_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, ::base::File* out_file_handle)
      : result_(result), out_error_(out_error), out_file_handle_(out_file_handle) {
    DCHECK(!*result_);
  }

  Directory_OpenFileHandle_HandleSyncResponse(const Directory_OpenFileHandle_HandleSyncResponse&) = delete;
  Directory_OpenFileHandle_HandleSyncResponse& operator=(const Directory_OpenFileHandle_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  ::base::File* out_file_handle_;};

class Directory_OpenFileHandle_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_OpenFileHandle_ForwardToCallback(
      Directory::OpenFileHandleCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_OpenFileHandle_ForwardToCallback(const Directory_OpenFileHandle_ForwardToCallback&) = delete;
  Directory_OpenFileHandle_ForwardToCallback& operator=(const Directory_OpenFileHandle_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::OpenFileHandleCallback callback_;
};
class Directory_OpenFileHandles_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_OpenFileHandles_HandleSyncResponse(
      bool* result, std::vector<FileOpenResultPtr>* out_results)
      : result_(result), out_results_(out_results) {
    DCHECK(!*result_);
  }

  Directory_OpenFileHandles_HandleSyncResponse(const Directory_OpenFileHandles_HandleSyncResponse&) = delete;
  Directory_OpenFileHandles_HandleSyncResponse& operator=(const Directory_OpenFileHandles_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  std::vector<FileOpenResultPtr>* out_results_;};

class Directory_OpenFileHandles_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_OpenFileHandles_ForwardToCallback(
      Directory::OpenFileHandlesCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_OpenFileHandles_ForwardToCallback(const Directory_OpenFileHandles_ForwardToCallback&) = delete;
  Directory_OpenFileHandles_ForwardToCallback& operator=(const Directory_OpenFileHandles_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::OpenFileHandlesCallback callback_;
};
class Directory_OpenDirectory_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_OpenDirectory_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }

  Directory_OpenDirectory_HandleSyncResponse(const Directory_OpenDirectory_HandleSyncResponse&) = delete;
  Directory_OpenDirectory_HandleSyncResponse& operator=(const Directory_OpenDirectory_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;};

class Directory_OpenDirectory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_OpenDirectory_ForwardToCallback(
      Directory::OpenDirectoryCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_OpenDirectory_ForwardToCallback(const Directory_OpenDirectory_ForwardToCallback&) = delete;
  Directory_OpenDirectory_ForwardToCallback& operator=(const Directory_OpenDirectory_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::OpenDirectoryCallback callback_;
};
class Directory_Rename_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_Rename_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }

  Directory_Rename_HandleSyncResponse(const Directory_Rename_HandleSyncResponse&) = delete;
  Directory_Rename_HandleSyncResponse& operator=(const Directory_Rename_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;};

class Directory_Rename_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_Rename_ForwardToCallback(
      Directory::RenameCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_Rename_ForwardToCallback(const Directory_Rename_ForwardToCallback&) = delete;
  Directory_Rename_ForwardToCallback& operator=(const Directory_Rename_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::RenameCallback callback_;
};
class Directory_Replace_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_Replace_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }

  Directory_Replace_HandleSyncResponse(const Directory_Replace_HandleSyncResponse&) = delete;
  Directory_Replace_HandleSyncResponse& operator=(const Directory_Replace_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;};

class Directory_Replace_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_Replace_ForwardToCallback(
      Directory::ReplaceCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_Replace_ForwardToCallback(const Directory_Replace_ForwardToCallback&) = delete;
  Directory_Replace_ForwardToCallback& operator=(const Directory_Replace_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::ReplaceCallback callback_;
};
class Directory_Delete_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_Delete_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }

  Directory_Delete_HandleSyncResponse(const Directory_Delete_HandleSyncResponse&) = delete;
  Directory_Delete_HandleSyncResponse& operator=(const Directory_Delete_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;};

class Directory_Delete_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_Delete_ForwardToCallback(
      Directory::DeleteCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_Delete_ForwardToCallback(const Directory_Delete_ForwardToCallback&) = delete;
  Directory_Delete_ForwardToCallback& operator=(const Directory_Delete_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::DeleteCallback callback_;
};
class Directory_Exists_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_Exists_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, bool* out_exists)
      : result_(result), out_error_(out_error), out_exists_(out_exists) {
    DCHECK(!*result_);
  }

  Directory_Exists_HandleSyncResponse(const Directory_Exists_HandleSyncResponse&) = delete;
  Directory_Exists_HandleSyncResponse& operator=(const Directory_Exists_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  bool* out_exists_;};

class Directory_Exists_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_Exists_ForwardToCallback(
      Directory::ExistsCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_Exists_ForwardToCallback(const Directory_Exists_ForwardToCallback&) = delete;
  Directory_Exists_ForwardToCallback& operator=(const Directory_Exists_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::ExistsCallback callback_;
};
class Directory_IsWritable_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_IsWritable_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, bool* out_is_writable)
      : result_(result), out_error_(out_error), out_is_writable_(out_is_writable) {
    DCHECK(!*result_);
  }

  Directory_IsWritable_HandleSyncResponse(const Directory_IsWritable_HandleSyncResponse&) = delete;
  Directory_IsWritable_HandleSyncResponse& operator=(const Directory_IsWritable_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  bool* out_is_writable_;};

class Directory_IsWritable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_IsWritable_ForwardToCallback(
      Directory::IsWritableCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_IsWritable_ForwardToCallback(const Directory_IsWritable_ForwardToCallback&) = delete;
  Directory_IsWritable_ForwardToCallback& operator=(const Directory_IsWritable_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::IsWritableCallback callback_;
};
class Directory_Flush_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_Flush_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }

  Directory_Flush_HandleSyncResponse(const Directory_Flush_HandleSyncResponse&) = delete;
  Directory_Flush_HandleSyncResponse& operator=(const Directory_Flush_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;};

class Directory_Flush_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_Flush_ForwardToCallback(
      Directory::FlushCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_Flush_ForwardToCallback(const Directory_Flush_ForwardToCallback&) = delete;
  Directory_Flush_ForwardToCallback& operator=(const Directory_Flush_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::FlushCallback callback_;
};
class Directory_StatFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_StatFile_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, ::filesystem::mojom::FileInformationPtr* out_file_information)
      : result_(result), out_error_(out_error), out_file_information_(out_file_information) {
    DCHECK(!*result_);
  }

  Directory_StatFile_HandleSyncResponse(const Directory_StatFile_HandleSyncResponse&) = delete;
  Directory_StatFile_HandleSyncResponse& operator=(const Directory_StatFile_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  ::filesystem::mojom::FileInformationPtr* out_file_information_;};

class Directory_StatFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_StatFile_ForwardToCallback(
      Directory::StatFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_StatFile_ForwardToCallback(const Directory_StatFile_ForwardToCallback&) = delete;
  Directory_StatFile_ForwardToCallback& operator=(const Directory_StatFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::StatFileCallback callback_;
};
class Directory_ReadEntireFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_ReadEntireFile_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, std::vector<uint8_t>* out_data)
      : result_(result), out_error_(out_error), out_data_(out_data) {
    DCHECK(!*result_);
  }

  Directory_ReadEntireFile_HandleSyncResponse(const Directory_ReadEntireFile_HandleSyncResponse&) = delete;
  Directory_ReadEntireFile_HandleSyncResponse& operator=(const Directory_ReadEntireFile_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  std::vector<uint8_t>* out_data_;};

class Directory_ReadEntireFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_ReadEntireFile_ForwardToCallback(
      Directory::ReadEntireFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_ReadEntireFile_ForwardToCallback(const Directory_ReadEntireFile_ForwardToCallback&) = delete;
  Directory_ReadEntireFile_ForwardToCallback& operator=(const Directory_ReadEntireFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::ReadEntireFileCallback callback_;
};
class Directory_WriteFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_WriteFile_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }

  Directory_WriteFile_HandleSyncResponse(const Directory_WriteFile_HandleSyncResponse&) = delete;
  Directory_WriteFile_HandleSyncResponse& operator=(const Directory_WriteFile_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;};

class Directory_WriteFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_WriteFile_ForwardToCallback(
      Directory::WriteFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_WriteFile_ForwardToCallback(const Directory_WriteFile_ForwardToCallback&) = delete;
  Directory_WriteFile_ForwardToCallback& operator=(const Directory_WriteFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::WriteFileCallback callback_;
};

DirectoryProxy::DirectoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool DirectoryProxy::Read(
    ::base::File::Error* out_param_error, std::optional<std::vector<::filesystem::mojom::DirectoryEntryPtr>>* out_param_directory_contents) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call filesystem::mojom::Directory::Read (sync)");
#else
  TRACE_EVENT0("mojom", "Directory::Read");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Read_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Read");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Read_HandleSyncResponse(
          &result, out_param_error, out_param_directory_contents));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::Read", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory_contents"), out_param_directory_contents,
                        "<value of type std::optional<std::vector<::filesystem::mojom::DirectoryEntryPtr>>>");
   });
#endif
  return result;
}

void DirectoryProxy::Read(
    ReadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send filesystem::mojom::Directory::Read");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Read_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Read");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Read_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::OpenFileHandle(
    const std::string& param_path, uint32_t param_open_flags, ::base::File::Error* out_param_error, ::base::File* out_param_file_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call filesystem::mojom::Directory::OpenFileHandle (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("open_flags"), param_open_flags,
                        "<value of type uint32_t>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::OpenFileHandle");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kOpenFileHandle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenFileHandle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.OpenFileHandle request");

  params->open_flags = param_open_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFileHandle");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_OpenFileHandle_HandleSyncResponse(
          &result, out_param_error, out_param_file_handle));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::OpenFileHandle", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_handle"), out_param_file_handle,
                        "<value of type ::base::File>");
   });
#endif
  return result;
}

void DirectoryProxy::OpenFileHandle(
    const std::string& in_path, uint32_t in_open_flags, OpenFileHandleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send filesystem::mojom::Directory::OpenFileHandle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("open_flags"), in_open_flags,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kOpenFileHandle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenFileHandle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.OpenFileHandle request");

  params->open_flags = in_open_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFileHandle");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_OpenFileHandle_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::OpenFileHandles(
    std::vector<FileOpenDetailsPtr> param_files, std::vector<FileOpenResultPtr>* out_param_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call filesystem::mojom::Directory::OpenFileHandles (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("files"), param_files,
                        "<value of type std::vector<FileOpenDetailsPtr>>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::OpenFileHandles");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kOpenFileHandles), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenFileHandles_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->files)::BaseType>
      files_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::filesystem::mojom::FileOpenDetailsDataView>>(
    param_files,
    files_fragment,
    &files_validate_params);

  params->files.Set(
      files_fragment.is_null() ? nullptr : files_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->files.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null files in Directory.OpenFileHandles request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFileHandles");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_OpenFileHandles_HandleSyncResponse(
          &result, out_param_results));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::OpenFileHandles", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), out_param_results,
                        "<value of type std::vector<FileOpenResultPtr>>");
   });
#endif
  return result;
}

void DirectoryProxy::OpenFileHandles(
    std::vector<FileOpenDetailsPtr> in_files, OpenFileHandlesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send filesystem::mojom::Directory::OpenFileHandles", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("files"), in_files,
                        "<value of type std::vector<FileOpenDetailsPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kOpenFileHandles), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenFileHandles_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->files)::BaseType>
      files_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::filesystem::mojom::FileOpenDetailsDataView>>(
    in_files,
    files_fragment,
    &files_validate_params);

  params->files.Set(
      files_fragment.is_null() ? nullptr : files_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->files.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null files in Directory.OpenFileHandles request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFileHandles");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_OpenFileHandles_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::OpenDirectory(
    const std::string& param_path, ::mojo::PendingReceiver<Directory> param_directory, uint32_t param_open_flags, ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call filesystem::mojom::Directory::OpenDirectory (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory"), param_directory,
                        "<value of type ::mojo::PendingReceiver<Directory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("open_flags"), param_open_flags,
                        "<value of type uint32_t>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::OpenDirectory");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kOpenDirectory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenDirectory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.OpenDirectory request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::filesystem::mojom::DirectoryInterfaceBase>>(
    param_directory,
    &params->directory,
    &params.message());

  params->open_flags = param_open_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenDirectory");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_OpenDirectory_HandleSyncResponse(
          &result, out_param_error));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::OpenDirectory", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void DirectoryProxy::OpenDirectory(
    const std::string& in_path, ::mojo::PendingReceiver<Directory> in_directory, uint32_t in_open_flags, OpenDirectoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send filesystem::mojom::Directory::OpenDirectory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory"), in_directory,
                        "<value of type ::mojo::PendingReceiver<Directory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("open_flags"), in_open_flags,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kOpenDirectory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenDirectory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.OpenDirectory request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::filesystem::mojom::DirectoryInterfaceBase>>(
    in_directory,
    &params->directory,
    &params.message());

  params->open_flags = in_open_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenDirectory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_OpenDirectory_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::Rename(
    const std::string& param_path, const std::string& param_new_path, ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call filesystem::mojom::Directory::Rename (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_path"), param_new_path,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::Rename");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kRename), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Rename_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.Rename request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_path)::BaseType> new_path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_new_path,
    new_path_fragment);

  params->new_path.Set(
      new_path_fragment.is_null() ? nullptr : new_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_path in Directory.Rename request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Rename");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Rename_HandleSyncResponse(
          &result, out_param_error));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::Rename", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void DirectoryProxy::Rename(
    const std::string& in_path, const std::string& in_new_path, RenameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send filesystem::mojom::Directory::Rename", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_path"), in_new_path,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kRename), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Rename_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.Rename request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_path)::BaseType> new_path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_new_path,
    new_path_fragment);

  params->new_path.Set(
      new_path_fragment.is_null() ? nullptr : new_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_path in Directory.Rename request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Rename");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Rename_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::Replace(
    const std::string& param_path, const std::string& param_new_path, ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call filesystem::mojom::Directory::Replace (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_path"), param_new_path,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::Replace");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kReplace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Replace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.Replace request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_path)::BaseType> new_path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_new_path,
    new_path_fragment);

  params->new_path.Set(
      new_path_fragment.is_null() ? nullptr : new_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_path in Directory.Replace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Replace");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Replace_HandleSyncResponse(
          &result, out_param_error));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::Replace", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void DirectoryProxy::Replace(
    const std::string& in_path, const std::string& in_new_path, ReplaceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send filesystem::mojom::Directory::Replace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_path"), in_new_path,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kReplace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Replace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.Replace request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_path)::BaseType> new_path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_new_path,
    new_path_fragment);

  params->new_path.Set(
      new_path_fragment.is_null() ? nullptr : new_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_path in Directory.Replace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Replace");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Replace_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::Delete(
    const std::string& param_path, uint32_t param_delete_flags, ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call filesystem::mojom::Directory::Delete (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delete_flags"), param_delete_flags,
                        "<value of type uint32_t>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::Delete");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kDelete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Delete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.Delete request");

  params->delete_flags = param_delete_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Delete");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Delete_HandleSyncResponse(
          &result, out_param_error));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::Delete", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void DirectoryProxy::Delete(
    const std::string& in_path, uint32_t in_delete_flags, DeleteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send filesystem::mojom::Directory::Delete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("delete_flags"), in_delete_flags,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kDelete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Delete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.Delete request");

  params->delete_flags = in_delete_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Delete");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Delete_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::Exists(
    const std::string& param_path, ::base::File::Error* out_param_error, bool* out_param_exists) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call filesystem::mojom::Directory::Exists (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::Exists");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kExists), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Exists_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.Exists request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Exists");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Exists_HandleSyncResponse(
          &result, out_param_error, out_param_exists));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::Exists", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("exists"), out_param_exists,
                        "<value of type bool>");
   });
#endif
  return result;
}

void DirectoryProxy::Exists(
    const std::string& in_path, ExistsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send filesystem::mojom::Directory::Exists", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kExists), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Exists_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.Exists request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Exists");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Exists_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::IsWritable(
    const std::string& param_path, ::base::File::Error* out_param_error, bool* out_param_is_writable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call filesystem::mojom::Directory::IsWritable (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::IsWritable");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kIsWritable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_IsWritable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.IsWritable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("IsWritable");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_IsWritable_HandleSyncResponse(
          &result, out_param_error, out_param_is_writable));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::IsWritable", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_writable"), out_param_is_writable,
                        "<value of type bool>");
   });
#endif
  return result;
}

void DirectoryProxy::IsWritable(
    const std::string& in_path, IsWritableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send filesystem::mojom::Directory::IsWritable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kIsWritable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_IsWritable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.IsWritable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("IsWritable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_IsWritable_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::Flush(
    ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call filesystem::mojom::Directory::Flush (sync)");
#else
  TRACE_EVENT0("mojom", "Directory::Flush");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kFlush), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Flush");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Flush_HandleSyncResponse(
          &result, out_param_error));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::Flush", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void DirectoryProxy::Flush(
    FlushCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send filesystem::mojom::Directory::Flush");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kFlush), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Flush");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_Flush_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::StatFile(
    const std::string& param_path, ::base::File::Error* out_param_error, ::filesystem::mojom::FileInformationPtr* out_param_file_information) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call filesystem::mojom::Directory::StatFile (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::StatFile");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kStatFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_StatFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.StatFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("StatFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_StatFile_HandleSyncResponse(
          &result, out_param_error, out_param_file_information));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::StatFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_information"), out_param_file_information,
                        "<value of type ::filesystem::mojom::FileInformationPtr>");
   });
#endif
  return result;
}

void DirectoryProxy::StatFile(
    const std::string& in_path, StatFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send filesystem::mojom::Directory::StatFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kStatFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_StatFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.StatFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("StatFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_StatFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DirectoryProxy::Clone(
    ::mojo::PendingReceiver<Directory> in_directory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send filesystem::mojom::Directory::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory"), in_directory,
                        "<value of type ::mojo::PendingReceiver<Directory>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::filesystem::mojom::DirectoryInterfaceBase>>(
    in_directory,
    &params->directory,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->directory)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid directory in Directory.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool DirectoryProxy::ReadEntireFile(
    const std::string& param_path, ::base::File::Error* out_param_error, std::vector<uint8_t>* out_param_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call filesystem::mojom::Directory::ReadEntireFile (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::ReadEntireFile");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kReadEntireFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_ReadEntireFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.ReadEntireFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("ReadEntireFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_ReadEntireFile_HandleSyncResponse(
          &result, out_param_error, out_param_data));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::ReadEntireFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), out_param_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif
  return result;
}

void DirectoryProxy::ReadEntireFile(
    const std::string& in_path, ReadEntireFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send filesystem::mojom::Directory::ReadEntireFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kReadEntireFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_ReadEntireFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.ReadEntireFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("ReadEntireFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_ReadEntireFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::WriteFile(
    const std::string& param_path, const std::vector<uint8_t>& param_data, ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call filesystem::mojom::Directory::WriteFile (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), param_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::WriteFile");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kWriteFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_WriteFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.WriteFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    param_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in Directory.WriteFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("WriteFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_WriteFile_HandleSyncResponse(
          &result, out_param_error));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::WriteFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void DirectoryProxy::WriteFile(
    const std::string& in_path, const std::vector<uint8_t>& in_data, WriteFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send filesystem::mojom::Directory::WriteFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kWriteFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_WriteFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in Directory.WriteFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in Directory.WriteFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("WriteFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_WriteFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Directory_Read_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::ReadCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_Read_ProxyToResponder> proxy(
        new Directory_Read_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_Read_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_Read_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_Read_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::ReadCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, std::optional<std::vector<::filesystem::mojom::DirectoryEntryPtr>> in_directory_contents);
};

bool Directory_Read_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_Read_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_Read_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Directory.0
  bool success = true;
  ::base::File::Error p_error{};
  std::optional<std::vector<::filesystem::mojom::DirectoryEntryPtr>> p_directory_contents{};
  Directory_Read_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadDirectoryContents(&p_directory_contents))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_directory_contents));
  }
  return true;
}

void Directory_Read_ProxyToResponder::Run(
    ::base::File::Error in_error, std::optional<std::vector<::filesystem::mojom::DirectoryEntryPtr>> in_directory_contents) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply filesystem::mojom::Directory::Read", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory_contents"), in_directory_contents,
                        "<value of type std::optional<std::vector<::filesystem::mojom::DirectoryEntryPtr>>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Read_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->directory_contents)::BaseType>
      directory_contents_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& directory_contents_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::filesystem::mojom::DirectoryEntryDataView>>(
    in_directory_contents,
    directory_contents_fragment,
    &directory_contents_validate_params);

  params->directory_contents.Set(
      directory_contents_fragment.is_null() ? nullptr : directory_contents_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Read");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_Read_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_Read_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_Read_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Directory.0
  bool success = true;
  ::base::File::Error p_error{};
  std::optional<std::vector<::filesystem::mojom::DirectoryEntryPtr>> p_directory_contents{};
  Directory_Read_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadDirectoryContents(&p_directory_contents))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 0, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_directory_contents_ = std::move(p_directory_contents);
  *result_ = true;
  return true;
}
class Directory_OpenFileHandle_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::OpenFileHandleCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_OpenFileHandle_ProxyToResponder> proxy(
        new Directory_OpenFileHandle_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_OpenFileHandle_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_OpenFileHandle_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_OpenFileHandle_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::OpenFileHandleCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, ::base::File in_file_handle);
};

bool Directory_OpenFileHandle_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_OpenFileHandle_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_OpenFileHandle_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Directory.1
  bool success = true;
  ::base::File::Error p_error{};
  ::base::File p_file_handle{};
  Directory_OpenFileHandle_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadFileHandle(&p_file_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_file_handle));
  }
  return true;
}

void Directory_OpenFileHandle_ProxyToResponder::Run(
    ::base::File::Error in_error, ::base::File in_file_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply filesystem::mojom::Directory::OpenFileHandle", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_handle"), in_file_handle,
                        "<value of type ::base::File>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kOpenFileHandle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenFileHandle_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->file_handle)::BaseType> file_handle_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
    in_file_handle,
    file_handle_fragment);

  params->file_handle.Set(
      file_handle_fragment.is_null() ? nullptr : file_handle_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFileHandle");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_OpenFileHandle_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_OpenFileHandle_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_OpenFileHandle_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Directory.1
  bool success = true;
  ::base::File::Error p_error{};
  ::base::File p_file_handle{};
  Directory_OpenFileHandle_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadFileHandle(&p_file_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 1, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_file_handle_ = std::move(p_file_handle);
  *result_ = true;
  return true;
}
class Directory_OpenFileHandles_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::OpenFileHandlesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_OpenFileHandles_ProxyToResponder> proxy(
        new Directory_OpenFileHandles_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_OpenFileHandles_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_OpenFileHandles_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_OpenFileHandles_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::OpenFileHandlesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<FileOpenResultPtr> in_results);
};

bool Directory_OpenFileHandles_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_OpenFileHandles_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_OpenFileHandles_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Directory.2
  bool success = true;
  std::vector<FileOpenResultPtr> p_results{};
  Directory_OpenFileHandles_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_results));
  }
  return true;
}

void Directory_OpenFileHandles_ProxyToResponder::Run(
    std::vector<FileOpenResultPtr> in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply filesystem::mojom::Directory::OpenFileHandles", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type std::vector<FileOpenResultPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kOpenFileHandles), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenFileHandles_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType>
      results_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::filesystem::mojom::FileOpenResultDataView>>(
    in_results,
    results_fragment,
    &results_validate_params);

  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->results.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null results in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFileHandles");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_OpenFileHandles_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_OpenFileHandles_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_OpenFileHandles_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Directory.2
  bool success = true;
  std::vector<FileOpenResultPtr> p_results{};
  Directory_OpenFileHandles_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 2, true);
    return false;
  }
  *out_results_ = std::move(p_results);
  *result_ = true;
  return true;
}
class Directory_OpenDirectory_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::OpenDirectoryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_OpenDirectory_ProxyToResponder> proxy(
        new Directory_OpenDirectory_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_OpenDirectory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_OpenDirectory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_OpenDirectory_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::OpenDirectoryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);
};

bool Directory_OpenDirectory_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_OpenDirectory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_OpenDirectory_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Directory.3
  bool success = true;
  ::base::File::Error p_error{};
  Directory_OpenDirectory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void Directory_OpenDirectory_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply filesystem::mojom::Directory::OpenDirectory", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kOpenDirectory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_OpenDirectory_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error,
    &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenDirectory");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_OpenDirectory_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_OpenDirectory_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_OpenDirectory_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Directory.3
  bool success = true;
  ::base::File::Error p_error{};
  Directory_OpenDirectory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 3, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}
class Directory_Rename_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::RenameCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_Rename_ProxyToResponder> proxy(
        new Directory_Rename_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_Rename_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_Rename_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_Rename_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::RenameCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);
};

bool Directory_Rename_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_Rename_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_Rename_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Directory.4
  bool success = true;
  ::base::File::Error p_error{};
  Directory_Rename_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void Directory_Rename_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply filesystem::mojom::Directory::Rename", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kRename), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Rename_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error,
    &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Rename");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_Rename_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_Rename_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_Rename_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Directory.4
  bool success = true;
  ::base::File::Error p_error{};
  Directory_Rename_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 4, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}
class Directory_Replace_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::ReplaceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_Replace_ProxyToResponder> proxy(
        new Directory_Replace_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_Replace_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_Replace_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_Replace_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::ReplaceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);
};

bool Directory_Replace_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_Replace_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_Replace_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Directory.5
  bool success = true;
  ::base::File::Error p_error{};
  Directory_Replace_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void Directory_Replace_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply filesystem::mojom::Directory::Replace", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kReplace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Replace_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error,
    &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Replace");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_Replace_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_Replace_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_Replace_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Directory.5
  bool success = true;
  ::base::File::Error p_error{};
  Directory_Replace_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 5, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}
class Directory_Delete_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::DeleteCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_Delete_ProxyToResponder> proxy(
        new Directory_Delete_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_Delete_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_Delete_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_Delete_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::DeleteCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);
};

bool Directory_Delete_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_Delete_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_Delete_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Directory.6
  bool success = true;
  ::base::File::Error p_error{};
  Directory_Delete_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void Directory_Delete_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply filesystem::mojom::Directory::Delete", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kDelete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Delete_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error,
    &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Delete");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_Delete_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_Delete_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_Delete_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Directory.6
  bool success = true;
  ::base::File::Error p_error{};
  Directory_Delete_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 6, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}
class Directory_Exists_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::ExistsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_Exists_ProxyToResponder> proxy(
        new Directory_Exists_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_Exists_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_Exists_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_Exists_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::ExistsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, bool in_exists);
};

bool Directory_Exists_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_Exists_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_Exists_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Directory.7
  bool success = true;
  ::base::File::Error p_error{};
  bool p_exists{};
  Directory_Exists_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_exists = input_data_view.exists();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_exists));
  }
  return true;
}

void Directory_Exists_ProxyToResponder::Run(
    ::base::File::Error in_error, bool in_exists) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply filesystem::mojom::Directory::Exists", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("exists"), in_exists,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kExists), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Exists_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error,
    &params->error);

  params->exists = in_exists;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Exists");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_Exists_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_Exists_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_Exists_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Directory.7
  bool success = true;
  ::base::File::Error p_error{};
  bool p_exists{};
  Directory_Exists_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_exists = input_data_view.exists();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 7, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_exists_ = std::move(p_exists);
  *result_ = true;
  return true;
}
class Directory_IsWritable_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::IsWritableCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_IsWritable_ProxyToResponder> proxy(
        new Directory_IsWritable_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_IsWritable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_IsWritable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_IsWritable_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::IsWritableCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, bool in_is_writable);
};

bool Directory_IsWritable_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_IsWritable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_IsWritable_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Directory.8
  bool success = true;
  ::base::File::Error p_error{};
  bool p_is_writable{};
  Directory_IsWritable_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_is_writable = input_data_view.is_writable();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_is_writable));
  }
  return true;
}

void Directory_IsWritable_ProxyToResponder::Run(
    ::base::File::Error in_error, bool in_is_writable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply filesystem::mojom::Directory::IsWritable", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_writable"), in_is_writable,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kIsWritable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_IsWritable_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error,
    &params->error);

  params->is_writable = in_is_writable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("IsWritable");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_IsWritable_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_IsWritable_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_IsWritable_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Directory.8
  bool success = true;
  ::base::File::Error p_error{};
  bool p_is_writable{};
  Directory_IsWritable_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success)
    p_is_writable = input_data_view.is_writable();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 8, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_is_writable_ = std::move(p_is_writable);
  *result_ = true;
  return true;
}
class Directory_Flush_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::FlushCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_Flush_ProxyToResponder> proxy(
        new Directory_Flush_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_Flush_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_Flush_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_Flush_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::FlushCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);
};

bool Directory_Flush_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_Flush_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_Flush_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Directory.9
  bool success = true;
  ::base::File::Error p_error{};
  Directory_Flush_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void Directory_Flush_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply filesystem::mojom::Directory::Flush", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kFlush), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_Flush_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error,
    &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Flush");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_Flush_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_Flush_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_Flush_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Directory.9
  bool success = true;
  ::base::File::Error p_error{};
  Directory_Flush_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 9, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}
class Directory_StatFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::StatFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_StatFile_ProxyToResponder> proxy(
        new Directory_StatFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_StatFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_StatFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_StatFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::StatFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, ::filesystem::mojom::FileInformationPtr in_file_information);
};

bool Directory_StatFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_StatFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_StatFile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Directory.10
  bool success = true;
  ::base::File::Error p_error{};
  ::filesystem::mojom::FileInformationPtr p_file_information{};
  Directory_StatFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadFileInformation(&p_file_information))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_file_information));
  }
  return true;
}

void Directory_StatFile_ProxyToResponder::Run(
    ::base::File::Error in_error, ::filesystem::mojom::FileInformationPtr in_file_information) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply filesystem::mojom::Directory::StatFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_information"), in_file_information,
                        "<value of type ::filesystem::mojom::FileInformationPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kStatFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_StatFile_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->file_information)::BaseType> file_information_fragment(
          params.message());
  
  mojo::internal::Serialize<::filesystem::mojom::FileInformationDataView>(
    in_file_information,
    file_information_fragment);

  params->file_information.Set(
      file_information_fragment.is_null() ? nullptr : file_information_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("StatFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_StatFile_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_StatFile_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_StatFile_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Directory.10
  bool success = true;
  ::base::File::Error p_error{};
  ::filesystem::mojom::FileInformationPtr p_file_information{};
  Directory_StatFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadFileInformation(&p_file_information))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 10, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_file_information_ = std::move(p_file_information);
  *result_ = true;
  return true;
}
class Directory_ReadEntireFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::ReadEntireFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_ReadEntireFile_ProxyToResponder> proxy(
        new Directory_ReadEntireFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_ReadEntireFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_ReadEntireFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_ReadEntireFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::ReadEntireFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, const std::vector<uint8_t>& in_data);
};

bool Directory_ReadEntireFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_ReadEntireFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_ReadEntireFile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Directory.12
  bool success = true;
  ::base::File::Error p_error{};
  std::vector<uint8_t> p_data{};
  Directory_ReadEntireFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_data));
  }
  return true;
}

void Directory_ReadEntireFile_ProxyToResponder::Run(
    ::base::File::Error in_error, const std::vector<uint8_t>& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply filesystem::mojom::Directory::ReadEntireFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kReadEntireFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_ReadEntireFile_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error,
    &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("ReadEntireFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_ReadEntireFile_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_ReadEntireFile_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_ReadEntireFile_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Directory.12
  bool success = true;
  ::base::File::Error p_error{};
  std::vector<uint8_t> p_data{};
  Directory_ReadEntireFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 12, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_data_ = std::move(p_data);
  *result_ = true;
  return true;
}
class Directory_WriteFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::WriteFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_WriteFile_ProxyToResponder> proxy(
        new Directory_WriteFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_WriteFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_WriteFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_WriteFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::WriteFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);
};

bool Directory_WriteFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_WriteFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_WriteFile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Directory.13
  bool success = true;
  ::base::File::Error p_error{};
  Directory_WriteFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void Directory_WriteFile_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply filesystem::mojom::Directory::WriteFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kWriteFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::filesystem::mojom::internal::Directory_WriteFile_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error,
    &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("WriteFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_WriteFile_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_WriteFile_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_WriteFile_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Directory.13
  bool success = true;
  ::base::File::Error p_error{};
  Directory_WriteFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 13, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}

// static
bool DirectoryStubDispatch::Accept(
    Directory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Directory>(message->header()->name)) {
    case messages::Directory::kRead: {
      break;
    }
    case messages::Directory::kOpenFileHandle: {
      break;
    }
    case messages::Directory::kOpenFileHandles: {
      break;
    }
    case messages::Directory::kOpenDirectory: {
      break;
    }
    case messages::Directory::kRename: {
      break;
    }
    case messages::Directory::kReplace: {
      break;
    }
    case messages::Directory::kDelete: {
      break;
    }
    case messages::Directory::kExists: {
      break;
    }
    case messages::Directory::kIsWritable: {
      break;
    }
    case messages::Directory::kFlush: {
      break;
    }
    case messages::Directory::kStatFile: {
      break;
    }
    case messages::Directory::kClone: {
      DCHECK(message->is_serialized());
      internal::Directory_Clone_Params_Data* params =
          reinterpret_cast<internal::Directory_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Directory.11
      bool success = true;
      ::mojo::PendingReceiver<Directory> p_directory{};
      Directory_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_directory =
            input_data_view.TakeDirectory<decltype(p_directory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_directory));
      return true;
    }
    case messages::Directory::kReadEntireFile: {
      break;
    }
    case messages::Directory::kWriteFile: {
      break;
    }
  }
  return false;
}

// static
bool DirectoryStubDispatch::AcceptWithResponder(
    Directory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Directory>(message->header()->name)) {
    case messages::Directory::kRead: {
      internal::Directory_Read_Params_Data* params =
          reinterpret_cast<
              internal::Directory_Read_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Directory.0
      bool success = true;
      Directory_Read_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 0, false);
        return false;
      }
      auto callback =
          Directory_Read_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Read(std::move(callback));
      return true;
    }
    case messages::Directory::kOpenFileHandle: {
      internal::Directory_OpenFileHandle_Params_Data* params =
          reinterpret_cast<
              internal::Directory_OpenFileHandle_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Directory.1
      bool success = true;
      std::string p_path{};
      uint32_t p_open_flags{};
      Directory_OpenFileHandle_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success)
        p_open_flags = input_data_view.open_flags();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 1, false);
        return false;
      }
      auto callback =
          Directory_OpenFileHandle_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenFileHandle(        
        std::move(p_path), 
        std::move(p_open_flags), std::move(callback));
      return true;
    }
    case messages::Directory::kOpenFileHandles: {
      internal::Directory_OpenFileHandles_Params_Data* params =
          reinterpret_cast<
              internal::Directory_OpenFileHandles_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Directory.2
      bool success = true;
      std::vector<FileOpenDetailsPtr> p_files{};
      Directory_OpenFileHandles_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFiles(&p_files))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 2, false);
        return false;
      }
      auto callback =
          Directory_OpenFileHandles_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenFileHandles(        
        std::move(p_files), std::move(callback));
      return true;
    }
    case messages::Directory::kOpenDirectory: {
      internal::Directory_OpenDirectory_Params_Data* params =
          reinterpret_cast<
              internal::Directory_OpenDirectory_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Directory.3
      bool success = true;
      std::string p_path{};
      ::mojo::PendingReceiver<Directory> p_directory{};
      uint32_t p_open_flags{};
      Directory_OpenDirectory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success) {
        p_directory =
            input_data_view.TakeDirectory<decltype(p_directory)>();
      }
      if (success)
        p_open_flags = input_data_view.open_flags();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 3, false);
        return false;
      }
      auto callback =
          Directory_OpenDirectory_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenDirectory(        
        std::move(p_path), 
        std::move(p_directory), 
        std::move(p_open_flags), std::move(callback));
      return true;
    }
    case messages::Directory::kRename: {
      internal::Directory_Rename_Params_Data* params =
          reinterpret_cast<
              internal::Directory_Rename_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Directory.4
      bool success = true;
      std::string p_path{};
      std::string p_new_path{};
      Directory_Rename_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success && !input_data_view.ReadNewPath(&p_new_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 4, false);
        return false;
      }
      auto callback =
          Directory_Rename_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Rename(        
        std::move(p_path), 
        std::move(p_new_path), std::move(callback));
      return true;
    }
    case messages::Directory::kReplace: {
      internal::Directory_Replace_Params_Data* params =
          reinterpret_cast<
              internal::Directory_Replace_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Directory.5
      bool success = true;
      std::string p_path{};
      std::string p_new_path{};
      Directory_Replace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success && !input_data_view.ReadNewPath(&p_new_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 5, false);
        return false;
      }
      auto callback =
          Directory_Replace_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Replace(        
        std::move(p_path), 
        std::move(p_new_path), std::move(callback));
      return true;
    }
    case messages::Directory::kDelete: {
      internal::Directory_Delete_Params_Data* params =
          reinterpret_cast<
              internal::Directory_Delete_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Directory.6
      bool success = true;
      std::string p_path{};
      uint32_t p_delete_flags{};
      Directory_Delete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success)
        p_delete_flags = input_data_view.delete_flags();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 6, false);
        return false;
      }
      auto callback =
          Directory_Delete_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Delete(        
        std::move(p_path), 
        std::move(p_delete_flags), std::move(callback));
      return true;
    }
    case messages::Directory::kExists: {
      internal::Directory_Exists_Params_Data* params =
          reinterpret_cast<
              internal::Directory_Exists_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Directory.7
      bool success = true;
      std::string p_path{};
      Directory_Exists_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 7, false);
        return false;
      }
      auto callback =
          Directory_Exists_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Exists(        
        std::move(p_path), std::move(callback));
      return true;
    }
    case messages::Directory::kIsWritable: {
      internal::Directory_IsWritable_Params_Data* params =
          reinterpret_cast<
              internal::Directory_IsWritable_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Directory.8
      bool success = true;
      std::string p_path{};
      Directory_IsWritable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 8, false);
        return false;
      }
      auto callback =
          Directory_IsWritable_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsWritable(        
        std::move(p_path), std::move(callback));
      return true;
    }
    case messages::Directory::kFlush: {
      internal::Directory_Flush_Params_Data* params =
          reinterpret_cast<
              internal::Directory_Flush_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Directory.9
      bool success = true;
      Directory_Flush_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 9, false);
        return false;
      }
      auto callback =
          Directory_Flush_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Flush(std::move(callback));
      return true;
    }
    case messages::Directory::kStatFile: {
      internal::Directory_StatFile_Params_Data* params =
          reinterpret_cast<
              internal::Directory_StatFile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Directory.10
      bool success = true;
      std::string p_path{};
      Directory_StatFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 10, false);
        return false;
      }
      auto callback =
          Directory_StatFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StatFile(        
        std::move(p_path), std::move(callback));
      return true;
    }
    case messages::Directory::kClone: {
      break;
    }
    case messages::Directory::kReadEntireFile: {
      internal::Directory_ReadEntireFile_Params_Data* params =
          reinterpret_cast<
              internal::Directory_ReadEntireFile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Directory.12
      bool success = true;
      std::string p_path{};
      Directory_ReadEntireFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 12, false);
        return false;
      }
      auto callback =
          Directory_ReadEntireFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadEntireFile(        
        std::move(p_path), std::move(callback));
      return true;
    }
    case messages::Directory::kWriteFile: {
      internal::Directory_WriteFile_Params_Data* params =
          reinterpret_cast<
              internal::Directory_WriteFile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Directory.13
      bool success = true;
      std::string p_path{};
      std::vector<uint8_t> p_data{};
      Directory_WriteFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 13, false);
        return false;
      }
      auto callback =
          Directory_WriteFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteFile(        
        std::move(p_path), 
        std::move(p_data), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDirectoryValidationInfo[] = {
    {base::to_underlying(messages::Directory::kRead),
     { &internal::Directory_Read_Params_Data::Validate,
      &internal::Directory_Read_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kOpenFileHandle),
     { &internal::Directory_OpenFileHandle_Params_Data::Validate,
      &internal::Directory_OpenFileHandle_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kOpenFileHandles),
     { &internal::Directory_OpenFileHandles_Params_Data::Validate,
      &internal::Directory_OpenFileHandles_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kOpenDirectory),
     { &internal::Directory_OpenDirectory_Params_Data::Validate,
      &internal::Directory_OpenDirectory_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kRename),
     { &internal::Directory_Rename_Params_Data::Validate,
      &internal::Directory_Rename_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kReplace),
     { &internal::Directory_Replace_Params_Data::Validate,
      &internal::Directory_Replace_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kDelete),
     { &internal::Directory_Delete_Params_Data::Validate,
      &internal::Directory_Delete_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kExists),
     { &internal::Directory_Exists_Params_Data::Validate,
      &internal::Directory_Exists_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kIsWritable),
     { &internal::Directory_IsWritable_Params_Data::Validate,
      &internal::Directory_IsWritable_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kFlush),
     { &internal::Directory_Flush_Params_Data::Validate,
      &internal::Directory_Flush_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kStatFile),
     { &internal::Directory_StatFile_Params_Data::Validate,
      &internal::Directory_StatFile_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kClone),
     { &internal::Directory_Clone_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Directory::kReadEntireFile),
     { &internal::Directory_ReadEntireFile_Params_Data::Validate,
      &internal::Directory_ReadEntireFile_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kWriteFile),
     { &internal::Directory_WriteFile_Params_Data::Validate,
      &internal::Directory_WriteFile_ResponseParams_Data::Validate}},
};

bool DirectoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::filesystem::mojom::Directory::Name_,
    kDirectoryValidationInfo);
}

bool DirectoryResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::filesystem::mojom::Directory::Name_,
    kDirectoryValidationInfo);

}


}  // filesystem::mojom


namespace mojo {


// static
bool StructTraits<::filesystem::mojom::FileOpenDetails::DataView, ::filesystem::mojom::FileOpenDetailsPtr>::Read(
    ::filesystem::mojom::FileOpenDetails::DataView input,
    ::filesystem::mojom::FileOpenDetailsPtr* output) {
  bool success = true;
  ::filesystem::mojom::FileOpenDetailsPtr result(::filesystem::mojom::FileOpenDetails::New());
  
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success)
        result->open_flags = input.open_flags();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::filesystem::mojom::FileOpenResult::DataView, ::filesystem::mojom::FileOpenResultPtr>::Read(
    ::filesystem::mojom::FileOpenResult::DataView input,
    ::filesystem::mojom::FileOpenResultPtr* output) {
  bool success = true;
  ::filesystem::mojom::FileOpenResultPtr result(::filesystem::mojom::FileOpenResult::New());
  
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success && !input.ReadError(&result->error))
        success = false;
      if (success && !input.ReadFileHandle(&result->file_handle))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace filesystem::mojom {


void DirectoryInterceptorForTesting::Read(ReadCallback callback) {
  GetForwardingInterface()->Read(std::move(callback));
}
void DirectoryInterceptorForTesting::OpenFileHandle(const std::string& path, uint32_t open_flags, OpenFileHandleCallback callback) {
  GetForwardingInterface()->OpenFileHandle(
    std::move(path)
    , 
    std::move(open_flags)
    , std::move(callback));
}
void DirectoryInterceptorForTesting::OpenFileHandles(std::vector<FileOpenDetailsPtr> files, OpenFileHandlesCallback callback) {
  GetForwardingInterface()->OpenFileHandles(
    std::move(files)
    , std::move(callback));
}
void DirectoryInterceptorForTesting::OpenDirectory(const std::string& path, ::mojo::PendingReceiver<Directory> directory, uint32_t open_flags, OpenDirectoryCallback callback) {
  GetForwardingInterface()->OpenDirectory(
    std::move(path)
    , 
    std::move(directory)
    , 
    std::move(open_flags)
    , std::move(callback));
}
void DirectoryInterceptorForTesting::Rename(const std::string& path, const std::string& new_path, RenameCallback callback) {
  GetForwardingInterface()->Rename(
    std::move(path)
    , 
    std::move(new_path)
    , std::move(callback));
}
void DirectoryInterceptorForTesting::Replace(const std::string& path, const std::string& new_path, ReplaceCallback callback) {
  GetForwardingInterface()->Replace(
    std::move(path)
    , 
    std::move(new_path)
    , std::move(callback));
}
void DirectoryInterceptorForTesting::Delete(const std::string& path, uint32_t delete_flags, DeleteCallback callback) {
  GetForwardingInterface()->Delete(
    std::move(path)
    , 
    std::move(delete_flags)
    , std::move(callback));
}
void DirectoryInterceptorForTesting::Exists(const std::string& path, ExistsCallback callback) {
  GetForwardingInterface()->Exists(
    std::move(path)
    , std::move(callback));
}
void DirectoryInterceptorForTesting::IsWritable(const std::string& path, IsWritableCallback callback) {
  GetForwardingInterface()->IsWritable(
    std::move(path)
    , std::move(callback));
}
void DirectoryInterceptorForTesting::Flush(FlushCallback callback) {
  GetForwardingInterface()->Flush(std::move(callback));
}
void DirectoryInterceptorForTesting::StatFile(const std::string& path, StatFileCallback callback) {
  GetForwardingInterface()->StatFile(
    std::move(path)
    , std::move(callback));
}
void DirectoryInterceptorForTesting::Clone(::mojo::PendingReceiver<Directory> directory) {
  GetForwardingInterface()->Clone(
    std::move(directory)
    );
}
void DirectoryInterceptorForTesting::ReadEntireFile(const std::string& path, ReadEntireFileCallback callback) {
  GetForwardingInterface()->ReadEntireFile(
    std::move(path)
    , std::move(callback));
}
void DirectoryInterceptorForTesting::WriteFile(const std::string& path, const std::vector<uint8_t>& data, WriteFileCallback callback) {
  GetForwardingInterface()->WriteFile(
    std::move(path)
    , 
    std::move(data)
    , std::move(callback));
}
DirectoryAsyncWaiter::DirectoryAsyncWaiter(
    Directory* proxy) : proxy_(proxy) {}

DirectoryAsyncWaiter::~DirectoryAsyncWaiter() = default;


void DirectoryAsyncWaiter::Read(
    ::base::File::Error* out_error, std::optional<std::vector<::filesystem::mojom::DirectoryEntryPtr>>* out_directory_contents) {
  base::RunLoop loop;
  proxy_->Read(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             std::optional<std::vector<::filesystem::mojom::DirectoryEntryPtr>>* out_directory_contents
,
             ::base::File::Error error,
             std::optional<std::vector<::filesystem::mojom::DirectoryEntryPtr>> directory_contents) {*out_error = std::move(error);*out_directory_contents = std::move(directory_contents);
            loop->Quit();
          },
          &loop,
          out_error,
          out_directory_contents));
  loop.Run();
}



void DirectoryAsyncWaiter::OpenFileHandle(
    const std::string& path, uint32_t open_flags, ::base::File::Error* out_error, ::base::File* out_file_handle) {
  base::RunLoop loop;
  proxy_->OpenFileHandle(
      std::move(path),
      std::move(open_flags),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             ::base::File* out_file_handle
,
             ::base::File::Error error,
             ::base::File file_handle) {*out_error = std::move(error);*out_file_handle = std::move(file_handle);
            loop->Quit();
          },
          &loop,
          out_error,
          out_file_handle));
  loop.Run();
}



void DirectoryAsyncWaiter::OpenFileHandles(
    std::vector<FileOpenDetailsPtr> files, std::vector<FileOpenResultPtr>* out_results) {
  base::RunLoop loop;
  proxy_->OpenFileHandles(
      std::move(files),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<FileOpenResultPtr>* out_results
,
             std::vector<FileOpenResultPtr> results) {*out_results = std::move(results);
            loop->Quit();
          },
          &loop,
          out_results));
  loop.Run();
}

std::vector<FileOpenResultPtr> DirectoryAsyncWaiter::OpenFileHandles(
    std::vector<FileOpenDetailsPtr> files) {
  std::vector<FileOpenResultPtr> async_wait_result;
  OpenFileHandles(std::move(files),&async_wait_result);
  return async_wait_result;
}

void DirectoryAsyncWaiter::OpenDirectory(
    const std::string& path, ::mojo::PendingReceiver<Directory> directory, uint32_t open_flags, ::base::File::Error* out_error) {
  base::RunLoop loop;
  proxy_->OpenDirectory(
      std::move(path),
      std::move(directory),
      std::move(open_flags),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             ::base::File::Error error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

::base::File::Error DirectoryAsyncWaiter::OpenDirectory(
    const std::string& path, ::mojo::PendingReceiver<Directory> directory, uint32_t open_flags) {
  ::base::File::Error async_wait_result;
  OpenDirectory(std::move(path),std::move(directory),std::move(open_flags),&async_wait_result);
  return async_wait_result;
}

void DirectoryAsyncWaiter::Rename(
    const std::string& path, const std::string& new_path, ::base::File::Error* out_error) {
  base::RunLoop loop;
  proxy_->Rename(
      std::move(path),
      std::move(new_path),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             ::base::File::Error error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

::base::File::Error DirectoryAsyncWaiter::Rename(
    const std::string& path, const std::string& new_path) {
  ::base::File::Error async_wait_result;
  Rename(std::move(path),std::move(new_path),&async_wait_result);
  return async_wait_result;
}

void DirectoryAsyncWaiter::Replace(
    const std::string& path, const std::string& new_path, ::base::File::Error* out_error) {
  base::RunLoop loop;
  proxy_->Replace(
      std::move(path),
      std::move(new_path),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             ::base::File::Error error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

::base::File::Error DirectoryAsyncWaiter::Replace(
    const std::string& path, const std::string& new_path) {
  ::base::File::Error async_wait_result;
  Replace(std::move(path),std::move(new_path),&async_wait_result);
  return async_wait_result;
}

void DirectoryAsyncWaiter::Delete(
    const std::string& path, uint32_t delete_flags, ::base::File::Error* out_error) {
  base::RunLoop loop;
  proxy_->Delete(
      std::move(path),
      std::move(delete_flags),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             ::base::File::Error error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

::base::File::Error DirectoryAsyncWaiter::Delete(
    const std::string& path, uint32_t delete_flags) {
  ::base::File::Error async_wait_result;
  Delete(std::move(path),std::move(delete_flags),&async_wait_result);
  return async_wait_result;
}

void DirectoryAsyncWaiter::Exists(
    const std::string& path, ::base::File::Error* out_error, bool* out_exists) {
  base::RunLoop loop;
  proxy_->Exists(
      std::move(path),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             bool* out_exists
,
             ::base::File::Error error,
             bool exists) {*out_error = std::move(error);*out_exists = std::move(exists);
            loop->Quit();
          },
          &loop,
          out_error,
          out_exists));
  loop.Run();
}



void DirectoryAsyncWaiter::IsWritable(
    const std::string& path, ::base::File::Error* out_error, bool* out_is_writable) {
  base::RunLoop loop;
  proxy_->IsWritable(
      std::move(path),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             bool* out_is_writable
,
             ::base::File::Error error,
             bool is_writable) {*out_error = std::move(error);*out_is_writable = std::move(is_writable);
            loop->Quit();
          },
          &loop,
          out_error,
          out_is_writable));
  loop.Run();
}



void DirectoryAsyncWaiter::Flush(
    ::base::File::Error* out_error) {
  base::RunLoop loop;
  proxy_->Flush(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             ::base::File::Error error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

::base::File::Error DirectoryAsyncWaiter::Flush(
    ) {
  ::base::File::Error async_wait_result;
  Flush(&async_wait_result);
  return async_wait_result;
}

void DirectoryAsyncWaiter::StatFile(
    const std::string& path, ::base::File::Error* out_error, ::filesystem::mojom::FileInformationPtr* out_file_information) {
  base::RunLoop loop;
  proxy_->StatFile(
      std::move(path),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             ::filesystem::mojom::FileInformationPtr* out_file_information
,
             ::base::File::Error error,
             ::filesystem::mojom::FileInformationPtr file_information) {*out_error = std::move(error);*out_file_information = std::move(file_information);
            loop->Quit();
          },
          &loop,
          out_error,
          out_file_information));
  loop.Run();
}



void DirectoryAsyncWaiter::ReadEntireFile(
    const std::string& path, ::base::File::Error* out_error, std::vector<uint8_t>* out_data) {
  base::RunLoop loop;
  proxy_->ReadEntireFile(
      std::move(path),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             std::vector<uint8_t>* out_data
,
             ::base::File::Error error,
             const std::vector<uint8_t>& data) {*out_error = std::move(error);*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_error,
          out_data));
  loop.Run();
}



void DirectoryAsyncWaiter::WriteFile(
    const std::string& path, const std::vector<uint8_t>& data, ::base::File::Error* out_error) {
  base::RunLoop loop;
  proxy_->WriteFile(
      std::move(path),
      std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             ::base::File::Error error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

::base::File::Error DirectoryAsyncWaiter::WriteFile(
    const std::string& path, const std::vector<uint8_t>& data) {
  ::base::File::Error async_wait_result;
  WriteFile(std::move(path),std::move(data),&async_wait_result);
  return async_wait_result;
}






}  // filesystem::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif