// components/services/storage/privileged/mojom/bucket_client_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_BUCKET_CLIENT_INFO_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_BUCKET_CLIENT_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/privileged/mojom/bucket_client_info.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"




#include "components/services/storage/privileged/mojom/bucket_client_info.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::BucketClientInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::BucketClientInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::BucketClientInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->process_id = Traits::process_id(input);

    decltype(Traits::context_token(input)) in_context_token = Traits::context_token(input);
    mojo::internal::MessageFragment<decltype(fragment->context_token)>
        context_token_fragment(fragment.message());
    context_token_fragment.Claim(&fragment->context_token);
    
    mojo::internal::Serialize<::blink::mojom::ExecutionContextTokenDataView>(
      in_context_token,
      context_token_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->context_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null context_token in BucketClientInfo struct");

    decltype(Traits::document_token(input)) in_document_token = Traits::document_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->document_token)::BaseType> document_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::DocumentTokenDataView>(
      in_document_token,
      document_token_fragment);

    fragment->document_token.Set(
        document_token_fragment.is_null() ? nullptr : document_token_fragment.data());
  }

  static bool Deserialize(::storage::mojom::internal::BucketClientInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::BucketClientInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace storage::mojom {

inline void BucketClientInfoDataView::GetContextTokenDataView(
    ::blink::mojom::ExecutionContextTokenDataView* output) {
  auto pointer = &data_->context_token;
  *output = ::blink::mojom::ExecutionContextTokenDataView(pointer, message_);
}
inline void BucketClientInfoDataView::GetDocumentTokenDataView(
    ::blink::mojom::DocumentTokenDataView* output) {
  auto pointer = data_->document_token.Get();
  *output = ::blink::mojom::DocumentTokenDataView(pointer, message_);
}



}  // storage::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_BUCKET_CLIENT_INFO_MOJOM_SHARED_H_