// extensions/common/mojom/app_window.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/app_window.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/app_window.mojom-params-data.h"
#include "extensions/common/mojom/app_window.mojom-shared-message-ids.h"

#include "extensions/common/mojom/app_window.mojom-import-headers.h"
#include "extensions/common/mojom/app_window.mojom-test-utils.h"


namespace extensions::mojom {
// The declaration includes the definition on other builds.

AppWindow::IPCStableHashFunction AppWindow::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AppWindow>(message.name())) {
    case messages::AppWindow::kSetVisuallyDeemphasized: {
      return &AppWindow::SetVisuallyDeemphasized_Sym::IPCStableHash;
    }
    case messages::AppWindow::kSetSupportsDraggableRegions: {
      return &AppWindow::SetSupportsDraggableRegions_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AppWindow::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AppWindow>(message.name())) {
      case messages::AppWindow::kSetVisuallyDeemphasized:
            return "Receive extensions::mojom::AppWindow::SetVisuallyDeemphasized";
      case messages::AppWindow::kSetSupportsDraggableRegions:
            return "Receive extensions::mojom::AppWindow::SetSupportsDraggableRegions";
    }
  } else {
    switch (static_cast<messages::AppWindow>(message.name())) {
      case messages::AppWindow::kSetVisuallyDeemphasized:
            return "Receive reply extensions::mojom::AppWindow::SetVisuallyDeemphasized";
      case messages::AppWindow::kSetSupportsDraggableRegions:
            return "Receive reply extensions::mojom::AppWindow::SetSupportsDraggableRegions";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AppWindow::SetVisuallyDeemphasized_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x51eca665;  // IPCStableHash for extensions::mojom::AppWindow::SetVisuallyDeemphasized
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppWindow::SetSupportsDraggableRegions_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x78608c02;  // IPCStableHash for extensions::mojom::AppWindow::SetSupportsDraggableRegions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AppWindowProxy::AppWindowProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AppWindowProxy::SetVisuallyDeemphasized(
    bool in_deemphasized) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::AppWindow::SetVisuallyDeemphasized", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("deemphasized"), in_deemphasized,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppWindow::kSetVisuallyDeemphasized), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::AppWindow_SetVisuallyDeemphasized_Params_Data> params(
          message);
  params.Allocate();

  params->deemphasized = in_deemphasized;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppWindow::Name_);
  message.set_method_name("SetVisuallyDeemphasized");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AppWindowProxy::SetSupportsDraggableRegions(
    bool in_supports_draggable_regions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::AppWindow::SetSupportsDraggableRegions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("supports_draggable_regions"), in_supports_draggable_regions,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppWindow::kSetSupportsDraggableRegions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::AppWindow_SetSupportsDraggableRegions_Params_Data> params(
          message);
  params.Allocate();

  params->supports_draggable_regions = in_supports_draggable_regions;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppWindow::Name_);
  message.set_method_name("SetSupportsDraggableRegions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AppWindowStubDispatch::Accept(
    AppWindow* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AppWindow>(message->header()->name)) {
    case messages::AppWindow::kSetVisuallyDeemphasized: {
      DCHECK(message->is_serialized());
      internal::AppWindow_SetVisuallyDeemphasized_Params_Data* params =
          reinterpret_cast<internal::AppWindow_SetVisuallyDeemphasized_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppWindow.0
      bool success = true;
      bool p_deemphasized{};
      AppWindow_SetVisuallyDeemphasized_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_deemphasized = input_data_view.deemphasized();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppWindow::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVisuallyDeemphasized(        
        std::move(p_deemphasized));
      return true;
    }
    case messages::AppWindow::kSetSupportsDraggableRegions: {
      DCHECK(message->is_serialized());
      internal::AppWindow_SetSupportsDraggableRegions_Params_Data* params =
          reinterpret_cast<internal::AppWindow_SetSupportsDraggableRegions_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppWindow.1
      bool success = true;
      bool p_supports_draggable_regions{};
      AppWindow_SetSupportsDraggableRegions_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_supports_draggable_regions = input_data_view.supports_draggable_regions();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppWindow::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSupportsDraggableRegions(        
        std::move(p_supports_draggable_regions));
      return true;
    }
  }
  return false;
}

// static
bool AppWindowStubDispatch::AcceptWithResponder(
    AppWindow* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AppWindow>(message->header()->name)) {
    case messages::AppWindow::kSetVisuallyDeemphasized: {
      break;
    }
    case messages::AppWindow::kSetSupportsDraggableRegions: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAppWindowValidationInfo[] = {
    {base::to_underlying(messages::AppWindow::kSetVisuallyDeemphasized),
     { &internal::AppWindow_SetVisuallyDeemphasized_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::AppWindow::kSetSupportsDraggableRegions),
     { &internal::AppWindow_SetSupportsDraggableRegions_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AppWindowRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::extensions::mojom::AppWindow::Name_,
    kAppWindowValidationInfo);
}



}  // extensions::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace extensions::mojom {


void AppWindowInterceptorForTesting::SetVisuallyDeemphasized(bool deemphasized) {
  GetForwardingInterface()->SetVisuallyDeemphasized(
    std::move(deemphasized)
    );
}
void AppWindowInterceptorForTesting::SetSupportsDraggableRegions(bool supports_draggable_regions) {
  GetForwardingInterface()->SetSupportsDraggableRegions(
    std::move(supports_draggable_regions)
    );
}
AppWindowAsyncWaiter::AppWindowAsyncWaiter(
    AppWindow* proxy) : proxy_(proxy) {}

AppWindowAsyncWaiter::~AppWindowAsyncWaiter() = default;







}  // extensions::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif