// extensions/common/mojom/event_router.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_EVENT_ROUTER_MOJOM_DATA_VIEW_H_
#define EXTENSIONS_COMMON_MOJOM_EVENT_ROUTER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "extensions/common/mojom/event_router.mojom-shared-internal.h"
#include "extensions/common/mojom/extension_id.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace extensions::mojom {
class ServiceWorkerContextDataView;

class EventListenerDataView;

class EventListenerOwnerDataView;


}  // extensions::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::extensions::mojom::ServiceWorkerContextDataView> {
  using Data = ::extensions::mojom::internal::ServiceWorkerContext_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::EventListenerDataView> {
  using Data = ::extensions::mojom::internal::EventListener_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::EventListenerOwnerDataView> {
  using Data = ::extensions::mojom::internal::EventListenerOwner_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace extensions::mojom {
// Interface base classes. They are used for type safety check.
class EventRouterInterfaceBase {};

using EventRouterPtrDataView =
    mojo::InterfacePtrDataView<EventRouterInterfaceBase>;
using EventRouterRequestDataView =
    mojo::InterfaceRequestDataView<EventRouterInterfaceBase>;
using EventRouterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<EventRouterInterfaceBase>;
using EventRouterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<EventRouterInterfaceBase>;


class ServiceWorkerContextDataView {
 public:
  ServiceWorkerContextDataView() = default;

  ServiceWorkerContextDataView(
      internal::ServiceWorkerContext_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScopeUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScopeUrl(UserType* output) {
    
    auto* pointer = data_->scope_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  int64_t version_id() const {
    return data_->version_id;
  }
  int32_t thread_id() const {
    return data_->thread_id;
  }
 private:
  internal::ServiceWorkerContext_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EventListenerDataView {
 public:
  EventListenerDataView() = default;

  EventListenerDataView(
      internal::EventListener_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetListenerOwnerDataView(
      EventListenerOwnerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadListenerOwner(UserType* output) {
    
    auto* pointer = !data_->listener_owner.is_null() ? &data_->listener_owner : nullptr;
    return mojo::internal::Deserialize<::extensions::mojom::EventListenerOwnerDataView>(
        pointer, output, message_);
  }
  inline void GetEventNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventName(UserType* output) {
    
    auto* pointer = data_->event_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetServiceWorkerContextDataView(
      ServiceWorkerContextDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceWorkerContext(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::extensions::mojom::ServiceWorkerContextDataView, UserType>(),
    "Attempting to read the optional `service_worker_context` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadServiceWorkerContext` instead "
    "of `ReadServiceWorkerContext if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->service_worker_context.Get();
    return mojo::internal::Deserialize<::extensions::mojom::ServiceWorkerContextDataView>(
        pointer, output, message_);
  }
  inline void GetFilterDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilter(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::DictionaryValueDataView, UserType>(),
    "Attempting to read the optional `filter` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFilter` instead "
    "of `ReadFilter if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->filter.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::EventListener_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EventListenerOwnerDataView {
 public:
  using Tag = internal::EventListenerOwner_Data::EventListenerOwner_Tag;

  EventListenerOwnerDataView() = default;

  EventListenerOwnerDataView(
      internal::EventListenerOwner_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_extension_id() const { return data_->tag == Tag::kExtensionId; }
  inline void GetExtensionIdDataView(
      ::extensions::mojom::ExtensionIdDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionId(UserType* output) const {
    
    CHECK(is_extension_id());
    return mojo::internal::Deserialize<::extensions::mojom::ExtensionIdDataView>(
        data_->data.f_extension_id.Get(), output, message_);
  }
  bool is_listener_url() const { return data_->tag == Tag::kListenerUrl; }
  inline void GetListenerUrlDataView(
      ::url::mojom::UrlDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadListenerUrl(UserType* output) const {
    
    CHECK(is_listener_url());
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        data_->data.f_listener_url.Get(), output, message_);
  }

 private:
  internal::EventListenerOwner_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // extensions::mojom

#endif  // EXTENSIONS_COMMON_MOJOM_EVENT_ROUTER_MOJOM_DATA_VIEW_H_