// extensions/common/mojom/frame.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_H_
#define EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/frame.mojom-features.h"  // IWYU pragma: export
#include "extensions/common/mojom/frame.mojom-shared.h"  // IWYU pragma: export
#include "extensions/common/mojom/frame.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/uuid.mojom.h"
#include "extensions/common/mojom/code_injection.mojom.h"
#include "extensions/common/mojom/context_type.mojom-forward.h"
#include "extensions/common/mojom/extra_response_data.mojom-forward.h"
#include "extensions/common/mojom/host_id.mojom.h"
#include "extensions/common/mojom/injection_type.mojom-forward.h"
#include "extensions/common/mojom/extension_id.mojom.h"
#include "extensions/common/mojom/match_origin_as_fallback.mojom-forward.h"
#include "extensions/common/mojom/message_port.mojom.h"
#include "extensions/common/mojom/run_location.mojom-forward.h"
#include "extensions/common/mojom/stack_frame.mojom.h"
#include "extensions/common/mojom/view_type.mojom-forward.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace extensions::mojom {

class LocalFrameProxy;

template <typename ImplRefTraits>
class LocalFrameStub;

class LocalFrameRequestValidator;
class LocalFrameResponseValidator;


class LocalFrame
    : public LocalFrameInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "extensions.mojom.LocalFrame";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LocalFrameInterfaceBase;
  using Proxy_ = LocalFrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = LocalFrameStub<ImplRefTraits>;

  using RequestValidator_ = LocalFrameRequestValidator;
  using ResponseValidator_ = LocalFrameResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetFrameNameMinVersion = 0,
    kSetSpatialNavigationEnabledMinVersion = 0,
    kSetTabIdMinVersion = 0,
    kAppWindowClosedMinVersion = 0,
    kNotifyRenderViewTypeMinVersion = 0,
    kMessageInvokeMinVersion = 0,
    kExecuteCodeMinVersion = 0,
    kExecuteDeclarativeScriptMinVersion = 0,
    kUpdateBrowserWindowIdMinVersion = 0,
    kDispatchOnConnectMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetFrameName_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSpatialNavigationEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTabId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AppWindowClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyRenderViewType_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MessageInvoke_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExecuteCode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExecuteDeclarativeScript_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateBrowserWindowId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchOnConnect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LocalFrame() = default;

  virtual void SetFrameName(const std::string& frame_name) = 0;

  virtual void SetSpatialNavigationEnabled(bool spatial_nav_enabled) = 0;

  virtual void SetTabId(int32_t tab_id) = 0;

  virtual void AppWindowClosed(bool send_onclosed) = 0;

  virtual void NotifyRenderViewType(::extensions::mojom::ViewType view_type) = 0;

  virtual void MessageInvoke(const ::extensions::ExtensionId& extension_id, const std::string& module_name, const std::string& function_name, ::base::Value::List args) = 0;

  using ExecuteCodeCallback = base::OnceCallback<void(const std::string&, const ::GURL&, std::optional<::base::Value>)>;
  using ExecuteCodeMojoCallback = base::OnceCallback<void(const std::string&, const ::GURL&, std::optional<::base::Value>)>;

  virtual void ExecuteCode(ExecuteCodeParamsPtr param, ExecuteCodeCallback callback) = 0;

  virtual void ExecuteDeclarativeScript(int32_t tab_id, const ::extensions::ExtensionId& extension_id, const std::string& script_id, const ::GURL& url) = 0;

  virtual void UpdateBrowserWindowId(int32_t window_id) = 0;

  using DispatchOnConnectCallback = base::OnceCallback<void(bool)>;
  using DispatchOnConnectMojoCallback = base::OnceCallback<void(bool)>;

  virtual void DispatchOnConnect(const ::extensions::PortId& port_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, ::extensions::mojom::TabConnectionInfoPtr tab_info, ::extensions::mojom::ExternalConnectionInfoPtr external_connection_info, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost> port_host, DispatchOnConnectCallback callback) = 0;
};

class LocalFrameHostProxy;

template <typename ImplRefTraits>
class LocalFrameHostStub;

class LocalFrameHostRequestValidator;
class LocalFrameHostResponseValidator;


class LocalFrameHost
    : public LocalFrameHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "extensions.mojom.LocalFrameHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LocalFrameHostInterfaceBase;
  using Proxy_ = LocalFrameHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = LocalFrameHostStub<ImplRefTraits>;

  using RequestValidator_ = LocalFrameHostRequestValidator;
  using ResponseValidator_ = LocalFrameHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestScriptInjectionPermissionMinVersion = 0,
    kGetAppInstallStateMinVersion = 0,
    kRequestMinVersion = 0,
    kResponseAckMinVersion = 0,
    kWatchedPageChangeMinVersion = 0,
    kDetailedConsoleMessageAddedMinVersion = 0,
    kContentScriptsExecutingMinVersion = 0,
    kIncrementLazyKeepaliveCountMinVersion = 0,
    kDecrementLazyKeepaliveCountMinVersion = 0,
    kAppWindowReadyMinVersion = 0,
    kOpenChannelToExtensionMinVersion = 0,
    kOpenChannelToNativeAppMinVersion = 0,
    kOpenChannelToTabMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestScriptInjectionPermission_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAppInstallState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Request_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResponseAck_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WatchedPageChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DetailedConsoleMessageAdded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ContentScriptsExecuting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IncrementLazyKeepaliveCount_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DecrementLazyKeepaliveCount_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AppWindowReady_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenChannelToExtension_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenChannelToNativeApp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenChannelToTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LocalFrameHost() = default;

  using RequestScriptInjectionPermissionCallback = base::OnceCallback<void(bool)>;
  using RequestScriptInjectionPermissionMojoCallback = base::OnceCallback<void(bool)>;

  virtual void RequestScriptInjectionPermission(const ::extensions::ExtensionId& extension_id, ::extensions::mojom::InjectionType script_type, ::extensions::mojom::RunLocation run_location, RequestScriptInjectionPermissionCallback callback) = 0;

  using GetAppInstallStateCallback = base::OnceCallback<void(const std::string&)>;
  using GetAppInstallStateMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void GetAppInstallState(const ::GURL& url, GetAppInstallStateCallback callback) = 0;

  using RequestCallback = base::OnceCallback<void(bool, ::base::Value::List, const std::string&, ::extensions::mojom::ExtraResponseDataPtr)>;
  using RequestMojoCallback = base::OnceCallback<void(bool, ::base::Value::List, const std::string&, ::extensions::mojom::ExtraResponseDataPtr)>;

  virtual void Request(RequestParamsPtr params, RequestCallback callback) = 0;

  virtual void ResponseAck(const ::base::Uuid& request_uuid) = 0;

  virtual void WatchedPageChange(const std::vector<std::string>& css_selectors) = 0;

  virtual void DetailedConsoleMessageAdded(const ::std::u16string& message, const ::std::u16string& source, const std::vector<::extensions::StackFrame>& stack_trace, ::blink::mojom::ConsoleMessageLevel level) = 0;

  virtual void ContentScriptsExecuting(const base::flat_map<std::string, std::vector<std::string>>& extension_id_to_scripts, const ::GURL& frame_url) = 0;

  virtual void IncrementLazyKeepaliveCount() = 0;

  virtual void DecrementLazyKeepaliveCount() = 0;

  virtual void AppWindowReady() = 0;

  virtual void OpenChannelToExtension(::extensions::mojom::ExternalConnectionInfoPtr info, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) = 0;

  virtual void OpenChannelToNativeApp(const std::string& native_app_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) = 0;

  virtual void OpenChannelToTab(int32_t tab_id, int32_t frame_id, const std::optional<std::string>& document_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) = 0;
};



class  LocalFrameProxy
    : public LocalFrame {
 public:
  using InterfaceType = LocalFrame;

  explicit LocalFrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetFrameName(const std::string& frame_name) final;
  
  void SetSpatialNavigationEnabled(bool spatial_nav_enabled) final;
  
  void SetTabId(int32_t tab_id) final;
  
  void AppWindowClosed(bool send_onclosed) final;
  
  void NotifyRenderViewType(::extensions::mojom::ViewType view_type) final;
  
  void MessageInvoke(const ::extensions::ExtensionId& extension_id, const std::string& module_name, const std::string& function_name, ::base::Value::List args) final;
  
  void ExecuteCode(ExecuteCodeParamsPtr param, ExecuteCodeCallback callback) final;
  
  void ExecuteDeclarativeScript(int32_t tab_id, const ::extensions::ExtensionId& extension_id, const std::string& script_id, const ::GURL& url) final;
  
  void UpdateBrowserWindowId(int32_t window_id) final;
  
  void DispatchOnConnect(const ::extensions::PortId& port_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, ::extensions::mojom::TabConnectionInfoPtr tab_info, ::extensions::mojom::ExternalConnectionInfoPtr external_connection_info, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost> port_host, DispatchOnConnectCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  LocalFrameHostProxy
    : public LocalFrameHost {
 public:
  using InterfaceType = LocalFrameHost;

  explicit LocalFrameHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestScriptInjectionPermission(const ::extensions::ExtensionId& extension_id, ::extensions::mojom::InjectionType script_type, ::extensions::mojom::RunLocation run_location, RequestScriptInjectionPermissionCallback callback) final;
  
  void GetAppInstallState(const ::GURL& url, GetAppInstallStateCallback callback) final;
  
  void Request(RequestParamsPtr params, RequestCallback callback) final;
  
  void ResponseAck(const ::base::Uuid& request_uuid) final;
  
  void WatchedPageChange(const std::vector<std::string>& css_selectors) final;
  
  void DetailedConsoleMessageAdded(const ::std::u16string& message, const ::std::u16string& source, const std::vector<::extensions::StackFrame>& stack_trace, ::blink::mojom::ConsoleMessageLevel level) final;
  
  void ContentScriptsExecuting(const base::flat_map<std::string, std::vector<std::string>>& extension_id_to_scripts, const ::GURL& frame_url) final;
  
  void IncrementLazyKeepaliveCount() final;
  
  void DecrementLazyKeepaliveCount() final;
  
  void AppWindowReady() final;
  
  void OpenChannelToExtension(::extensions::mojom::ExternalConnectionInfoPtr info, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) final;
  
  void OpenChannelToNativeApp(const std::string& native_app_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) final;
  
  void OpenChannelToTab(int32_t tab_id, int32_t frame_id, const std::optional<std::string>& document_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  LocalFrameStubDispatch {
 public:
  static bool Accept(LocalFrame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LocalFrame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LocalFrame>>
class LocalFrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LocalFrameStub() = default;
  ~LocalFrameStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalFrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalFrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LocalFrameHostStubDispatch {
 public:
  static bool Accept(LocalFrameHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LocalFrameHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LocalFrameHost>>
class LocalFrameHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LocalFrameHostStub() = default;
  ~LocalFrameHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalFrameHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalFrameHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  LocalFrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  LocalFrameHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  LocalFrameResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  LocalFrameHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  ExecuteCodeParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExecuteCodeParams, T>::value>;
  using DataView = ExecuteCodeParamsDataView;
  using Data_ = internal::ExecuteCodeParams_Data;

  template <typename... Args>
  static ExecuteCodeParamsPtr New(Args&&... args) {
    return ExecuteCodeParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExecuteCodeParamsPtr From(const U& u) {
    return mojo::TypeConverter<ExecuteCodeParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExecuteCodeParams>::Convert(*this);
  }


  ExecuteCodeParams();

  ExecuteCodeParams(
      ::extensions::mojom::HostIDPtr host_id,
      ::extensions::mojom::CodeInjectionPtr injection,
      const ::GURL& webview_src,
      ::extensions::mojom::MatchOriginAsFallbackBehavior match_origin_as_fallback_behavior,
      ::extensions::mojom::RunLocation run_at,
      bool is_web_view);

ExecuteCodeParams(const ExecuteCodeParams&) = delete;
ExecuteCodeParams& operator=(const ExecuteCodeParams&) = delete;

  ~ExecuteCodeParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExecuteCodeParamsPtr>
  ExecuteCodeParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExecuteCodeParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ExecuteCodeParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ExecuteCodeParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExecuteCodeParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExecuteCodeParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExecuteCodeParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExecuteCodeParams_UnserializedMessageContext<
            UserType, ExecuteCodeParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ExecuteCodeParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ExecuteCodeParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExecuteCodeParams_UnserializedMessageContext<
            UserType, ExecuteCodeParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExecuteCodeParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::extensions::mojom::HostIDPtr host_id;
  
  ::extensions::mojom::CodeInjectionPtr injection;
  
  ::GURL webview_src;
  
  ::extensions::mojom::MatchOriginAsFallbackBehavior match_origin_as_fallback_behavior;
  
  ::extensions::mojom::RunLocation run_at;
  
  bool is_web_view;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExecuteCodeParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExecuteCodeParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExecuteCodeParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExecuteCodeParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  RequestParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RequestParams, T>::value>;
  using DataView = RequestParamsDataView;
  using Data_ = internal::RequestParams_Data;

  template <typename... Args>
  static RequestParamsPtr New(Args&&... args) {
    return RequestParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RequestParamsPtr From(const U& u) {
    return mojo::TypeConverter<RequestParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RequestParams>::Convert(*this);
  }


  RequestParams();

  RequestParams(
      const std::string& name,
      ::base::Value::List arguments,
      const std::string& extension_id,
      const ::GURL& source_url,
      ::extensions::mojom::ContextType context_type,
      int32_t request_id,
      bool has_callback,
      bool user_gesture,
      int32_t worker_thread_id,
      int64_t service_worker_version_id,
      std::optional<std::vector<::extensions::StackFrame>> js_callstack);

RequestParams(const RequestParams&) = delete;
RequestParams& operator=(const RequestParams&) = delete;

  ~RequestParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RequestParamsPtr>
  RequestParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequestParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequestParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RequestParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RequestParams_UnserializedMessageContext<
            UserType, RequestParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RequestParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RequestParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RequestParams_UnserializedMessageContext<
            UserType, RequestParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RequestParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  ::base::Value::List arguments;
  
  std::string extension_id;
  
  ::GURL source_url;
  
  ::extensions::mojom::ContextType context_type;
  
  int32_t request_id;
  
  bool has_callback;
  
  bool user_gesture;
  
  int32_t worker_thread_id;
  
  int64_t service_worker_version_id;
  
  std::optional<std::vector<::extensions::StackFrame>> js_callstack;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ExecuteCodeParamsPtr ExecuteCodeParams::Clone() const {
  return New(
      mojo::Clone(host_id),
      mojo::Clone(injection),
      mojo::Clone(webview_src),
      mojo::Clone(match_origin_as_fallback_behavior),
      mojo::Clone(run_at),
      mojo::Clone(is_web_view)
  );
}

template <typename T, ExecuteCodeParams::EnableIfSame<T>*>
bool ExecuteCodeParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->host_id, other_struct.host_id))
    return false;
  if (!mojo::Equals(this->injection, other_struct.injection))
    return false;
  if (!mojo::Equals(this->webview_src, other_struct.webview_src))
    return false;
  if (!mojo::Equals(this->match_origin_as_fallback_behavior, other_struct.match_origin_as_fallback_behavior))
    return false;
  if (!mojo::Equals(this->run_at, other_struct.run_at))
    return false;
  if (!mojo::Equals(this->is_web_view, other_struct.is_web_view))
    return false;
  return true;
}

template <typename T, ExecuteCodeParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.host_id < rhs.host_id)
    return true;
  if (rhs.host_id < lhs.host_id)
    return false;
  if (lhs.injection < rhs.injection)
    return true;
  if (rhs.injection < lhs.injection)
    return false;
  if (lhs.webview_src < rhs.webview_src)
    return true;
  if (rhs.webview_src < lhs.webview_src)
    return false;
  if (lhs.match_origin_as_fallback_behavior < rhs.match_origin_as_fallback_behavior)
    return true;
  if (rhs.match_origin_as_fallback_behavior < lhs.match_origin_as_fallback_behavior)
    return false;
  if (lhs.run_at < rhs.run_at)
    return true;
  if (rhs.run_at < lhs.run_at)
    return false;
  if (lhs.is_web_view < rhs.is_web_view)
    return true;
  if (rhs.is_web_view < lhs.is_web_view)
    return false;
  return false;
}
template <typename StructPtrType>
RequestParamsPtr RequestParams::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(arguments),
      mojo::Clone(extension_id),
      mojo::Clone(source_url),
      mojo::Clone(context_type),
      mojo::Clone(request_id),
      mojo::Clone(has_callback),
      mojo::Clone(user_gesture),
      mojo::Clone(worker_thread_id),
      mojo::Clone(service_worker_version_id),
      mojo::Clone(js_callstack)
  );
}

template <typename T, RequestParams::EnableIfSame<T>*>
bool RequestParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->arguments, other_struct.arguments))
    return false;
  if (!mojo::Equals(this->extension_id, other_struct.extension_id))
    return false;
  if (!mojo::Equals(this->source_url, other_struct.source_url))
    return false;
  if (!mojo::Equals(this->context_type, other_struct.context_type))
    return false;
  if (!mojo::Equals(this->request_id, other_struct.request_id))
    return false;
  if (!mojo::Equals(this->has_callback, other_struct.has_callback))
    return false;
  if (!mojo::Equals(this->user_gesture, other_struct.user_gesture))
    return false;
  if (!mojo::Equals(this->worker_thread_id, other_struct.worker_thread_id))
    return false;
  if (!mojo::Equals(this->service_worker_version_id, other_struct.service_worker_version_id))
    return false;
  if (!mojo::Equals(this->js_callstack, other_struct.js_callstack))
    return false;
  return true;
}

template <typename T, RequestParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.arguments < rhs.arguments)
    return true;
  if (rhs.arguments < lhs.arguments)
    return false;
  if (lhs.extension_id < rhs.extension_id)
    return true;
  if (rhs.extension_id < lhs.extension_id)
    return false;
  if (lhs.source_url < rhs.source_url)
    return true;
  if (rhs.source_url < lhs.source_url)
    return false;
  if (lhs.context_type < rhs.context_type)
    return true;
  if (rhs.context_type < lhs.context_type)
    return false;
  if (lhs.request_id < rhs.request_id)
    return true;
  if (rhs.request_id < lhs.request_id)
    return false;
  if (lhs.has_callback < rhs.has_callback)
    return true;
  if (rhs.has_callback < lhs.has_callback)
    return false;
  if (lhs.user_gesture < rhs.user_gesture)
    return true;
  if (rhs.user_gesture < lhs.user_gesture)
    return false;
  if (lhs.worker_thread_id < rhs.worker_thread_id)
    return true;
  if (rhs.worker_thread_id < lhs.worker_thread_id)
    return false;
  if (lhs.service_worker_version_id < rhs.service_worker_version_id)
    return true;
  if (rhs.service_worker_version_id < lhs.service_worker_version_id)
    return false;
  if (lhs.js_callstack < rhs.js_callstack)
    return true;
  if (rhs.js_callstack < lhs.js_callstack)
    return false;
  return false;
}


}  // extensions::mojom

namespace mojo {


template <>
struct  StructTraits<::extensions::mojom::ExecuteCodeParams::DataView,
                                         ::extensions::mojom::ExecuteCodeParamsPtr> {
  static bool IsNull(const ::extensions::mojom::ExecuteCodeParamsPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::ExecuteCodeParamsPtr* output) { output->reset(); }

  static const decltype(::extensions::mojom::ExecuteCodeParams::host_id)& host_id(
      const ::extensions::mojom::ExecuteCodeParamsPtr& input) {
    return input->host_id;
  }

  static const decltype(::extensions::mojom::ExecuteCodeParams::injection)& injection(
      const ::extensions::mojom::ExecuteCodeParamsPtr& input) {
    return input->injection;
  }

  static const decltype(::extensions::mojom::ExecuteCodeParams::webview_src)& webview_src(
      const ::extensions::mojom::ExecuteCodeParamsPtr& input) {
    return input->webview_src;
  }

  static decltype(::extensions::mojom::ExecuteCodeParams::match_origin_as_fallback_behavior) match_origin_as_fallback_behavior(
      const ::extensions::mojom::ExecuteCodeParamsPtr& input) {
    return input->match_origin_as_fallback_behavior;
  }

  static decltype(::extensions::mojom::ExecuteCodeParams::run_at) run_at(
      const ::extensions::mojom::ExecuteCodeParamsPtr& input) {
    return input->run_at;
  }

  static decltype(::extensions::mojom::ExecuteCodeParams::is_web_view) is_web_view(
      const ::extensions::mojom::ExecuteCodeParamsPtr& input) {
    return input->is_web_view;
  }

  static bool Read(::extensions::mojom::ExecuteCodeParams::DataView input, ::extensions::mojom::ExecuteCodeParamsPtr* output);
};


template <>
struct  StructTraits<::extensions::mojom::RequestParams::DataView,
                                         ::extensions::mojom::RequestParamsPtr> {
  static bool IsNull(const ::extensions::mojom::RequestParamsPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::RequestParamsPtr* output) { output->reset(); }

  static const decltype(::extensions::mojom::RequestParams::name)& name(
      const ::extensions::mojom::RequestParamsPtr& input) {
    return input->name;
  }

  static const decltype(::extensions::mojom::RequestParams::arguments)& arguments(
      const ::extensions::mojom::RequestParamsPtr& input) {
    return input->arguments;
  }

  static const decltype(::extensions::mojom::RequestParams::extension_id)& extension_id(
      const ::extensions::mojom::RequestParamsPtr& input) {
    return input->extension_id;
  }

  static const decltype(::extensions::mojom::RequestParams::source_url)& source_url(
      const ::extensions::mojom::RequestParamsPtr& input) {
    return input->source_url;
  }

  static decltype(::extensions::mojom::RequestParams::context_type) context_type(
      const ::extensions::mojom::RequestParamsPtr& input) {
    return input->context_type;
  }

  static decltype(::extensions::mojom::RequestParams::request_id) request_id(
      const ::extensions::mojom::RequestParamsPtr& input) {
    return input->request_id;
  }

  static decltype(::extensions::mojom::RequestParams::has_callback) has_callback(
      const ::extensions::mojom::RequestParamsPtr& input) {
    return input->has_callback;
  }

  static decltype(::extensions::mojom::RequestParams::user_gesture) user_gesture(
      const ::extensions::mojom::RequestParamsPtr& input) {
    return input->user_gesture;
  }

  static decltype(::extensions::mojom::RequestParams::worker_thread_id) worker_thread_id(
      const ::extensions::mojom::RequestParamsPtr& input) {
    return input->worker_thread_id;
  }

  static decltype(::extensions::mojom::RequestParams::service_worker_version_id) service_worker_version_id(
      const ::extensions::mojom::RequestParamsPtr& input) {
    return input->service_worker_version_id;
  }

  static const decltype(::extensions::mojom::RequestParams::js_callstack)& js_callstack(
      const ::extensions::mojom::RequestParamsPtr& input) {
    return input->js_callstack;
  }

  static bool Read(::extensions::mojom::RequestParams::DataView input, ::extensions::mojom::RequestParamsPtr* output);
};

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_H_