// extensions/common/mojom/permission_set.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_PERMISSION_SET_MOJOM_DATA_VIEW_H_
#define EXTENSIONS_COMMON_MOJOM_PERMISSION_SET_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "extensions/common/mojom/permission_set.mojom-shared-internal.h"
#include "extensions/common/mojom/api_permission_id.mojom-shared.h"
#include "extensions/common/mojom/url_pattern_set.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"


namespace extensions::mojom {
class APIPermissionDataView;

class APIPermissionSetDataView;

class ManifestPermissionDataView;

class ManifestPermissionSetDataView;

class PermissionSetDataView;



}  // extensions::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::extensions::mojom::APIPermissionDataView> {
  using Data = ::extensions::mojom::internal::APIPermission_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::APIPermissionSetDataView> {
  using Data = ::extensions::mojom::internal::APIPermissionSet_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::ManifestPermissionDataView> {
  using Data = ::extensions::mojom::internal::ManifestPermission_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::ManifestPermissionSetDataView> {
  using Data = ::extensions::mojom::internal::ManifestPermissionSet_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::PermissionSetDataView> {
  using Data = ::extensions::mojom::internal::PermissionSet_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace extensions::mojom {


class APIPermissionDataView {
 public:
  APIPermissionDataView() = default;

  APIPermissionDataView(
      internal::APIPermission_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) const {
    auto data_value = data_->id;
    return mojo::internal::Deserialize<::extensions::mojom::APIPermissionID>(
        data_value, output);
  }
  ::extensions::mojom::APIPermissionID id() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::APIPermissionID>(data_->id));
  }
  inline void GetValueDataView(
      ::mojo_base::mojom::ValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ValueDataView, UserType>(),
    "Attempting to read the optional `value` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadValue` instead "
    "of `ReadValue if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->value.is_null() ? &data_->value : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::ValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::APIPermission_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class APIPermissionSetDataView {
 public:
  APIPermissionSetDataView() = default;

  APIPermissionSetDataView(
      internal::APIPermissionSet_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPermissionMapDataView(
      mojo::MapDataView<::extensions::mojom::APIPermissionID, APIPermissionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPermissionMap(UserType* output) {
    
    auto* pointer = data_->permission_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::extensions::mojom::APIPermissionID, ::extensions::mojom::APIPermissionDataView>>(
        pointer, output, message_);
  }
 private:
  internal::APIPermissionSet_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestPermissionDataView {
 public:
  ManifestPermissionDataView() = default;

  ManifestPermissionDataView(
      internal::ManifestPermission_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      ::mojo_base::mojom::ValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ValueDataView, UserType>(),
    "Attempting to read the optional `value` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadValue` instead "
    "of `ReadValue if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->value.is_null() ? &data_->value : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::ValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::ManifestPermission_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ManifestPermissionSetDataView {
 public:
  ManifestPermissionSetDataView() = default;

  ManifestPermissionSetDataView(
      internal::ManifestPermissionSet_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPermissionMapDataView(
      mojo::MapDataView<mojo::StringDataView, ManifestPermissionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPermissionMap(UserType* output) {
    
    auto* pointer = data_->permission_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::extensions::mojom::ManifestPermissionDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ManifestPermissionSet_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PermissionSetDataView {
 public:
  PermissionSetDataView() = default;

  PermissionSetDataView(
      internal::PermissionSet_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetApisDataView(
      APIPermissionSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadApis(UserType* output) {
    
    auto* pointer = data_->apis.Get();
    return mojo::internal::Deserialize<::extensions::mojom::APIPermissionSetDataView>(
        pointer, output, message_);
  }
  inline void GetManifestPermissionsDataView(
      ManifestPermissionSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadManifestPermissions(UserType* output) {
    
    auto* pointer = data_->manifest_permissions.Get();
    return mojo::internal::Deserialize<::extensions::mojom::ManifestPermissionSetDataView>(
        pointer, output, message_);
  }
  inline void GetHostsDataView(
      ::extensions::mojom::URLPatternSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHosts(UserType* output) {
    
    auto* pointer = data_->hosts.Get();
    return mojo::internal::Deserialize<::extensions::mojom::URLPatternSetDataView>(
        pointer, output, message_);
  }
  inline void GetUserScriptHostsDataView(
      ::extensions::mojom::URLPatternSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserScriptHosts(UserType* output) {
    
    auto* pointer = data_->user_script_hosts.Get();
    return mojo::internal::Deserialize<::extensions::mojom::URLPatternSetDataView>(
        pointer, output, message_);
  }
 private:
  internal::PermissionSet_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // extensions::mojom

#endif  // EXTENSIONS_COMMON_MOJOM_PERMISSION_SET_MOJOM_DATA_VIEW_H_