// extensions/common/mojom/renderer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_H_
#define EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/renderer.mojom-features.h"  // IWYU pragma: export
#include "extensions/common/mojom/renderer.mojom-shared.h"  // IWYU pragma: export
#include "extensions/common/mojom/renderer.mojom-forward.h"  // IWYU pragma: export
#include "extensions/common/mojom/api_permission_id.mojom-forward.h"
#include "extensions/common/mojom/channel.mojom.h"
#include "extensions/common/mojom/extension_id.mojom.h"
#include "extensions/common/mojom/feature_session_type.mojom-forward.h"
#include "extensions/common/mojom/host_id.mojom-forward.h"
#include "extensions/common/mojom/manifest.mojom-forward.h"
#include "extensions/common/mojom/permission_set.mojom.h"
#include "extensions/common/mojom/url_pattern_set.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace extensions::mojom {

class RendererProxy;

template <typename ImplRefTraits>
class RendererStub;

class RendererRequestValidator;
class RendererResponseValidator;


class Renderer
    : public RendererInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "extensions.mojom.Renderer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RendererInterfaceBase;
  using Proxy_ = RendererProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererStub<ImplRefTraits>;

  using RequestValidator_ = RendererRequestValidator;
  using ResponseValidator_ = RendererResponseValidator;
  enum MethodMinVersions : uint32_t {
    kActivateExtensionMinVersion = 0,
    kSetActivityLoggingEnabledMinVersion = 0,
    kLoadExtensionsMinVersion = 0,
    kUnloadExtensionMinVersion = 0,
    kSuspendExtensionMinVersion = 0,
    kCancelSuspendExtensionMinVersion = 0,
    kSetDeveloperModeMinVersion = 0,
    kSetUserScriptsAllowedMinVersion = 0,
    kSetSessionInfoMinVersion = 0,
    kSetSystemFontMinVersion = 0,
    kSetWebViewPartitionIDMinVersion = 0,
    kSetScriptingAllowlistMinVersion = 0,
    kUpdateUserScriptWorldsMinVersion = 0,
    kClearUserScriptWorldConfigMinVersion = 0,
    kShouldSuspendMinVersion = 0,
    kTransferBlobsMinVersion = 0,
    kUpdatePermissionsMinVersion = 0,
    kUpdateDefaultPolicyHostRestrictionsMinVersion = 0,
    kUpdateUserHostRestrictionsMinVersion = 0,
    kUpdateTabSpecificPermissionsMinVersion = 0,
    kUpdateUserScriptsMinVersion = 0,
    kClearTabSpecificPermissionsMinVersion = 0,
    kWatchPagesMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ActivateExtension_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetActivityLoggingEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LoadExtensions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UnloadExtension_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SuspendExtension_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CancelSuspendExtension_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetDeveloperMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUserScriptsAllowed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSessionInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSystemFont_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetWebViewPartitionID_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetScriptingAllowlist_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateUserScriptWorlds_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearUserScriptWorldConfig_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShouldSuspend_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TransferBlobs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdatePermissions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateDefaultPolicyHostRestrictions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateUserHostRestrictions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateTabSpecificPermissions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateUserScripts_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearTabSpecificPermissions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WatchPages_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Renderer() = default;

  virtual void ActivateExtension(const ::extensions::ExtensionId& extension_id) = 0;

  virtual void SetActivityLoggingEnabled(bool enabled) = 0;

  virtual void LoadExtensions(std::vector<ExtensionLoadedParamsPtr> params) = 0;

  virtual void UnloadExtension(const ::extensions::ExtensionId& extension_id) = 0;

  using SuspendExtensionCallback = base::OnceCallback<void()>;
  using SuspendExtensionMojoCallback = base::OnceCallback<void()>;

  virtual void SuspendExtension(const ::extensions::ExtensionId& extension_id, SuspendExtensionCallback callback) = 0;

  virtual void CancelSuspendExtension(const ::extensions::ExtensionId& extension_id) = 0;

  virtual void SetDeveloperMode(bool developer_mode_only) = 0;

  virtual void SetUserScriptsAllowed(const ::extensions::ExtensionId& extension_id, bool allowed) = 0;

  virtual void SetSessionInfo(version_info::Channel channel, ::extensions::mojom::FeatureSessionType session) = 0;

  virtual void SetSystemFont(const std::string& font_family, const std::string& font_size) = 0;

  virtual void SetWebViewPartitionID(const std::string& partition_id) = 0;

  virtual void SetScriptingAllowlist(const std::vector<::extensions::ExtensionId>& extension_ids) = 0;

  virtual void UpdateUserScriptWorlds(std::vector<UserScriptWorldInfoPtr> infos) = 0;

  virtual void ClearUserScriptWorldConfig(const ::extensions::ExtensionId& extension_id, const std::optional<std::string>& world_id) = 0;

  using ShouldSuspendCallback = base::OnceCallback<void()>;
  using ShouldSuspendMojoCallback = base::OnceCallback<void()>;

  virtual void ShouldSuspend(ShouldSuspendCallback callback) = 0;

  using TransferBlobsCallback = base::OnceCallback<void()>;
  using TransferBlobsMojoCallback = base::OnceCallback<void()>;

  virtual void TransferBlobs(TransferBlobsCallback callback) = 0;

  virtual void UpdatePermissions(const ::extensions::ExtensionId& extension_id, ::extensions::PermissionSet active_permissions, ::extensions::PermissionSet withheld_permissions, ::extensions::URLPatternSet policy_blocked_hosts, ::extensions::URLPatternSet policy_allowed_hosts, bool uses_default_policy_host_restrictions) = 0;

  virtual void UpdateDefaultPolicyHostRestrictions(::extensions::URLPatternSet default_policy_blocked_hosts, ::extensions::URLPatternSet default_policy_allowed_hosts) = 0;

  virtual void UpdateUserHostRestrictions(::extensions::URLPatternSet user_blocked_hosts, ::extensions::URLPatternSet user_allowed_hosts) = 0;

  virtual void UpdateTabSpecificPermissions(const ::extensions::ExtensionId& extension_id, ::extensions::URLPatternSet new_hosts, int32_t tab_id, bool update_origin_allowlist) = 0;

  virtual void UpdateUserScripts(::base::ReadOnlySharedMemoryRegion region, ::extensions::mojom::HostIDPtr owner) = 0;

  virtual void ClearTabSpecificPermissions(const std::vector<::extensions::ExtensionId>& extension_ids, int32_t tab_id, bool update_origin_allowlist) = 0;

  virtual void WatchPages(const std::vector<std::string>& css_selectors) = 0;
};



class  RendererProxy
    : public Renderer {
 public:
  using InterfaceType = Renderer;

  explicit RendererProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ActivateExtension(const ::extensions::ExtensionId& extension_id) final;
  
  void SetActivityLoggingEnabled(bool enabled) final;
  
  void LoadExtensions(std::vector<ExtensionLoadedParamsPtr> params) final;
  
  void UnloadExtension(const ::extensions::ExtensionId& extension_id) final;
  
  void SuspendExtension(const ::extensions::ExtensionId& extension_id, SuspendExtensionCallback callback) final;
  
  void CancelSuspendExtension(const ::extensions::ExtensionId& extension_id) final;
  
  void SetDeveloperMode(bool developer_mode_only) final;
  
  void SetUserScriptsAllowed(const ::extensions::ExtensionId& extension_id, bool allowed) final;
  
  void SetSessionInfo(version_info::Channel channel, ::extensions::mojom::FeatureSessionType session) final;
  
  void SetSystemFont(const std::string& font_family, const std::string& font_size) final;
  
  void SetWebViewPartitionID(const std::string& partition_id) final;
  
  void SetScriptingAllowlist(const std::vector<::extensions::ExtensionId>& extension_ids) final;
  
  void UpdateUserScriptWorlds(std::vector<UserScriptWorldInfoPtr> infos) final;
  
  void ClearUserScriptWorldConfig(const ::extensions::ExtensionId& extension_id, const std::optional<std::string>& world_id) final;
  
  void ShouldSuspend(ShouldSuspendCallback callback) final;
  
  void TransferBlobs(TransferBlobsCallback callback) final;
  
  void UpdatePermissions(const ::extensions::ExtensionId& extension_id, ::extensions::PermissionSet active_permissions, ::extensions::PermissionSet withheld_permissions, ::extensions::URLPatternSet policy_blocked_hosts, ::extensions::URLPatternSet policy_allowed_hosts, bool uses_default_policy_host_restrictions) final;
  
  void UpdateDefaultPolicyHostRestrictions(::extensions::URLPatternSet default_policy_blocked_hosts, ::extensions::URLPatternSet default_policy_allowed_hosts) final;
  
  void UpdateUserHostRestrictions(::extensions::URLPatternSet user_blocked_hosts, ::extensions::URLPatternSet user_allowed_hosts) final;
  
  void UpdateTabSpecificPermissions(const ::extensions::ExtensionId& extension_id, ::extensions::URLPatternSet new_hosts, int32_t tab_id, bool update_origin_allowlist) final;
  
  void UpdateUserScripts(::base::ReadOnlySharedMemoryRegion region, ::extensions::mojom::HostIDPtr owner) final;
  
  void ClearTabSpecificPermissions(const std::vector<::extensions::ExtensionId>& extension_ids, int32_t tab_id, bool update_origin_allowlist) final;
  
  void WatchPages(const std::vector<std::string>& css_selectors) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  RendererStubDispatch {
 public:
  static bool Accept(Renderer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Renderer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Renderer>>
class RendererStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererStub() = default;
  ~RendererStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  RendererRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  RendererResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  ExtensionLoadedParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ExtensionLoadedParams, T>::value>;
  using DataView = ExtensionLoadedParamsDataView;
  using Data_ = internal::ExtensionLoadedParams_Data;

  template <typename... Args>
  static ExtensionLoadedParamsPtr New(Args&&... args) {
    return ExtensionLoadedParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ExtensionLoadedParamsPtr From(const U& u) {
    return mojo::TypeConverter<ExtensionLoadedParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ExtensionLoadedParams>::Convert(*this);
  }


  ExtensionLoadedParams();

  ExtensionLoadedParams(
      ::base::Value::Dict manifest,
      ::extensions::mojom::ManifestLocation location,
      const ::base::FilePath& path,
      ::extensions::PermissionSet active_permissions,
      ::extensions::PermissionSet withheld_permissions,
      base::flat_map<int32_t, ::extensions::PermissionSet> tab_specific_permissions,
      ::extensions::URLPatternSet policy_blocked_hosts,
      ::extensions::URLPatternSet policy_allowed_hosts,
      bool uses_default_policy_blocked_allowed_hosts,
      bool user_scripts_allowed,
      const std::string& id,
      const std::optional<::base::UnguessableToken>& worker_activation_token,
      int32_t creation_flags,
      const std::string& guid);

ExtensionLoadedParams(const ExtensionLoadedParams&) = delete;
ExtensionLoadedParams& operator=(const ExtensionLoadedParams&) = delete;

  ~ExtensionLoadedParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ExtensionLoadedParamsPtr>
  ExtensionLoadedParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ExtensionLoadedParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ExtensionLoadedParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ExtensionLoadedParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtensionLoadedParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ExtensionLoadedParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ExtensionLoadedParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ExtensionLoadedParams_UnserializedMessageContext<
            UserType, ExtensionLoadedParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ExtensionLoadedParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ExtensionLoadedParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ExtensionLoadedParams_UnserializedMessageContext<
            UserType, ExtensionLoadedParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ExtensionLoadedParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Value::Dict manifest;
  
  ::extensions::mojom::ManifestLocation location;
  
  ::base::FilePath path;
  
  ::extensions::PermissionSet active_permissions;
  
  ::extensions::PermissionSet withheld_permissions;
  
  base::flat_map<int32_t, ::extensions::PermissionSet> tab_specific_permissions;
  
  ::extensions::URLPatternSet policy_blocked_hosts;
  
  ::extensions::URLPatternSet policy_allowed_hosts;
  
  bool uses_default_policy_blocked_allowed_hosts;
  
  bool user_scripts_allowed;
  
  std::string id;
  
  std::optional<::base::UnguessableToken> worker_activation_token;
  
  int32_t creation_flags;
  
  std::string guid;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ExtensionLoadedParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ExtensionLoadedParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ExtensionLoadedParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ExtensionLoadedParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  UserScriptWorldInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UserScriptWorldInfo, T>::value>;
  using DataView = UserScriptWorldInfoDataView;
  using Data_ = internal::UserScriptWorldInfo_Data;

  template <typename... Args>
  static UserScriptWorldInfoPtr New(Args&&... args) {
    return UserScriptWorldInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UserScriptWorldInfoPtr From(const U& u) {
    return mojo::TypeConverter<UserScriptWorldInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UserScriptWorldInfo>::Convert(*this);
  }


  UserScriptWorldInfo();

  UserScriptWorldInfo(
      const ::extensions::ExtensionId& extension_id,
      const std::optional<std::string>& world_id,
      const std::optional<std::string>& csp,
      bool enable_messaging);


  ~UserScriptWorldInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UserScriptWorldInfoPtr>
  UserScriptWorldInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UserScriptWorldInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UserScriptWorldInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UserScriptWorldInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserScriptWorldInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserScriptWorldInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UserScriptWorldInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UserScriptWorldInfo_UnserializedMessageContext<
            UserType, UserScriptWorldInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UserScriptWorldInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UserScriptWorldInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UserScriptWorldInfo_UnserializedMessageContext<
            UserType, UserScriptWorldInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UserScriptWorldInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::extensions::ExtensionId extension_id;
  
  std::optional<std::string> world_id;
  
  std::optional<std::string> csp;
  
  bool enable_messaging;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UserScriptWorldInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UserScriptWorldInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UserScriptWorldInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UserScriptWorldInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ExtensionLoadedParamsPtr ExtensionLoadedParams::Clone() const {
  return New(
      mojo::Clone(manifest),
      mojo::Clone(location),
      mojo::Clone(path),
      mojo::Clone(active_permissions),
      mojo::Clone(withheld_permissions),
      mojo::Clone(tab_specific_permissions),
      mojo::Clone(policy_blocked_hosts),
      mojo::Clone(policy_allowed_hosts),
      mojo::Clone(uses_default_policy_blocked_allowed_hosts),
      mojo::Clone(user_scripts_allowed),
      mojo::Clone(id),
      mojo::Clone(worker_activation_token),
      mojo::Clone(creation_flags),
      mojo::Clone(guid)
  );
}

template <typename T, ExtensionLoadedParams::EnableIfSame<T>*>
bool ExtensionLoadedParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->manifest, other_struct.manifest))
    return false;
  if (!mojo::Equals(this->location, other_struct.location))
    return false;
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->active_permissions, other_struct.active_permissions))
    return false;
  if (!mojo::Equals(this->withheld_permissions, other_struct.withheld_permissions))
    return false;
  if (!mojo::Equals(this->tab_specific_permissions, other_struct.tab_specific_permissions))
    return false;
  if (!mojo::Equals(this->policy_blocked_hosts, other_struct.policy_blocked_hosts))
    return false;
  if (!mojo::Equals(this->policy_allowed_hosts, other_struct.policy_allowed_hosts))
    return false;
  if (!mojo::Equals(this->uses_default_policy_blocked_allowed_hosts, other_struct.uses_default_policy_blocked_allowed_hosts))
    return false;
  if (!mojo::Equals(this->user_scripts_allowed, other_struct.user_scripts_allowed))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->worker_activation_token, other_struct.worker_activation_token))
    return false;
  if (!mojo::Equals(this->creation_flags, other_struct.creation_flags))
    return false;
  if (!mojo::Equals(this->guid, other_struct.guid))
    return false;
  return true;
}

template <typename T, ExtensionLoadedParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.manifest < rhs.manifest)
    return true;
  if (rhs.manifest < lhs.manifest)
    return false;
  if (lhs.location < rhs.location)
    return true;
  if (rhs.location < lhs.location)
    return false;
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  if (lhs.active_permissions < rhs.active_permissions)
    return true;
  if (rhs.active_permissions < lhs.active_permissions)
    return false;
  if (lhs.withheld_permissions < rhs.withheld_permissions)
    return true;
  if (rhs.withheld_permissions < lhs.withheld_permissions)
    return false;
  if (lhs.tab_specific_permissions < rhs.tab_specific_permissions)
    return true;
  if (rhs.tab_specific_permissions < lhs.tab_specific_permissions)
    return false;
  if (lhs.policy_blocked_hosts < rhs.policy_blocked_hosts)
    return true;
  if (rhs.policy_blocked_hosts < lhs.policy_blocked_hosts)
    return false;
  if (lhs.policy_allowed_hosts < rhs.policy_allowed_hosts)
    return true;
  if (rhs.policy_allowed_hosts < lhs.policy_allowed_hosts)
    return false;
  if (lhs.uses_default_policy_blocked_allowed_hosts < rhs.uses_default_policy_blocked_allowed_hosts)
    return true;
  if (rhs.uses_default_policy_blocked_allowed_hosts < lhs.uses_default_policy_blocked_allowed_hosts)
    return false;
  if (lhs.user_scripts_allowed < rhs.user_scripts_allowed)
    return true;
  if (rhs.user_scripts_allowed < lhs.user_scripts_allowed)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.worker_activation_token < rhs.worker_activation_token)
    return true;
  if (rhs.worker_activation_token < lhs.worker_activation_token)
    return false;
  if (lhs.creation_flags < rhs.creation_flags)
    return true;
  if (rhs.creation_flags < lhs.creation_flags)
    return false;
  if (lhs.guid < rhs.guid)
    return true;
  if (rhs.guid < lhs.guid)
    return false;
  return false;
}
template <typename StructPtrType>
UserScriptWorldInfoPtr UserScriptWorldInfo::Clone() const {
  return New(
      mojo::Clone(extension_id),
      mojo::Clone(world_id),
      mojo::Clone(csp),
      mojo::Clone(enable_messaging)
  );
}

template <typename T, UserScriptWorldInfo::EnableIfSame<T>*>
bool UserScriptWorldInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->extension_id, other_struct.extension_id))
    return false;
  if (!mojo::Equals(this->world_id, other_struct.world_id))
    return false;
  if (!mojo::Equals(this->csp, other_struct.csp))
    return false;
  if (!mojo::Equals(this->enable_messaging, other_struct.enable_messaging))
    return false;
  return true;
}

template <typename T, UserScriptWorldInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.extension_id < rhs.extension_id)
    return true;
  if (rhs.extension_id < lhs.extension_id)
    return false;
  if (lhs.world_id < rhs.world_id)
    return true;
  if (rhs.world_id < lhs.world_id)
    return false;
  if (lhs.csp < rhs.csp)
    return true;
  if (rhs.csp < lhs.csp)
    return false;
  if (lhs.enable_messaging < rhs.enable_messaging)
    return true;
  if (rhs.enable_messaging < lhs.enable_messaging)
    return false;
  return false;
}


}  // extensions::mojom

namespace mojo {


template <>
struct  StructTraits<::extensions::mojom::ExtensionLoadedParams::DataView,
                                         ::extensions::mojom::ExtensionLoadedParamsPtr> {
  static bool IsNull(const ::extensions::mojom::ExtensionLoadedParamsPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::ExtensionLoadedParamsPtr* output) { output->reset(); }

  static const decltype(::extensions::mojom::ExtensionLoadedParams::manifest)& manifest(
      const ::extensions::mojom::ExtensionLoadedParamsPtr& input) {
    return input->manifest;
  }

  static decltype(::extensions::mojom::ExtensionLoadedParams::location) location(
      const ::extensions::mojom::ExtensionLoadedParamsPtr& input) {
    return input->location;
  }

  static const decltype(::extensions::mojom::ExtensionLoadedParams::path)& path(
      const ::extensions::mojom::ExtensionLoadedParamsPtr& input) {
    return input->path;
  }

  static const decltype(::extensions::mojom::ExtensionLoadedParams::active_permissions)& active_permissions(
      const ::extensions::mojom::ExtensionLoadedParamsPtr& input) {
    return input->active_permissions;
  }

  static const decltype(::extensions::mojom::ExtensionLoadedParams::withheld_permissions)& withheld_permissions(
      const ::extensions::mojom::ExtensionLoadedParamsPtr& input) {
    return input->withheld_permissions;
  }

  static const decltype(::extensions::mojom::ExtensionLoadedParams::tab_specific_permissions)& tab_specific_permissions(
      const ::extensions::mojom::ExtensionLoadedParamsPtr& input) {
    return input->tab_specific_permissions;
  }

  static const decltype(::extensions::mojom::ExtensionLoadedParams::policy_blocked_hosts)& policy_blocked_hosts(
      const ::extensions::mojom::ExtensionLoadedParamsPtr& input) {
    return input->policy_blocked_hosts;
  }

  static const decltype(::extensions::mojom::ExtensionLoadedParams::policy_allowed_hosts)& policy_allowed_hosts(
      const ::extensions::mojom::ExtensionLoadedParamsPtr& input) {
    return input->policy_allowed_hosts;
  }

  static decltype(::extensions::mojom::ExtensionLoadedParams::uses_default_policy_blocked_allowed_hosts) uses_default_policy_blocked_allowed_hosts(
      const ::extensions::mojom::ExtensionLoadedParamsPtr& input) {
    return input->uses_default_policy_blocked_allowed_hosts;
  }

  static decltype(::extensions::mojom::ExtensionLoadedParams::user_scripts_allowed) user_scripts_allowed(
      const ::extensions::mojom::ExtensionLoadedParamsPtr& input) {
    return input->user_scripts_allowed;
  }

  static const decltype(::extensions::mojom::ExtensionLoadedParams::id)& id(
      const ::extensions::mojom::ExtensionLoadedParamsPtr& input) {
    return input->id;
  }

  static const decltype(::extensions::mojom::ExtensionLoadedParams::worker_activation_token)& worker_activation_token(
      const ::extensions::mojom::ExtensionLoadedParamsPtr& input) {
    return input->worker_activation_token;
  }

  static decltype(::extensions::mojom::ExtensionLoadedParams::creation_flags) creation_flags(
      const ::extensions::mojom::ExtensionLoadedParamsPtr& input) {
    return input->creation_flags;
  }

  static const decltype(::extensions::mojom::ExtensionLoadedParams::guid)& guid(
      const ::extensions::mojom::ExtensionLoadedParamsPtr& input) {
    return input->guid;
  }

  static bool Read(::extensions::mojom::ExtensionLoadedParams::DataView input, ::extensions::mojom::ExtensionLoadedParamsPtr* output);
};


template <>
struct  StructTraits<::extensions::mojom::UserScriptWorldInfo::DataView,
                                         ::extensions::mojom::UserScriptWorldInfoPtr> {
  static bool IsNull(const ::extensions::mojom::UserScriptWorldInfoPtr& input) { return !input; }
  static void SetToNull(::extensions::mojom::UserScriptWorldInfoPtr* output) { output->reset(); }

  static const decltype(::extensions::mojom::UserScriptWorldInfo::extension_id)& extension_id(
      const ::extensions::mojom::UserScriptWorldInfoPtr& input) {
    return input->extension_id;
  }

  static const decltype(::extensions::mojom::UserScriptWorldInfo::world_id)& world_id(
      const ::extensions::mojom::UserScriptWorldInfoPtr& input) {
    return input->world_id;
  }

  static const decltype(::extensions::mojom::UserScriptWorldInfo::csp)& csp(
      const ::extensions::mojom::UserScriptWorldInfoPtr& input) {
    return input->csp;
  }

  static decltype(::extensions::mojom::UserScriptWorldInfo::enable_messaging) enable_messaging(
      const ::extensions::mojom::UserScriptWorldInfoPtr& input) {
    return input->enable_messaging;
  }

  static bool Read(::extensions::mojom::UserScriptWorldInfo::DataView input, ::extensions::mojom::UserScriptWorldInfoPtr* output);
};

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_H_