// gpu/ipc/common/gpu_feature_info.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_FEATURE_INFO_MOJOM_DATA_VIEW_H_
#define GPU_IPC_COMMON_GPU_FEATURE_INFO_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "gpu/ipc/common/gpu_feature_info.mojom-shared-internal.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"


namespace gpu::mojom {
class GpuFeatureInfoDataView;



}  // gpu::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::GpuFeatureInfoDataView> {
  using Data = ::gpu::mojom::internal::GpuFeatureInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gpu::mojom {


enum class GpuFeatureStatus : int32_t {
  
  Enabled = 0,
  
  Blocklisted = 1,
  
  Disabled = 2,
  
  Software = 3,
  
  Undefined = 4,
  
  Max = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) std::ostream& operator<<(std::ostream& os, GpuFeatureStatus value);
inline bool IsKnownEnumValue(GpuFeatureStatus value) {
  return internal::GpuFeatureStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class GpuFeatureInfoDataView {
 public:
  GpuFeatureInfoDataView() = default;

  GpuFeatureInfoDataView(
      internal::GpuFeatureInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStatusValuesDataView(
      mojo::ArrayDataView<GpuFeatureStatus>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatusValues(UserType* output) {
    
    auto* pointer = data_->status_values.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gpu::mojom::GpuFeatureStatus>>(
        pointer, output, message_);
  }
  inline void GetEnabledGpuDriverBugWorkaroundsDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnabledGpuDriverBugWorkarounds(UserType* output) {
    
    auto* pointer = data_->enabled_gpu_driver_bug_workarounds.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
  inline void GetDisabledExtensionsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisabledExtensions(UserType* output) {
    
    auto* pointer = data_->disabled_extensions.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDisabledWebglExtensionsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisabledWebglExtensions(UserType* output) {
    
    auto* pointer = data_->disabled_webgl_extensions.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAppliedGpuBlocklistEntriesDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAppliedGpuBlocklistEntries(UserType* output) {
    
    auto* pointer = data_->applied_gpu_blocklist_entries.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  inline void GetAppliedGpuDriverBugListEntriesDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAppliedGpuDriverBugListEntries(UserType* output) {
    
    auto* pointer = data_->applied_gpu_driver_bug_list_entries.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  inline void GetSupportedBufferFormatsForAllocationAndTexturingDataView(
      mojo::ArrayDataView<::gfx::mojom::BufferFormat>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedBufferFormatsForAllocationAndTexturing(UserType* output) {
    
    auto* pointer = data_->supported_buffer_formats_for_allocation_and_texturing.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::BufferFormat>>(
        pointer, output, message_);
  }
 private:
  internal::GpuFeatureInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gpu::mojom

#endif  // GPU_IPC_COMMON_GPU_FEATURE_INFO_MOJOM_DATA_VIEW_H_