// gpu/ipc/common/vulkan_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_VULKAN_INFO_MOJOM_H_
#define GPU_IPC_COMMON_VULKAN_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/vulkan_info.mojom-features.h"  // IWYU pragma: export
#include "gpu/ipc/common/vulkan_info.mojom-shared.h"  // IWYU pragma: export
#include "gpu/ipc/common/vulkan_info.mojom-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/vulkan_types.mojom.h"
#include <string>
#include <vector>




#include "gpu/ipc/common/vulkan_info_mojom_traits.h"
#include "gpu/gpu_export.h"




namespace gpu::mojom {









class GPU_EXPORT VulkanPhysicalDeviceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VulkanPhysicalDeviceInfo, T>::value>;
  using DataView = VulkanPhysicalDeviceInfoDataView;
  using Data_ = internal::VulkanPhysicalDeviceInfo_Data;

  template <typename... Args>
  static VulkanPhysicalDeviceInfoPtr New(Args&&... args) {
    return VulkanPhysicalDeviceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VulkanPhysicalDeviceInfoPtr From(const U& u) {
    return mojo::TypeConverter<VulkanPhysicalDeviceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VulkanPhysicalDeviceInfo>::Convert(*this);
  }


  VulkanPhysicalDeviceInfo();

  VulkanPhysicalDeviceInfo(
      const ::VkPhysicalDeviceProperties& properties,
      std::vector<::VkExtensionProperties> extensions,
      const ::VkPhysicalDeviceFeatures& features,
      bool feature_sampler_ycbcr_conversion,
      bool feature_protected_memory,
      std::vector<::VkQueueFamilyProperties> queue_families);


  ~VulkanPhysicalDeviceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VulkanPhysicalDeviceInfoPtr>
  VulkanPhysicalDeviceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VulkanPhysicalDeviceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VulkanPhysicalDeviceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VulkanPhysicalDeviceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VulkanPhysicalDeviceInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VulkanPhysicalDeviceInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VulkanPhysicalDeviceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VulkanPhysicalDeviceInfo_UnserializedMessageContext<
            UserType, VulkanPhysicalDeviceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VulkanPhysicalDeviceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VulkanPhysicalDeviceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VulkanPhysicalDeviceInfo_UnserializedMessageContext<
            UserType, VulkanPhysicalDeviceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VulkanPhysicalDeviceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::VkPhysicalDeviceProperties properties;
  
  std::vector<::VkExtensionProperties> extensions;
  
  ::VkPhysicalDeviceFeatures features;
  
  bool feature_sampler_ycbcr_conversion;
  
  bool feature_protected_memory;
  
  std::vector<::VkQueueFamilyProperties> queue_families;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VulkanPhysicalDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VulkanPhysicalDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VulkanPhysicalDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VulkanPhysicalDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class GPU_EXPORT VulkanInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VulkanInfo, T>::value>;
  using DataView = VulkanInfoDataView;
  using Data_ = internal::VulkanInfo_Data;

  template <typename... Args>
  static VulkanInfoPtr New(Args&&... args) {
    return VulkanInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VulkanInfoPtr From(const U& u) {
    return mojo::TypeConverter<VulkanInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VulkanInfo>::Convert(*this);
  }


  VulkanInfo();

  VulkanInfo(
      uint32_t api_version,
      uint32_t used_api_version,
      std::vector<::VkExtensionProperties> instance_extensions,
      std::vector<std::string> enabled_instance_extensions,
      std::vector<::VkLayerProperties> instance_layers,
      std::vector<::gpu::VulkanPhysicalDeviceInfo> physical_devices);


  ~VulkanInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VulkanInfoPtr>
  VulkanInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VulkanInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VulkanInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VulkanInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VulkanInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VulkanInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VulkanInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VulkanInfo_UnserializedMessageContext<
            UserType, VulkanInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VulkanInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VulkanInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VulkanInfo_UnserializedMessageContext<
            UserType, VulkanInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VulkanInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t api_version;
  
  uint32_t used_api_version;
  
  std::vector<::VkExtensionProperties> instance_extensions;
  
  std::vector<std::string> enabled_instance_extensions;
  
  std::vector<::VkLayerProperties> instance_layers;
  
  std::vector<::gpu::VulkanPhysicalDeviceInfo> physical_devices;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VulkanInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VulkanInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VulkanInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VulkanInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
VulkanPhysicalDeviceInfoPtr VulkanPhysicalDeviceInfo::Clone() const {
  return New(
      mojo::Clone(properties),
      mojo::Clone(extensions),
      mojo::Clone(features),
      mojo::Clone(feature_sampler_ycbcr_conversion),
      mojo::Clone(feature_protected_memory),
      mojo::Clone(queue_families)
  );
}

template <typename T, VulkanPhysicalDeviceInfo::EnableIfSame<T>*>
bool VulkanPhysicalDeviceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->properties, other_struct.properties))
    return false;
  if (!mojo::Equals(this->extensions, other_struct.extensions))
    return false;
  if (!mojo::Equals(this->features, other_struct.features))
    return false;
  if (!mojo::Equals(this->feature_sampler_ycbcr_conversion, other_struct.feature_sampler_ycbcr_conversion))
    return false;
  if (!mojo::Equals(this->feature_protected_memory, other_struct.feature_protected_memory))
    return false;
  if (!mojo::Equals(this->queue_families, other_struct.queue_families))
    return false;
  return true;
}

template <typename T, VulkanPhysicalDeviceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.properties < rhs.properties)
    return true;
  if (rhs.properties < lhs.properties)
    return false;
  if (lhs.extensions < rhs.extensions)
    return true;
  if (rhs.extensions < lhs.extensions)
    return false;
  if (lhs.features < rhs.features)
    return true;
  if (rhs.features < lhs.features)
    return false;
  if (lhs.feature_sampler_ycbcr_conversion < rhs.feature_sampler_ycbcr_conversion)
    return true;
  if (rhs.feature_sampler_ycbcr_conversion < lhs.feature_sampler_ycbcr_conversion)
    return false;
  if (lhs.feature_protected_memory < rhs.feature_protected_memory)
    return true;
  if (rhs.feature_protected_memory < lhs.feature_protected_memory)
    return false;
  if (lhs.queue_families < rhs.queue_families)
    return true;
  if (rhs.queue_families < lhs.queue_families)
    return false;
  return false;
}
template <typename StructPtrType>
VulkanInfoPtr VulkanInfo::Clone() const {
  return New(
      mojo::Clone(api_version),
      mojo::Clone(used_api_version),
      mojo::Clone(instance_extensions),
      mojo::Clone(enabled_instance_extensions),
      mojo::Clone(instance_layers),
      mojo::Clone(physical_devices)
  );
}

template <typename T, VulkanInfo::EnableIfSame<T>*>
bool VulkanInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->api_version, other_struct.api_version))
    return false;
  if (!mojo::Equals(this->used_api_version, other_struct.used_api_version))
    return false;
  if (!mojo::Equals(this->instance_extensions, other_struct.instance_extensions))
    return false;
  if (!mojo::Equals(this->enabled_instance_extensions, other_struct.enabled_instance_extensions))
    return false;
  if (!mojo::Equals(this->instance_layers, other_struct.instance_layers))
    return false;
  if (!mojo::Equals(this->physical_devices, other_struct.physical_devices))
    return false;
  return true;
}

template <typename T, VulkanInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.api_version < rhs.api_version)
    return true;
  if (rhs.api_version < lhs.api_version)
    return false;
  if (lhs.used_api_version < rhs.used_api_version)
    return true;
  if (rhs.used_api_version < lhs.used_api_version)
    return false;
  if (lhs.instance_extensions < rhs.instance_extensions)
    return true;
  if (rhs.instance_extensions < lhs.instance_extensions)
    return false;
  if (lhs.enabled_instance_extensions < rhs.enabled_instance_extensions)
    return true;
  if (rhs.enabled_instance_extensions < lhs.enabled_instance_extensions)
    return false;
  if (lhs.instance_layers < rhs.instance_layers)
    return true;
  if (rhs.instance_layers < lhs.instance_layers)
    return false;
  if (lhs.physical_devices < rhs.physical_devices)
    return true;
  if (rhs.physical_devices < lhs.physical_devices)
    return false;
  return false;
}


}  // gpu::mojom

namespace mojo {


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::VulkanPhysicalDeviceInfo::DataView,
                                         ::gpu::mojom::VulkanPhysicalDeviceInfoPtr> {
  static bool IsNull(const ::gpu::mojom::VulkanPhysicalDeviceInfoPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::VulkanPhysicalDeviceInfoPtr* output) { output->reset(); }

  static const decltype(::gpu::mojom::VulkanPhysicalDeviceInfo::properties)& properties(
      const ::gpu::mojom::VulkanPhysicalDeviceInfoPtr& input) {
    return input->properties;
  }

  static const decltype(::gpu::mojom::VulkanPhysicalDeviceInfo::extensions)& extensions(
      const ::gpu::mojom::VulkanPhysicalDeviceInfoPtr& input) {
    return input->extensions;
  }

  static const decltype(::gpu::mojom::VulkanPhysicalDeviceInfo::features)& features(
      const ::gpu::mojom::VulkanPhysicalDeviceInfoPtr& input) {
    return input->features;
  }

  static decltype(::gpu::mojom::VulkanPhysicalDeviceInfo::feature_sampler_ycbcr_conversion) feature_sampler_ycbcr_conversion(
      const ::gpu::mojom::VulkanPhysicalDeviceInfoPtr& input) {
    return input->feature_sampler_ycbcr_conversion;
  }

  static decltype(::gpu::mojom::VulkanPhysicalDeviceInfo::feature_protected_memory) feature_protected_memory(
      const ::gpu::mojom::VulkanPhysicalDeviceInfoPtr& input) {
    return input->feature_protected_memory;
  }

  static const decltype(::gpu::mojom::VulkanPhysicalDeviceInfo::queue_families)& queue_families(
      const ::gpu::mojom::VulkanPhysicalDeviceInfoPtr& input) {
    return input->queue_families;
  }

  static bool Read(::gpu::mojom::VulkanPhysicalDeviceInfo::DataView input, ::gpu::mojom::VulkanPhysicalDeviceInfoPtr* output);
};


template <>
struct GPU_EXPORT StructTraits<::gpu::mojom::VulkanInfo::DataView,
                                         ::gpu::mojom::VulkanInfoPtr> {
  static bool IsNull(const ::gpu::mojom::VulkanInfoPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::VulkanInfoPtr* output) { output->reset(); }

  static decltype(::gpu::mojom::VulkanInfo::api_version) api_version(
      const ::gpu::mojom::VulkanInfoPtr& input) {
    return input->api_version;
  }

  static decltype(::gpu::mojom::VulkanInfo::used_api_version) used_api_version(
      const ::gpu::mojom::VulkanInfoPtr& input) {
    return input->used_api_version;
  }

  static const decltype(::gpu::mojom::VulkanInfo::instance_extensions)& instance_extensions(
      const ::gpu::mojom::VulkanInfoPtr& input) {
    return input->instance_extensions;
  }

  static const decltype(::gpu::mojom::VulkanInfo::enabled_instance_extensions)& enabled_instance_extensions(
      const ::gpu::mojom::VulkanInfoPtr& input) {
    return input->enabled_instance_extensions;
  }

  static const decltype(::gpu::mojom::VulkanInfo::instance_layers)& instance_layers(
      const ::gpu::mojom::VulkanInfoPtr& input) {
    return input->instance_layers;
  }

  static const decltype(::gpu::mojom::VulkanInfo::physical_devices)& physical_devices(
      const ::gpu::mojom::VulkanInfoPtr& input) {
    return input->physical_devices;
  }

  static bool Read(::gpu::mojom::VulkanInfo::DataView input, ::gpu::mojom::VulkanInfoPtr* output);
};

}  // namespace mojo

#endif  // GPU_IPC_COMMON_VULKAN_INFO_MOJOM_H_