// ipc/ipc.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef IPC_IPC_MOJOM_H_
#define IPC_IPC_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ipc/ipc.mojom-features.h"  // IWYU pragma: export
#include "ipc/ipc.mojom-shared.h"  // IWYU pragma: export
#include "ipc/ipc.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/interfaces/bindings/native_struct.mojom.h"
#include "mojo/public/mojom/base/generic_pending_associated_receiver.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "ipc/message_mojom_traits.h"
#include "base/component_export.h"




namespace IPC::mojom {

class ChannelProxy;

template <typename ImplRefTraits>
class ChannelStub;

class ChannelRequestValidator;


class COMPONENT_EXPORT(IPC_MOJOM) Channel
    : public ChannelInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "IPC.mojom.Channel";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ChannelInterfaceBase;
  using Proxy_ = ChannelProxy;

  template <typename ImplRefTraits>
  using Stub_ = ChannelStub<ImplRefTraits>;

  using RequestValidator_ = ChannelRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetPeerPidMinVersion = 0,
    kReceiveMinVersion = 0,
    kGetAssociatedInterfaceMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetPeerPid_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Receive_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAssociatedInterface_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Channel() = default;

  virtual void SetPeerPid(int32_t pid) = 0;

  virtual void Receive(::IPC::MessageView message) = 0;

  virtual void GetAssociatedInterface(::mojo::GenericPendingAssociatedReceiver receiver) = 0;
};

class ChannelBootstrapProxy;

template <typename ImplRefTraits>
class ChannelBootstrapStub;

class ChannelBootstrapRequestValidator;


class COMPONENT_EXPORT(IPC_MOJOM) ChannelBootstrap
    : public ChannelBootstrapInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "IPC.mojom.ChannelBootstrap";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ChannelBootstrapInterfaceBase;
  using Proxy_ = ChannelBootstrapProxy;

  template <typename ImplRefTraits>
  using Stub_ = ChannelBootstrapStub<ImplRefTraits>;

  using RequestValidator_ = ChannelBootstrapRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ChannelBootstrap() = default;
};



class COMPONENT_EXPORT(IPC_MOJOM) ChannelProxy
    : public Channel {
 public:
  using InterfaceType = Channel;

  explicit ChannelProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetPeerPid(int32_t pid) final;
  
  void Receive(::IPC::MessageView message) final;
  
  void GetAssociatedInterface(::mojo::GenericPendingAssociatedReceiver receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(IPC_MOJOM) ChannelBootstrapProxy
    : public ChannelBootstrap {
 public:
  using InterfaceType = ChannelBootstrap;

  explicit ChannelBootstrapProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(IPC_MOJOM) ChannelStubDispatch {
 public:
  static bool Accept(Channel* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Channel* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Channel>>
class ChannelStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ChannelStub() = default;
  ~ChannelStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChannelStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChannelStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(IPC_MOJOM) ChannelBootstrapStubDispatch {
 public:
  static bool Accept(ChannelBootstrap* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ChannelBootstrap* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ChannelBootstrap>>
class ChannelBootstrapStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ChannelBootstrapStub() = default;
  ~ChannelBootstrapStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChannelBootstrapStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChannelBootstrapStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(IPC_MOJOM) ChannelRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(IPC_MOJOM) ChannelBootstrapRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class COMPONENT_EXPORT(IPC_MOJOM) Message {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Message, T>::value>;
  using DataView = MessageDataView;
  using Data_ = internal::Message_Data;

  template <typename... Args>
  static MessagePtr New(Args&&... args) {
    return MessagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MessagePtr From(const U& u) {
    return mojo::TypeConverter<MessagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Message>::Convert(*this);
  }


  Message();

  Message(
      std::vector<uint8_t> bytes,
      std::optional<std::vector<::mojo::native::SerializedHandlePtr>> handles);

Message(const Message&) = delete;
Message& operator=(const Message&) = delete;

  ~Message();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MessagePtr>
  MessagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Message::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Message::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Message::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Message::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Message_UnserializedMessageContext<
            UserType, Message::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Message::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Message::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Message_UnserializedMessageContext<
            UserType, Message::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Message::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> bytes;
  
  std::optional<std::vector<::mojo::native::SerializedHandlePtr>> handles;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Message::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Message::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Message::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Message::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
MessagePtr Message::Clone() const {
  return New(
      mojo::Clone(bytes),
      mojo::Clone(handles)
  );
}

template <typename T, Message::EnableIfSame<T>*>
bool Message::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bytes, other_struct.bytes))
    return false;
  if (!mojo::Equals(this->handles, other_struct.handles))
    return false;
  return true;
}

template <typename T, Message::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bytes < rhs.bytes)
    return true;
  if (rhs.bytes < lhs.bytes)
    return false;
  if (lhs.handles < rhs.handles)
    return true;
  if (rhs.handles < lhs.handles)
    return false;
  return false;
}


}  // IPC::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(IPC_MOJOM) StructTraits<::IPC::mojom::Message::DataView,
                                         ::IPC::mojom::MessagePtr> {
  static bool IsNull(const ::IPC::mojom::MessagePtr& input) { return !input; }
  static void SetToNull(::IPC::mojom::MessagePtr* output) { output->reset(); }

  static const decltype(::IPC::mojom::Message::bytes)& bytes(
      const ::IPC::mojom::MessagePtr& input) {
    return input->bytes;
  }

  static  decltype(::IPC::mojom::Message::handles)& handles(
       ::IPC::mojom::MessagePtr& input) {
    return input->handles;
  }

  static bool Read(::IPC::mojom::Message::DataView input, ::IPC::mojom::MessagePtr* output);
};

}  // namespace mojo

#endif  // IPC_IPC_MOJOM_H_