// media/mojo/mojom/media_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/media_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/media_service.mojom-params-data.h"
#include "media/mojo/mojom/media_service.mojom-shared-message-ids.h"

#include "media/mojo/mojom/media_service.mojom-blink-import-headers.h"
#include "media/mojo/mojom/media_service.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
// The declaration includes the definition on other builds.

MediaService::IPCStableHashFunction MediaService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaService>(message.name())) {
    case messages::MediaService::kCreateInterfaceFactory: {
      return &MediaService::CreateInterfaceFactory_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaService>(message.name())) {
      case messages::MediaService::kCreateInterfaceFactory:
            return "Receive media::mojom::MediaService::CreateInterfaceFactory";
    }
  } else {
    switch (static_cast<messages::MediaService>(message.name())) {
      case messages::MediaService::kCreateInterfaceFactory:
            return "Receive reply media::mojom::MediaService::CreateInterfaceFactory";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaService::CreateInterfaceFactory_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf6011f53;  // IPCStableHash for media::mojom::MediaService::CreateInterfaceFactory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaServiceProxy::MediaServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaServiceProxy::CreateInterfaceFactory(
    ::mojo::PendingReceiver<::media::mojom::blink::InterfaceFactory> in_factory, ::mojo::PendingRemote<::media::mojom::blink::FrameInterfaceFactory> in_frame_interfaces) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaService::CreateInterfaceFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("factory"), in_factory,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::blink::InterfaceFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_interfaces"), in_frame_interfaces,
                        "<value of type ::mojo::PendingRemote<::media::mojom::blink::FrameInterfaceFactory>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaService::kCreateInterfaceFactory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaService_CreateInterfaceFactory_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::InterfaceFactoryInterfaceBase>>(
    in_factory,
    &params->factory,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->factory)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid factory in MediaService.CreateInterfaceFactory request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::FrameInterfaceFactoryInterfaceBase>>(
    in_frame_interfaces,
    &params->frame_interfaces,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->frame_interfaces)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid frame_interfaces in MediaService.CreateInterfaceFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaService::Name_);
  message.set_method_name("CreateInterfaceFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaServiceStubDispatch::Accept(
    MediaService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaService>(message->header()->name)) {
    case messages::MediaService::kCreateInterfaceFactory: {
      DCHECK(message->is_serialized());
      internal::MediaService_CreateInterfaceFactory_Params_Data* params =
          reinterpret_cast<internal::MediaService_CreateInterfaceFactory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaService.0
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::blink::InterfaceFactory> p_factory{};
      ::mojo::PendingRemote<::media::mojom::blink::FrameInterfaceFactory> p_frame_interfaces{};
      MediaService_CreateInterfaceFactory_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (success) {
        p_frame_interfaces =
            input_data_view.TakeFrameInterfaces<decltype(p_frame_interfaces)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateInterfaceFactory(        
        std::move(p_factory), 
        std::move(p_frame_interfaces));
      return true;
    }
  }
  return false;
}

// static
bool MediaServiceStubDispatch::AcceptWithResponder(
    MediaService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaService>(message->header()->name)) {
    case messages::MediaService::kCreateInterfaceFactory: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMediaServiceValidationInfo[] = {
    {base::to_underlying(messages::MediaService::kCreateInterfaceFactory),
     { &internal::MediaService_CreateInterfaceFactory_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MediaServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::media::mojom::blink::MediaService::Name_,
    kMediaServiceValidationInfo);
}



}  // media::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {


void MediaServiceInterceptorForTesting::CreateInterfaceFactory(::mojo::PendingReceiver<::media::mojom::blink::InterfaceFactory> factory, ::mojo::PendingRemote<::media::mojom::blink::FrameInterfaceFactory> frame_interfaces) {
  GetForwardingInterface()->CreateInterfaceFactory(
    std::move(factory)
    , 
    std::move(frame_interfaces)
    );
}
MediaServiceAsyncWaiter::MediaServiceAsyncWaiter(
    MediaService* proxy) : proxy_(proxy) {}

MediaServiceAsyncWaiter::~MediaServiceAsyncWaiter() = default;







}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif