// pdf/mojom/pdf.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "pdf/mojom/pdf.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "pdf/mojom/pdf.mojom-params-data.h"
namespace pdf {
namespace mojom {

NOINLINE static const char* SaveRequestTypeToStringHelper(SaveRequestType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SaveRequestType::kAnnotation:
      return "kAnnotation";
    case SaveRequestType::kOriginal:
      return "kOriginal";
    case SaveRequestType::kEdited:
      return "kEdited";
    case SaveRequestType::kSearchified:
      return "kSearchified";
    default:
      return nullptr;
  }
}

std::string SaveRequestTypeToString(SaveRequestType value) {
  const char *str = SaveRequestTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SaveRequestType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SaveRequestType value) {
  return os << SaveRequestTypeToString(value);
}

NOINLINE static const char* PdfListener_GetPdfBytesStatusToStringHelper(PdfListener_GetPdfBytesStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PdfListener_GetPdfBytesStatus::kSuccess:
      return "kSuccess";
    case PdfListener_GetPdfBytesStatus::kSizeLimitExceeded:
      return "kSizeLimitExceeded";
    case PdfListener_GetPdfBytesStatus::kFailed:
      return "kFailed";
    default:
      return nullptr;
  }
}

std::string PdfListener_GetPdfBytesStatusToString(PdfListener_GetPdfBytesStatus value) {
  const char *str = PdfListener_GetPdfBytesStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PdfListener_GetPdfBytesStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PdfListener_GetPdfBytesStatus value) {
  return os << PdfListener_GetPdfBytesStatusToString(value);
}

namespace internal {


// static
bool PdfListener_SetCaretPosition_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfListener_SetCaretPosition_Params_Data* object =
      static_cast<const PdfListener_SetCaretPosition_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->position, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;

  return true;
}

PdfListener_SetCaretPosition_Params_Data::PdfListener_SetCaretPosition_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfListener_MoveRangeSelectionExtent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfListener_MoveRangeSelectionExtent_Params_Data* object =
      static_cast<const PdfListener_MoveRangeSelectionExtent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extent, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extent, validation_context))
    return false;

  return true;
}

PdfListener_MoveRangeSelectionExtent_Params_Data::PdfListener_MoveRangeSelectionExtent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfListener_SetSelectionBounds_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfListener_SetSelectionBounds_Params_Data* object =
      static_cast<const PdfListener_SetSelectionBounds_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->base, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->base, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extent, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->extent, validation_context))
    return false;

  return true;
}

PdfListener_SetSelectionBounds_Params_Data::PdfListener_SetSelectionBounds_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfListener_GetPdfBytes_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfListener_GetPdfBytes_Params_Data* object =
      static_cast<const PdfListener_GetPdfBytes_Params_Data*>(data);

  return true;
}

PdfListener_GetPdfBytes_Params_Data::PdfListener_GetPdfBytes_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfListener_GetPdfBytes_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfListener_GetPdfBytes_ResponseParams_Data* object =
      static_cast<const PdfListener_GetPdfBytes_ResponseParams_Data*>(data);


  if (!::pdf::mojom::internal::PdfListener_GetPdfBytesStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bytes, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->bytes, validation_context,
                                         &bytes_validate_params)) {
    return false;
  }

  return true;
}

PdfListener_GetPdfBytes_ResponseParams_Data::PdfListener_GetPdfBytes_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfListener_GetPageText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfListener_GetPageText_Params_Data* object =
      static_cast<const PdfListener_GetPageText_Params_Data*>(data);

  return true;
}

PdfListener_GetPageText_Params_Data::PdfListener_GetPageText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfListener_GetPageText_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfListener_GetPageText_ResponseParams_Data* object =
      static_cast<const PdfListener_GetPageText_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  return true;
}

PdfListener_GetPageText_ResponseParams_Data::PdfListener_GetPageText_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfListener_GetMostVisiblePageIndex_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfListener_GetMostVisiblePageIndex_Params_Data* object =
      static_cast<const PdfListener_GetMostVisiblePageIndex_Params_Data*>(data);

  return true;
}

PdfListener_GetMostVisiblePageIndex_Params_Data::PdfListener_GetMostVisiblePageIndex_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfListener_GetMostVisiblePageIndex_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfListener_GetMostVisiblePageIndex_ResponseParams_Data* object =
      static_cast<const PdfListener_GetMostVisiblePageIndex_ResponseParams_Data*>(data);

  return true;
}

PdfListener_GetMostVisiblePageIndex_ResponseParams_Data::PdfListener_GetMostVisiblePageIndex_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfHost_SetListener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfHost_SetListener_Params_Data* object =
      static_cast<const PdfHost_SetListener_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PdfHost_SetListener_Params_Data::PdfHost_SetListener_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfHost_OnDocumentLoadComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfHost_OnDocumentLoadComplete_Params_Data* object =
      static_cast<const PdfHost_OnDocumentLoadComplete_Params_Data*>(data);

  return true;
}

PdfHost_OnDocumentLoadComplete_Params_Data::PdfHost_OnDocumentLoadComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfHost_UpdateContentRestrictions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfHost_UpdateContentRestrictions_Params_Data* object =
      static_cast<const PdfHost_UpdateContentRestrictions_Params_Data*>(data);

  return true;
}

PdfHost_UpdateContentRestrictions_Params_Data::PdfHost_UpdateContentRestrictions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfHost_SaveUrlAs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfHost_SaveUrlAs_Params_Data* object =
      static_cast<const PdfHost_SaveUrlAs_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::network::mojom::internal::ReferrerPolicy_Data
        ::Validate(object->policy, validation_context))
    return false;

  return true;
}

PdfHost_SaveUrlAs_Params_Data::PdfHost_SaveUrlAs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfHost_SelectionChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfHost_SelectionChanged_Params_Data* object =
      static_cast<const PdfHost_SelectionChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->left, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->left, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->right, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->right, validation_context))
    return false;

  return true;
}

PdfHost_SelectionChanged_Params_Data::PdfHost_SelectionChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfHost_SetPluginCanSave_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfHost_SetPluginCanSave_Params_Data* object =
      static_cast<const PdfHost_SetPluginCanSave_Params_Data*>(data);

  return true;
}

PdfHost_SetPluginCanSave_Params_Data::PdfHost_SetPluginCanSave_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace pdf

namespace perfetto {

// static
void TraceFormatTraits<::pdf::mojom::SaveRequestType>::WriteIntoTrace(
   perfetto::TracedValue context, ::pdf::mojom::SaveRequestType value) {
  return std::move(context).WriteString(::pdf::mojom::SaveRequestTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::pdf::mojom::PdfListener_GetPdfBytesStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::pdf::mojom::PdfListener_GetPdfBytesStatus value) {
  return std::move(context).WriteString(::pdf::mojom::PdfListener_GetPdfBytesStatusToString(value));
}

} // namespace perfetto