// services/audio/public/mojom/debug_recording.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/audio/public/mojom/debug_recording.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/audio/public/mojom/debug_recording.mojom-params-data.h"
#include "services/audio/public/mojom/debug_recording.mojom-shared-message-ids.h"

#include "services/audio/public/mojom/debug_recording.mojom-import-headers.h"
#include "services/audio/public/mojom/debug_recording.mojom-test-utils.h"


namespace audio::mojom {
// The declaration includes the definition on other builds.

DebugRecordingFileProvider::IPCStableHashFunction DebugRecordingFileProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DebugRecordingFileProvider>(message.name())) {
    case messages::DebugRecordingFileProvider::kCreateWavFile: {
      return &DebugRecordingFileProvider::CreateWavFile_Sym::IPCStableHash;
    }
    case messages::DebugRecordingFileProvider::kCreateAecdumpFile: {
      return &DebugRecordingFileProvider::CreateAecdumpFile_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DebugRecordingFileProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DebugRecordingFileProvider>(message.name())) {
      case messages::DebugRecordingFileProvider::kCreateWavFile:
            return "Receive audio::mojom::DebugRecordingFileProvider::CreateWavFile";
      case messages::DebugRecordingFileProvider::kCreateAecdumpFile:
            return "Receive audio::mojom::DebugRecordingFileProvider::CreateAecdumpFile";
    }
  } else {
    switch (static_cast<messages::DebugRecordingFileProvider>(message.name())) {
      case messages::DebugRecordingFileProvider::kCreateWavFile:
            return "Receive reply audio::mojom::DebugRecordingFileProvider::CreateWavFile";
      case messages::DebugRecordingFileProvider::kCreateAecdumpFile:
            return "Receive reply audio::mojom::DebugRecordingFileProvider::CreateAecdumpFile";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DebugRecordingFileProvider::CreateWavFile_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1c9e0304;  // IPCStableHash for audio::mojom::DebugRecordingFileProvider::CreateWavFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DebugRecordingFileProvider::CreateAecdumpFile_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5f3c1677;  // IPCStableHash for audio::mojom::DebugRecordingFileProvider::CreateAecdumpFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class DebugRecordingFileProvider_CreateWavFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DebugRecordingFileProvider_CreateWavFile_ForwardToCallback(
      DebugRecordingFileProvider::CreateWavFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  DebugRecordingFileProvider_CreateWavFile_ForwardToCallback(const DebugRecordingFileProvider_CreateWavFile_ForwardToCallback&) = delete;
  DebugRecordingFileProvider_CreateWavFile_ForwardToCallback& operator=(const DebugRecordingFileProvider_CreateWavFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DebugRecordingFileProvider::CreateWavFileCallback callback_;
};

class DebugRecordingFileProvider_CreateAecdumpFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DebugRecordingFileProvider_CreateAecdumpFile_ForwardToCallback(
      DebugRecordingFileProvider::CreateAecdumpFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  DebugRecordingFileProvider_CreateAecdumpFile_ForwardToCallback(const DebugRecordingFileProvider_CreateAecdumpFile_ForwardToCallback&) = delete;
  DebugRecordingFileProvider_CreateAecdumpFile_ForwardToCallback& operator=(const DebugRecordingFileProvider_CreateAecdumpFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DebugRecordingFileProvider::CreateAecdumpFileCallback callback_;
};

DebugRecordingFileProviderProxy::DebugRecordingFileProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DebugRecordingFileProviderProxy::CreateWavFile(
    ::media::AudioDebugRecordingStreamType in_stream_type, uint32_t in_id, CreateWavFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send audio::mojom::DebugRecordingFileProvider::CreateWavFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_type"), in_stream_type,
                        "<value of type ::media::AudioDebugRecordingStreamType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DebugRecordingFileProvider::kCreateWavFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::DebugRecordingFileProvider_CreateWavFile_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::audio::mojom::DebugRecordingStreamType>(
    in_stream_type,
    &params->stream_type);

  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DebugRecordingFileProvider::Name_);
  message.set_method_name("CreateWavFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DebugRecordingFileProvider_CreateWavFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DebugRecordingFileProviderProxy::CreateAecdumpFile(
    uint32_t in_id, CreateAecdumpFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send audio::mojom::DebugRecordingFileProvider::CreateAecdumpFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DebugRecordingFileProvider::kCreateAecdumpFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::DebugRecordingFileProvider_CreateAecdumpFile_Params_Data> params(
          message);
  params.Allocate();

  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DebugRecordingFileProvider::Name_);
  message.set_method_name("CreateAecdumpFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DebugRecordingFileProvider_CreateAecdumpFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class DebugRecordingFileProvider_CreateWavFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DebugRecordingFileProvider::CreateWavFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DebugRecordingFileProvider_CreateWavFile_ProxyToResponder> proxy(
        new DebugRecordingFileProvider_CreateWavFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DebugRecordingFileProvider_CreateWavFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DebugRecordingFileProvider_CreateWavFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DebugRecordingFileProvider_CreateWavFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DebugRecordingFileProvider::CreateWavFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File in_file);
};

bool DebugRecordingFileProvider_CreateWavFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DebugRecordingFileProvider_CreateWavFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DebugRecordingFileProvider_CreateWavFile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DebugRecordingFileProvider.0
  bool success = true;
  ::base::File p_file{};
  DebugRecordingFileProvider_CreateWavFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFile(&p_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DebugRecordingFileProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_file));
  }
  return true;
}

void DebugRecordingFileProvider_CreateWavFile_ProxyToResponder::Run(
    ::base::File in_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply audio::mojom::DebugRecordingFileProvider::CreateWavFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::base::File>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DebugRecordingFileProvider::kCreateWavFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::DebugRecordingFileProvider_CreateWavFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
    in_file,
    file_fragment);

  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DebugRecordingFileProvider::Name_);
  message.set_method_name("CreateWavFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DebugRecordingFileProvider_CreateAecdumpFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DebugRecordingFileProvider::CreateAecdumpFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DebugRecordingFileProvider_CreateAecdumpFile_ProxyToResponder> proxy(
        new DebugRecordingFileProvider_CreateAecdumpFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DebugRecordingFileProvider_CreateAecdumpFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DebugRecordingFileProvider_CreateAecdumpFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DebugRecordingFileProvider_CreateAecdumpFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DebugRecordingFileProvider::CreateAecdumpFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File in_file);
};

bool DebugRecordingFileProvider_CreateAecdumpFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DebugRecordingFileProvider_CreateAecdumpFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DebugRecordingFileProvider_CreateAecdumpFile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DebugRecordingFileProvider.1
  bool success = true;
  ::base::File p_file{};
  DebugRecordingFileProvider_CreateAecdumpFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFile(&p_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DebugRecordingFileProvider::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_file));
  }
  return true;
}

void DebugRecordingFileProvider_CreateAecdumpFile_ProxyToResponder::Run(
    ::base::File in_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply audio::mojom::DebugRecordingFileProvider::CreateAecdumpFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::base::File>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DebugRecordingFileProvider::kCreateAecdumpFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::DebugRecordingFileProvider_CreateAecdumpFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
    in_file,
    file_fragment);

  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DebugRecordingFileProvider::Name_);
  message.set_method_name("CreateAecdumpFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DebugRecordingFileProviderStubDispatch::Accept(
    DebugRecordingFileProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DebugRecordingFileProvider>(message->header()->name)) {
    case messages::DebugRecordingFileProvider::kCreateWavFile: {
      break;
    }
    case messages::DebugRecordingFileProvider::kCreateAecdumpFile: {
      break;
    }
  }
  return false;
}

// static
bool DebugRecordingFileProviderStubDispatch::AcceptWithResponder(
    DebugRecordingFileProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DebugRecordingFileProvider>(message->header()->name)) {
    case messages::DebugRecordingFileProvider::kCreateWavFile: {
      internal::DebugRecordingFileProvider_CreateWavFile_Params_Data* params =
          reinterpret_cast<
              internal::DebugRecordingFileProvider_CreateWavFile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DebugRecordingFileProvider.0
      bool success = true;
      ::media::AudioDebugRecordingStreamType p_stream_type{};
      uint32_t p_id{};
      DebugRecordingFileProvider_CreateWavFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStreamType(&p_stream_type))
        success = false;
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DebugRecordingFileProvider::Name_, 0, false);
        return false;
      }
      auto callback =
          DebugRecordingFileProvider_CreateWavFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWavFile(        
        std::move(p_stream_type), 
        std::move(p_id), std::move(callback));
      return true;
    }
    case messages::DebugRecordingFileProvider::kCreateAecdumpFile: {
      internal::DebugRecordingFileProvider_CreateAecdumpFile_Params_Data* params =
          reinterpret_cast<
              internal::DebugRecordingFileProvider_CreateAecdumpFile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DebugRecordingFileProvider.1
      bool success = true;
      uint32_t p_id{};
      DebugRecordingFileProvider_CreateAecdumpFile_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DebugRecordingFileProvider::Name_, 1, false);
        return false;
      }
      auto callback =
          DebugRecordingFileProvider_CreateAecdumpFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAecdumpFile(        
        std::move(p_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDebugRecordingFileProviderValidationInfo[] = {
    {base::to_underlying(messages::DebugRecordingFileProvider::kCreateWavFile),
     { &internal::DebugRecordingFileProvider_CreateWavFile_Params_Data::Validate,
      &internal::DebugRecordingFileProvider_CreateWavFile_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::DebugRecordingFileProvider::kCreateAecdumpFile),
     { &internal::DebugRecordingFileProvider_CreateAecdumpFile_Params_Data::Validate,
      &internal::DebugRecordingFileProvider_CreateAecdumpFile_ResponseParams_Data::Validate}},
};

bool DebugRecordingFileProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::audio::mojom::DebugRecordingFileProvider::Name_,
    kDebugRecordingFileProviderValidationInfo);
}

bool DebugRecordingFileProviderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::audio::mojom::DebugRecordingFileProvider::Name_,
    kDebugRecordingFileProviderValidationInfo);

}
// The declaration includes the definition on other builds.

DebugRecording::IPCStableHashFunction DebugRecording::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DebugRecording>(message.name())) {
    case messages::DebugRecording::kEnable: {
      return &DebugRecording::Enable_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DebugRecording::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DebugRecording>(message.name())) {
      case messages::DebugRecording::kEnable:
            return "Receive audio::mojom::DebugRecording::Enable";
    }
  } else {
    switch (static_cast<messages::DebugRecording>(message.name())) {
      case messages::DebugRecording::kEnable:
            return "Receive reply audio::mojom::DebugRecording::Enable";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DebugRecording::Enable_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdf203944;  // IPCStableHash for audio::mojom::DebugRecording::Enable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DebugRecordingProxy::DebugRecordingProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DebugRecordingProxy::Enable(
    ::mojo::PendingRemote<DebugRecordingFileProvider> in_file_provider) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send audio::mojom::DebugRecording::Enable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_provider"), in_file_provider,
                        "<value of type ::mojo::PendingRemote<DebugRecordingFileProvider>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DebugRecording::kEnable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::DebugRecording_Enable_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::audio::mojom::DebugRecordingFileProviderInterfaceBase>>(
    in_file_provider,
    &params->file_provider,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->file_provider)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid file_provider in DebugRecording.Enable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DebugRecording::Name_);
  message.set_method_name("Enable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DebugRecordingStubDispatch::Accept(
    DebugRecording* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DebugRecording>(message->header()->name)) {
    case messages::DebugRecording::kEnable: {
      DCHECK(message->is_serialized());
      internal::DebugRecording_Enable_Params_Data* params =
          reinterpret_cast<internal::DebugRecording_Enable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DebugRecording.0
      bool success = true;
      ::mojo::PendingRemote<DebugRecordingFileProvider> p_file_provider{};
      DebugRecording_Enable_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_file_provider =
            input_data_view.TakeFileProvider<decltype(p_file_provider)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DebugRecording::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Enable(        
        std::move(p_file_provider));
      return true;
    }
  }
  return false;
}

// static
bool DebugRecordingStubDispatch::AcceptWithResponder(
    DebugRecording* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DebugRecording>(message->header()->name)) {
    case messages::DebugRecording::kEnable: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDebugRecordingValidationInfo[] = {
    {base::to_underlying(messages::DebugRecording::kEnable),
     { &internal::DebugRecording_Enable_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DebugRecordingRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::audio::mojom::DebugRecording::Name_,
    kDebugRecordingValidationInfo);
}



}  // audio::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace audio::mojom {


void DebugRecordingFileProviderInterceptorForTesting::CreateWavFile(::media::AudioDebugRecordingStreamType stream_type, uint32_t id, CreateWavFileCallback callback) {
  GetForwardingInterface()->CreateWavFile(
    std::move(stream_type)
    , 
    std::move(id)
    , std::move(callback));
}
void DebugRecordingFileProviderInterceptorForTesting::CreateAecdumpFile(uint32_t id, CreateAecdumpFileCallback callback) {
  GetForwardingInterface()->CreateAecdumpFile(
    std::move(id)
    , std::move(callback));
}
DebugRecordingFileProviderAsyncWaiter::DebugRecordingFileProviderAsyncWaiter(
    DebugRecordingFileProvider* proxy) : proxy_(proxy) {}

DebugRecordingFileProviderAsyncWaiter::~DebugRecordingFileProviderAsyncWaiter() = default;


void DebugRecordingFileProviderAsyncWaiter::CreateWavFile(
    ::media::AudioDebugRecordingStreamType stream_type, uint32_t id, ::base::File* out_file) {
  base::RunLoop loop;
  proxy_->CreateWavFile(
      std::move(stream_type),
      std::move(id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File* out_file
,
             ::base::File file) {*out_file = std::move(file);
            loop->Quit();
          },
          &loop,
          out_file));
  loop.Run();
}

::base::File DebugRecordingFileProviderAsyncWaiter::CreateWavFile(
    ::media::AudioDebugRecordingStreamType stream_type, uint32_t id) {
  ::base::File async_wait_result;
  CreateWavFile(std::move(stream_type),std::move(id),&async_wait_result);
  return async_wait_result;
}

void DebugRecordingFileProviderAsyncWaiter::CreateAecdumpFile(
    uint32_t id, ::base::File* out_file) {
  base::RunLoop loop;
  proxy_->CreateAecdumpFile(
      std::move(id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File* out_file
,
             ::base::File file) {*out_file = std::move(file);
            loop->Quit();
          },
          &loop,
          out_file));
  loop.Run();
}

::base::File DebugRecordingFileProviderAsyncWaiter::CreateAecdumpFile(
    uint32_t id) {
  ::base::File async_wait_result;
  CreateAecdumpFile(std::move(id),&async_wait_result);
  return async_wait_result;
}




void DebugRecordingInterceptorForTesting::Enable(::mojo::PendingRemote<DebugRecordingFileProvider> file_provider) {
  GetForwardingInterface()->Enable(
    std::move(file_provider)
    );
}
DebugRecordingAsyncWaiter::DebugRecordingAsyncWaiter(
    DebugRecording* proxy) : proxy_(proxy) {}

DebugRecordingAsyncWaiter::~DebugRecordingAsyncWaiter() = default;







}  // audio::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif