// services/network/public/mojom/accept_ch_frame_observer.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/accept_ch_frame_observer.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/accept_ch_frame_observer.mojom-params-data.h"
#include "services/network/public/mojom/accept_ch_frame_observer.mojom-shared-message-ids.h"

#include "services/network/public/mojom/accept_ch_frame_observer.mojom-blink-import-headers.h"
#include "services/network/public/mojom/accept_ch_frame_observer.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
// The declaration includes the definition on other builds.

AcceptCHFrameObserver::IPCStableHashFunction AcceptCHFrameObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AcceptCHFrameObserver>(message.name())) {
    case messages::AcceptCHFrameObserver::kOnAcceptCHFrameReceived: {
      return &AcceptCHFrameObserver::OnAcceptCHFrameReceived_Sym::IPCStableHash;
    }
    case messages::AcceptCHFrameObserver::kClone: {
      return &AcceptCHFrameObserver::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AcceptCHFrameObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AcceptCHFrameObserver>(message.name())) {
      case messages::AcceptCHFrameObserver::kOnAcceptCHFrameReceived:
            return "Receive network::mojom::AcceptCHFrameObserver::OnAcceptCHFrameReceived";
      case messages::AcceptCHFrameObserver::kClone:
            return "Receive network::mojom::AcceptCHFrameObserver::Clone";
    }
  } else {
    switch (static_cast<messages::AcceptCHFrameObserver>(message.name())) {
      case messages::AcceptCHFrameObserver::kOnAcceptCHFrameReceived:
            return "Receive reply network::mojom::AcceptCHFrameObserver::OnAcceptCHFrameReceived";
      case messages::AcceptCHFrameObserver::kClone:
            return "Receive reply network::mojom::AcceptCHFrameObserver::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AcceptCHFrameObserver::OnAcceptCHFrameReceived_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0ae2fe04;  // IPCStableHash for network::mojom::AcceptCHFrameObserver::OnAcceptCHFrameReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AcceptCHFrameObserver::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x58c10af4;  // IPCStableHash for network::mojom::AcceptCHFrameObserver::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AcceptCHFrameObserver_OnAcceptCHFrameReceived_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AcceptCHFrameObserver_OnAcceptCHFrameReceived_ForwardToCallback(
      AcceptCHFrameObserver::OnAcceptCHFrameReceivedCallback callback
      ) : callback_(std::move(callback)) {
  }

  AcceptCHFrameObserver_OnAcceptCHFrameReceived_ForwardToCallback(const AcceptCHFrameObserver_OnAcceptCHFrameReceived_ForwardToCallback&) = delete;
  AcceptCHFrameObserver_OnAcceptCHFrameReceived_ForwardToCallback& operator=(const AcceptCHFrameObserver_OnAcceptCHFrameReceived_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AcceptCHFrameObserver::OnAcceptCHFrameReceivedCallback callback_;
};

AcceptCHFrameObserverProxy::AcceptCHFrameObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AcceptCHFrameObserverProxy::OnAcceptCHFrameReceived(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& in_origin, const ::blink::Vector<::network::mojom::blink::WebClientHintsType>& in_accept_ch_frame, OnAcceptCHFrameReceivedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::AcceptCHFrameObserver::OnAcceptCHFrameReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("accept_ch_frame"), in_accept_ch_frame,
                        "<value of type const ::blink::Vector<::network::mojom::blink::WebClientHintsType>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AcceptCHFrameObserver::kOnAcceptCHFrameReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::AcceptCHFrameObserver_OnAcceptCHFrameReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in AcceptCHFrameObserver.OnAcceptCHFrameReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->accept_ch_frame)::BaseType>
      accept_ch_frame_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& accept_ch_frame_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::WebClientHintsType_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::WebClientHintsType>>(
    in_accept_ch_frame,
    accept_ch_frame_fragment,
    &accept_ch_frame_validate_params);

  params->accept_ch_frame.Set(
      accept_ch_frame_fragment.is_null() ? nullptr : accept_ch_frame_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->accept_ch_frame.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null accept_ch_frame in AcceptCHFrameObserver.OnAcceptCHFrameReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AcceptCHFrameObserver::Name_);
  message.set_method_name("OnAcceptCHFrameReceived");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AcceptCHFrameObserver_OnAcceptCHFrameReceived_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AcceptCHFrameObserverProxy::Clone(
    ::mojo::PendingReceiver<AcceptCHFrameObserver> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::AcceptCHFrameObserver::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingReceiver<AcceptCHFrameObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AcceptCHFrameObserver::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::AcceptCHFrameObserver_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::AcceptCHFrameObserverInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid listener in AcceptCHFrameObserver.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AcceptCHFrameObserver::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class AcceptCHFrameObserver_OnAcceptCHFrameReceived_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AcceptCHFrameObserver::OnAcceptCHFrameReceivedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AcceptCHFrameObserver_OnAcceptCHFrameReceived_ProxyToResponder> proxy(
        new AcceptCHFrameObserver_OnAcceptCHFrameReceived_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AcceptCHFrameObserver_OnAcceptCHFrameReceived_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AcceptCHFrameObserver_OnAcceptCHFrameReceived_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AcceptCHFrameObserver_OnAcceptCHFrameReceived_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AcceptCHFrameObserver::OnAcceptCHFrameReceivedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_status);
};

bool AcceptCHFrameObserver_OnAcceptCHFrameReceived_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AcceptCHFrameObserver_OnAcceptCHFrameReceived_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AcceptCHFrameObserver_OnAcceptCHFrameReceived_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AcceptCHFrameObserver.0
  bool success = true;
  int32_t p_status{};
  AcceptCHFrameObserver_OnAcceptCHFrameReceived_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_status = input_data_view.status();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AcceptCHFrameObserver::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void AcceptCHFrameObserver_OnAcceptCHFrameReceived_ProxyToResponder::Run(
    int32_t in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::AcceptCHFrameObserver::OnAcceptCHFrameReceived", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AcceptCHFrameObserver::kOnAcceptCHFrameReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::AcceptCHFrameObserver_OnAcceptCHFrameReceived_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->status = in_status;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AcceptCHFrameObserver::Name_);
  message.set_method_name("OnAcceptCHFrameReceived");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AcceptCHFrameObserverStubDispatch::Accept(
    AcceptCHFrameObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AcceptCHFrameObserver>(message->header()->name)) {
    case messages::AcceptCHFrameObserver::kOnAcceptCHFrameReceived: {
      break;
    }
    case messages::AcceptCHFrameObserver::kClone: {
      DCHECK(message->is_serialized());
      internal::AcceptCHFrameObserver_Clone_Params_Data* params =
          reinterpret_cast<internal::AcceptCHFrameObserver_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AcceptCHFrameObserver.1
      bool success = true;
      ::mojo::PendingReceiver<AcceptCHFrameObserver> p_listener{};
      AcceptCHFrameObserver_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AcceptCHFrameObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_listener));
      return true;
    }
  }
  return false;
}

// static
bool AcceptCHFrameObserverStubDispatch::AcceptWithResponder(
    AcceptCHFrameObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AcceptCHFrameObserver>(message->header()->name)) {
    case messages::AcceptCHFrameObserver::kOnAcceptCHFrameReceived: {
      internal::AcceptCHFrameObserver_OnAcceptCHFrameReceived_Params_Data* params =
          reinterpret_cast<
              internal::AcceptCHFrameObserver_OnAcceptCHFrameReceived_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AcceptCHFrameObserver.0
      bool success = true;
      ::scoped_refptr<const ::blink::SecurityOrigin> p_origin{};
      ::blink::Vector<::network::mojom::blink::WebClientHintsType> p_accept_ch_frame{};
      AcceptCHFrameObserver_OnAcceptCHFrameReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadAcceptChFrame(&p_accept_ch_frame))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AcceptCHFrameObserver::Name_, 0, false);
        return false;
      }
      auto callback =
          AcceptCHFrameObserver_OnAcceptCHFrameReceived_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAcceptCHFrameReceived(        
        std::move(p_origin), 
        std::move(p_accept_ch_frame), std::move(callback));
      return true;
    }
    case messages::AcceptCHFrameObserver::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAcceptCHFrameObserverValidationInfo[] = {
    {base::to_underlying(messages::AcceptCHFrameObserver::kOnAcceptCHFrameReceived),
     { &internal::AcceptCHFrameObserver_OnAcceptCHFrameReceived_Params_Data::Validate,
      &internal::AcceptCHFrameObserver_OnAcceptCHFrameReceived_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::AcceptCHFrameObserver::kClone),
     { &internal::AcceptCHFrameObserver_Clone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AcceptCHFrameObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::blink::AcceptCHFrameObserver::Name_,
    kAcceptCHFrameObserverValidationInfo);
}

bool AcceptCHFrameObserverResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::network::mojom::blink::AcceptCHFrameObserver::Name_,
    kAcceptCHFrameObserverValidationInfo);

}


}  // network::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void AcceptCHFrameObserverInterceptorForTesting::OnAcceptCHFrameReceived(const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, const ::blink::Vector<::network::mojom::blink::WebClientHintsType>& accept_ch_frame, OnAcceptCHFrameReceivedCallback callback) {
  GetForwardingInterface()->OnAcceptCHFrameReceived(
    std::move(origin)
    , 
    std::move(accept_ch_frame)
    , std::move(callback));
}
void AcceptCHFrameObserverInterceptorForTesting::Clone(::mojo::PendingReceiver<AcceptCHFrameObserver> listener) {
  GetForwardingInterface()->Clone(
    std::move(listener)
    );
}
AcceptCHFrameObserverAsyncWaiter::AcceptCHFrameObserverAsyncWaiter(
    AcceptCHFrameObserver* proxy) : proxy_(proxy) {}

AcceptCHFrameObserverAsyncWaiter::~AcceptCHFrameObserverAsyncWaiter() = default;


void AcceptCHFrameObserverAsyncWaiter::OnAcceptCHFrameReceived(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, const ::blink::Vector<::network::mojom::blink::WebClientHintsType>& accept_ch_frame, int32_t* out_status) {
  base::RunLoop loop;
  proxy_->OnAcceptCHFrameReceived(
      std::move(origin),
      std::move(accept_ch_frame),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_status
,
             int32_t status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

int32_t AcceptCHFrameObserverAsyncWaiter::OnAcceptCHFrameReceived(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, const ::blink::Vector<::network::mojom::blink::WebClientHintsType>& accept_ch_frame) {
  int32_t async_wait_result;
  OnAcceptCHFrameReceived(std::move(origin),std::move(accept_ch_frame),&async_wait_result);
  return async_wait_result;
}






}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif