// services/network/public/mojom/ad_auction.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_AD_AUCTION_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_AD_AUCTION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/ad_auction.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"




#include "services/network/public/mojom/ad_auction.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::AdAuctionEventRecord_Type>
    : public mojo::internal::EnumHashImpl<::network::mojom::AdAuctionEventRecord_Type> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::AdAuctionEventRecord_Type, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::AdAuctionEventRecord_Type, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::AdAuctionEventRecord_Type>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::AdAuctionEventRecordDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::AdAuctionEventRecordDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::AdAuctionEventRecord_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::AdAuctionEventRecord_Type>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::providing_origin(input)) in_providing_origin = Traits::providing_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->providing_origin)::BaseType> providing_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_providing_origin,
      providing_origin_fragment);

    fragment->providing_origin.Set(
        providing_origin_fragment.is_null() ? nullptr : providing_origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->providing_origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null providing_origin in AdAuctionEventRecord struct");

    decltype(Traits::eligible_origins(input)) in_eligible_origins = Traits::eligible_origins(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->eligible_origins)::BaseType>
        eligible_origins_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& eligible_origins_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
      in_eligible_origins,
      eligible_origins_fragment,
      &eligible_origins_validate_params);

    fragment->eligible_origins.Set(
        eligible_origins_fragment.is_null() ? nullptr : eligible_origins_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->eligible_origins.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null eligible_origins in AdAuctionEventRecord struct");
  }

  static bool Deserialize(::network::mojom::internal::AdAuctionEventRecord_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::AdAuctionEventRecordDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void AdAuctionEventRecordDataView::GetProvidingOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->providing_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void AdAuctionEventRecordDataView::GetEligibleOriginsDataView(
    mojo::ArrayDataView<::url::mojom::OriginDataView>* output) {
  auto pointer = data_->eligible_origins.Get();
  *output = mojo::ArrayDataView<::url::mojom::OriginDataView>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::AdAuctionEventRecord_Type> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::AdAuctionEventRecord_Type value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_AD_AUCTION_MOJOM_SHARED_H_