// services/network/public/mojom/clear_data_filter.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CLEAR_DATA_FILTER_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CLEAR_DATA_FILTER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/clear_data_filter.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"




#include "services/network/public/mojom/clear_data_filter.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::ClearDataFilter_Type>
    : public mojo::internal::EnumHashImpl<::network::mojom::ClearDataFilter_Type> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ClearDataFilter_Type, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ClearDataFilter_Type, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ClearDataFilter_Type>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ClearDataFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ClearDataFilterDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ClearDataFilter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::ClearDataFilter_Type>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::domains(input)) in_domains = Traits::domains(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->domains)::BaseType>
        domains_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& domains_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_domains,
      domains_fragment,
      &domains_validate_params);

    fragment->domains.Set(
        domains_fragment.is_null() ? nullptr : domains_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->domains.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null domains in ClearDataFilter struct");

    decltype(Traits::origins(input)) in_origins = Traits::origins(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origins)::BaseType>
        origins_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& origins_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
      in_origins,
      origins_fragment,
      &origins_validate_params);

    fragment->origins.Set(
        origins_fragment.is_null() ? nullptr : origins_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origins.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origins in ClearDataFilter struct");
  }

  static bool Deserialize(::network::mojom::internal::ClearDataFilter_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ClearDataFilterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void ClearDataFilterDataView::GetDomainsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->domains.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void ClearDataFilterDataView::GetOriginsDataView(
    mojo::ArrayDataView<::url::mojom::OriginDataView>* output) {
  auto pointer = data_->origins.Get();
  *output = mojo::ArrayDataView<::url::mojom::OriginDataView>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ClearDataFilter_Type> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ClearDataFilter_Type value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CLEAR_DATA_FILTER_MOJOM_SHARED_H_