// services/network/public/mojom/connection_change_observer_client.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_CHANGE_OBSERVER_CLIENT_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_CHANGE_OBSERVER_CLIENT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/connection_change_observer_client.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/connection_change_observer_client.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/connection_change_observer_client.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {

class ConnectionChangeObserverClientProxy;

template <typename ImplRefTraits>
class ConnectionChangeObserverClientStub;

class ConnectionChangeObserverClientRequestValidator;


class BLINK_PLATFORM_EXPORT ConnectionChangeObserverClient
    : public ConnectionChangeObserverClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.ConnectionChangeObserverClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ConnectionChangeObserverClientInterfaceBase;
  using Proxy_ = ConnectionChangeObserverClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ConnectionChangeObserverClientStub<ImplRefTraits>;

  using RequestValidator_ = ConnectionChangeObserverClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnSessionClosedMinVersion = 0,
    kOnNetworkEventMinVersion = 0,
    kOnConnectionFailedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnSessionClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNetworkEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnConnectionFailed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ConnectionChangeObserverClient() = default;

  virtual void OnSessionClosed() = 0;

  virtual void OnNetworkEvent(NetworkChangeEvent event) = 0;

  virtual void OnConnectionFailed() = 0;
};



class BLINK_PLATFORM_EXPORT ConnectionChangeObserverClientProxy
    : public ConnectionChangeObserverClient {
 public:
  using InterfaceType = ConnectionChangeObserverClient;

  explicit ConnectionChangeObserverClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnSessionClosed() final;
  
  void OnNetworkEvent(NetworkChangeEvent event) final;
  
  void OnConnectionFailed() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT ConnectionChangeObserverClientStubDispatch {
 public:
  static bool Accept(ConnectionChangeObserverClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ConnectionChangeObserverClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ConnectionChangeObserverClient>>
class ConnectionChangeObserverClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ConnectionChangeObserverClientStub() = default;
  ~ConnectionChangeObserverClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ConnectionChangeObserverClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ConnectionChangeObserverClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT ConnectionChangeObserverClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_PLATFORM_EXPORT ConnectionKeepAliveConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ConnectionKeepAliveConfig, T>::value>;
  using DataView = ConnectionKeepAliveConfigDataView;
  using Data_ = internal::ConnectionKeepAliveConfig_Data;

  template <typename... Args>
  static ConnectionKeepAliveConfigPtr New(Args&&... args) {
    return ConnectionKeepAliveConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ConnectionKeepAliveConfigPtr From(const U& u) {
    return mojo::TypeConverter<ConnectionKeepAliveConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ConnectionKeepAliveConfig>::Convert(*this);
  }


  ConnectionKeepAliveConfig();

  ConnectionKeepAliveConfig(
      int32_t idle_timeout_in_seconds,
      int32_t ping_interval_in_seconds,
      bool enable_connection_keep_alive,
      const ::blink::String& quic_connection_options);


  ~ConnectionKeepAliveConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ConnectionKeepAliveConfigPtr>
  ConnectionKeepAliveConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ConnectionKeepAliveConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ConnectionKeepAliveConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ConnectionKeepAliveConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConnectionKeepAliveConfig::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConnectionKeepAliveConfig::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ConnectionKeepAliveConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ConnectionKeepAliveConfig_UnserializedMessageContext<
            UserType, ConnectionKeepAliveConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ConnectionKeepAliveConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ConnectionKeepAliveConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ConnectionKeepAliveConfig_UnserializedMessageContext<
            UserType, ConnectionKeepAliveConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ConnectionKeepAliveConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t idle_timeout_in_seconds;
  
  int32_t ping_interval_in_seconds;
  
  bool enable_connection_keep_alive;
  
  ::blink::String quic_connection_options;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ConnectionKeepAliveConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ConnectionKeepAliveConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ConnectionKeepAliveConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ConnectionKeepAliveConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
ConnectionKeepAliveConfigPtr ConnectionKeepAliveConfig::Clone() const {
  return New(
      mojo::Clone(idle_timeout_in_seconds),
      mojo::Clone(ping_interval_in_seconds),
      mojo::Clone(enable_connection_keep_alive),
      mojo::Clone(quic_connection_options)
  );
}

template <typename T, ConnectionKeepAliveConfig::EnableIfSame<T>*>
bool ConnectionKeepAliveConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->idle_timeout_in_seconds, other_struct.idle_timeout_in_seconds))
    return false;
  if (!mojo::Equals(this->ping_interval_in_seconds, other_struct.ping_interval_in_seconds))
    return false;
  if (!mojo::Equals(this->enable_connection_keep_alive, other_struct.enable_connection_keep_alive))
    return false;
  if (!mojo::Equals(this->quic_connection_options, other_struct.quic_connection_options))
    return false;
  return true;
}

template <typename T, ConnectionKeepAliveConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.idle_timeout_in_seconds < rhs.idle_timeout_in_seconds)
    return true;
  if (rhs.idle_timeout_in_seconds < lhs.idle_timeout_in_seconds)
    return false;
  if (lhs.ping_interval_in_seconds < rhs.ping_interval_in_seconds)
    return true;
  if (rhs.ping_interval_in_seconds < lhs.ping_interval_in_seconds)
    return false;
  if (lhs.enable_connection_keep_alive < rhs.enable_connection_keep_alive)
    return true;
  if (rhs.enable_connection_keep_alive < lhs.enable_connection_keep_alive)
    return false;
  if (lhs.quic_connection_options < rhs.quic_connection_options)
    return true;
  if (rhs.quic_connection_options < lhs.quic_connection_options)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::ConnectionKeepAliveConfig::DataView,
                                         ::network::mojom::blink::ConnectionKeepAliveConfigPtr> {
  static bool IsNull(const ::network::mojom::blink::ConnectionKeepAliveConfigPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ConnectionKeepAliveConfigPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::ConnectionKeepAliveConfig::idle_timeout_in_seconds) idle_timeout_in_seconds(
      const ::network::mojom::blink::ConnectionKeepAliveConfigPtr& input) {
    return input->idle_timeout_in_seconds;
  }

  static decltype(::network::mojom::blink::ConnectionKeepAliveConfig::ping_interval_in_seconds) ping_interval_in_seconds(
      const ::network::mojom::blink::ConnectionKeepAliveConfigPtr& input) {
    return input->ping_interval_in_seconds;
  }

  static decltype(::network::mojom::blink::ConnectionKeepAliveConfig::enable_connection_keep_alive) enable_connection_keep_alive(
      const ::network::mojom::blink::ConnectionKeepAliveConfigPtr& input) {
    return input->enable_connection_keep_alive;
  }

  static const decltype(::network::mojom::blink::ConnectionKeepAliveConfig::quic_connection_options)& quic_connection_options(
      const ::network::mojom::blink::ConnectionKeepAliveConfigPtr& input) {
    return input->quic_connection_options;
  }

  static bool Read(::network::mojom::blink::ConnectionKeepAliveConfig::DataView input, ::network::mojom::blink::ConnectionKeepAliveConfigPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_CHANGE_OBSERVER_CLIENT_MOJOM_BLINK_H_