// services/network/public/mojom/ct_log_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/ct_log_info.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/ct_log_info.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* CTLogInfo_LogTypeToStringHelper(CTLogInfo_LogType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CTLogInfo_LogType::kUnspecified:
      return "kUnspecified";
    case CTLogInfo_LogType::kRFC6962:
      return "kRFC6962";
    case CTLogInfo_LogType::kStaticCTAPI:
      return "kStaticCTAPI";
    default:
      return nullptr;
  }
}

std::string CTLogInfo_LogTypeToString(CTLogInfo_LogType value) {
  const char *str = CTLogInfo_LogTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CTLogInfo_LogType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CTLogInfo_LogType value) {
  return os << CTLogInfo_LogTypeToString(value);
}

namespace internal {


// static
bool PreviousOperatorEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PreviousOperatorEntry_Data* object =
      static_cast<const PreviousOperatorEntry_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->end_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->end_time, validation_context))
    return false;

  return true;
}

PreviousOperatorEntry_Data::PreviousOperatorEntry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CTLogInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CTLogInfo_Data* object =
      static_cast<const CTLogInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->public_key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->public_key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->disqualified_at, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mmd, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mmd, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->current_operator, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& current_operator_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->current_operator, validation_context,
                                         &current_operator_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->previous_operators, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& previous_operators_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->previous_operators, validation_context,
                                         &previous_operators_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::CTLogInfo_LogType_Data
        ::Validate(object->log_type, validation_context))
    return false;

  return true;
}

CTLogInfo_Data::CTLogInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CTLogInfo_LogType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CTLogInfo_LogType value) {
  return std::move(context).WriteString(::network::mojom::CTLogInfo_LogTypeToString(value));
}

} // namespace perfetto