// services/network/public/mojom/device_bound_sessions.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/device_bound_sessions.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "services/network/public/mojom/clear_data_filter.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/device_bound_sessions.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::DeviceBoundSessionAccessType>
    : public mojo::internal::EnumHashImpl<::network::mojom::DeviceBoundSessionAccessType> {};

template <>
struct hash<::network::mojom::DeviceBoundSessionUsage>
    : public mojo::internal::EnumHashImpl<::network::mojom::DeviceBoundSessionUsage> {};

template <>
struct hash<::network::mojom::DeviceBoundSessionDeletionReason>
    : public mojo::internal::EnumHashImpl<::network::mojom::DeviceBoundSessionDeletionReason> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionAccessType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::DeviceBoundSessionAccessType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::DeviceBoundSessionAccessType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionUsage, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::DeviceBoundSessionUsage, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::DeviceBoundSessionUsage>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionDeletionReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::DeviceBoundSessionDeletionReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::DeviceBoundSessionDeletionReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DeviceBoundSessionKeyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DeviceBoundSessionKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::site(input)) in_site = Traits::site(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->site)::BaseType> site_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView>(
      in_site,
      site_fragment);

    fragment->site.Set(
        site_fragment.is_null() ? nullptr : site_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->site.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site in DeviceBoundSessionKey struct");

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in DeviceBoundSessionKey struct");
  }

  static bool Deserialize(::network::mojom::internal::DeviceBoundSessionKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DeviceBoundSessionKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionAccessDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DeviceBoundSessionAccessDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DeviceBoundSessionAccess_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::DeviceBoundSessionAccessType>(
      Traits::access_type(input),
      &fragment->access_type);

    decltype(Traits::session_key(input)) in_session_key = Traits::session_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session_key)::BaseType> session_key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::DeviceBoundSessionKeyDataView>(
      in_session_key,
      session_key_fragment);

    fragment->session_key.Set(
        session_key_fragment.is_null() ? nullptr : session_key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->session_key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_key in DeviceBoundSessionAccess struct");

    decltype(Traits::cookies(input)) in_cookies = Traits::cookies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookies)::BaseType>
        cookies_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& cookies_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_cookies,
      cookies_fragment,
      &cookies_validate_params);

    fragment->cookies.Set(
        cookies_fragment.is_null() ? nullptr : cookies_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cookies.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookies in DeviceBoundSessionAccess struct");
  }

  static bool Deserialize(::network::mojom::internal::DeviceBoundSessionAccess_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DeviceBoundSessionAccessDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void DeviceBoundSessionKeyDataView::GetSiteDataView(
    ::network::mojom::SchemefulSiteDataView* output) {
  auto pointer = data_->site.Get();
  *output = ::network::mojom::SchemefulSiteDataView(pointer, message_);
}
inline void DeviceBoundSessionKeyDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DeviceBoundSessionAccessDataView::GetSessionKeyDataView(
    DeviceBoundSessionKeyDataView* output) {
  auto pointer = data_->session_key.Get();
  *output = DeviceBoundSessionKeyDataView(pointer, message_);
}
inline void DeviceBoundSessionAccessDataView::GetCookiesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->cookies.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::DeviceBoundSessionAccessType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::DeviceBoundSessionAccessType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::DeviceBoundSessionUsage> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::DeviceBoundSessionUsage value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::DeviceBoundSessionDeletionReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::DeviceBoundSessionDeletionReason value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_SHARED_H_