// services/network/public/mojom/device_bound_sessions.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/device_bound_sessions.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/device_bound_sessions.mojom-params-data.h"
#include "services/network/public/mojom/device_bound_sessions.mojom-shared-message-ids.h"

#include "services/network/public/mojom/device_bound_sessions.mojom-import-headers.h"
#include "services/network/public/mojom/device_bound_sessions.mojom-test-utils.h"


namespace network::mojom {
DeviceBoundSessionKey::DeviceBoundSessionKey()
    : site(),
      id() {}

DeviceBoundSessionKey::DeviceBoundSessionKey(
    const ::net::SchemefulSite& site_in,
    const std::string& id_in)
    : site(std::move(site_in)),
      id(std::move(id_in)) {}

DeviceBoundSessionKey::~DeviceBoundSessionKey() = default;

void DeviceBoundSessionKey::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site"), this->site,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::SchemefulSite&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DeviceBoundSessionKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DeviceBoundSessionAccess::DeviceBoundSessionAccess()
    : access_type(),
      session_key(),
      cookies() {}

DeviceBoundSessionAccess::DeviceBoundSessionAccess(
    DeviceBoundSessionAccessType access_type_in,
    const ::net::device_bound_sessions::SessionKey& session_key_in,
    std::vector<std::string> cookies_in)
    : access_type(std::move(access_type_in)),
      session_key(std::move(session_key_in)),
      cookies(std::move(cookies_in)) {}

DeviceBoundSessionAccess::~DeviceBoundSessionAccess() = default;

void DeviceBoundSessionAccess::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "access_type"), this->access_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DeviceBoundSessionAccessType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_key"), this->session_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::device_bound_sessions::SessionKey&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookies"), this->cookies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DeviceBoundSessionAccess::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

DeviceBoundSessionManager::IPCStableHashFunction DeviceBoundSessionManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DeviceBoundSessionManager>(message.name())) {
    case messages::DeviceBoundSessionManager::kGetAllSessions: {
      return &DeviceBoundSessionManager::GetAllSessions_Sym::IPCStableHash;
    }
    case messages::DeviceBoundSessionManager::kDeleteSession: {
      return &DeviceBoundSessionManager::DeleteSession_Sym::IPCStableHash;
    }
    case messages::DeviceBoundSessionManager::kDeleteAllSessions: {
      return &DeviceBoundSessionManager::DeleteAllSessions_Sym::IPCStableHash;
    }
    case messages::DeviceBoundSessionManager::kAddObserver: {
      return &DeviceBoundSessionManager::AddObserver_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DeviceBoundSessionManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DeviceBoundSessionManager>(message.name())) {
      case messages::DeviceBoundSessionManager::kGetAllSessions:
            return "Receive network::mojom::DeviceBoundSessionManager::GetAllSessions";
      case messages::DeviceBoundSessionManager::kDeleteSession:
            return "Receive network::mojom::DeviceBoundSessionManager::DeleteSession";
      case messages::DeviceBoundSessionManager::kDeleteAllSessions:
            return "Receive network::mojom::DeviceBoundSessionManager::DeleteAllSessions";
      case messages::DeviceBoundSessionManager::kAddObserver:
            return "Receive network::mojom::DeviceBoundSessionManager::AddObserver";
    }
  } else {
    switch (static_cast<messages::DeviceBoundSessionManager>(message.name())) {
      case messages::DeviceBoundSessionManager::kGetAllSessions:
            return "Receive reply network::mojom::DeviceBoundSessionManager::GetAllSessions";
      case messages::DeviceBoundSessionManager::kDeleteSession:
            return "Receive reply network::mojom::DeviceBoundSessionManager::DeleteSession";
      case messages::DeviceBoundSessionManager::kDeleteAllSessions:
            return "Receive reply network::mojom::DeviceBoundSessionManager::DeleteAllSessions";
      case messages::DeviceBoundSessionManager::kAddObserver:
            return "Receive reply network::mojom::DeviceBoundSessionManager::AddObserver";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DeviceBoundSessionManager::GetAllSessions_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3d7d9505;  // IPCStableHash for network::mojom::DeviceBoundSessionManager::GetAllSessions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceBoundSessionManager::DeleteSession_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x60cb2fca;  // IPCStableHash for network::mojom::DeviceBoundSessionManager::DeleteSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceBoundSessionManager::DeleteAllSessions_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd3a61cf4;  // IPCStableHash for network::mojom::DeviceBoundSessionManager::DeleteAllSessions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceBoundSessionManager::AddObserver_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3896b2b9;  // IPCStableHash for network::mojom::DeviceBoundSessionManager::AddObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class DeviceBoundSessionManager_GetAllSessions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DeviceBoundSessionManager_GetAllSessions_ForwardToCallback(
      DeviceBoundSessionManager::GetAllSessionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  DeviceBoundSessionManager_GetAllSessions_ForwardToCallback(const DeviceBoundSessionManager_GetAllSessions_ForwardToCallback&) = delete;
  DeviceBoundSessionManager_GetAllSessions_ForwardToCallback& operator=(const DeviceBoundSessionManager_GetAllSessions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DeviceBoundSessionManager::GetAllSessionsCallback callback_;
};

class DeviceBoundSessionManager_DeleteAllSessions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DeviceBoundSessionManager_DeleteAllSessions_ForwardToCallback(
      DeviceBoundSessionManager::DeleteAllSessionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  DeviceBoundSessionManager_DeleteAllSessions_ForwardToCallback(const DeviceBoundSessionManager_DeleteAllSessions_ForwardToCallback&) = delete;
  DeviceBoundSessionManager_DeleteAllSessions_ForwardToCallback& operator=(const DeviceBoundSessionManager_DeleteAllSessions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DeviceBoundSessionManager::DeleteAllSessionsCallback callback_;
};

DeviceBoundSessionManagerProxy::DeviceBoundSessionManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DeviceBoundSessionManagerProxy::GetAllSessions(
    GetAllSessionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::DeviceBoundSessionManager::GetAllSessions");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceBoundSessionManager::kGetAllSessions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DeviceBoundSessionManager_GetAllSessions_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceBoundSessionManager::Name_);
  message.set_method_name("GetAllSessions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DeviceBoundSessionManager_GetAllSessions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DeviceBoundSessionManagerProxy::DeleteSession(
    ::net::device_bound_sessions::DeletionReason in_reason, const ::net::device_bound_sessions::SessionKey& in_session) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DeviceBoundSessionManager::DeleteSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::net::device_bound_sessions::DeletionReason>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session,
                        "<value of type const ::net::device_bound_sessions::SessionKey&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceBoundSessionManager::kDeleteSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DeviceBoundSessionManager_DeleteSession_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::DeviceBoundSessionDeletionReason>(
    in_reason,
    &params->reason);
  mojo::internal::MessageFragment<
      typename decltype(params->session)::BaseType> session_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::DeviceBoundSessionKeyDataView>(
    in_session,
    session_fragment);

  params->session.Set(
      session_fragment.is_null() ? nullptr : session_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session in DeviceBoundSessionManager.DeleteSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceBoundSessionManager::Name_);
  message.set_method_name("DeleteSession");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceBoundSessionManagerProxy::DeleteAllSessions(
    ::net::device_bound_sessions::DeletionReason in_reason, std::optional<::base::Time> in_created_after_time, std::optional<::base::Time> in_created_before_time, ::network::mojom::ClearDataFilterPtr in_filter, DeleteAllSessionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DeviceBoundSessionManager::DeleteAllSessions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::net::device_bound_sessions::DeletionReason>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("created_after_time"), in_created_after_time,
                        "<value of type std::optional<::base::Time>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("created_before_time"), in_created_before_time,
                        "<value of type std::optional<::base::Time>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::network::mojom::ClearDataFilterPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceBoundSessionManager::kDeleteAllSessions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DeviceBoundSessionManager_DeleteAllSessions_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::DeviceBoundSessionDeletionReason>(
    in_reason,
    &params->reason);
  mojo::internal::MessageFragment<
      typename decltype(params->created_after_time)::BaseType> created_after_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_created_after_time,
    created_after_time_fragment);

  params->created_after_time.Set(
      created_after_time_fragment.is_null() ? nullptr : created_after_time_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->created_before_time)::BaseType> created_before_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_created_before_time,
    created_before_time_fragment);

  params->created_before_time.Set(
      created_before_time_fragment.is_null() ? nullptr : created_before_time_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ClearDataFilterDataView>(
    in_filter,
    filter_fragment);

  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceBoundSessionManager::Name_);
  message.set_method_name("DeleteAllSessions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DeviceBoundSessionManager_DeleteAllSessions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DeviceBoundSessionManagerProxy::AddObserver(
    const ::GURL& in_url, ::mojo::PendingRemote<DeviceBoundSessionAccessObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DeviceBoundSessionManager::AddObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<DeviceBoundSessionAccessObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceBoundSessionManager::kAddObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DeviceBoundSessionManager_AddObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in DeviceBoundSessionManager.AddObserver request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DeviceBoundSessionAccessObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in DeviceBoundSessionManager.AddObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceBoundSessionManager::Name_);
  message.set_method_name("AddObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class DeviceBoundSessionManager_GetAllSessions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DeviceBoundSessionManager::GetAllSessionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DeviceBoundSessionManager_GetAllSessions_ProxyToResponder> proxy(
        new DeviceBoundSessionManager_GetAllSessions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DeviceBoundSessionManager_GetAllSessions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DeviceBoundSessionManager_GetAllSessions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DeviceBoundSessionManager_GetAllSessions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DeviceBoundSessionManager::GetAllSessionsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::net::device_bound_sessions::SessionKey>& in_sessions);
};

bool DeviceBoundSessionManager_GetAllSessions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DeviceBoundSessionManager_GetAllSessions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DeviceBoundSessionManager_GetAllSessions_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DeviceBoundSessionManager.0
  bool success = true;
  std::vector<::net::device_bound_sessions::SessionKey> p_sessions{};
  DeviceBoundSessionManager_GetAllSessions_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSessions(&p_sessions))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DeviceBoundSessionManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_sessions));
  }
  return true;
}

void DeviceBoundSessionManager_GetAllSessions_ProxyToResponder::Run(
    const std::vector<::net::device_bound_sessions::SessionKey>& in_sessions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::DeviceBoundSessionManager::GetAllSessions", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sessions"), in_sessions,
                        "<value of type const std::vector<::net::device_bound_sessions::SessionKey>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceBoundSessionManager::kGetAllSessions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DeviceBoundSessionManager_GetAllSessions_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sessions)::BaseType>
      sessions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& sessions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::DeviceBoundSessionKeyDataView>>(
    in_sessions,
    sessions_fragment,
    &sessions_validate_params);

  params->sessions.Set(
      sessions_fragment.is_null() ? nullptr : sessions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sessions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sessions in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceBoundSessionManager::Name_);
  message.set_method_name("GetAllSessions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class DeviceBoundSessionManager_DeleteAllSessions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DeviceBoundSessionManager::DeleteAllSessionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DeviceBoundSessionManager_DeleteAllSessions_ProxyToResponder> proxy(
        new DeviceBoundSessionManager_DeleteAllSessions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DeviceBoundSessionManager_DeleteAllSessions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DeviceBoundSessionManager_DeleteAllSessions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DeviceBoundSessionManager_DeleteAllSessions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DeviceBoundSessionManager::DeleteAllSessionsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool DeviceBoundSessionManager_DeleteAllSessions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DeviceBoundSessionManager_DeleteAllSessions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DeviceBoundSessionManager_DeleteAllSessions_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DeviceBoundSessionManager.2
  bool success = true;
  DeviceBoundSessionManager_DeleteAllSessions_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DeviceBoundSessionManager::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void DeviceBoundSessionManager_DeleteAllSessions_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::DeviceBoundSessionManager::DeleteAllSessions");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceBoundSessionManager::kDeleteAllSessions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DeviceBoundSessionManager_DeleteAllSessions_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceBoundSessionManager::Name_);
  message.set_method_name("DeleteAllSessions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DeviceBoundSessionManagerStubDispatch::Accept(
    DeviceBoundSessionManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DeviceBoundSessionManager>(message->header()->name)) {
    case messages::DeviceBoundSessionManager::kGetAllSessions: {
      break;
    }
    case messages::DeviceBoundSessionManager::kDeleteSession: {
      DCHECK(message->is_serialized());
      internal::DeviceBoundSessionManager_DeleteSession_Params_Data* params =
          reinterpret_cast<internal::DeviceBoundSessionManager_DeleteSession_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DeviceBoundSessionManager.1
      bool success = true;
      ::net::device_bound_sessions::DeletionReason p_reason{};
      ::net::device_bound_sessions::SessionKey p_session{};
      DeviceBoundSessionManager_DeleteSession_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (success && !input_data_view.ReadSession(&p_session))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceBoundSessionManager::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteSession(        
        std::move(p_reason), 
        std::move(p_session));
      return true;
    }
    case messages::DeviceBoundSessionManager::kDeleteAllSessions: {
      break;
    }
    case messages::DeviceBoundSessionManager::kAddObserver: {
      DCHECK(message->is_serialized());
      internal::DeviceBoundSessionManager_AddObserver_Params_Data* params =
          reinterpret_cast<internal::DeviceBoundSessionManager_AddObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DeviceBoundSessionManager.3
      bool success = true;
      ::GURL p_url{};
      ::mojo::PendingRemote<DeviceBoundSessionAccessObserver> p_observer{};
      DeviceBoundSessionManager_AddObserver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceBoundSessionManager::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(        
        std::move(p_url), 
        std::move(p_observer));
      return true;
    }
  }
  return false;
}

// static
bool DeviceBoundSessionManagerStubDispatch::AcceptWithResponder(
    DeviceBoundSessionManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DeviceBoundSessionManager>(message->header()->name)) {
    case messages::DeviceBoundSessionManager::kGetAllSessions: {
      internal::DeviceBoundSessionManager_GetAllSessions_Params_Data* params =
          reinterpret_cast<
              internal::DeviceBoundSessionManager_GetAllSessions_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DeviceBoundSessionManager.0
      bool success = true;
      DeviceBoundSessionManager_GetAllSessions_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceBoundSessionManager::Name_, 0, false);
        return false;
      }
      auto callback =
          DeviceBoundSessionManager_GetAllSessions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllSessions(std::move(callback));
      return true;
    }
    case messages::DeviceBoundSessionManager::kDeleteSession: {
      break;
    }
    case messages::DeviceBoundSessionManager::kDeleteAllSessions: {
      internal::DeviceBoundSessionManager_DeleteAllSessions_Params_Data* params =
          reinterpret_cast<
              internal::DeviceBoundSessionManager_DeleteAllSessions_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DeviceBoundSessionManager.2
      bool success = true;
      ::net::device_bound_sessions::DeletionReason p_reason{};
      std::optional<::base::Time> p_created_after_time{};
      std::optional<::base::Time> p_created_before_time{};
      ::network::mojom::ClearDataFilterPtr p_filter{};
      DeviceBoundSessionManager_DeleteAllSessions_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (success && !input_data_view.ReadCreatedAfterTime(&p_created_after_time))
        success = false;
      if (success && !input_data_view.ReadCreatedBeforeTime(&p_created_before_time))
        success = false;
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceBoundSessionManager::Name_, 2, false);
        return false;
      }
      auto callback =
          DeviceBoundSessionManager_DeleteAllSessions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteAllSessions(        
        std::move(p_reason), 
        std::move(p_created_after_time), 
        std::move(p_created_before_time), 
        std::move(p_filter), std::move(callback));
      return true;
    }
    case messages::DeviceBoundSessionManager::kAddObserver: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDeviceBoundSessionManagerValidationInfo[] = {
    {base::to_underlying(messages::DeviceBoundSessionManager::kGetAllSessions),
     { &internal::DeviceBoundSessionManager_GetAllSessions_Params_Data::Validate,
      &internal::DeviceBoundSessionManager_GetAllSessions_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::DeviceBoundSessionManager::kDeleteSession),
     { &internal::DeviceBoundSessionManager_DeleteSession_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceBoundSessionManager::kDeleteAllSessions),
     { &internal::DeviceBoundSessionManager_DeleteAllSessions_Params_Data::Validate,
      &internal::DeviceBoundSessionManager_DeleteAllSessions_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::DeviceBoundSessionManager::kAddObserver),
     { &internal::DeviceBoundSessionManager_AddObserver_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DeviceBoundSessionManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::DeviceBoundSessionManager::Name_,
    kDeviceBoundSessionManagerValidationInfo);
}

bool DeviceBoundSessionManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::network::mojom::DeviceBoundSessionManager::Name_,
    kDeviceBoundSessionManagerValidationInfo);

}
// The declaration includes the definition on other builds.

DeviceBoundSessionAccessObserver::IPCStableHashFunction DeviceBoundSessionAccessObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DeviceBoundSessionAccessObserver>(message.name())) {
    case messages::DeviceBoundSessionAccessObserver::kOnDeviceBoundSessionAccessed: {
      return &DeviceBoundSessionAccessObserver::OnDeviceBoundSessionAccessed_Sym::IPCStableHash;
    }
    case messages::DeviceBoundSessionAccessObserver::kClone: {
      return &DeviceBoundSessionAccessObserver::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DeviceBoundSessionAccessObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DeviceBoundSessionAccessObserver>(message.name())) {
      case messages::DeviceBoundSessionAccessObserver::kOnDeviceBoundSessionAccessed:
            return "Receive network::mojom::DeviceBoundSessionAccessObserver::OnDeviceBoundSessionAccessed";
      case messages::DeviceBoundSessionAccessObserver::kClone:
            return "Receive network::mojom::DeviceBoundSessionAccessObserver::Clone";
    }
  } else {
    switch (static_cast<messages::DeviceBoundSessionAccessObserver>(message.name())) {
      case messages::DeviceBoundSessionAccessObserver::kOnDeviceBoundSessionAccessed:
            return "Receive reply network::mojom::DeviceBoundSessionAccessObserver::OnDeviceBoundSessionAccessed";
      case messages::DeviceBoundSessionAccessObserver::kClone:
            return "Receive reply network::mojom::DeviceBoundSessionAccessObserver::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DeviceBoundSessionAccessObserver::OnDeviceBoundSessionAccessed_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xffb37d73;  // IPCStableHash for network::mojom::DeviceBoundSessionAccessObserver::OnDeviceBoundSessionAccessed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceBoundSessionAccessObserver::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x84ad5d4a;  // IPCStableHash for network::mojom::DeviceBoundSessionAccessObserver::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DeviceBoundSessionAccessObserverProxy::DeviceBoundSessionAccessObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DeviceBoundSessionAccessObserverProxy::OnDeviceBoundSessionAccessed(
    const ::net::device_bound_sessions::SessionAccess& in_access) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DeviceBoundSessionAccessObserver::OnDeviceBoundSessionAccessed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("access"), in_access,
                        "<value of type const ::net::device_bound_sessions::SessionAccess&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceBoundSessionAccessObserver::kOnDeviceBoundSessionAccessed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->access)::BaseType> access_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::DeviceBoundSessionAccessDataView>(
    in_access,
    access_fragment);

  params->access.Set(
      access_fragment.is_null() ? nullptr : access_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->access.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null access in DeviceBoundSessionAccessObserver.OnDeviceBoundSessionAccessed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceBoundSessionAccessObserver::Name_);
  message.set_method_name("OnDeviceBoundSessionAccessed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceBoundSessionAccessObserverProxy::Clone(
    ::mojo::PendingReceiver<DeviceBoundSessionAccessObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::DeviceBoundSessionAccessObserver::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingReceiver<DeviceBoundSessionAccessObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceBoundSessionAccessObserver::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::DeviceBoundSessionAccessObserver_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::DeviceBoundSessionAccessObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in DeviceBoundSessionAccessObserver.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceBoundSessionAccessObserver::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DeviceBoundSessionAccessObserverStubDispatch::Accept(
    DeviceBoundSessionAccessObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DeviceBoundSessionAccessObserver>(message->header()->name)) {
    case messages::DeviceBoundSessionAccessObserver::kOnDeviceBoundSessionAccessed: {
      DCHECK(message->is_serialized());
      internal::DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params_Data* params =
          reinterpret_cast<internal::DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DeviceBoundSessionAccessObserver.0
      bool success = true;
      ::net::device_bound_sessions::SessionAccess p_access{};
      DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAccess(&p_access))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceBoundSessionAccessObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceBoundSessionAccessed(        
        std::move(p_access));
      return true;
    }
    case messages::DeviceBoundSessionAccessObserver::kClone: {
      DCHECK(message->is_serialized());
      internal::DeviceBoundSessionAccessObserver_Clone_Params_Data* params =
          reinterpret_cast<internal::DeviceBoundSessionAccessObserver_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DeviceBoundSessionAccessObserver.1
      bool success = true;
      ::mojo::PendingReceiver<DeviceBoundSessionAccessObserver> p_observer{};
      DeviceBoundSessionAccessObserver_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceBoundSessionAccessObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_observer));
      return true;
    }
  }
  return false;
}

// static
bool DeviceBoundSessionAccessObserverStubDispatch::AcceptWithResponder(
    DeviceBoundSessionAccessObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DeviceBoundSessionAccessObserver>(message->header()->name)) {
    case messages::DeviceBoundSessionAccessObserver::kOnDeviceBoundSessionAccessed: {
      break;
    }
    case messages::DeviceBoundSessionAccessObserver::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDeviceBoundSessionAccessObserverValidationInfo[] = {
    {base::to_underlying(messages::DeviceBoundSessionAccessObserver::kOnDeviceBoundSessionAccessed),
     { &internal::DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceBoundSessionAccessObserver::kClone),
     { &internal::DeviceBoundSessionAccessObserver_Clone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DeviceBoundSessionAccessObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::DeviceBoundSessionAccessObserver::Name_,
    kDeviceBoundSessionAccessObserverValidationInfo);
}



}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::DeviceBoundSessionKey::DataView, ::network::mojom::DeviceBoundSessionKeyPtr>::Read(
    ::network::mojom::DeviceBoundSessionKey::DataView input,
    ::network::mojom::DeviceBoundSessionKeyPtr* output) {
  bool success = true;
  ::network::mojom::DeviceBoundSessionKeyPtr result(::network::mojom::DeviceBoundSessionKey::New());
  
      if (success && !input.ReadSite(&result->site))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::DeviceBoundSessionAccess::DataView, ::network::mojom::DeviceBoundSessionAccessPtr>::Read(
    ::network::mojom::DeviceBoundSessionAccess::DataView input,
    ::network::mojom::DeviceBoundSessionAccessPtr* output) {
  bool success = true;
  ::network::mojom::DeviceBoundSessionAccessPtr result(::network::mojom::DeviceBoundSessionAccess::New());
  
      if (success && !input.ReadAccessType(&result->access_type))
        success = false;
      if (success && !input.ReadSessionKey(&result->session_key))
        success = false;
      if (success && !input.ReadCookies(&result->cookies))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void DeviceBoundSessionManagerInterceptorForTesting::GetAllSessions(GetAllSessionsCallback callback) {
  GetForwardingInterface()->GetAllSessions(std::move(callback));
}
void DeviceBoundSessionManagerInterceptorForTesting::DeleteSession(::net::device_bound_sessions::DeletionReason reason, const ::net::device_bound_sessions::SessionKey& session) {
  GetForwardingInterface()->DeleteSession(
    std::move(reason)
    , 
    std::move(session)
    );
}
void DeviceBoundSessionManagerInterceptorForTesting::DeleteAllSessions(::net::device_bound_sessions::DeletionReason reason, std::optional<::base::Time> created_after_time, std::optional<::base::Time> created_before_time, ::network::mojom::ClearDataFilterPtr filter, DeleteAllSessionsCallback callback) {
  GetForwardingInterface()->DeleteAllSessions(
    std::move(reason)
    , 
    std::move(created_after_time)
    , 
    std::move(created_before_time)
    , 
    std::move(filter)
    , std::move(callback));
}
void DeviceBoundSessionManagerInterceptorForTesting::AddObserver(const ::GURL& url, ::mojo::PendingRemote<DeviceBoundSessionAccessObserver> observer) {
  GetForwardingInterface()->AddObserver(
    std::move(url)
    , 
    std::move(observer)
    );
}
DeviceBoundSessionManagerAsyncWaiter::DeviceBoundSessionManagerAsyncWaiter(
    DeviceBoundSessionManager* proxy) : proxy_(proxy) {}

DeviceBoundSessionManagerAsyncWaiter::~DeviceBoundSessionManagerAsyncWaiter() = default;


void DeviceBoundSessionManagerAsyncWaiter::GetAllSessions(
    std::vector<::net::device_bound_sessions::SessionKey>* out_sessions) {
  base::RunLoop loop;
  proxy_->GetAllSessions(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::net::device_bound_sessions::SessionKey>* out_sessions
,
             const std::vector<::net::device_bound_sessions::SessionKey>& sessions) {*out_sessions = std::move(sessions);
            loop->Quit();
          },
          &loop,
          out_sessions));
  loop.Run();
}

std::vector<::net::device_bound_sessions::SessionKey> DeviceBoundSessionManagerAsyncWaiter::GetAllSessions(
    ) {
  std::vector<::net::device_bound_sessions::SessionKey> async_wait_result;
  GetAllSessions(&async_wait_result);
  return async_wait_result;
}

void DeviceBoundSessionManagerAsyncWaiter::DeleteAllSessions(
    ::net::device_bound_sessions::DeletionReason reason, std::optional<::base::Time> created_after_time, std::optional<::base::Time> created_before_time, ::network::mojom::ClearDataFilterPtr filter) {
  base::RunLoop loop;
  proxy_->DeleteAllSessions(
      std::move(reason),
      std::move(created_after_time),
      std::move(created_before_time),
      std::move(filter),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void DeviceBoundSessionAccessObserverInterceptorForTesting::OnDeviceBoundSessionAccessed(const ::net::device_bound_sessions::SessionAccess& access) {
  GetForwardingInterface()->OnDeviceBoundSessionAccessed(
    std::move(access)
    );
}
void DeviceBoundSessionAccessObserverInterceptorForTesting::Clone(::mojo::PendingReceiver<DeviceBoundSessionAccessObserver> observer) {
  GetForwardingInterface()->Clone(
    std::move(observer)
    );
}
DeviceBoundSessionAccessObserverAsyncWaiter::DeviceBoundSessionAccessObserverAsyncWaiter(
    DeviceBoundSessionAccessObserver* proxy) : proxy_(proxy) {}

DeviceBoundSessionAccessObserverAsyncWaiter::~DeviceBoundSessionAccessObserverAsyncWaiter() = default;







}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif