// services/network/public/mojom/first_party_sets.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_FIRST_PARTY_SETS_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_FIRST_PARTY_SETS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/first_party_sets.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/first_party_sets.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/first_party_sets.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/version.mojom-blink.h"
#include "services/network/public/mojom/schemeful_site.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {













class BLINK_PLATFORM_EXPORT FirstPartySetEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FirstPartySetEntry, T>::value>;
  using DataView = FirstPartySetEntryDataView;
  using Data_ = internal::FirstPartySetEntry_Data;

  template <typename... Args>
  static FirstPartySetEntryPtr New(Args&&... args) {
    return FirstPartySetEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FirstPartySetEntryPtr From(const U& u) {
    return mojo::TypeConverter<FirstPartySetEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FirstPartySetEntry>::Convert(*this);
  }


  FirstPartySetEntry();

  FirstPartySetEntry(
      const ::blink::BlinkSchemefulSite& primary,
      SiteType site_type);


  ~FirstPartySetEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FirstPartySetEntryPtr>
  FirstPartySetEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FirstPartySetEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FirstPartySetEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FirstPartySetEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetEntry::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetEntry::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FirstPartySetEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FirstPartySetEntry_UnserializedMessageContext<
            UserType, FirstPartySetEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FirstPartySetEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FirstPartySetEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FirstPartySetEntry_UnserializedMessageContext<
            UserType, FirstPartySetEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FirstPartySetEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::BlinkSchemefulSite primary;
  
  SiteType site_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FirstPartySetEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FirstPartySetEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FirstPartySetEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FirstPartySetEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT FirstPartySetMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FirstPartySetMetadata, T>::value>;
  using DataView = FirstPartySetMetadataDataView;
  using Data_ = internal::FirstPartySetMetadata_Data;

  template <typename... Args>
  static FirstPartySetMetadataPtr New(Args&&... args) {
    return FirstPartySetMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FirstPartySetMetadataPtr From(const U& u) {
    return mojo::TypeConverter<FirstPartySetMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FirstPartySetMetadata>::Convert(*this);
  }


  FirstPartySetMetadata();

  FirstPartySetMetadata(
      FirstPartySetEntryPtr frame_entry,
      FirstPartySetEntryPtr top_frame_entry);

FirstPartySetMetadata(const FirstPartySetMetadata&) = delete;
FirstPartySetMetadata& operator=(const FirstPartySetMetadata&) = delete;

  ~FirstPartySetMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FirstPartySetMetadataPtr>
  FirstPartySetMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FirstPartySetMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FirstPartySetMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FirstPartySetMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetMetadata::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetMetadata::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FirstPartySetMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FirstPartySetMetadata_UnserializedMessageContext<
            UserType, FirstPartySetMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FirstPartySetMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FirstPartySetMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FirstPartySetMetadata_UnserializedMessageContext<
            UserType, FirstPartySetMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FirstPartySetMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  FirstPartySetEntryPtr frame_entry;
  
  FirstPartySetEntryPtr top_frame_entry;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FirstPartySetMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FirstPartySetMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FirstPartySetMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FirstPartySetMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT FirstPartySetEntryOverride {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FirstPartySetEntryOverride, T>::value>;
  using DataView = FirstPartySetEntryOverrideDataView;
  using Data_ = internal::FirstPartySetEntryOverride_Data;

  template <typename... Args>
  static FirstPartySetEntryOverridePtr New(Args&&... args) {
    return FirstPartySetEntryOverridePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FirstPartySetEntryOverridePtr From(const U& u) {
    return mojo::TypeConverter<FirstPartySetEntryOverridePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FirstPartySetEntryOverride>::Convert(*this);
  }


  FirstPartySetEntryOverride();

  explicit FirstPartySetEntryOverride(
      FirstPartySetEntryPtr entry);

FirstPartySetEntryOverride(const FirstPartySetEntryOverride&) = delete;
FirstPartySetEntryOverride& operator=(const FirstPartySetEntryOverride&) = delete;

  ~FirstPartySetEntryOverride();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FirstPartySetEntryOverridePtr>
  FirstPartySetEntryOverridePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FirstPartySetEntryOverride::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FirstPartySetEntryOverride::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FirstPartySetEntryOverride::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetEntryOverride::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetEntryOverride::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FirstPartySetEntryOverride::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FirstPartySetEntryOverride_UnserializedMessageContext<
            UserType, FirstPartySetEntryOverride::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FirstPartySetEntryOverride::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FirstPartySetEntryOverride::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FirstPartySetEntryOverride_UnserializedMessageContext<
            UserType, FirstPartySetEntryOverride::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FirstPartySetEntryOverride::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  FirstPartySetEntryPtr entry;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FirstPartySetEntryOverride::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FirstPartySetEntryOverride::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FirstPartySetEntryOverride::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FirstPartySetEntryOverride::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT FirstPartySetsContextConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FirstPartySetsContextConfig, T>::value>;
  using DataView = FirstPartySetsContextConfigDataView;
  using Data_ = internal::FirstPartySetsContextConfig_Data;

  template <typename... Args>
  static FirstPartySetsContextConfigPtr New(Args&&... args) {
    return FirstPartySetsContextConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FirstPartySetsContextConfigPtr From(const U& u) {
    return mojo::TypeConverter<FirstPartySetsContextConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FirstPartySetsContextConfig>::Convert(*this);
  }


  FirstPartySetsContextConfig();

  FirstPartySetsContextConfig(
      ::blink::HashMap<::blink::BlinkSchemefulSite, FirstPartySetEntryOverridePtr> customizations,
      const ::blink::HashMap<::blink::BlinkSchemefulSite, ::blink::BlinkSchemefulSite>& aliases);

FirstPartySetsContextConfig(const FirstPartySetsContextConfig&) = delete;
FirstPartySetsContextConfig& operator=(const FirstPartySetsContextConfig&) = delete;

  ~FirstPartySetsContextConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FirstPartySetsContextConfigPtr>
  FirstPartySetsContextConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FirstPartySetsContextConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FirstPartySetsContextConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FirstPartySetsContextConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetsContextConfig::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetsContextConfig::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FirstPartySetsContextConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FirstPartySetsContextConfig_UnserializedMessageContext<
            UserType, FirstPartySetsContextConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FirstPartySetsContextConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FirstPartySetsContextConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FirstPartySetsContextConfig_UnserializedMessageContext<
            UserType, FirstPartySetsContextConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FirstPartySetsContextConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::HashMap<::blink::BlinkSchemefulSite, FirstPartySetEntryOverridePtr> customizations;
  
  ::blink::HashMap<::blink::BlinkSchemefulSite, ::blink::BlinkSchemefulSite> aliases;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FirstPartySetsContextConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FirstPartySetsContextConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FirstPartySetsContextConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FirstPartySetsContextConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT FirstPartySetsCacheFilter {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FirstPartySetsCacheFilter, T>::value>;
  using DataView = FirstPartySetsCacheFilterDataView;
  using Data_ = internal::FirstPartySetsCacheFilter_Data;

  template <typename... Args>
  static FirstPartySetsCacheFilterPtr New(Args&&... args) {
    return FirstPartySetsCacheFilterPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FirstPartySetsCacheFilterPtr From(const U& u) {
    return mojo::TypeConverter<FirstPartySetsCacheFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FirstPartySetsCacheFilter>::Convert(*this);
  }


  FirstPartySetsCacheFilter();

  FirstPartySetsCacheFilter(
      const ::blink::HashMap<::blink::BlinkSchemefulSite, int64_t>& filter,
      int64_t browser_run_id);


  ~FirstPartySetsCacheFilter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FirstPartySetsCacheFilterPtr>
  FirstPartySetsCacheFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FirstPartySetsCacheFilter::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FirstPartySetsCacheFilter::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FirstPartySetsCacheFilter::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetsCacheFilter::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FirstPartySetsCacheFilter::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FirstPartySetsCacheFilter::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FirstPartySetsCacheFilter_UnserializedMessageContext<
            UserType, FirstPartySetsCacheFilter::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FirstPartySetsCacheFilter::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FirstPartySetsCacheFilter::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FirstPartySetsCacheFilter_UnserializedMessageContext<
            UserType, FirstPartySetsCacheFilter::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FirstPartySetsCacheFilter::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::HashMap<::blink::BlinkSchemefulSite, int64_t> filter;
  
  int64_t browser_run_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FirstPartySetsCacheFilter::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FirstPartySetsCacheFilter::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FirstPartySetsCacheFilter::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FirstPartySetsCacheFilter::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT GlobalFirstPartySets {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GlobalFirstPartySets, T>::value>;
  using DataView = GlobalFirstPartySetsDataView;
  using Data_ = internal::GlobalFirstPartySets_Data;

  template <typename... Args>
  static GlobalFirstPartySetsPtr New(Args&&... args) {
    return GlobalFirstPartySetsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GlobalFirstPartySetsPtr From(const U& u) {
    return mojo::TypeConverter<GlobalFirstPartySetsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GlobalFirstPartySets>::Convert(*this);
  }


  GlobalFirstPartySets();

  GlobalFirstPartySets(
      const ::base::Version& public_sets_version,
      ::blink::HashMap<::blink::BlinkSchemefulSite, FirstPartySetEntryPtr> sets,
      const ::blink::HashMap<::blink::BlinkSchemefulSite, ::blink::BlinkSchemefulSite>& aliases,
      FirstPartySetsContextConfigPtr manual_config);

GlobalFirstPartySets(const GlobalFirstPartySets&) = delete;
GlobalFirstPartySets& operator=(const GlobalFirstPartySets&) = delete;

  ~GlobalFirstPartySets();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GlobalFirstPartySetsPtr>
  GlobalFirstPartySetsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GlobalFirstPartySets::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GlobalFirstPartySets::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GlobalFirstPartySets::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GlobalFirstPartySets::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GlobalFirstPartySets::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GlobalFirstPartySets::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GlobalFirstPartySets_UnserializedMessageContext<
            UserType, GlobalFirstPartySets::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GlobalFirstPartySets::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GlobalFirstPartySets::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GlobalFirstPartySets_UnserializedMessageContext<
            UserType, GlobalFirstPartySets::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GlobalFirstPartySets::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Version public_sets_version;
  
  ::blink::HashMap<::blink::BlinkSchemefulSite, FirstPartySetEntryPtr> sets;
  
  ::blink::HashMap<::blink::BlinkSchemefulSite, ::blink::BlinkSchemefulSite> aliases;
  
  FirstPartySetsContextConfigPtr manual_config;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GlobalFirstPartySets::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GlobalFirstPartySets::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GlobalFirstPartySets::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GlobalFirstPartySets::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FirstPartySetEntryPtr FirstPartySetEntry::Clone() const {
  return New(
      mojo::Clone(primary),
      mojo::Clone(site_type)
  );
}

template <typename T, FirstPartySetEntry::EnableIfSame<T>*>
bool FirstPartySetEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->primary, other_struct.primary))
    return false;
  if (!mojo::Equals(this->site_type, other_struct.site_type))
    return false;
  return true;
}

template <typename T, FirstPartySetEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.primary < rhs.primary)
    return true;
  if (rhs.primary < lhs.primary)
    return false;
  if (lhs.site_type < rhs.site_type)
    return true;
  if (rhs.site_type < lhs.site_type)
    return false;
  return false;
}
template <typename StructPtrType>
FirstPartySetMetadataPtr FirstPartySetMetadata::Clone() const {
  return New(
      mojo::Clone(frame_entry),
      mojo::Clone(top_frame_entry)
  );
}

template <typename T, FirstPartySetMetadata::EnableIfSame<T>*>
bool FirstPartySetMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_entry, other_struct.frame_entry))
    return false;
  if (!mojo::Equals(this->top_frame_entry, other_struct.top_frame_entry))
    return false;
  return true;
}

template <typename T, FirstPartySetMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_entry < rhs.frame_entry)
    return true;
  if (rhs.frame_entry < lhs.frame_entry)
    return false;
  if (lhs.top_frame_entry < rhs.top_frame_entry)
    return true;
  if (rhs.top_frame_entry < lhs.top_frame_entry)
    return false;
  return false;
}
template <typename StructPtrType>
FirstPartySetEntryOverridePtr FirstPartySetEntryOverride::Clone() const {
  return New(
      mojo::Clone(entry)
  );
}

template <typename T, FirstPartySetEntryOverride::EnableIfSame<T>*>
bool FirstPartySetEntryOverride::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->entry, other_struct.entry))
    return false;
  return true;
}

template <typename T, FirstPartySetEntryOverride::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.entry < rhs.entry)
    return true;
  if (rhs.entry < lhs.entry)
    return false;
  return false;
}
template <typename StructPtrType>
FirstPartySetsContextConfigPtr FirstPartySetsContextConfig::Clone() const {
  return New(
      mojo::Clone(customizations),
      mojo::Clone(aliases)
  );
}

template <typename T, FirstPartySetsContextConfig::EnableIfSame<T>*>
bool FirstPartySetsContextConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->customizations, other_struct.customizations))
    return false;
  if (!mojo::Equals(this->aliases, other_struct.aliases))
    return false;
  return true;
}

template <typename T, FirstPartySetsContextConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.customizations < rhs.customizations)
    return true;
  if (rhs.customizations < lhs.customizations)
    return false;
  if (lhs.aliases < rhs.aliases)
    return true;
  if (rhs.aliases < lhs.aliases)
    return false;
  return false;
}
template <typename StructPtrType>
FirstPartySetsCacheFilterPtr FirstPartySetsCacheFilter::Clone() const {
  return New(
      mojo::Clone(filter),
      mojo::Clone(browser_run_id)
  );
}

template <typename T, FirstPartySetsCacheFilter::EnableIfSame<T>*>
bool FirstPartySetsCacheFilter::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->filter, other_struct.filter))
    return false;
  if (!mojo::Equals(this->browser_run_id, other_struct.browser_run_id))
    return false;
  return true;
}

template <typename T, FirstPartySetsCacheFilter::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.filter < rhs.filter)
    return true;
  if (rhs.filter < lhs.filter)
    return false;
  if (lhs.browser_run_id < rhs.browser_run_id)
    return true;
  if (rhs.browser_run_id < lhs.browser_run_id)
    return false;
  return false;
}
template <typename StructPtrType>
GlobalFirstPartySetsPtr GlobalFirstPartySets::Clone() const {
  return New(
      mojo::Clone(public_sets_version),
      mojo::Clone(sets),
      mojo::Clone(aliases),
      mojo::Clone(manual_config)
  );
}

template <typename T, GlobalFirstPartySets::EnableIfSame<T>*>
bool GlobalFirstPartySets::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->public_sets_version, other_struct.public_sets_version))
    return false;
  if (!mojo::Equals(this->sets, other_struct.sets))
    return false;
  if (!mojo::Equals(this->aliases, other_struct.aliases))
    return false;
  if (!mojo::Equals(this->manual_config, other_struct.manual_config))
    return false;
  return true;
}

template <typename T, GlobalFirstPartySets::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.public_sets_version < rhs.public_sets_version)
    return true;
  if (rhs.public_sets_version < lhs.public_sets_version)
    return false;
  if (lhs.sets < rhs.sets)
    return true;
  if (rhs.sets < lhs.sets)
    return false;
  if (lhs.aliases < rhs.aliases)
    return true;
  if (rhs.aliases < lhs.aliases)
    return false;
  if (lhs.manual_config < rhs.manual_config)
    return true;
  if (rhs.manual_config < lhs.manual_config)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::FirstPartySetEntry::DataView,
                                         ::network::mojom::blink::FirstPartySetEntryPtr> {
  static bool IsNull(const ::network::mojom::blink::FirstPartySetEntryPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::FirstPartySetEntryPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::FirstPartySetEntry::primary)& primary(
      const ::network::mojom::blink::FirstPartySetEntryPtr& input) {
    return input->primary;
  }

  static decltype(::network::mojom::blink::FirstPartySetEntry::site_type) site_type(
      const ::network::mojom::blink::FirstPartySetEntryPtr& input) {
    return input->site_type;
  }

  static bool Read(::network::mojom::blink::FirstPartySetEntry::DataView input, ::network::mojom::blink::FirstPartySetEntryPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::FirstPartySetMetadata::DataView,
                                         ::network::mojom::blink::FirstPartySetMetadataPtr> {
  static bool IsNull(const ::network::mojom::blink::FirstPartySetMetadataPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::FirstPartySetMetadataPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::FirstPartySetMetadata::frame_entry)& frame_entry(
      const ::network::mojom::blink::FirstPartySetMetadataPtr& input) {
    return input->frame_entry;
  }

  static const decltype(::network::mojom::blink::FirstPartySetMetadata::top_frame_entry)& top_frame_entry(
      const ::network::mojom::blink::FirstPartySetMetadataPtr& input) {
    return input->top_frame_entry;
  }

  static bool Read(::network::mojom::blink::FirstPartySetMetadata::DataView input, ::network::mojom::blink::FirstPartySetMetadataPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::FirstPartySetEntryOverride::DataView,
                                         ::network::mojom::blink::FirstPartySetEntryOverridePtr> {
  static bool IsNull(const ::network::mojom::blink::FirstPartySetEntryOverridePtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::FirstPartySetEntryOverridePtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::FirstPartySetEntryOverride::entry)& entry(
      const ::network::mojom::blink::FirstPartySetEntryOverridePtr& input) {
    return input->entry;
  }

  static bool Read(::network::mojom::blink::FirstPartySetEntryOverride::DataView input, ::network::mojom::blink::FirstPartySetEntryOverridePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::FirstPartySetsContextConfig::DataView,
                                         ::network::mojom::blink::FirstPartySetsContextConfigPtr> {
  static bool IsNull(const ::network::mojom::blink::FirstPartySetsContextConfigPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::FirstPartySetsContextConfigPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::FirstPartySetsContextConfig::customizations)& customizations(
      const ::network::mojom::blink::FirstPartySetsContextConfigPtr& input) {
    return input->customizations;
  }

  static const decltype(::network::mojom::blink::FirstPartySetsContextConfig::aliases)& aliases(
      const ::network::mojom::blink::FirstPartySetsContextConfigPtr& input) {
    return input->aliases;
  }

  static bool Read(::network::mojom::blink::FirstPartySetsContextConfig::DataView input, ::network::mojom::blink::FirstPartySetsContextConfigPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::FirstPartySetsCacheFilter::DataView,
                                         ::network::mojom::blink::FirstPartySetsCacheFilterPtr> {
  static bool IsNull(const ::network::mojom::blink::FirstPartySetsCacheFilterPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::FirstPartySetsCacheFilterPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::FirstPartySetsCacheFilter::filter)& filter(
      const ::network::mojom::blink::FirstPartySetsCacheFilterPtr& input) {
    return input->filter;
  }

  static decltype(::network::mojom::blink::FirstPartySetsCacheFilter::browser_run_id) browser_run_id(
      const ::network::mojom::blink::FirstPartySetsCacheFilterPtr& input) {
    return input->browser_run_id;
  }

  static bool Read(::network::mojom::blink::FirstPartySetsCacheFilter::DataView input, ::network::mojom::blink::FirstPartySetsCacheFilterPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::GlobalFirstPartySets::DataView,
                                         ::network::mojom::blink::GlobalFirstPartySetsPtr> {
  static bool IsNull(const ::network::mojom::blink::GlobalFirstPartySetsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::GlobalFirstPartySetsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::GlobalFirstPartySets::public_sets_version)& public_sets_version(
      const ::network::mojom::blink::GlobalFirstPartySetsPtr& input) {
    return input->public_sets_version;
  }

  static const decltype(::network::mojom::blink::GlobalFirstPartySets::sets)& sets(
      const ::network::mojom::blink::GlobalFirstPartySetsPtr& input) {
    return input->sets;
  }

  static const decltype(::network::mojom::blink::GlobalFirstPartySets::aliases)& aliases(
      const ::network::mojom::blink::GlobalFirstPartySetsPtr& input) {
    return input->aliases;
  }

  static const decltype(::network::mojom::blink::GlobalFirstPartySets::manual_config)& manual_config(
      const ::network::mojom::blink::GlobalFirstPartySetsPtr& input) {
    return input->manual_config;
  }

  static bool Read(::network::mojom::blink::GlobalFirstPartySets::DataView input, ::network::mojom::blink::GlobalFirstPartySetsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_FIRST_PARTY_SETS_MOJOM_BLINK_H_