// services/network/public/mojom/permissions_policy/permissions_policy.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PERMISSIONS_POLICY_PERMISSIONS_POLICY_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PERMISSIONS_POLICY_PERMISSIONS_POLICY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared-internal.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy_feature.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"


namespace network::mojom {
class OriginWithPossibleWildcardsDataView;

class ParsedPermissionsPolicyDeclarationDataView;

class PermissionsPolicyDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::OriginWithPossibleWildcardsDataView> {
  using Data = ::network::mojom::internal::OriginWithPossibleWildcards_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ParsedPermissionsPolicyDeclarationDataView> {
  using Data = ::network::mojom::internal::ParsedPermissionsPolicyDeclaration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::PermissionsPolicyDataView> {
  using Data = ::network::mojom::internal::PermissionsPolicy_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class OriginWithPossibleWildcardsDataView {
 public:
  OriginWithPossibleWildcardsDataView() = default;

  OriginWithPossibleWildcardsDataView(
      internal::OriginWithPossibleWildcards_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSchemeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScheme(UserType* output) {
    
    auto* pointer = data_->scheme.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetHostDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHost(UserType* output) {
    
    auto* pointer = data_->host.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t port() const {
    return data_->port;
  }
  bool is_host_wildcard() const {
    return data_->is_host_wildcard;
  }
  bool is_port_wildcard() const {
    return data_->is_port_wildcard;
  }
 private:
  internal::OriginWithPossibleWildcards_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ParsedPermissionsPolicyDeclarationDataView {
 public:
  ParsedPermissionsPolicyDeclarationDataView() = default;

  ParsedPermissionsPolicyDeclarationDataView(
      internal::ParsedPermissionsPolicyDeclaration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadFeature(UserType* output) const {
    auto data_value = data_->feature;
    return mojo::internal::Deserialize<::network::mojom::PermissionsPolicyFeature>(
        data_value, output);
  }
  ::network::mojom::PermissionsPolicyFeature feature() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::PermissionsPolicyFeature>(data_->feature));
  }
  inline void GetAllowedOriginsDataView(
      mojo::ArrayDataView<OriginWithPossibleWildcardsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllowedOrigins(UserType* output) {
    
    auto* pointer = data_->allowed_origins.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::OriginWithPossibleWildcardsDataView>>(
        pointer, output, message_);
  }
  inline void GetSelfIfMatchesDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelfIfMatches(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `self_if_matches` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSelfIfMatches` instead "
    "of `ReadSelfIfMatches if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->self_if_matches.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  bool matches_all_origins() const {
    return data_->matches_all_origins;
  }
  bool matches_opaque_src() const {
    return data_->matches_opaque_src;
  }
  inline void GetReportingEndpointDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportingEndpoint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `reporting_endpoint` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportingEndpoint` instead "
    "of `ReadReportingEndpoint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reporting_endpoint.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ParsedPermissionsPolicyDeclaration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PermissionsPolicyDataView {
 public:
  PermissionsPolicyDataView() = default;

  PermissionsPolicyDataView(
      internal::PermissionsPolicy_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  bool headerless() const {
    return data_->headerless;
  }
  inline void GetDeclarationsDataView(
      mojo::ArrayDataView<ParsedPermissionsPolicyDeclarationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeclarations(UserType* output) {
    
    auto* pointer = data_->declarations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
        pointer, output, message_);
  }
  inline void GetInheritedPoliciesDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInheritedPolicies(UserType* output) {
    
    auto* pointer = data_->inherited_policies.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PermissionsPolicy_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PERMISSIONS_POLICY_PERMISSIONS_POLICY_MOJOM_DATA_VIEW_H_