// services/network/public/mojom/ssl_config.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SSL_CONFIG_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SSL_CONFIG_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/ssl_config.mojom-shared-internal.h"


namespace network::mojom {
class SSLConfigDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::SSLConfigDataView> {
  using Data = ::network::mojom::internal::SSLConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class SSLVersion : int32_t {
  
  kTLS12 = 0,
  
  kTLS13 = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SSLVersion value);
inline bool IsKnownEnumValue(SSLVersion value) {
  return internal::SSLVersion_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SSLConfigClientInterfaceBase {};

using SSLConfigClientPtrDataView =
    mojo::InterfacePtrDataView<SSLConfigClientInterfaceBase>;
using SSLConfigClientRequestDataView =
    mojo::InterfaceRequestDataView<SSLConfigClientInterfaceBase>;
using SSLConfigClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SSLConfigClientInterfaceBase>;
using SSLConfigClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SSLConfigClientInterfaceBase>;


class SSLConfigDataView {
 public:
  SSLConfigDataView() = default;

  SSLConfigDataView(
      internal::SSLConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool rev_checking_enabled() const {
    return data_->rev_checking_enabled;
  }
  bool rev_checking_required_local_anchors() const {
    return data_->rev_checking_required_local_anchors;
  }
  bool sha1_local_anchors_enabled() const {
    return data_->sha1_local_anchors_enabled;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVersionMin(UserType* output) const {
    auto data_value = data_->version_min;
    return mojo::internal::Deserialize<::network::mojom::SSLVersion>(
        data_value, output);
  }
  SSLVersion version_min() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::SSLVersion>(data_->version_min));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadVersionMax(UserType* output) const {
    auto data_value = data_->version_max;
    return mojo::internal::Deserialize<::network::mojom::SSLVersion>(
        data_value, output);
  }
  SSLVersion version_max() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::SSLVersion>(data_->version_max));
  }
  inline void GetDisabledCipherSuitesDataView(
      mojo::ArrayDataView<uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisabledCipherSuites(UserType* output) {
    
    auto* pointer = data_->disabled_cipher_suites.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint16_t>>(
        pointer, output, message_);
  }
  inline void GetClientCertPoolingPolicyDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientCertPoolingPolicy(UserType* output) {
    
    auto* pointer = data_->client_cert_pooling_policy.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  bool post_quantum_key_agreement_enabled() const {
    return data_->post_quantum_key_agreement_enabled;
  }
  bool ech_enabled() const {
    return data_->ech_enabled;
  }
  inline void GetTrustAnchorIdsDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustAnchorIds(UserType* output) {
    
    auto* pointer = data_->trust_anchor_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
 private:
  internal::SSLConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SSL_CONFIG_MOJOM_DATA_VIEW_H_