// services/network/public/mojom/url_loader_factory.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_FACTORY_MOJOM_PARAMS_DATA_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_FACTORY_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace network::mojom {
namespace internal {
class  URLLoaderFactory_CreateLoaderAndStart_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data loader;
  int32_t request_id;
  uint32_t options;
  uint8_t pad2_[4];
  mojo::internal::Pointer<::network::mojom::internal::URLRequest_Data> request;
  mojo::internal::Interface_Data client;
  mojo::internal::Pointer<::network::mojom::internal::MutableNetworkTrafficAnnotationTag_Data> traffic_annotation;

 private:
  friend class mojo::internal::MessageFragment<URLLoaderFactory_CreateLoaderAndStart_Params_Data>;

  URLLoaderFactory_CreateLoaderAndStart_Params_Data();
  ~URLLoaderFactory_CreateLoaderAndStart_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderFactory_CreateLoaderAndStart_Params_Data) == 48,
              "Bad sizeof(URLLoaderFactory_CreateLoaderAndStart_Params_Data)");
class  URLLoaderFactory_Clone_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data factory;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<URLLoaderFactory_Clone_Params_Data>;

  URLLoaderFactory_Clone_Params_Data();
  ~URLLoaderFactory_Clone_Params_Data() = delete;
};
static_assert(sizeof(URLLoaderFactory_Clone_Params_Data) == 16,
              "Bad sizeof(URLLoaderFactory_Clone_Params_Data)");

}  // namespace internal


class URLLoaderFactory_CreateLoaderAndStart_ParamsDataView {
 public:
  URLLoaderFactory_CreateLoaderAndStart_ParamsDataView() = default;

  URLLoaderFactory_CreateLoaderAndStart_ParamsDataView(
      internal::URLLoaderFactory_CreateLoaderAndStart_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeLoader() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderInterfaceBase>>(
            &data_->loader, &result, message_);
    DCHECK(ret);
    return result;
  }
  int32_t request_id() const {
    return data_->request_id;
  }
  uint32_t options() const {
    return data_->options;
  }
  inline void GetRequestDataView(
      ::network::mojom::URLRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) {
    
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::network::mojom::URLRequestDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderClientInterfaceBase>>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetTrafficAnnotationDataView(
      ::network::mojom::MutableNetworkTrafficAnnotationTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrafficAnnotation(UserType* output) {
    
    auto* pointer = data_->traffic_annotation.Get();
    return mojo::internal::Deserialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
        pointer, output, message_);
  }
 private:
  internal::URLLoaderFactory_CreateLoaderAndStart_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderFactory_Clone_ParamsDataView {
 public:
  URLLoaderFactory_Clone_ParamsDataView() = default;

  URLLoaderFactory_Clone_ParamsDataView(
      internal::URLLoaderFactory_Clone_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeFactory() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
            &data_->factory, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::URLLoaderFactory_Clone_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void URLLoaderFactory_CreateLoaderAndStart_ParamsDataView::GetRequestDataView(
    ::network::mojom::URLRequestDataView* output) {
  auto pointer = data_->request.Get();
  *output = ::network::mojom::URLRequestDataView(pointer, message_);
}
inline void URLLoaderFactory_CreateLoaderAndStart_ParamsDataView::GetTrafficAnnotationDataView(
    ::network::mojom::MutableNetworkTrafficAnnotationTagDataView* output) {
  auto pointer = data_->traffic_annotation.Get();
  *output = ::network::mojom::MutableNetworkTrafficAnnotationTagDataView(pointer, message_);
}





}  // network::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_FACTORY_MOJOM_PARAMS_DATA_H_