// services/viz/privileged/mojom/compositing/vsync_parameter_observer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/compositing/vsync_parameter_observer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/compositing/vsync_parameter_observer.mojom-params-data.h"
#include "services/viz/privileged/mojom/compositing/vsync_parameter_observer.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/compositing/vsync_parameter_observer.mojom-import-headers.h"
#include "services/viz/privileged/mojom/compositing/vsync_parameter_observer.mojom-test-utils.h"


namespace viz::mojom {
// The declaration includes the definition on other builds.

VSyncParameterObserver::IPCStableHashFunction VSyncParameterObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VSyncParameterObserver>(message.name())) {
    case messages::VSyncParameterObserver::kOnUpdateVSyncParameters: {
      return &VSyncParameterObserver::OnUpdateVSyncParameters_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VSyncParameterObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VSyncParameterObserver>(message.name())) {
      case messages::VSyncParameterObserver::kOnUpdateVSyncParameters:
            return "Receive viz::mojom::VSyncParameterObserver::OnUpdateVSyncParameters";
    }
  } else {
    switch (static_cast<messages::VSyncParameterObserver>(message.name())) {
      case messages::VSyncParameterObserver::kOnUpdateVSyncParameters:
            return "Receive reply viz::mojom::VSyncParameterObserver::OnUpdateVSyncParameters";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VSyncParameterObserver::OnUpdateVSyncParameters_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3b161abe;  // IPCStableHash for viz::mojom::VSyncParameterObserver::OnUpdateVSyncParameters
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

VSyncParameterObserverProxy::VSyncParameterObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VSyncParameterObserverProxy::OnUpdateVSyncParameters(
    ::base::TimeTicks in_timebase, ::base::TimeDelta in_interval) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::VSyncParameterObserver::OnUpdateVSyncParameters", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timebase"), in_timebase,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interval"), in_interval,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VSyncParameterObserver::kOnUpdateVSyncParameters), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::VSyncParameterObserver_OnUpdateVSyncParameters_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->timebase)::BaseType> timebase_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_timebase,
    timebase_fragment);

  params->timebase.Set(
      timebase_fragment.is_null() ? nullptr : timebase_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->timebase.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null timebase in VSyncParameterObserver.OnUpdateVSyncParameters request");
  mojo::internal::MessageFragment<
      typename decltype(params->interval)::BaseType> interval_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_interval,
    interval_fragment);

  params->interval.Set(
      interval_fragment.is_null() ? nullptr : interval_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->interval.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null interval in VSyncParameterObserver.OnUpdateVSyncParameters request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VSyncParameterObserver::Name_);
  message.set_method_name("OnUpdateVSyncParameters");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool VSyncParameterObserverStubDispatch::Accept(
    VSyncParameterObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VSyncParameterObserver>(message->header()->name)) {
    case messages::VSyncParameterObserver::kOnUpdateVSyncParameters: {
      DCHECK(message->is_serialized());
      internal::VSyncParameterObserver_OnUpdateVSyncParameters_Params_Data* params =
          reinterpret_cast<internal::VSyncParameterObserver_OnUpdateVSyncParameters_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VSyncParameterObserver.0
      bool success = true;
      ::base::TimeTicks p_timebase{};
      ::base::TimeDelta p_interval{};
      VSyncParameterObserver_OnUpdateVSyncParameters_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTimebase(&p_timebase))
        success = false;
      if (success && !input_data_view.ReadInterval(&p_interval))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VSyncParameterObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnUpdateVSyncParameters(        
        std::move(p_timebase), 
        std::move(p_interval));
      return true;
    }
  }
  return false;
}

// static
bool VSyncParameterObserverStubDispatch::AcceptWithResponder(
    VSyncParameterObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VSyncParameterObserver>(message->header()->name)) {
    case messages::VSyncParameterObserver::kOnUpdateVSyncParameters: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVSyncParameterObserverValidationInfo[] = {
    {base::to_underlying(messages::VSyncParameterObserver::kOnUpdateVSyncParameters),
     { &internal::VSyncParameterObserver_OnUpdateVSyncParameters_Params_Data::Validate,
      nullptr /* no response */}},
};

bool VSyncParameterObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::viz::mojom::VSyncParameterObserver::Name_,
    kVSyncParameterObserverValidationInfo);
}



}  // viz::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {


void VSyncParameterObserverInterceptorForTesting::OnUpdateVSyncParameters(::base::TimeTicks timebase, ::base::TimeDelta interval) {
  GetForwardingInterface()->OnUpdateVSyncParameters(
    std::move(timebase)
    , 
    std::move(interval)
    );
}
VSyncParameterObserverAsyncWaiter::VSyncParameterObserverAsyncWaiter(
    VSyncParameterObserver* proxy) : proxy_(proxy) {}

VSyncParameterObserverAsyncWaiter::~VSyncParameterObserverAsyncWaiter() = default;







}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif