// services/viz/public/mojom/compositing/frame_interval_inputs.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/frame_interval_inputs.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/frame_interval_inputs.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/frame_interval_inputs.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/frame_interval_inputs.mojom-import-headers.h"
#include "services/viz/public/mojom/compositing/frame_interval_inputs.mojom-test-utils.h"


namespace viz::mojom {
ContentFrameIntervalInfo::ContentFrameIntervalInfo()
    : type(),
      frame_interval(),
      duplicate_count(0U) {}

ContentFrameIntervalInfo::ContentFrameIntervalInfo(
    ContentFrameIntervalType type_in,
    ::base::TimeDelta frame_interval_in,
    uint32_t duplicate_count_in)
    : type(std::move(type_in)),
      frame_interval(std::move(frame_interval_in)),
      duplicate_count(std::move(duplicate_count_in)) {}

ContentFrameIntervalInfo::~ContentFrameIntervalInfo() = default;

void ContentFrameIntervalInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ContentFrameIntervalType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_interval"), this->frame_interval,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duplicate_count"), this->duplicate_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ContentFrameIntervalInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FrameIntervalInputs::FrameIntervalInputs()
    : frame_time(),
      has_user_input(),
      has_input(),
      major_scroll_speed_in_pixels_per_second(),
      content_interval_info(),
      has_only_content_frame_interval_updates(false) {}

FrameIntervalInputs::FrameIntervalInputs(
    ::base::TimeTicks frame_time_in,
    bool has_user_input_in,
    bool has_input_in,
    float major_scroll_speed_in_pixels_per_second_in,
    std::vector<::viz::ContentFrameIntervalInfo> content_interval_info_in,
    bool has_only_content_frame_interval_updates_in)
    : frame_time(std::move(frame_time_in)),
      has_user_input(std::move(has_user_input_in)),
      has_input(std::move(has_input_in)),
      major_scroll_speed_in_pixels_per_second(std::move(major_scroll_speed_in_pixels_per_second_in)),
      content_interval_info(std::move(content_interval_info_in)),
      has_only_content_frame_interval_updates(std::move(has_only_content_frame_interval_updates_in)) {}

FrameIntervalInputs::~FrameIntervalInputs() = default;

void FrameIntervalInputs::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_time"), this->frame_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_user_input"), this->has_user_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_input"), this->has_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "major_scroll_speed_in_pixels_per_second"), this->major_scroll_speed_in_pixels_per_second,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_interval_info"), this->content_interval_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::viz::ContentFrameIntervalInfo>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_only_content_frame_interval_updates"), this->has_only_content_frame_interval_updates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FrameIntervalInputs::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // viz::mojom


namespace mojo {


// static
bool StructTraits<::viz::mojom::ContentFrameIntervalInfo::DataView, ::viz::mojom::ContentFrameIntervalInfoPtr>::Read(
    ::viz::mojom::ContentFrameIntervalInfo::DataView input,
    ::viz::mojom::ContentFrameIntervalInfoPtr* output) {
  bool success = true;
  ::viz::mojom::ContentFrameIntervalInfoPtr result(::viz::mojom::ContentFrameIntervalInfo::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadFrameInterval(&result->frame_interval))
        success = false;
      if (success)
        result->duplicate_count = input.duplicate_count();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::FrameIntervalInputs::DataView, ::viz::mojom::FrameIntervalInputsPtr>::Read(
    ::viz::mojom::FrameIntervalInputs::DataView input,
    ::viz::mojom::FrameIntervalInputsPtr* output) {
  bool success = true;
  ::viz::mojom::FrameIntervalInputsPtr result(::viz::mojom::FrameIntervalInputs::New());
  
      if (success && !input.ReadFrameTime(&result->frame_time))
        success = false;
      if (success)
        result->has_user_input = input.has_user_input();
      if (success)
        result->has_input = input.has_input();
      if (success)
        result->major_scroll_speed_in_pixels_per_second = input.major_scroll_speed_in_pixels_per_second();
      if (success && !input.ReadContentIntervalInfo(&result->content_interval_info))
        success = false;
      if (success)
        result->has_only_content_frame_interval_updates = input.has_only_content_frame_interval_updates();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {




}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif