// services/viz/public/mojom/compositing/frame_timing_details.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/frame_timing_details.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-import-headers.h"
#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-test-utils.h"


namespace viz::mojom {
FrameTimingDetails::FrameTimingDetails()
    : received_compositor_frame_timestamp(),
      embedded_frame_timestamp(),
      draw_start_timestamp(),
      swap_timings(),
      presentation_feedback(),
      frame_id(),
      start_update_display_tree(),
      start_prepare_to_draw(),
      start_draw_layers() {}

FrameTimingDetails::FrameTimingDetails(
    ::base::TimeTicks received_compositor_frame_timestamp_in,
    ::base::TimeTicks embedded_frame_timestamp_in,
    ::base::TimeTicks draw_start_timestamp_in,
    const ::gfx::SwapTimings& swap_timings_in,
    const ::gfx::PresentationFeedback& presentation_feedback_in,
    ::viz::mojom::BeginFrameIdPtr frame_id_in,
    ::base::TimeTicks start_update_display_tree_in,
    ::base::TimeTicks start_prepare_to_draw_in,
    ::base::TimeTicks start_draw_layers_in)
    : received_compositor_frame_timestamp(std::move(received_compositor_frame_timestamp_in)),
      embedded_frame_timestamp(std::move(embedded_frame_timestamp_in)),
      draw_start_timestamp(std::move(draw_start_timestamp_in)),
      swap_timings(std::move(swap_timings_in)),
      presentation_feedback(std::move(presentation_feedback_in)),
      frame_id(std::move(frame_id_in)),
      start_update_display_tree(std::move(start_update_display_tree_in)),
      start_prepare_to_draw(std::move(start_prepare_to_draw_in)),
      start_draw_layers(std::move(start_draw_layers_in)) {}

FrameTimingDetails::~FrameTimingDetails() = default;

void FrameTimingDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "received_compositor_frame_timestamp"), this->received_compositor_frame_timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "embedded_frame_timestamp"), this->embedded_frame_timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "draw_start_timestamp"), this->draw_start_timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "swap_timings"), this->swap_timings,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::SwapTimings&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "presentation_feedback"), this->presentation_feedback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PresentationFeedback&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_id"), this->frame_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::mojom::BeginFrameIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_update_display_tree"), this->start_update_display_tree,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_prepare_to_draw"), this->start_prepare_to_draw,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_draw_layers"), this->start_draw_layers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FrameTimingDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // viz::mojom


namespace mojo {


// static
bool StructTraits<::viz::mojom::FrameTimingDetails::DataView, ::viz::mojom::FrameTimingDetailsPtr>::Read(
    ::viz::mojom::FrameTimingDetails::DataView input,
    ::viz::mojom::FrameTimingDetailsPtr* output) {
  bool success = true;
  ::viz::mojom::FrameTimingDetailsPtr result(::viz::mojom::FrameTimingDetails::New());
  
      if (success && !input.ReadReceivedCompositorFrameTimestamp(&result->received_compositor_frame_timestamp))
        success = false;
      if (success && !input.ReadEmbeddedFrameTimestamp(&result->embedded_frame_timestamp))
        success = false;
      if (success && !input.ReadDrawStartTimestamp(&result->draw_start_timestamp))
        success = false;
      if (success && !input.ReadSwapTimings(&result->swap_timings))
        success = false;
      if (success && !input.ReadPresentationFeedback(&result->presentation_feedback))
        success = false;
      if (success && !input.ReadFrameId(&result->frame_id))
        success = false;
      if (success && !input.ReadStartUpdateDisplayTree(&result->start_update_display_tree))
        success = false;
      if (success && !input.ReadStartPrepareToDraw(&result->start_prepare_to_draw))
        success = false;
      if (success && !input.ReadStartDrawLayers(&result->start_draw_layers))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {




}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif