// services/viz/public/mojom/compositing/surface_range.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_RANGE_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_RANGE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/surface_range.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-shared.h"




#include "services/viz/public/mojom/compositing/surface_range.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::SurfaceRangeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::SurfaceRangeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::SurfaceRange_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::start(input)) in_start = Traits::start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->start)::BaseType> start_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::SurfaceIdDataView>(
      in_start,
      start_fragment);

    fragment->start.Set(
        start_fragment.is_null() ? nullptr : start_fragment.data());

    decltype(Traits::end(input)) in_end = Traits::end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->end)::BaseType> end_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::SurfaceIdDataView>(
      in_end,
      end_fragment);

    fragment->end.Set(
        end_fragment.is_null() ? nullptr : end_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->end.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null end in SurfaceRange struct");
  }

  static bool Deserialize(::viz::mojom::internal::SurfaceRange_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::SurfaceRangeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void SurfaceRangeDataView::GetStartDataView(
    ::viz::mojom::SurfaceIdDataView* output) {
  auto pointer = data_->start.Get();
  *output = ::viz::mojom::SurfaceIdDataView(pointer, message_);
}
inline void SurfaceRangeDataView::GetEndDataView(
    ::viz::mojom::SurfaceIdDataView* output) {
  auto pointer = data_->end.Get();
  *output = ::viz::mojom::SurfaceIdDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_RANGE_MOJOM_SHARED_H_