// storage/browser/quota/quota_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef STORAGE_BROWSER_QUOTA_QUOTA_INTERNALS_MOJOM_DATA_VIEW_H_
#define STORAGE_BROWSER_QUOTA_QUOTA_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "storage/browser/quota/quota_internals.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "third_party/blink/public/mojom/quota/quota_types.mojom-shared.h"


namespace storage::mojom {
class BucketTableEntryDataView;



}  // storage::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::storage::mojom::BucketTableEntryDataView> {
  using Data = ::storage::mojom::internal::BucketTableEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace storage::mojom {
// Interface base classes. They are used for type safety check.
class QuotaInternalsHandlerInterfaceBase {};

using QuotaInternalsHandlerPtrDataView =
    mojo::InterfacePtrDataView<QuotaInternalsHandlerInterfaceBase>;
using QuotaInternalsHandlerRequestDataView =
    mojo::InterfaceRequestDataView<QuotaInternalsHandlerInterfaceBase>;
using QuotaInternalsHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<QuotaInternalsHandlerInterfaceBase>;
using QuotaInternalsHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<QuotaInternalsHandlerInterfaceBase>;


class BucketTableEntryDataView {
 public:
  BucketTableEntryDataView() = default;

  BucketTableEntryDataView(
      internal::BucketTableEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t bucket_id() const {
    return data_->bucket_id;
  }
  inline void GetStorageKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStorageKey(UserType* output) {
    
    auto* pointer = data_->storage_key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int64_t usage() const {
    return data_->usage;
  }
  int64_t use_count() const {
    return data_->use_count;
  }
  inline void GetLastAccessedDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastAccessed(UserType* output) {
    
    auto* pointer = data_->last_accessed.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetLastModifiedDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastModified(UserType* output) {
    
    auto* pointer = data_->last_modified.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::BucketTableEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // storage::mojom

#endif  // STORAGE_BROWSER_QUOTA_QUOTA_INTERNALS_MOJOM_DATA_VIEW_H_