// third_party/blink/public/mojom/compute_pressure/web_pressure_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_COMPUTE_PRESSURE_WEB_PRESSURE_MANAGER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_COMPUTE_PRESSURE_WEB_PRESSURE_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/compute_pressure/web_pressure_manager.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/compute_pressure/web_pressure_manager.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/compute_pressure/web_pressure_manager.mojom-forward.h"  // IWYU pragma: export
#include "services/device/public/mojom/pressure_manager.mojom-forward.h"
#include "services/device/public/mojom/pressure_update.mojom-forward.h"
#include "third_party/blink/public/mojom/compute_pressure/web_pressure_update.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class WebPressureManagerProxy;

template <typename ImplRefTraits>
class WebPressureManagerStub;

class WebPressureManagerRequestValidator;
class WebPressureManagerResponseValidator;


class BLINK_COMMON_EXPORT WebPressureManager
    : public WebPressureManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.WebPressureManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebPressureManagerInterfaceBase;
  using Proxy_ = WebPressureManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebPressureManagerStub<ImplRefTraits>;

  using RequestValidator_ = WebPressureManagerRequestValidator;
  using ResponseValidator_ = WebPressureManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAddClientMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebPressureManager() = default;

  using AddClientCallback = base::OnceCallback<void(::device::mojom::PressureManagerAddClientResult)>;
  using AddClientMojoCallback = base::OnceCallback<void(::device::mojom::PressureManagerAddClientResult)>;

  virtual void AddClient(::device::mojom::PressureSource source, ::mojo::PendingAssociatedRemote<WebPressureClient> client, AddClientCallback callback) = 0;
};

class WebPressureClientProxy;

template <typename ImplRefTraits>
class WebPressureClientStub;

class WebPressureClientRequestValidator;


class BLINK_COMMON_EXPORT WebPressureClient
    : public WebPressureClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.WebPressureClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebPressureClientInterfaceBase;
  using Proxy_ = WebPressureClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebPressureClientStub<ImplRefTraits>;

  using RequestValidator_ = WebPressureClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnPressureUpdatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnPressureUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebPressureClient() = default;

  virtual void OnPressureUpdated(::blink::mojom::WebPressureUpdatePtr update) = 0;
};



class BLINK_COMMON_EXPORT WebPressureManagerProxy
    : public WebPressureManager {
 public:
  using InterfaceType = WebPressureManager;

  explicit WebPressureManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddClient(::device::mojom::PressureSource source, ::mojo::PendingAssociatedRemote<WebPressureClient> client, AddClientCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT WebPressureClientProxy
    : public WebPressureClient {
 public:
  using InterfaceType = WebPressureClient;

  explicit WebPressureClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnPressureUpdated(::blink::mojom::WebPressureUpdatePtr update) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT WebPressureManagerStubDispatch {
 public:
  static bool Accept(WebPressureManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebPressureManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebPressureManager>>
class WebPressureManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebPressureManagerStub() = default;
  ~WebPressureManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebPressureManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebPressureManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT WebPressureClientStubDispatch {
 public:
  static bool Accept(WebPressureClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebPressureClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebPressureClient>>
class WebPressureClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebPressureClientStub() = default;
  ~WebPressureClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebPressureClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebPressureClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT WebPressureManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT WebPressureClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT WebPressureManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_COMPUTE_PRESSURE_WEB_PRESSURE_MANAGER_MOJOM_H_