// third_party/blink/public/mojom/manifest/manifest_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MANAGER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/manifest/manifest_manager.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/manifest/manifest_manager.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/manifest/manifest_manager.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/manifest/manifest.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class ManifestManagerProxy;

template <typename ImplRefTraits>
class ManifestManagerStub;

class ManifestManagerRequestValidator;
class ManifestManagerResponseValidator;


class BLINK_COMMON_EXPORT ManifestManager
    : public ManifestManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ManifestManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ManifestManagerInterfaceBase;
  using Proxy_ = ManifestManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ManifestManagerStub<ImplRefTraits>;

  using RequestValidator_ = ManifestManagerRequestValidator;
  using ResponseValidator_ = ManifestManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestManifestMinVersion = 0,
    kRequestManifestDebugInfoMinVersion = 0,
    kParseManifestFromStringMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestManifest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestManifestDebugInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ParseManifestFromString_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ManifestManager() = default;

  using RequestManifestCallback = base::OnceCallback<void(::blink::mojom::ManifestRequestResult, const ::GURL&, ::blink::mojom::ManifestPtr)>;
  using RequestManifestMojoCallback = base::OnceCallback<void(::blink::mojom::ManifestRequestResult, const ::GURL&, ::blink::mojom::ManifestPtr)>;

  virtual void RequestManifest(RequestManifestCallback callback) = 0;

  using RequestManifestDebugInfoCallback = base::OnceCallback<void(const ::GURL&, ::blink::mojom::ManifestPtr, ::blink::mojom::ManifestDebugInfoPtr)>;
  using RequestManifestDebugInfoMojoCallback = base::OnceCallback<void(const ::GURL&, ::blink::mojom::ManifestPtr, ::blink::mojom::ManifestDebugInfoPtr)>;

  virtual void RequestManifestDebugInfo(RequestManifestDebugInfoCallback callback) = 0;

  using ParseManifestFromStringCallback = base::OnceCallback<void(::blink::mojom::ManifestPtr)>;
  using ParseManifestFromStringMojoCallback = base::OnceCallback<void(::blink::mojom::ManifestPtr)>;

  virtual void ParseManifestFromString(const ::GURL& document_url, const ::GURL& manifest_url, const std::string& manifest_content, ParseManifestFromStringCallback callback) = 0;
};



class BLINK_COMMON_EXPORT ManifestManagerProxy
    : public ManifestManager {
 public:
  using InterfaceType = ManifestManager;

  explicit ManifestManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestManifest(RequestManifestCallback callback) final;
  
  void RequestManifestDebugInfo(RequestManifestDebugInfoCallback callback) final;
  
  void ParseManifestFromString(const ::GURL& document_url, const ::GURL& manifest_url, const std::string& manifest_content, ParseManifestFromStringCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT ManifestManagerStubDispatch {
 public:
  static bool Accept(ManifestManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ManifestManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ManifestManager>>
class ManifestManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ManifestManagerStub() = default;
  ~ManifestManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ManifestManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ManifestManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ManifestManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT ManifestManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MANIFEST_MANIFEST_MANAGER_MOJOM_H_