// third_party/blink/public/mojom/origin_trials/origin_trial_state_host.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_ORIGIN_TRIALS_ORIGIN_TRIAL_STATE_HOST_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_ORIGIN_TRIALS_ORIGIN_TRIAL_STATE_HOST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_state_host.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/origin_trials/origin_trial_state_host.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/origin_trials/origin_trial_state_host.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/runtime_feature_state/runtime_feature.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class OriginTrialStateHostProxy;

template <typename ImplRefTraits>
class OriginTrialStateHostStub;

class OriginTrialStateHostRequestValidator;


class BLINK_COMMON_EXPORT OriginTrialStateHost
    : public OriginTrialStateHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.OriginTrialStateHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = OriginTrialStateHostInterfaceBase;
  using Proxy_ = OriginTrialStateHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = OriginTrialStateHostStub<ImplRefTraits>;

  using RequestValidator_ = OriginTrialStateHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kApplyFeatureDiffForOriginTrialMinVersion = 0,
    kEnablePersistentTrialMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ApplyFeatureDiffForOriginTrial_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnablePersistentTrial_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~OriginTrialStateHost() = default;

  virtual void ApplyFeatureDiffForOriginTrial(base::flat_map<::blink::mojom::RuntimeFeature, OriginTrialFeatureStatePtr> origin_trial_features) = 0;

  virtual void EnablePersistentTrial(const std::string& token, const std::vector<::url::Origin>& script_origins) = 0;
};



class BLINK_COMMON_EXPORT OriginTrialStateHostProxy
    : public OriginTrialStateHost {
 public:
  using InterfaceType = OriginTrialStateHost;

  explicit OriginTrialStateHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ApplyFeatureDiffForOriginTrial(base::flat_map<::blink::mojom::RuntimeFeature, OriginTrialFeatureStatePtr> origin_trial_features) final;
  
  void EnablePersistentTrial(const std::string& token, const std::vector<::url::Origin>& script_origins) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT OriginTrialStateHostStubDispatch {
 public:
  static bool Accept(OriginTrialStateHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      OriginTrialStateHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<OriginTrialStateHost>>
class OriginTrialStateHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  OriginTrialStateHostStub() = default;
  ~OriginTrialStateHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OriginTrialStateHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OriginTrialStateHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT OriginTrialStateHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT OriginTrialFeatureState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OriginTrialFeatureState, T>::value>;
  using DataView = OriginTrialFeatureStateDataView;
  using Data_ = internal::OriginTrialFeatureState_Data;

  template <typename... Args>
  static OriginTrialFeatureStatePtr New(Args&&... args) {
    return OriginTrialFeatureStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OriginTrialFeatureStatePtr From(const U& u) {
    return mojo::TypeConverter<OriginTrialFeatureStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OriginTrialFeatureState>::Convert(*this);
  }


  OriginTrialFeatureState();

  OriginTrialFeatureState(
      bool is_enabled,
      std::vector<std::string> tokens);


  ~OriginTrialFeatureState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OriginTrialFeatureStatePtr>
  OriginTrialFeatureStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OriginTrialFeatureState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OriginTrialFeatureState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OriginTrialFeatureState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OriginTrialFeatureState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OriginTrialFeatureState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OriginTrialFeatureState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OriginTrialFeatureState_UnserializedMessageContext<
            UserType, OriginTrialFeatureState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OriginTrialFeatureState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OriginTrialFeatureState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OriginTrialFeatureState_UnserializedMessageContext<
            UserType, OriginTrialFeatureState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OriginTrialFeatureState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_enabled;
  
  std::vector<std::string> tokens;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OriginTrialFeatureState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OriginTrialFeatureState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OriginTrialFeatureState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OriginTrialFeatureState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
OriginTrialFeatureStatePtr OriginTrialFeatureState::Clone() const {
  return New(
      mojo::Clone(is_enabled),
      mojo::Clone(tokens)
  );
}

template <typename T, OriginTrialFeatureState::EnableIfSame<T>*>
bool OriginTrialFeatureState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_enabled, other_struct.is_enabled))
    return false;
  if (!mojo::Equals(this->tokens, other_struct.tokens))
    return false;
  return true;
}

template <typename T, OriginTrialFeatureState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_enabled < rhs.is_enabled)
    return true;
  if (rhs.is_enabled < lhs.is_enabled)
    return false;
  if (lhs.tokens < rhs.tokens)
    return true;
  if (rhs.tokens < lhs.tokens)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::OriginTrialFeatureState::DataView,
                                         ::blink::mojom::OriginTrialFeatureStatePtr> {
  static bool IsNull(const ::blink::mojom::OriginTrialFeatureStatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::OriginTrialFeatureStatePtr* output) { output->reset(); }

  static decltype(::blink::mojom::OriginTrialFeatureState::is_enabled) is_enabled(
      const ::blink::mojom::OriginTrialFeatureStatePtr& input) {
    return input->is_enabled;
  }

  static const decltype(::blink::mojom::OriginTrialFeatureState::tokens)& tokens(
      const ::blink::mojom::OriginTrialFeatureStatePtr& input) {
    return input->tokens;
  }

  static bool Read(::blink::mojom::OriginTrialFeatureState::DataView input, ::blink::mojom::OriginTrialFeatureStatePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_ORIGIN_TRIALS_ORIGIN_TRIAL_STATE_HOST_MOJOM_H_