// third_party/blink/public/mojom/payments/payment_app.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/payments/payment_app.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/payments/payment_app.mojom-params-data.h"
namespace payments {
namespace mojom {

NOINLINE static const char* PaymentHandlerStatusToStringHelper(PaymentHandlerStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PaymentHandlerStatus::SUCCESS:
      return "SUCCESS";
    case PaymentHandlerStatus::NOT_FOUND:
      return "NOT_FOUND";
    case PaymentHandlerStatus::NO_ACTIVE_WORKER:
      return "NO_ACTIVE_WORKER";
    case PaymentHandlerStatus::STORAGE_OPERATION_FAILED:
      return "STORAGE_OPERATION_FAILED";
    case PaymentHandlerStatus::FETCH_INSTRUMENT_ICON_FAILED:
      return "FETCH_INSTRUMENT_ICON_FAILED";
    case PaymentHandlerStatus::FETCH_PAYMENT_APP_INFO_FAILED:
      return "FETCH_PAYMENT_APP_INFO_FAILED";
    default:
      return nullptr;
  }
}

std::string PaymentHandlerStatusToString(PaymentHandlerStatus value) {
  const char *str = PaymentHandlerStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PaymentHandlerStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PaymentHandlerStatus value) {
  return os << PaymentHandlerStatusToString(value);
}

NOINLINE static const char* CanMakePaymentEventResponseTypeToStringHelper(CanMakePaymentEventResponseType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CanMakePaymentEventResponseType::INCOGNITO:
      return "INCOGNITO";
    case CanMakePaymentEventResponseType::NO_EXPLICITLY_VERIFIED_METHODS:
      return "NO_EXPLICITLY_VERIFIED_METHODS";
    case CanMakePaymentEventResponseType::NOT_INSTALLED:
      return "NOT_INSTALLED";
    case CanMakePaymentEventResponseType::NO_URL_BASED_PAYMENT_METHODS:
      return "NO_URL_BASED_PAYMENT_METHODS";
    case CanMakePaymentEventResponseType::BOOLEAN_CONVERSION_ERROR:
      return "BOOLEAN_CONVERSION_ERROR";
    case CanMakePaymentEventResponseType::BROWSER_ERROR:
      return "BROWSER_ERROR";
    case CanMakePaymentEventResponseType::INTERNAL_ERROR:
      return "INTERNAL_ERROR";
    case CanMakePaymentEventResponseType::NO_RESPONSE:
      return "NO_RESPONSE";
    case CanMakePaymentEventResponseType::REJECT:
      return "REJECT";
    case CanMakePaymentEventResponseType::SUCCESS:
      return "SUCCESS";
    case CanMakePaymentEventResponseType::TIMEOUT:
      return "TIMEOUT";
    default:
      return nullptr;
  }
}

std::string CanMakePaymentEventResponseTypeToString(CanMakePaymentEventResponseType value) {
  const char *str = CanMakePaymentEventResponseTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CanMakePaymentEventResponseType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CanMakePaymentEventResponseType value) {
  return os << CanMakePaymentEventResponseTypeToString(value);
}

NOINLINE static const char* PaymentEventResponseTypeToStringHelper(PaymentEventResponseType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PaymentEventResponseType::PAYER_NAME_EMPTY:
      return "PAYER_NAME_EMPTY";
    case PaymentEventResponseType::PAYER_EMAIL_EMPTY:
      return "PAYER_EMAIL_EMPTY";
    case PaymentEventResponseType::PAYER_PHONE_EMPTY:
      return "PAYER_PHONE_EMPTY";
    case PaymentEventResponseType::PAYMENT_DETAILS_ABSENT:
      return "PAYMENT_DETAILS_ABSENT";
    case PaymentEventResponseType::PAYMENT_DETAILS_NOT_OBJECT:
      return "PAYMENT_DETAILS_NOT_OBJECT";
    case PaymentEventResponseType::PAYMENT_DETAILS_STRINGIFY_ERROR:
      return "PAYMENT_DETAILS_STRINGIFY_ERROR";
    case PaymentEventResponseType::PAYMENT_EVENT_BROWSER_ERROR:
      return "PAYMENT_EVENT_BROWSER_ERROR";
    case PaymentEventResponseType::PAYMENT_EVENT_INTERNAL_ERROR:
      return "PAYMENT_EVENT_INTERNAL_ERROR";
    case PaymentEventResponseType::PAYMENT_EVENT_NO_RESPONSE:
      return "PAYMENT_EVENT_NO_RESPONSE";
    case PaymentEventResponseType::PAYMENT_EVENT_REJECT:
      return "PAYMENT_EVENT_REJECT";
    case PaymentEventResponseType::PAYMENT_EVENT_SERVICE_WORKER_ERROR:
      return "PAYMENT_EVENT_SERVICE_WORKER_ERROR";
    case PaymentEventResponseType::PAYMENT_EVENT_SUCCESS:
      return "PAYMENT_EVENT_SUCCESS";
    case PaymentEventResponseType::PAYMENT_EVENT_TIMEOUT:
      return "PAYMENT_EVENT_TIMEOUT";
    case PaymentEventResponseType::PAYMENT_HANDLER_ACTIVITY_DIED:
      return "PAYMENT_HANDLER_ACTIVITY_DIED";
    case PaymentEventResponseType::PAYMENT_HANDLER_FAIL_TO_LOAD_MAIN_FRAME:
      return "PAYMENT_HANDLER_FAIL_TO_LOAD_MAIN_FRAME";
    case PaymentEventResponseType::PAYMENT_HANDLER_INSECURE_NAVIGATION:
      return "PAYMENT_HANDLER_INSECURE_NAVIGATION";
    case PaymentEventResponseType::PAYMENT_HANDLER_INSTALL_FAILED:
      return "PAYMENT_HANDLER_INSTALL_FAILED";
    case PaymentEventResponseType::PAYMENT_HANDLER_WINDOW_CLOSING:
      return "PAYMENT_HANDLER_WINDOW_CLOSING";
    case PaymentEventResponseType::PAYMENT_METHOD_NAME_EMPTY:
      return "PAYMENT_METHOD_NAME_EMPTY";
    case PaymentEventResponseType::SHIPPING_ADDRESS_INVALID:
      return "SHIPPING_ADDRESS_INVALID";
    case PaymentEventResponseType::SHIPPING_OPTION_EMPTY:
      return "SHIPPING_OPTION_EMPTY";
    default:
      return nullptr;
  }
}

std::string PaymentEventResponseTypeToString(PaymentEventResponseType value) {
  const char *str = PaymentEventResponseTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PaymentEventResponseType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PaymentEventResponseType value) {
  return os << PaymentEventResponseTypeToString(value);
}

NOINLINE static const char* PaymentDelegationToStringHelper(PaymentDelegation value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PaymentDelegation::SHIPPING_ADDRESS:
      return "SHIPPING_ADDRESS";
    case PaymentDelegation::PAYER_NAME:
      return "PAYER_NAME";
    case PaymentDelegation::PAYER_PHONE:
      return "PAYER_PHONE";
    case PaymentDelegation::PAYER_EMAIL:
      return "PAYER_EMAIL";
    default:
      return nullptr;
  }
}

std::string PaymentDelegationToString(PaymentDelegation value) {
  const char *str = PaymentDelegationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PaymentDelegation value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PaymentDelegation value) {
  return os << PaymentDelegationToString(value);
}

namespace internal {


// static
bool PaymentInstrument_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentInstrument_Data* object =
      static_cast<const PaymentInstrument_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icons, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->icons, validation_context,
                                         &icons_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& method_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->method, validation_context,
                                         &method_validate_params)) {
    return false;
  }

  return true;
}

PaymentInstrument_Data::PaymentInstrument_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CanMakePaymentEventData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CanMakePaymentEventData_Data* object =
      static_cast<const CanMakePaymentEventData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->payment_request_origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->payment_request_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method_data, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& method_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->method_data, validation_context,
                                         &method_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->modifiers, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& modifiers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->modifiers, validation_context,
                                         &modifiers_validate_params)) {
    return false;
  }

  return true;
}

CanMakePaymentEventData_Data::CanMakePaymentEventData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentRequestEventData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentRequestEventData_Data* object =
      static_cast<const PaymentRequestEventData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->payment_request_origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->payment_request_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->payment_request_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& payment_request_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->payment_request_id, validation_context,
                                         &payment_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method_data, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& method_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->method_data, validation_context,
                                         &method_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->total, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->total, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->modifiers, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& modifiers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->modifiers, validation_context,
                                         &modifiers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instrument_key, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& instrument_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->instrument_key, validation_context,
                                         &instrument_key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->payment_options, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& shipping_options_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->shipping_options, validation_context,
                                         &shipping_options_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->payment_handler_host,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PaymentRequestEventData_Data::PaymentRequestEventData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CanMakePaymentResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CanMakePaymentResponse_Data* object =
      static_cast<const CanMakePaymentResponse_Data*>(data);


  if (!::payments::mojom::internal::CanMakePaymentEventResponseType_Data
        ::Validate(object->response_type, validation_context))
    return false;

  return true;
}

CanMakePaymentResponse_Data::CanMakePaymentResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentHandlerResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentHandlerResponse_Data* object =
      static_cast<const PaymentHandlerResponse_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& method_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->method_name, validation_context,
                                         &method_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stringified_details, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& stringified_details_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->stringified_details, validation_context,
                                         &stringified_details_validate_params)) {
    return false;
  }


  if (!::payments::mojom::internal::PaymentEventResponseType_Data
        ::Validate(object->response_type, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& payer_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->payer_name, validation_context,
                                         &payer_name_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& payer_email_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->payer_email, validation_context,
                                         &payer_email_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& payer_phone_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->payer_phone, validation_context,
                                         &payer_phone_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->shipping_address, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& shipping_option_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->shipping_option, validation_context,
                                         &shipping_option_validate_params)) {
    return false;
  }

  return true;
}

PaymentHandlerResponse_Data::PaymentHandlerResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentManager_Init_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentManager_Init_Params_Data* object =
      static_cast<const PaymentManager_Init_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->context_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->context_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_worker_scope, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& service_worker_scope_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->service_worker_scope, validation_context,
                                         &service_worker_scope_validate_params)) {
    return false;
  }

  return true;
}

PaymentManager_Init_Params_Data::PaymentManager_Init_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentManager_DeletePaymentInstrument_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentManager_DeletePaymentInstrument_Params_Data* object =
      static_cast<const PaymentManager_DeletePaymentInstrument_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instrument_key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& instrument_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->instrument_key, validation_context,
                                         &instrument_key_validate_params)) {
    return false;
  }

  return true;
}

PaymentManager_DeletePaymentInstrument_Params_Data::PaymentManager_DeletePaymentInstrument_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentManager_DeletePaymentInstrument_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentManager_DeletePaymentInstrument_ResponseParams_Data* object =
      static_cast<const PaymentManager_DeletePaymentInstrument_ResponseParams_Data*>(data);


  if (!::payments::mojom::internal::PaymentHandlerStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

PaymentManager_DeletePaymentInstrument_ResponseParams_Data::PaymentManager_DeletePaymentInstrument_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentManager_GetPaymentInstrument_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentManager_GetPaymentInstrument_Params_Data* object =
      static_cast<const PaymentManager_GetPaymentInstrument_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instrument_key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& instrument_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->instrument_key, validation_context,
                                         &instrument_key_validate_params)) {
    return false;
  }

  return true;
}

PaymentManager_GetPaymentInstrument_Params_Data::PaymentManager_GetPaymentInstrument_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentManager_GetPaymentInstrument_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentManager_GetPaymentInstrument_ResponseParams_Data* object =
      static_cast<const PaymentManager_GetPaymentInstrument_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instrument, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->instrument, validation_context))
    return false;


  if (!::payments::mojom::internal::PaymentHandlerStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

PaymentManager_GetPaymentInstrument_ResponseParams_Data::PaymentManager_GetPaymentInstrument_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentManager_KeysOfPaymentInstruments_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentManager_KeysOfPaymentInstruments_Params_Data* object =
      static_cast<const PaymentManager_KeysOfPaymentInstruments_Params_Data*>(data);

  return true;
}

PaymentManager_KeysOfPaymentInstruments_Params_Data::PaymentManager_KeysOfPaymentInstruments_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentManager_KeysOfPaymentInstruments_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentManager_KeysOfPaymentInstruments_ResponseParams_Data* object =
      static_cast<const PaymentManager_KeysOfPaymentInstruments_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keys, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->keys, validation_context,
                                         &keys_validate_params)) {
    return false;
  }


  if (!::payments::mojom::internal::PaymentHandlerStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

PaymentManager_KeysOfPaymentInstruments_ResponseParams_Data::PaymentManager_KeysOfPaymentInstruments_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentManager_HasPaymentInstrument_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentManager_HasPaymentInstrument_Params_Data* object =
      static_cast<const PaymentManager_HasPaymentInstrument_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instrument_key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& instrument_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->instrument_key, validation_context,
                                         &instrument_key_validate_params)) {
    return false;
  }

  return true;
}

PaymentManager_HasPaymentInstrument_Params_Data::PaymentManager_HasPaymentInstrument_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentManager_HasPaymentInstrument_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentManager_HasPaymentInstrument_ResponseParams_Data* object =
      static_cast<const PaymentManager_HasPaymentInstrument_ResponseParams_Data*>(data);


  if (!::payments::mojom::internal::PaymentHandlerStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

PaymentManager_HasPaymentInstrument_ResponseParams_Data::PaymentManager_HasPaymentInstrument_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentManager_SetPaymentInstrument_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentManager_SetPaymentInstrument_Params_Data* object =
      static_cast<const PaymentManager_SetPaymentInstrument_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instrument_key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& instrument_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->instrument_key, validation_context,
                                         &instrument_key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instrument, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->instrument, validation_context))
    return false;

  return true;
}

PaymentManager_SetPaymentInstrument_Params_Data::PaymentManager_SetPaymentInstrument_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentManager_SetPaymentInstrument_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentManager_SetPaymentInstrument_ResponseParams_Data* object =
      static_cast<const PaymentManager_SetPaymentInstrument_ResponseParams_Data*>(data);


  if (!::payments::mojom::internal::PaymentHandlerStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

PaymentManager_SetPaymentInstrument_ResponseParams_Data::PaymentManager_SetPaymentInstrument_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentManager_ClearPaymentInstruments_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentManager_ClearPaymentInstruments_Params_Data* object =
      static_cast<const PaymentManager_ClearPaymentInstruments_Params_Data*>(data);

  return true;
}

PaymentManager_ClearPaymentInstruments_Params_Data::PaymentManager_ClearPaymentInstruments_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentManager_ClearPaymentInstruments_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentManager_ClearPaymentInstruments_ResponseParams_Data* object =
      static_cast<const PaymentManager_ClearPaymentInstruments_ResponseParams_Data*>(data);


  if (!::payments::mojom::internal::PaymentHandlerStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

PaymentManager_ClearPaymentInstruments_ResponseParams_Data::PaymentManager_ClearPaymentInstruments_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentManager_SetUserHint_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentManager_SetUserHint_Params_Data* object =
      static_cast<const PaymentManager_SetUserHint_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_hint, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_hint_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_hint, validation_context,
                                         &user_hint_validate_params)) {
    return false;
  }

  return true;
}

PaymentManager_SetUserHint_Params_Data::PaymentManager_SetUserHint_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentManager_EnableDelegations_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentManager_EnableDelegations_Params_Data* object =
      static_cast<const PaymentManager_EnableDelegations_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->delegations, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& delegations_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::payments::mojom::internal::PaymentDelegation_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->delegations, validation_context,
                                         &delegations_validate_params)) {
    return false;
  }

  return true;
}

PaymentManager_EnableDelegations_Params_Data::PaymentManager_EnableDelegations_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentManager_EnableDelegations_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentManager_EnableDelegations_ResponseParams_Data* object =
      static_cast<const PaymentManager_EnableDelegations_ResponseParams_Data*>(data);


  if (!::payments::mojom::internal::PaymentHandlerStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

PaymentManager_EnableDelegations_ResponseParams_Data::PaymentManager_EnableDelegations_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentHandlerResponseCallback_OnResponseForAbortPayment_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentHandlerResponseCallback_OnResponseForAbortPayment_Params_Data* object =
      static_cast<const PaymentHandlerResponseCallback_OnResponseForAbortPayment_Params_Data*>(data);

  return true;
}

PaymentHandlerResponseCallback_OnResponseForAbortPayment_Params_Data::PaymentHandlerResponseCallback_OnResponseForAbortPayment_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentHandlerResponseCallback_OnResponseForCanMakePayment_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentHandlerResponseCallback_OnResponseForCanMakePayment_Params_Data* object =
      static_cast<const PaymentHandlerResponseCallback_OnResponseForCanMakePayment_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

PaymentHandlerResponseCallback_OnResponseForCanMakePayment_Params_Data::PaymentHandlerResponseCallback_OnResponseForCanMakePayment_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaymentHandlerResponseCallback_OnResponseForPaymentRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaymentHandlerResponseCallback_OnResponseForPaymentRequest_Params_Data* object =
      static_cast<const PaymentHandlerResponseCallback_OnResponseForPaymentRequest_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

PaymentHandlerResponseCallback_OnResponseForPaymentRequest_Params_Data::PaymentHandlerResponseCallback_OnResponseForPaymentRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace payments

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::PaymentHandlerStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::PaymentHandlerStatus value) {
  return std::move(context).WriteString(::payments::mojom::PaymentHandlerStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::CanMakePaymentEventResponseType>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::CanMakePaymentEventResponseType value) {
  return std::move(context).WriteString(::payments::mojom::CanMakePaymentEventResponseTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::PaymentEventResponseType>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::PaymentEventResponseType value) {
  return std::move(context).WriteString(::payments::mojom::PaymentEventResponseTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::payments::mojom::PaymentDelegation>::WriteIntoTrace(
   perfetto::TracedValue context, ::payments::mojom::PaymentDelegation value) {
  return std::move(context).WriteString(::payments::mojom::PaymentDelegationToString(value));
}

} // namespace perfetto