// third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERFORMANCE_MANAGER_V8_DETAILED_MEMORY_REPORTER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERFORMANCE_MANAGER_V8_DETAILED_MEMORY_REPORTER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/performance_manager/v8_detailed_memory_reporter.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class V8DetailedMemoryReporterProxy;

template <typename ImplRefTraits>
class V8DetailedMemoryReporterStub;

class V8DetailedMemoryReporterRequestValidator;
class V8DetailedMemoryReporterResponseValidator;


class BLINK_COMMON_EXPORT V8DetailedMemoryReporter
    : public V8DetailedMemoryReporterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.V8DetailedMemoryReporter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = V8DetailedMemoryReporterInterfaceBase;
  using Proxy_ = V8DetailedMemoryReporterProxy;

  template <typename ImplRefTraits>
  using Stub_ = V8DetailedMemoryReporterStub<ImplRefTraits>;

  using RequestValidator_ = V8DetailedMemoryReporterRequestValidator;
  using ResponseValidator_ = V8DetailedMemoryReporterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetV8MemoryUsageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetV8MemoryUsage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  using Mode = V8DetailedMemoryReporter_Mode;
  virtual ~V8DetailedMemoryReporter() = default;

  using GetV8MemoryUsageCallback = base::OnceCallback<void(PerProcessV8MemoryUsagePtr)>;
  using GetV8MemoryUsageMojoCallback = base::OnceCallback<void(PerProcessV8MemoryUsagePtr)>;

  virtual void GetV8MemoryUsage(V8DetailedMemoryReporter::Mode mode, GetV8MemoryUsageCallback callback) = 0;
};



class BLINK_COMMON_EXPORT V8DetailedMemoryReporterProxy
    : public V8DetailedMemoryReporter {
 public:
  using InterfaceType = V8DetailedMemoryReporter;

  explicit V8DetailedMemoryReporterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetV8MemoryUsage(V8DetailedMemoryReporter::Mode mode, GetV8MemoryUsageCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT V8DetailedMemoryReporterStubDispatch {
 public:
  static bool Accept(V8DetailedMemoryReporter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      V8DetailedMemoryReporter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<V8DetailedMemoryReporter>>
class V8DetailedMemoryReporterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  V8DetailedMemoryReporterStub() = default;
  ~V8DetailedMemoryReporterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return V8DetailedMemoryReporterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return V8DetailedMemoryReporterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT V8DetailedMemoryReporterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT V8DetailedMemoryReporterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};











class BLINK_COMMON_EXPORT PerContextV8MemoryUsage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PerContextV8MemoryUsage, T>::value>;
  using DataView = PerContextV8MemoryUsageDataView;
  using Data_ = internal::PerContextV8MemoryUsage_Data;

  template <typename... Args>
  static PerContextV8MemoryUsagePtr New(Args&&... args) {
    return PerContextV8MemoryUsagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PerContextV8MemoryUsagePtr From(const U& u) {
    return mojo::TypeConverter<PerContextV8MemoryUsagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PerContextV8MemoryUsage>::Convert(*this);
  }


  PerContextV8MemoryUsage();

  PerContextV8MemoryUsage(
      const ::blink::ExecutionContextToken& token,
      uint64_t bytes_used,
      const std::optional<std::string>& url);


  ~PerContextV8MemoryUsage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PerContextV8MemoryUsagePtr>
  PerContextV8MemoryUsagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PerContextV8MemoryUsage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PerContextV8MemoryUsage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PerContextV8MemoryUsage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PerContextV8MemoryUsage::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PerContextV8MemoryUsage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PerContextV8MemoryUsage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PerContextV8MemoryUsage_UnserializedMessageContext<
            UserType, PerContextV8MemoryUsage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PerContextV8MemoryUsage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PerContextV8MemoryUsage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PerContextV8MemoryUsage_UnserializedMessageContext<
            UserType, PerContextV8MemoryUsage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PerContextV8MemoryUsage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::ExecutionContextToken token;
  
  uint64_t bytes_used;
  
  std::optional<std::string> url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PerContextV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PerContextV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PerContextV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PerContextV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PerContextCanvasMemoryUsage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PerContextCanvasMemoryUsage, T>::value>;
  using DataView = PerContextCanvasMemoryUsageDataView;
  using Data_ = internal::PerContextCanvasMemoryUsage_Data;

  template <typename... Args>
  static PerContextCanvasMemoryUsagePtr New(Args&&... args) {
    return PerContextCanvasMemoryUsagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PerContextCanvasMemoryUsagePtr From(const U& u) {
    return mojo::TypeConverter<PerContextCanvasMemoryUsagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PerContextCanvasMemoryUsage>::Convert(*this);
  }


  PerContextCanvasMemoryUsage();

  PerContextCanvasMemoryUsage(
      const ::blink::ExecutionContextToken& token,
      uint64_t bytes_used);


  ~PerContextCanvasMemoryUsage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PerContextCanvasMemoryUsagePtr>
  PerContextCanvasMemoryUsagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PerContextCanvasMemoryUsage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PerContextCanvasMemoryUsage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PerContextCanvasMemoryUsage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PerContextCanvasMemoryUsage::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PerContextCanvasMemoryUsage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PerContextCanvasMemoryUsage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PerContextCanvasMemoryUsage_UnserializedMessageContext<
            UserType, PerContextCanvasMemoryUsage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PerContextCanvasMemoryUsage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PerContextCanvasMemoryUsage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PerContextCanvasMemoryUsage_UnserializedMessageContext<
            UserType, PerContextCanvasMemoryUsage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PerContextCanvasMemoryUsage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::ExecutionContextToken token;
  
  uint64_t bytes_used;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PerContextCanvasMemoryUsage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PerContextCanvasMemoryUsage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PerContextCanvasMemoryUsage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PerContextCanvasMemoryUsage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PerIsolateV8MemoryUsage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PerIsolateV8MemoryUsage, T>::value>;
  using DataView = PerIsolateV8MemoryUsageDataView;
  using Data_ = internal::PerIsolateV8MemoryUsage_Data;

  template <typename... Args>
  static PerIsolateV8MemoryUsagePtr New(Args&&... args) {
    return PerIsolateV8MemoryUsagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PerIsolateV8MemoryUsagePtr From(const U& u) {
    return mojo::TypeConverter<PerIsolateV8MemoryUsagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PerIsolateV8MemoryUsage>::Convert(*this);
  }


  PerIsolateV8MemoryUsage();

  PerIsolateV8MemoryUsage(
      uint64_t num_detached_contexts,
      uint64_t detached_bytes_used,
      uint64_t shared_bytes_used,
      uint64_t blink_bytes_used,
      std::vector<PerContextV8MemoryUsagePtr> contexts,
      std::vector<PerContextCanvasMemoryUsagePtr> canvas_contexts);

PerIsolateV8MemoryUsage(const PerIsolateV8MemoryUsage&) = delete;
PerIsolateV8MemoryUsage& operator=(const PerIsolateV8MemoryUsage&) = delete;

  ~PerIsolateV8MemoryUsage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PerIsolateV8MemoryUsagePtr>
  PerIsolateV8MemoryUsagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PerIsolateV8MemoryUsage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PerIsolateV8MemoryUsage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PerIsolateV8MemoryUsage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PerIsolateV8MemoryUsage::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PerIsolateV8MemoryUsage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PerIsolateV8MemoryUsage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PerIsolateV8MemoryUsage_UnserializedMessageContext<
            UserType, PerIsolateV8MemoryUsage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PerIsolateV8MemoryUsage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PerIsolateV8MemoryUsage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PerIsolateV8MemoryUsage_UnserializedMessageContext<
            UserType, PerIsolateV8MemoryUsage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PerIsolateV8MemoryUsage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t num_detached_contexts;
  
  uint64_t detached_bytes_used;
  
  uint64_t shared_bytes_used;
  
  uint64_t blink_bytes_used;
  
  std::vector<PerContextV8MemoryUsagePtr> contexts;
  
  std::vector<PerContextCanvasMemoryUsagePtr> canvas_contexts;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PerIsolateV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PerIsolateV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PerIsolateV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PerIsolateV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PerProcessV8MemoryUsage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PerProcessV8MemoryUsage, T>::value>;
  using DataView = PerProcessV8MemoryUsageDataView;
  using Data_ = internal::PerProcessV8MemoryUsage_Data;

  template <typename... Args>
  static PerProcessV8MemoryUsagePtr New(Args&&... args) {
    return PerProcessV8MemoryUsagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PerProcessV8MemoryUsagePtr From(const U& u) {
    return mojo::TypeConverter<PerProcessV8MemoryUsagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PerProcessV8MemoryUsage>::Convert(*this);
  }


  PerProcessV8MemoryUsage();

  explicit PerProcessV8MemoryUsage(
      std::vector<PerIsolateV8MemoryUsagePtr> isolates);

PerProcessV8MemoryUsage(const PerProcessV8MemoryUsage&) = delete;
PerProcessV8MemoryUsage& operator=(const PerProcessV8MemoryUsage&) = delete;

  ~PerProcessV8MemoryUsage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PerProcessV8MemoryUsagePtr>
  PerProcessV8MemoryUsagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PerProcessV8MemoryUsage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PerProcessV8MemoryUsage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PerProcessV8MemoryUsage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PerProcessV8MemoryUsage::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PerProcessV8MemoryUsage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PerProcessV8MemoryUsage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PerProcessV8MemoryUsage_UnserializedMessageContext<
            UserType, PerProcessV8MemoryUsage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PerProcessV8MemoryUsage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PerProcessV8MemoryUsage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PerProcessV8MemoryUsage_UnserializedMessageContext<
            UserType, PerProcessV8MemoryUsage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PerProcessV8MemoryUsage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<PerIsolateV8MemoryUsagePtr> isolates;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PerProcessV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PerProcessV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PerProcessV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PerProcessV8MemoryUsage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PerContextV8MemoryUsagePtr PerContextV8MemoryUsage::Clone() const {
  return New(
      mojo::Clone(token),
      mojo::Clone(bytes_used),
      mojo::Clone(url)
  );
}

template <typename T, PerContextV8MemoryUsage::EnableIfSame<T>*>
bool PerContextV8MemoryUsage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->token, other_struct.token))
    return false;
  if (!mojo::Equals(this->bytes_used, other_struct.bytes_used))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  return true;
}

template <typename T, PerContextV8MemoryUsage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.token < rhs.token)
    return true;
  if (rhs.token < lhs.token)
    return false;
  if (lhs.bytes_used < rhs.bytes_used)
    return true;
  if (rhs.bytes_used < lhs.bytes_used)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  return false;
}
template <typename StructPtrType>
PerContextCanvasMemoryUsagePtr PerContextCanvasMemoryUsage::Clone() const {
  return New(
      mojo::Clone(token),
      mojo::Clone(bytes_used)
  );
}

template <typename T, PerContextCanvasMemoryUsage::EnableIfSame<T>*>
bool PerContextCanvasMemoryUsage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->token, other_struct.token))
    return false;
  if (!mojo::Equals(this->bytes_used, other_struct.bytes_used))
    return false;
  return true;
}

template <typename T, PerContextCanvasMemoryUsage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.token < rhs.token)
    return true;
  if (rhs.token < lhs.token)
    return false;
  if (lhs.bytes_used < rhs.bytes_used)
    return true;
  if (rhs.bytes_used < lhs.bytes_used)
    return false;
  return false;
}
template <typename StructPtrType>
PerIsolateV8MemoryUsagePtr PerIsolateV8MemoryUsage::Clone() const {
  return New(
      mojo::Clone(num_detached_contexts),
      mojo::Clone(detached_bytes_used),
      mojo::Clone(shared_bytes_used),
      mojo::Clone(blink_bytes_used),
      mojo::Clone(contexts),
      mojo::Clone(canvas_contexts)
  );
}

template <typename T, PerIsolateV8MemoryUsage::EnableIfSame<T>*>
bool PerIsolateV8MemoryUsage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->num_detached_contexts, other_struct.num_detached_contexts))
    return false;
  if (!mojo::Equals(this->detached_bytes_used, other_struct.detached_bytes_used))
    return false;
  if (!mojo::Equals(this->shared_bytes_used, other_struct.shared_bytes_used))
    return false;
  if (!mojo::Equals(this->blink_bytes_used, other_struct.blink_bytes_used))
    return false;
  if (!mojo::Equals(this->contexts, other_struct.contexts))
    return false;
  if (!mojo::Equals(this->canvas_contexts, other_struct.canvas_contexts))
    return false;
  return true;
}

template <typename T, PerIsolateV8MemoryUsage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.num_detached_contexts < rhs.num_detached_contexts)
    return true;
  if (rhs.num_detached_contexts < lhs.num_detached_contexts)
    return false;
  if (lhs.detached_bytes_used < rhs.detached_bytes_used)
    return true;
  if (rhs.detached_bytes_used < lhs.detached_bytes_used)
    return false;
  if (lhs.shared_bytes_used < rhs.shared_bytes_used)
    return true;
  if (rhs.shared_bytes_used < lhs.shared_bytes_used)
    return false;
  if (lhs.blink_bytes_used < rhs.blink_bytes_used)
    return true;
  if (rhs.blink_bytes_used < lhs.blink_bytes_used)
    return false;
  if (lhs.contexts < rhs.contexts)
    return true;
  if (rhs.contexts < lhs.contexts)
    return false;
  if (lhs.canvas_contexts < rhs.canvas_contexts)
    return true;
  if (rhs.canvas_contexts < lhs.canvas_contexts)
    return false;
  return false;
}
template <typename StructPtrType>
PerProcessV8MemoryUsagePtr PerProcessV8MemoryUsage::Clone() const {
  return New(
      mojo::Clone(isolates)
  );
}

template <typename T, PerProcessV8MemoryUsage::EnableIfSame<T>*>
bool PerProcessV8MemoryUsage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->isolates, other_struct.isolates))
    return false;
  return true;
}

template <typename T, PerProcessV8MemoryUsage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.isolates < rhs.isolates)
    return true;
  if (rhs.isolates < lhs.isolates)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PerContextV8MemoryUsage::DataView,
                                         ::blink::mojom::PerContextV8MemoryUsagePtr> {
  static bool IsNull(const ::blink::mojom::PerContextV8MemoryUsagePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PerContextV8MemoryUsagePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PerContextV8MemoryUsage::token)& token(
      const ::blink::mojom::PerContextV8MemoryUsagePtr& input) {
    return input->token;
  }

  static decltype(::blink::mojom::PerContextV8MemoryUsage::bytes_used) bytes_used(
      const ::blink::mojom::PerContextV8MemoryUsagePtr& input) {
    return input->bytes_used;
  }

  static const decltype(::blink::mojom::PerContextV8MemoryUsage::url)& url(
      const ::blink::mojom::PerContextV8MemoryUsagePtr& input) {
    return input->url;
  }

  static bool Read(::blink::mojom::PerContextV8MemoryUsage::DataView input, ::blink::mojom::PerContextV8MemoryUsagePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PerContextCanvasMemoryUsage::DataView,
                                         ::blink::mojom::PerContextCanvasMemoryUsagePtr> {
  static bool IsNull(const ::blink::mojom::PerContextCanvasMemoryUsagePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PerContextCanvasMemoryUsagePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PerContextCanvasMemoryUsage::token)& token(
      const ::blink::mojom::PerContextCanvasMemoryUsagePtr& input) {
    return input->token;
  }

  static decltype(::blink::mojom::PerContextCanvasMemoryUsage::bytes_used) bytes_used(
      const ::blink::mojom::PerContextCanvasMemoryUsagePtr& input) {
    return input->bytes_used;
  }

  static bool Read(::blink::mojom::PerContextCanvasMemoryUsage::DataView input, ::blink::mojom::PerContextCanvasMemoryUsagePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PerIsolateV8MemoryUsage::DataView,
                                         ::blink::mojom::PerIsolateV8MemoryUsagePtr> {
  static bool IsNull(const ::blink::mojom::PerIsolateV8MemoryUsagePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PerIsolateV8MemoryUsagePtr* output) { output->reset(); }

  static decltype(::blink::mojom::PerIsolateV8MemoryUsage::num_detached_contexts) num_detached_contexts(
      const ::blink::mojom::PerIsolateV8MemoryUsagePtr& input) {
    return input->num_detached_contexts;
  }

  static decltype(::blink::mojom::PerIsolateV8MemoryUsage::detached_bytes_used) detached_bytes_used(
      const ::blink::mojom::PerIsolateV8MemoryUsagePtr& input) {
    return input->detached_bytes_used;
  }

  static decltype(::blink::mojom::PerIsolateV8MemoryUsage::shared_bytes_used) shared_bytes_used(
      const ::blink::mojom::PerIsolateV8MemoryUsagePtr& input) {
    return input->shared_bytes_used;
  }

  static decltype(::blink::mojom::PerIsolateV8MemoryUsage::blink_bytes_used) blink_bytes_used(
      const ::blink::mojom::PerIsolateV8MemoryUsagePtr& input) {
    return input->blink_bytes_used;
  }

  static const decltype(::blink::mojom::PerIsolateV8MemoryUsage::contexts)& contexts(
      const ::blink::mojom::PerIsolateV8MemoryUsagePtr& input) {
    return input->contexts;
  }

  static const decltype(::blink::mojom::PerIsolateV8MemoryUsage::canvas_contexts)& canvas_contexts(
      const ::blink::mojom::PerIsolateV8MemoryUsagePtr& input) {
    return input->canvas_contexts;
  }

  static bool Read(::blink::mojom::PerIsolateV8MemoryUsage::DataView input, ::blink::mojom::PerIsolateV8MemoryUsagePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PerProcessV8MemoryUsage::DataView,
                                         ::blink::mojom::PerProcessV8MemoryUsagePtr> {
  static bool IsNull(const ::blink::mojom::PerProcessV8MemoryUsagePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PerProcessV8MemoryUsagePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PerProcessV8MemoryUsage::isolates)& isolates(
      const ::blink::mojom::PerProcessV8MemoryUsagePtr& input) {
    return input->isolates;
  }

  static bool Read(::blink::mojom::PerProcessV8MemoryUsage::DataView input, ::blink::mojom::PerProcessV8MemoryUsagePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERFORMANCE_MANAGER_V8_DETAILED_MEMORY_REPORTER_MOJOM_H_