// ui/base/ime/mojom/text_input_state.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_H_
#define UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/base/ime/mojom/text_input_state.mojom-features.h"  // IWYU pragma: export
#include "ui/base/ime/mojom/text_input_state.mojom-shared.h"  // IWYU pragma: export
#include "ui/base/ime/mojom/text_input_state.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/text_direction.mojom-forward.h"
#include "ui/base/ime/mojom/ime_types.mojom.h"
#include "ui/base/ime/mojom/virtual_keyboard_types.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/range/mojom/range.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace ui::mojom {









class  ImeTextSpanInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ImeTextSpanInfo, T>::value>;
  using DataView = ImeTextSpanInfoDataView;
  using Data_ = internal::ImeTextSpanInfo_Data;

  template <typename... Args>
  static ImeTextSpanInfoPtr New(Args&&... args) {
    return ImeTextSpanInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ImeTextSpanInfoPtr From(const U& u) {
    return mojo::TypeConverter<ImeTextSpanInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ImeTextSpanInfo>::Convert(*this);
  }


  ImeTextSpanInfo();

  ImeTextSpanInfo(
      const ::ui::ImeTextSpan& span,
      const ::gfx::Rect& bounds);


  ~ImeTextSpanInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ImeTextSpanInfoPtr>
  ImeTextSpanInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ImeTextSpanInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ImeTextSpanInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ImeTextSpanInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImeTextSpanInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImeTextSpanInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ImeTextSpanInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ImeTextSpanInfo_UnserializedMessageContext<
            UserType, ImeTextSpanInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ImeTextSpanInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ImeTextSpanInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ImeTextSpanInfo_UnserializedMessageContext<
            UserType, ImeTextSpanInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ImeTextSpanInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::ui::ImeTextSpan span;
  
  ::gfx::Rect bounds;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ImeTextSpanInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ImeTextSpanInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ImeTextSpanInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ImeTextSpanInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TextInputState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TextInputState, T>::value>;
  using DataView = TextInputStateDataView;
  using Data_ = internal::TextInputState_Data;

  template <typename... Args>
  static TextInputStatePtr New(Args&&... args) {
    return TextInputStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TextInputStatePtr From(const U& u) {
    return mojo::TypeConverter<TextInputStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TextInputState>::Convert(*this);
  }


  TextInputState();

  TextInputState(
      int32_t node_id,
      ::ui::TextInputType type,
      ::ui::TextInputMode mode,
      ::ui::TextInputAction action,
      uint32_t flags,
      const std::optional<::std::u16string>& value,
      const ::gfx::Range& selection,
      const std::optional<::gfx::Range>& composition,
      bool can_compose_inline,
      bool show_ime_if_needed,
      bool always_hide_ime,
      bool reply_to_request,
      const std::optional<::gfx::Rect>& edit_context_control_bounds,
      const std::optional<::gfx::Rect>& edit_context_selection_bounds,
      ::ui::mojom::VirtualKeyboardPolicy vk_policy,
      ::ui::mojom::VirtualKeyboardVisibilityRequest last_vk_visibility_request,
      std::vector<ImeTextSpanInfoPtr> ime_text_spans_info);

TextInputState(const TextInputState&) = delete;
TextInputState& operator=(const TextInputState&) = delete;

  ~TextInputState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TextInputStatePtr>
  TextInputStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TextInputState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TextInputState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TextInputState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TextInputState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TextInputState_UnserializedMessageContext<
            UserType, TextInputState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TextInputState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TextInputState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TextInputState_UnserializedMessageContext<
            UserType, TextInputState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TextInputState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t node_id;
  
  ::ui::TextInputType type;
  
  ::ui::TextInputMode mode;
  
  ::ui::TextInputAction action;
  
  uint32_t flags;
  
  std::optional<::std::u16string> value;
  
  ::gfx::Range selection;
  
  std::optional<::gfx::Range> composition;
  
  bool can_compose_inline;
  
  bool show_ime_if_needed;
  
  bool always_hide_ime;
  
  bool reply_to_request;
  
  std::optional<::gfx::Rect> edit_context_control_bounds;
  
  std::optional<::gfx::Rect> edit_context_selection_bounds;
  
  ::ui::mojom::VirtualKeyboardPolicy vk_policy;
  
  ::ui::mojom::VirtualKeyboardVisibilityRequest last_vk_visibility_request;
  
  std::vector<ImeTextSpanInfoPtr> ime_text_spans_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TextInputState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TextInputState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TextInputState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TextInputState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ImeTextSpanInfoPtr ImeTextSpanInfo::Clone() const {
  return New(
      mojo::Clone(span),
      mojo::Clone(bounds)
  );
}

template <typename T, ImeTextSpanInfo::EnableIfSame<T>*>
bool ImeTextSpanInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->span, other_struct.span))
    return false;
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  return true;
}

template <typename T, ImeTextSpanInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.span < rhs.span)
    return true;
  if (rhs.span < lhs.span)
    return false;
  if (lhs.bounds < rhs.bounds)
    return true;
  if (rhs.bounds < lhs.bounds)
    return false;
  return false;
}
template <typename StructPtrType>
TextInputStatePtr TextInputState::Clone() const {
  return New(
      mojo::Clone(node_id),
      mojo::Clone(type),
      mojo::Clone(mode),
      mojo::Clone(action),
      mojo::Clone(flags),
      mojo::Clone(value),
      mojo::Clone(selection),
      mojo::Clone(composition),
      mojo::Clone(can_compose_inline),
      mojo::Clone(show_ime_if_needed),
      mojo::Clone(always_hide_ime),
      mojo::Clone(reply_to_request),
      mojo::Clone(edit_context_control_bounds),
      mojo::Clone(edit_context_selection_bounds),
      mojo::Clone(vk_policy),
      mojo::Clone(last_vk_visibility_request),
      mojo::Clone(ime_text_spans_info)
  );
}

template <typename T, TextInputState::EnableIfSame<T>*>
bool TextInputState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->node_id, other_struct.node_id))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->action, other_struct.action))
    return false;
  if (!mojo::Equals(this->flags, other_struct.flags))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->selection, other_struct.selection))
    return false;
  if (!mojo::Equals(this->composition, other_struct.composition))
    return false;
  if (!mojo::Equals(this->can_compose_inline, other_struct.can_compose_inline))
    return false;
  if (!mojo::Equals(this->show_ime_if_needed, other_struct.show_ime_if_needed))
    return false;
  if (!mojo::Equals(this->always_hide_ime, other_struct.always_hide_ime))
    return false;
  if (!mojo::Equals(this->reply_to_request, other_struct.reply_to_request))
    return false;
  if (!mojo::Equals(this->edit_context_control_bounds, other_struct.edit_context_control_bounds))
    return false;
  if (!mojo::Equals(this->edit_context_selection_bounds, other_struct.edit_context_selection_bounds))
    return false;
  if (!mojo::Equals(this->vk_policy, other_struct.vk_policy))
    return false;
  if (!mojo::Equals(this->last_vk_visibility_request, other_struct.last_vk_visibility_request))
    return false;
  if (!mojo::Equals(this->ime_text_spans_info, other_struct.ime_text_spans_info))
    return false;
  return true;
}

template <typename T, TextInputState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.node_id < rhs.node_id)
    return true;
  if (rhs.node_id < lhs.node_id)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.mode < rhs.mode)
    return true;
  if (rhs.mode < lhs.mode)
    return false;
  if (lhs.action < rhs.action)
    return true;
  if (rhs.action < lhs.action)
    return false;
  if (lhs.flags < rhs.flags)
    return true;
  if (rhs.flags < lhs.flags)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.selection < rhs.selection)
    return true;
  if (rhs.selection < lhs.selection)
    return false;
  if (lhs.composition < rhs.composition)
    return true;
  if (rhs.composition < lhs.composition)
    return false;
  if (lhs.can_compose_inline < rhs.can_compose_inline)
    return true;
  if (rhs.can_compose_inline < lhs.can_compose_inline)
    return false;
  if (lhs.show_ime_if_needed < rhs.show_ime_if_needed)
    return true;
  if (rhs.show_ime_if_needed < lhs.show_ime_if_needed)
    return false;
  if (lhs.always_hide_ime < rhs.always_hide_ime)
    return true;
  if (rhs.always_hide_ime < lhs.always_hide_ime)
    return false;
  if (lhs.reply_to_request < rhs.reply_to_request)
    return true;
  if (rhs.reply_to_request < lhs.reply_to_request)
    return false;
  if (lhs.edit_context_control_bounds < rhs.edit_context_control_bounds)
    return true;
  if (rhs.edit_context_control_bounds < lhs.edit_context_control_bounds)
    return false;
  if (lhs.edit_context_selection_bounds < rhs.edit_context_selection_bounds)
    return true;
  if (rhs.edit_context_selection_bounds < lhs.edit_context_selection_bounds)
    return false;
  if (lhs.vk_policy < rhs.vk_policy)
    return true;
  if (rhs.vk_policy < lhs.vk_policy)
    return false;
  if (lhs.last_vk_visibility_request < rhs.last_vk_visibility_request)
    return true;
  if (rhs.last_vk_visibility_request < lhs.last_vk_visibility_request)
    return false;
  if (lhs.ime_text_spans_info < rhs.ime_text_spans_info)
    return true;
  if (rhs.ime_text_spans_info < lhs.ime_text_spans_info)
    return false;
  return false;
}


}  // ui::mojom

namespace mojo {


template <>
struct  StructTraits<::ui::mojom::ImeTextSpanInfo::DataView,
                                         ::ui::mojom::ImeTextSpanInfoPtr> {
  static bool IsNull(const ::ui::mojom::ImeTextSpanInfoPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::ImeTextSpanInfoPtr* output) { output->reset(); }

  static const decltype(::ui::mojom::ImeTextSpanInfo::span)& span(
      const ::ui::mojom::ImeTextSpanInfoPtr& input) {
    return input->span;
  }

  static const decltype(::ui::mojom::ImeTextSpanInfo::bounds)& bounds(
      const ::ui::mojom::ImeTextSpanInfoPtr& input) {
    return input->bounds;
  }

  static bool Read(::ui::mojom::ImeTextSpanInfo::DataView input, ::ui::mojom::ImeTextSpanInfoPtr* output);
};


template <>
struct  StructTraits<::ui::mojom::TextInputState::DataView,
                                         ::ui::mojom::TextInputStatePtr> {
  static bool IsNull(const ::ui::mojom::TextInputStatePtr& input) { return !input; }
  static void SetToNull(::ui::mojom::TextInputStatePtr* output) { output->reset(); }

  static decltype(::ui::mojom::TextInputState::node_id) node_id(
      const ::ui::mojom::TextInputStatePtr& input) {
    return input->node_id;
  }

  static decltype(::ui::mojom::TextInputState::type) type(
      const ::ui::mojom::TextInputStatePtr& input) {
    return input->type;
  }

  static decltype(::ui::mojom::TextInputState::mode) mode(
      const ::ui::mojom::TextInputStatePtr& input) {
    return input->mode;
  }

  static decltype(::ui::mojom::TextInputState::action) action(
      const ::ui::mojom::TextInputStatePtr& input) {
    return input->action;
  }

  static decltype(::ui::mojom::TextInputState::flags) flags(
      const ::ui::mojom::TextInputStatePtr& input) {
    return input->flags;
  }

  static  decltype(::ui::mojom::TextInputState::value)& value(
       ::ui::mojom::TextInputStatePtr& input) {
    return input->value;
  }

  static const decltype(::ui::mojom::TextInputState::selection)& selection(
      const ::ui::mojom::TextInputStatePtr& input) {
    return input->selection;
  }

  static const decltype(::ui::mojom::TextInputState::composition)& composition(
      const ::ui::mojom::TextInputStatePtr& input) {
    return input->composition;
  }

  static decltype(::ui::mojom::TextInputState::can_compose_inline) can_compose_inline(
      const ::ui::mojom::TextInputStatePtr& input) {
    return input->can_compose_inline;
  }

  static decltype(::ui::mojom::TextInputState::show_ime_if_needed) show_ime_if_needed(
      const ::ui::mojom::TextInputStatePtr& input) {
    return input->show_ime_if_needed;
  }

  static decltype(::ui::mojom::TextInputState::always_hide_ime) always_hide_ime(
      const ::ui::mojom::TextInputStatePtr& input) {
    return input->always_hide_ime;
  }

  static decltype(::ui::mojom::TextInputState::reply_to_request) reply_to_request(
      const ::ui::mojom::TextInputStatePtr& input) {
    return input->reply_to_request;
  }

  static const decltype(::ui::mojom::TextInputState::edit_context_control_bounds)& edit_context_control_bounds(
      const ::ui::mojom::TextInputStatePtr& input) {
    return input->edit_context_control_bounds;
  }

  static const decltype(::ui::mojom::TextInputState::edit_context_selection_bounds)& edit_context_selection_bounds(
      const ::ui::mojom::TextInputStatePtr& input) {
    return input->edit_context_selection_bounds;
  }

  static decltype(::ui::mojom::TextInputState::vk_policy) vk_policy(
      const ::ui::mojom::TextInputStatePtr& input) {
    return input->vk_policy;
  }

  static decltype(::ui::mojom::TextInputState::last_vk_visibility_request) last_vk_visibility_request(
      const ::ui::mojom::TextInputStatePtr& input) {
    return input->last_vk_visibility_request;
  }

  static const decltype(::ui::mojom::TextInputState::ime_text_spans_info)& ime_text_spans_info(
      const ::ui::mojom::TextInputStatePtr& input) {
    return input->ime_text_spans_info;
  }

  static bool Read(::ui::mojom::TextInputState::DataView input, ::ui::mojom::TextInputStatePtr* output);
};

}  // namespace mojo

#endif  // UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_H_