// ui/events/mojom/event_latency_metadata.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_EVENTS_MOJOM_EVENT_LATENCY_METADATA_MOJOM_H_
#define UI_EVENTS_MOJOM_EVENT_LATENCY_METADATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/events/mojom/event_latency_metadata.mojom-features.h"  // IWYU pragma: export
#include "ui/events/mojom/event_latency_metadata.mojom-shared.h"  // IWYU pragma: export
#include "ui/events/mojom/event_latency_metadata.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>




#include "ui/events/mojom/event_latency_metadata_mojom_traits.h"




namespace ui::mojom {








class  EventLatencyMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EventLatencyMetadata, T>::value>;
  using DataView = EventLatencyMetadataDataView;
  using Data_ = internal::EventLatencyMetadata_Data;

  template <typename... Args>
  static EventLatencyMetadataPtr New(Args&&... args) {
    return EventLatencyMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EventLatencyMetadataPtr From(const U& u) {
    return mojo::TypeConverter<EventLatencyMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EventLatencyMetadata>::Convert(*this);
  }


  EventLatencyMetadata();

  EventLatencyMetadata(
      ::base::TimeTicks arrived_in_browser_main_timestamp,
      ::base::TimeTicks scrolls_blocking_touch_dispatched_to_renderer,
      ::base::TimeTicks dispatched_to_renderer);


  ~EventLatencyMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EventLatencyMetadataPtr>
  EventLatencyMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EventLatencyMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EventLatencyMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EventLatencyMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EventLatencyMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EventLatencyMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EventLatencyMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EventLatencyMetadata_UnserializedMessageContext<
            UserType, EventLatencyMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EventLatencyMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EventLatencyMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EventLatencyMetadata_UnserializedMessageContext<
            UserType, EventLatencyMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EventLatencyMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeTicks arrived_in_browser_main_timestamp;
  
  ::base::TimeTicks scrolls_blocking_touch_dispatched_to_renderer;
  
  ::base::TimeTicks dispatched_to_renderer;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EventLatencyMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EventLatencyMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EventLatencyMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EventLatencyMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
EventLatencyMetadataPtr EventLatencyMetadata::Clone() const {
  return New(
      mojo::Clone(arrived_in_browser_main_timestamp),
      mojo::Clone(scrolls_blocking_touch_dispatched_to_renderer),
      mojo::Clone(dispatched_to_renderer)
  );
}

template <typename T, EventLatencyMetadata::EnableIfSame<T>*>
bool EventLatencyMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->arrived_in_browser_main_timestamp, other_struct.arrived_in_browser_main_timestamp))
    return false;
  if (!mojo::Equals(this->scrolls_blocking_touch_dispatched_to_renderer, other_struct.scrolls_blocking_touch_dispatched_to_renderer))
    return false;
  if (!mojo::Equals(this->dispatched_to_renderer, other_struct.dispatched_to_renderer))
    return false;
  return true;
}

template <typename T, EventLatencyMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.arrived_in_browser_main_timestamp < rhs.arrived_in_browser_main_timestamp)
    return true;
  if (rhs.arrived_in_browser_main_timestamp < lhs.arrived_in_browser_main_timestamp)
    return false;
  if (lhs.scrolls_blocking_touch_dispatched_to_renderer < rhs.scrolls_blocking_touch_dispatched_to_renderer)
    return true;
  if (rhs.scrolls_blocking_touch_dispatched_to_renderer < lhs.scrolls_blocking_touch_dispatched_to_renderer)
    return false;
  if (lhs.dispatched_to_renderer < rhs.dispatched_to_renderer)
    return true;
  if (rhs.dispatched_to_renderer < lhs.dispatched_to_renderer)
    return false;
  return false;
}


}  // ui::mojom

namespace mojo {


template <>
struct  StructTraits<::ui::mojom::EventLatencyMetadata::DataView,
                                         ::ui::mojom::EventLatencyMetadataPtr> {
  static bool IsNull(const ::ui::mojom::EventLatencyMetadataPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::EventLatencyMetadataPtr* output) { output->reset(); }

  static const decltype(::ui::mojom::EventLatencyMetadata::arrived_in_browser_main_timestamp)& arrived_in_browser_main_timestamp(
      const ::ui::mojom::EventLatencyMetadataPtr& input) {
    return input->arrived_in_browser_main_timestamp;
  }

  static const decltype(::ui::mojom::EventLatencyMetadata::scrolls_blocking_touch_dispatched_to_renderer)& scrolls_blocking_touch_dispatched_to_renderer(
      const ::ui::mojom::EventLatencyMetadataPtr& input) {
    return input->scrolls_blocking_touch_dispatched_to_renderer;
  }

  static const decltype(::ui::mojom::EventLatencyMetadata::dispatched_to_renderer)& dispatched_to_renderer(
      const ::ui::mojom::EventLatencyMetadataPtr& input) {
    return input->dispatched_to_renderer;
  }

  static bool Read(::ui::mojom::EventLatencyMetadata::DataView input, ::ui::mojom::EventLatencyMetadataPtr* output);
};

}  // namespace mojo

#endif  // UI_EVENTS_MOJOM_EVENT_LATENCY_METADATA_MOJOM_H_