// ui/gfx/mojom/ca_layer_params.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_CA_LAYER_PARAMS_MOJOM_DATA_VIEW_H_
#define UI_GFX_MOJOM_CA_LAYER_PARAMS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/gfx/mojom/ca_layer_params.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace gfx::mojom {
class CALayerParamsDataView;

class CALayerContentDataView;


}  // gfx::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::CALayerParamsDataView> {
  using Data = ::gfx::mojom::internal::CALayerParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gfx::mojom::CALayerContentDataView> {
  using Data = ::gfx::mojom::internal::CALayerContent_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace gfx::mojom {


class CALayerParamsDataView {
 public:
  CALayerParamsDataView() = default;

  CALayerParamsDataView(
      internal::CALayerParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool is_empty() const {
    return data_->is_empty;
  }
  inline void GetContentDataView(
      CALayerContentDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContent(UserType* output) {
    
    auto* pointer = !data_->content.is_null() ? &data_->content : nullptr;
    return mojo::internal::Deserialize<::gfx::mojom::CALayerContentDataView>(
        pointer, output, message_);
  }
  inline void GetPixelSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPixelSize(UserType* output) {
    
    auto* pointer = data_->pixel_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  float scale_factor() const {
    return data_->scale_factor;
  }
 private:
  internal::CALayerParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CALayerContentDataView {
 public:
  using Tag = internal::CALayerContent_Data::CALayerContent_Tag;

  CALayerContentDataView() = default;

  CALayerContentDataView(
      internal::CALayerContent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_ca_context_id() const { return data_->tag == Tag::kCaContextId; }
  uint32_t ca_context_id() const {
    CHECK(is_ca_context_id());
    return data_->data.f_ca_context_id;
  }
  bool is_io_surface_mach_port() const { return data_->tag == Tag::kIoSurfaceMachPort; }
  mojo::PlatformHandle TakeIoSurfaceMachPort() {
    CHECK(is_io_surface_mach_port());
    mojo::PlatformHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::PlatformHandle>(
            &data_->data.f_io_surface_mach_port, &result, message_);
    CHECK(ret);
    return result;
  }

 private:
  internal::CALayerContent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // gfx::mojom

#endif  // UI_GFX_MOJOM_CA_LAYER_PARAMS_MOJOM_DATA_VIEW_H_