// ui/gfx/mojom/linear_gradient.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/gfx/mojom/linear_gradient.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gfx/mojom/linear_gradient.mojom-params-data.h"
#include "ui/gfx/mojom/linear_gradient.mojom-shared-message-ids.h"

#include "ui/gfx/mojom/linear_gradient.mojom-import-headers.h"
#include "ui/gfx/mojom/linear_gradient.mojom-test-utils.h"


namespace gfx::mojom {
Step::Step()
    : fraction(),
      alpha() {}

Step::Step(
    float fraction_in,
    uint8_t alpha_in)
    : fraction(std::move(fraction_in)),
      alpha(std::move(alpha_in)) {}

Step::~Step() = default;
size_t Step::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->fraction);
  seed = mojo::internal::Hash(seed, this->alpha);
  return seed;
}

void Step::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fraction"), this->fraction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpha"), this->alpha,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Step::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LinearGradient::LinearGradient()
    : angle(0),
      step_count(0U),
      steps() {}

LinearGradient::LinearGradient(
    int16_t angle_in,
    uint8_t step_count_in,
    std::vector<StepPtr> steps_in)
    : angle(std::move(angle_in)),
      step_count(std::move(step_count_in)),
      steps(std::move(steps_in)) {}

LinearGradient::~LinearGradient() = default;

void LinearGradient::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "angle"), this->angle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "step_count"), this->step_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "steps"), this->steps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<StepPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LinearGradient::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // gfx::mojom


namespace mojo {


// static
bool StructTraits<::gfx::mojom::Step::DataView, ::gfx::mojom::StepPtr>::Read(
    ::gfx::mojom::Step::DataView input,
    ::gfx::mojom::StepPtr* output) {
  bool success = true;
  ::gfx::mojom::StepPtr result(::gfx::mojom::Step::New());
  
      if (success)
        result->fraction = input.fraction();
      if (success)
        result->alpha = input.alpha();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::gfx::mojom::LinearGradient::DataView, ::gfx::mojom::LinearGradientPtr>::Read(
    ::gfx::mojom::LinearGradient::DataView input,
    ::gfx::mojom::LinearGradientPtr* output) {
  bool success = true;
  ::gfx::mojom::LinearGradientPtr result(::gfx::mojom::LinearGradient::New());
  
      if (success)
        result->angle = input.angle();
      if (success)
        result->step_count = input.step_count();
      if (success && !input.ReadSteps(&result->steps))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace gfx::mojom {




}  // gfx::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif