// ui/gfx/mojom/selection_bound.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_SELECTION_BOUND_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_SELECTION_BOUND_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/selection_bound.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"




#include "ui/gfx/mojom/selection_bound.mojom-data-view.h"




namespace std {

template <>
struct hash<::gfx::mojom::SelectionBoundType>
    : public mojo::internal::EnumHashImpl<::gfx::mojom::SelectionBoundType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::SelectionBoundType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gfx::mojom::SelectionBoundType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gfx::mojom::SelectionBoundType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::SelectionBoundDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::SelectionBoundDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::SelectionBound_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::gfx::mojom::SelectionBoundType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::edge_start(input)) in_edge_start = Traits::edge_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->edge_start)::BaseType> edge_start_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_edge_start,
      edge_start_fragment);

    fragment->edge_start.Set(
        edge_start_fragment.is_null() ? nullptr : edge_start_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->edge_start.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null edge_start in SelectionBound struct");

    decltype(Traits::edge_end(input)) in_edge_end = Traits::edge_end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->edge_end)::BaseType> edge_end_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_edge_end,
      edge_end_fragment);

    fragment->edge_end.Set(
        edge_end_fragment.is_null() ? nullptr : edge_end_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->edge_end.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null edge_end in SelectionBound struct");

    decltype(Traits::visible_edge_start(input)) in_visible_edge_start = Traits::visible_edge_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visible_edge_start)::BaseType> visible_edge_start_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_visible_edge_start,
      visible_edge_start_fragment);

    fragment->visible_edge_start.Set(
        visible_edge_start_fragment.is_null() ? nullptr : visible_edge_start_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visible_edge_start.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visible_edge_start in SelectionBound struct");

    decltype(Traits::visible_edge_end(input)) in_visible_edge_end = Traits::visible_edge_end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visible_edge_end)::BaseType> visible_edge_end_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_visible_edge_end,
      visible_edge_end_fragment);

    fragment->visible_edge_end.Set(
        visible_edge_end_fragment.is_null() ? nullptr : visible_edge_end_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visible_edge_end.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visible_edge_end in SelectionBound struct");

    fragment->visible = Traits::visible(input);
  }

  static bool Deserialize(::gfx::mojom::internal::SelectionBound_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::SelectionBoundDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx::mojom {

inline void SelectionBoundDataView::GetEdgeStartDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->edge_start.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void SelectionBoundDataView::GetEdgeEndDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->edge_end.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void SelectionBoundDataView::GetVisibleEdgeStartDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->visible_edge_start.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void SelectionBoundDataView::GetVisibleEdgeEndDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->visible_edge_end.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}



}  // gfx::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::gfx::mojom::SelectionBoundType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gfx::mojom::SelectionBoundType value);
};

} // namespace perfetto

#endif  // UI_GFX_MOJOM_SELECTION_BOUND_MOJOM_SHARED_H_