// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_PUBLIC_BROWSER_MEDIA_PLAYER_ID_H_
#define CONTENT_PUBLIC_BROWSER_MEDIA_PLAYER_ID_H_

#include "content/common/content_export.h"
#include "content/public/browser/global_routing_id.h"

namespace content {

struct CONTENT_EXPORT MediaPlayerId {
  static MediaPlayerId CreateMediaPlayerIdForTests();
  MediaPlayerId() = delete;

  // Construct a MediaPlayerId with the given routing and player IDs.
  // `routing_id` is the ID of the RenderFrameHost that contains this player.
  // `player_id` is a per-RenderFrameHost-unique ID generated by Blink for the
  // player.
  MediaPlayerId(GlobalRenderFrameHostId routing_id, int player_id);
  bool operator==(const MediaPlayerId&) const;
  bool operator!=(const MediaPlayerId&) const;
  bool operator<(const MediaPlayerId&) const;

  GlobalRenderFrameHostId frame_routing_id;
  int player_id;
};

}  // namespace content

#endif  // CONTENT_PUBLIC_BROWSER_MEDIA_PLAYER_ID_H_
