
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_misc.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

static PyTypeObject GUID_Type;
static PyTypeObject ndr_syntax_id_Type;
static PyTypeObject policy_handle_Type;
static PyTypeObject winreg_Data_Type;
static PyTypeObject winreg_Data_GPO_Type;

static PyTypeObject *BaseObject_Type;
#include "librpc/ndr/py_misc.c"


static PyObject *py_GUID_get_time_low(PyObject *obj, void *closure)
{
	struct GUID *object = pytalloc_get_ptr(obj);
	PyObject *py_time_low;
	py_time_low = PyLong_FromUnsignedLongLong((uint32_t)(object->time_low));
	return py_time_low;
}

static int py_GUID_set_time_low(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GUID *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->time_low");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->time_low));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->time_low = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GUID_get_time_mid(PyObject *obj, void *closure)
{
	struct GUID *object = pytalloc_get_ptr(obj);
	PyObject *py_time_mid;
	py_time_mid = PyLong_FromLong((uint16_t)(object->time_mid));
	return py_time_mid;
}

static int py_GUID_set_time_mid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GUID *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->time_mid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->time_mid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->time_mid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GUID_get_time_hi_and_version(PyObject *obj, void *closure)
{
	struct GUID *object = pytalloc_get_ptr(obj);
	PyObject *py_time_hi_and_version;
	py_time_hi_and_version = PyLong_FromLong((uint16_t)(object->time_hi_and_version));
	return py_time_hi_and_version;
}

static int py_GUID_set_time_hi_and_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GUID *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->time_hi_and_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->time_hi_and_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->time_hi_and_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_GUID_get_clock_seq(PyObject *obj, void *closure)
{
	struct GUID *object = pytalloc_get_ptr(obj);
	PyObject *py_clock_seq;
	py_clock_seq = PyList_New(2);
	if (py_clock_seq == NULL) {
		return NULL;
	}
	{
		int clock_seq_cntr_0;
		for (clock_seq_cntr_0 = 0; clock_seq_cntr_0 < (2); clock_seq_cntr_0++) {
			PyObject *py_clock_seq_0;
			py_clock_seq_0 = PyLong_FromLong((uint16_t)((object->clock_seq)[clock_seq_cntr_0]));
			PyList_SetItem(py_clock_seq, clock_seq_cntr_0, py_clock_seq_0);
		}
	}
	return py_clock_seq;
}

static int py_GUID_set_clock_seq(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GUID *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->clock_seq");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int clock_seq_cntr_0;
		if (ARRAY_SIZE(object->clock_seq) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->clock_seq),  PyList_GET_SIZE(value));
			return -1;
		}
		for (clock_seq_cntr_0 = 0; clock_seq_cntr_0 < PyList_GET_SIZE(value); clock_seq_cntr_0++) {
			if (PyList_GET_ITEM(value, clock_seq_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->clock_seq)[clock_seq_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->clock_seq)[clock_seq_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, clock_seq_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, clock_seq_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->clock_seq)[clock_seq_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_GUID_get_node(PyObject *obj, void *closure)
{
	struct GUID *object = pytalloc_get_ptr(obj);
	PyObject *py_node;
	py_node = PyList_New(6);
	if (py_node == NULL) {
		return NULL;
	}
	{
		int node_cntr_0;
		for (node_cntr_0 = 0; node_cntr_0 < (6); node_cntr_0++) {
			PyObject *py_node_0;
			py_node_0 = PyLong_FromLong((uint16_t)((object->node)[node_cntr_0]));
			PyList_SetItem(py_node, node_cntr_0, py_node_0);
		}
	}
	return py_node;
}

static int py_GUID_set_node(PyObject *py_obj, PyObject *value, void *closure)
{
	struct GUID *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->node");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int node_cntr_0;
		if (ARRAY_SIZE(object->node) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->node),  PyList_GET_SIZE(value));
			return -1;
		}
		for (node_cntr_0 = 0; node_cntr_0 < PyList_GET_SIZE(value); node_cntr_0++) {
			if (PyList_GET_ITEM(value, node_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->node)[node_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->node)[node_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, node_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, node_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->node)[node_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_GUID_getsetters[] = {
	{
		.name = discard_const_p(char, "time_low"),
		.get = py_GUID_get_time_low,
		.set = py_GUID_set_time_low,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "time_mid"),
		.get = py_GUID_get_time_mid,
		.set = py_GUID_set_time_mid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "time_hi_and_version"),
		.get = py_GUID_get_time_hi_and_version,
		.set = py_GUID_set_time_hi_and_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "clock_seq"),
		.get = py_GUID_get_clock_seq,
		.set = py_GUID_set_clock_seq,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "node"),
		.get = py_GUID_get_node,
		.set = py_GUID_set_node,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_GUID_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct GUID, type);
}

static PyObject *py_GUID_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct GUID *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_GUID);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_GUID_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct GUID *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_GUID);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_GUID);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_GUID_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct GUID *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_GUID, "GUID", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_GUID, "GUID", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_GUID_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_GUID_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_GUID_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_GUID_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject GUID_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "misc.GUID",
	.tp_getset = py_GUID_getsetters,
	.tp_methods = py_GUID_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_GUID_new,
};


static PyObject *py_ndr_syntax_id_get_uuid(PyObject *obj, void *closure)
{
	struct ndr_syntax_id *object = pytalloc_get_ptr(obj);
	PyObject *py_uuid;
	py_uuid = pytalloc_reference_ex(&GUID_Type, pytalloc_get_mem_ctx(obj), &object->uuid);
	return py_uuid;
}

static int py_ndr_syntax_id_set_uuid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ndr_syntax_id *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->uuid");
		return -1;
	}
	PY_CHECK_TYPE(&GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->uuid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_ndr_syntax_id_get_if_version(PyObject *obj, void *closure)
{
	struct ndr_syntax_id *object = pytalloc_get_ptr(obj);
	PyObject *py_if_version;
	py_if_version = PyLong_FromUnsignedLongLong((uint32_t)(object->if_version));
	return py_if_version;
}

static int py_ndr_syntax_id_set_if_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ndr_syntax_id *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->if_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->if_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->if_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_ndr_syntax_id_getsetters[] = {
	{
		.name = discard_const_p(char, "uuid"),
		.get = py_ndr_syntax_id_get_uuid,
		.set = py_ndr_syntax_id_set_uuid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "if_version"),
		.get = py_ndr_syntax_id_get_if_version,
		.set = py_ndr_syntax_id_set_if_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_ndr_syntax_id_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ndr_syntax_id, type);
}

static PyObject *py_ndr_syntax_id_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct ndr_syntax_id *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_ndr_syntax_id);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_ndr_syntax_id_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ndr_syntax_id *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ndr_syntax_id);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ndr_syntax_id);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ndr_syntax_id_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ndr_syntax_id *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ndr_syntax_id, "ndr_syntax_id", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ndr_syntax_id, "ndr_syntax_id", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ndr_syntax_id_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ndr_syntax_id_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ndr_syntax_id_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ndr_syntax_id_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ndr_syntax_id_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "misc.ndr_syntax_id",
	.tp_getset = py_ndr_syntax_id_getsetters,
	.tp_methods = py_ndr_syntax_id_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ndr_syntax_id_new,
};


static PyObject *py_policy_handle_get_handle_type(PyObject *obj, void *closure)
{
	struct policy_handle *object = pytalloc_get_ptr(obj);
	PyObject *py_handle_type;
	py_handle_type = PyLong_FromUnsignedLongLong((uint32_t)(object->handle_type));
	return py_handle_type;
}

static int py_policy_handle_set_handle_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct policy_handle *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->handle_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->handle_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->handle_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_policy_handle_get_uuid(PyObject *obj, void *closure)
{
	struct policy_handle *object = pytalloc_get_ptr(obj);
	PyObject *py_uuid;
	py_uuid = pytalloc_reference_ex(&GUID_Type, pytalloc_get_mem_ctx(obj), &object->uuid);
	return py_uuid;
}

static int py_policy_handle_set_uuid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct policy_handle *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->uuid");
		return -1;
	}
	PY_CHECK_TYPE(&GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->uuid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_policy_handle_getsetters[] = {
	{
		.name = discard_const_p(char, "handle_type"),
		.get = py_policy_handle_get_handle_type,
		.set = py_policy_handle_set_handle_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "uuid"),
		.get = py_policy_handle_get_uuid,
		.set = py_policy_handle_set_uuid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{ .name = NULL }
};

static PyObject *py_policy_handle_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct policy_handle, type);
}

static PyObject *py_policy_handle_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct policy_handle *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_policy_handle);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_policy_handle_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct policy_handle *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_policy_handle);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_policy_handle);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_policy_handle_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct policy_handle *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_policy_handle, "policy_handle", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_policy_handle, "policy_handle", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_policy_handle_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_policy_handle_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_policy_handle_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_policy_handle_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject policy_handle_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "misc.policy_handle",
	.tp_getset = py_policy_handle_getsetters,
	.tp_methods = py_policy_handle_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_policy_handle_new,
};

static PyObject *py_import_winreg_Data(TALLOC_CTX *mem_ctx, int level, union winreg_Data *in)
{
	PyObject *ret;

	switch (level) {
		case REG_NONE:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case REG_SZ:
			ret = PyString_FromStringOrNULL(in->string);
			return ret;

		case REG_EXPAND_SZ:
			ret = PyString_FromStringOrNULL(in->string);
			return ret;

		case REG_BINARY:
			ret = PyBytes_FromStringAndSize((char *)(in->binary).data, (in->binary).length);
			return ret;

		case REG_DWORD:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->value));
			return ret;

		case REG_DWORD_BIG_ENDIAN:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->value));
			return ret;

		case REG_MULTI_SZ:
			ret = pytalloc_GenericObject_reference_ex(mem_ctx, in->string_array);
			return ret;

		case REG_QWORD:
			ret = PyLong_FromUnsignedLongLong(in->qword);
			return ret;

		default:
			ret = PyBytes_FromStringAndSize((char *)(in->data).data, (in->data).length);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union winreg_Data *py_export_winreg_Data(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union winreg_Data *ret = talloc_zero(mem_ctx, union winreg_Data);
	switch (level) {
		case REG_NONE:
			break;

		case REG_SZ:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->string");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->string = talloc_str;
			}
			break;

		case REG_EXPAND_SZ:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->string");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->string = talloc_str;
			}
			break;

		case REG_BINARY:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->binary");
				talloc_free(ret); return NULL;
			}
			ret->binary = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			break;

		case REG_DWORD:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->value");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->value));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->value = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case REG_DWORD_BIG_ENDIAN:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->value");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->value));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->value = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case REG_MULTI_SZ:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->string_array");
				talloc_free(ret); return NULL;
			}
			ret->string_array = pytalloc_get_ptr(in);
			break;

		case REG_QWORD:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->qword");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->qword));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->qword = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->data");
				talloc_free(ret); return NULL;
			}
			ret->data = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			break;

	}

	return ret;
}

static PyObject *py_winreg_Data_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union winreg_Data *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union winreg_Data *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union winreg_Data!");
		return NULL;
	}

	return py_import_winreg_Data(mem_ctx, level, in);
}

static PyObject *py_winreg_Data_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union winreg_Data *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_winreg_Data(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_winreg_Data_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_Data_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_Data_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_winreg_Data_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject winreg_Data_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "misc.winreg_Data",
	.tp_getset = NULL,
	.tp_methods = py_winreg_Data_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_Data_new,
};

static PyObject *py_import_winreg_Data_GPO(TALLOC_CTX *mem_ctx, int level, union winreg_Data_GPO *in)
{
	PyObject *ret;

	switch (level) {
		case REG_NONE:
			ret = Py_None;
			Py_INCREF(ret);
			return ret;

		case REG_SZ:
			ret = PyString_FromStringOrNULL(in->string);
			return ret;

		case REG_EXPAND_SZ:
			ret = PyString_FromStringOrNULL(in->string);
			return ret;

		case REG_BINARY:
			ret = PyBytes_FromStringAndSize((char *)(in->binary).data, (in->binary).length);
			return ret;

		case REG_DWORD:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->value));
			return ret;

		case REG_DWORD_BIG_ENDIAN:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->value));
			return ret;

		case REG_QWORD:
			ret = PyLong_FromUnsignedLongLong(in->qword);
			return ret;

		default:
			ret = PyBytes_FromStringAndSize((char *)(in->data).data, (in->data).length);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union winreg_Data_GPO *py_export_winreg_Data_GPO(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union winreg_Data_GPO *ret = talloc_zero(mem_ctx, union winreg_Data_GPO);
	switch (level) {
		case REG_NONE:
			break;

		case REG_SZ:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->string");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->string = talloc_str;
			}
			break;

		case REG_EXPAND_SZ:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->string");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->string = talloc_str;
			}
			break;

		case REG_BINARY:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->binary");
				talloc_free(ret); return NULL;
			}
			ret->binary = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			break;

		case REG_DWORD:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->value");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->value));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->value = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case REG_DWORD_BIG_ENDIAN:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->value");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->value));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->value = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case REG_QWORD:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->qword");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->qword));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->qword = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->data");
				talloc_free(ret); return NULL;
			}
			ret->data = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			break;

	}

	return ret;
}

static PyObject *py_winreg_Data_GPO_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union winreg_Data_GPO *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union winreg_Data_GPO *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union winreg_Data_GPO!");
		return NULL;
	}

	return py_import_winreg_Data_GPO(mem_ctx, level, in);
}

static PyObject *py_winreg_Data_GPO_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union winreg_Data_GPO *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_winreg_Data_GPO(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_winreg_Data_GPO_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_Data_GPO_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_winreg_Data_GPO_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_winreg_Data_GPO_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject winreg_Data_GPO_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "misc.winreg_Data_GPO",
	.tp_getset = NULL,
	.tp_methods = py_winreg_Data_GPO_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_winreg_Data_GPO_new,
};

static PyMethodDef misc_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "misc",
	.m_doc = "misc DCE/RPC",
	.m_size = -1,
	.m_methods = misc_methods,
};
MODULE_INIT_FUNC(misc)
{
	PyObject *m = NULL;
	PyObject *dep_talloc = NULL;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	GUID_Type.tp_base = BaseObject_Type;
	GUID_Type.tp_basicsize = pytalloc_BaseObject_size();

	ndr_syntax_id_Type.tp_base = BaseObject_Type;
	ndr_syntax_id_Type.tp_basicsize = pytalloc_BaseObject_size();

	policy_handle_Type.tp_base = BaseObject_Type;
	policy_handle_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_Data_Type.tp_base = BaseObject_Type;
	winreg_Data_Type.tp_basicsize = pytalloc_BaseObject_size();

	winreg_Data_GPO_Type.tp_base = BaseObject_Type;
	winreg_Data_GPO_Type.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&GUID_Type) < 0)
		goto out;
	if (PyType_Ready(&ndr_syntax_id_Type) < 0)
		goto out;
	if (PyType_Ready(&policy_handle_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_Data_Type) < 0)
		goto out;
	if (PyType_Ready(&winreg_Data_GPO_Type) < 0)
		goto out;
#ifdef PY_GUID_PATCH
	PY_GUID_PATCH(&GUID_Type);
#endif
#ifdef PY_NDR_SYNTAX_ID_PATCH
	PY_NDR_SYNTAX_ID_PATCH(&ndr_syntax_id_Type);
#endif
#ifdef PY_POLICY_HANDLE_PATCH
	PY_POLICY_HANDLE_PATCH(&policy_handle_Type);
#endif
#ifdef PY_WINREG_DATA_PATCH
	PY_WINREG_DATA_PATCH(&winreg_Data_Type);
#endif
#ifdef PY_WINREG_DATA_GPO_PATCH
	PY_WINREG_DATA_GPO_PATCH(&winreg_Data_GPO_Type);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "SV_TYPE_ALL", PyLong_FromUnsignedLongLong(0xFFFFFFFF));
	PyModule_AddObject(m, "SEC_CHAN_NULL", PyLong_FromLong((uint16_t)(SEC_CHAN_NULL)));
	PyModule_AddObject(m, "SEC_CHAN_LOCAL", PyLong_FromLong((uint16_t)(SEC_CHAN_LOCAL)));
	PyModule_AddObject(m, "SEC_CHAN_WKSTA", PyLong_FromLong((uint16_t)(SEC_CHAN_WKSTA)));
	PyModule_AddObject(m, "SEC_CHAN_DNS_DOMAIN", PyLong_FromLong((uint16_t)(SEC_CHAN_DNS_DOMAIN)));
	PyModule_AddObject(m, "SEC_CHAN_DOMAIN", PyLong_FromLong((uint16_t)(SEC_CHAN_DOMAIN)));
	PyModule_AddObject(m, "SEC_CHAN_LANMAN", PyLong_FromLong((uint16_t)(SEC_CHAN_LANMAN)));
	PyModule_AddObject(m, "SEC_CHAN_BDC", PyLong_FromLong((uint16_t)(SEC_CHAN_BDC)));
	PyModule_AddObject(m, "SEC_CHAN_RODC", PyLong_FromLong((uint16_t)(SEC_CHAN_RODC)));
	PyModule_AddObject(m, "REG_NONE", PyLong_FromUnsignedLongLong((uint32_t)(REG_NONE)));
	PyModule_AddObject(m, "REG_SZ", PyLong_FromUnsignedLongLong((uint32_t)(REG_SZ)));
	PyModule_AddObject(m, "REG_EXPAND_SZ", PyLong_FromUnsignedLongLong((uint32_t)(REG_EXPAND_SZ)));
	PyModule_AddObject(m, "REG_BINARY", PyLong_FromUnsignedLongLong((uint32_t)(REG_BINARY)));
	PyModule_AddObject(m, "REG_DWORD", PyLong_FromUnsignedLongLong((uint32_t)(REG_DWORD)));
	PyModule_AddObject(m, "REG_DWORD_BIG_ENDIAN", PyLong_FromUnsignedLongLong((uint32_t)(REG_DWORD_BIG_ENDIAN)));
	PyModule_AddObject(m, "REG_LINK", PyLong_FromUnsignedLongLong((uint32_t)(REG_LINK)));
	PyModule_AddObject(m, "REG_MULTI_SZ", PyLong_FromUnsignedLongLong((uint32_t)(REG_MULTI_SZ)));
	PyModule_AddObject(m, "REG_RESOURCE_LIST", PyLong_FromUnsignedLongLong((uint32_t)(REG_RESOURCE_LIST)));
	PyModule_AddObject(m, "REG_FULL_RESOURCE_DESCRIPTOR", PyLong_FromUnsignedLongLong((uint32_t)(REG_FULL_RESOURCE_DESCRIPTOR)));
	PyModule_AddObject(m, "REG_RESOURCE_REQUIREMENTS_LIST", PyLong_FromUnsignedLongLong((uint32_t)(REG_RESOURCE_REQUIREMENTS_LIST)));
	PyModule_AddObject(m, "REG_QWORD", PyLong_FromUnsignedLongLong((uint32_t)(REG_QWORD)));
	PyModule_AddObject(m, "SAM_DATABASE_DOMAIN", PyLong_FromUnsignedLongLong((uint32_t)(SAM_DATABASE_DOMAIN)));
	PyModule_AddObject(m, "SAM_DATABASE_BUILTIN", PyLong_FromUnsignedLongLong((uint32_t)(SAM_DATABASE_BUILTIN)));
	PyModule_AddObject(m, "SAM_DATABASE_PRIVS", PyLong_FromUnsignedLongLong((uint32_t)(SAM_DATABASE_PRIVS)));
	PyModule_AddObject(m, "SV_TYPE_WORKSTATION", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_WORKSTATION)));
	PyModule_AddObject(m, "SV_TYPE_SERVER", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_SERVER)));
	PyModule_AddObject(m, "SV_TYPE_SQLSERVER", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_SQLSERVER)));
	PyModule_AddObject(m, "SV_TYPE_DOMAIN_CTRL", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_DOMAIN_CTRL)));
	PyModule_AddObject(m, "SV_TYPE_DOMAIN_BAKCTRL", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_DOMAIN_BAKCTRL)));
	PyModule_AddObject(m, "SV_TYPE_TIME_SOURCE", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_TIME_SOURCE)));
	PyModule_AddObject(m, "SV_TYPE_AFP", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_AFP)));
	PyModule_AddObject(m, "SV_TYPE_NOVELL", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_NOVELL)));
	PyModule_AddObject(m, "SV_TYPE_DOMAIN_MEMBER", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_DOMAIN_MEMBER)));
	PyModule_AddObject(m, "SV_TYPE_PRINTQ_SERVER", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_PRINTQ_SERVER)));
	PyModule_AddObject(m, "SV_TYPE_DIALIN_SERVER", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_DIALIN_SERVER)));
	PyModule_AddObject(m, "SV_TYPE_SERVER_UNIX", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_SERVER_UNIX)));
	PyModule_AddObject(m, "SV_TYPE_NT", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_NT)));
	PyModule_AddObject(m, "SV_TYPE_WFW", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_WFW)));
	PyModule_AddObject(m, "SV_TYPE_SERVER_MFPN", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_SERVER_MFPN)));
	PyModule_AddObject(m, "SV_TYPE_SERVER_NT", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_SERVER_NT)));
	PyModule_AddObject(m, "SV_TYPE_POTENTIAL_BROWSER", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_POTENTIAL_BROWSER)));
	PyModule_AddObject(m, "SV_TYPE_BACKUP_BROWSER", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_BACKUP_BROWSER)));
	PyModule_AddObject(m, "SV_TYPE_MASTER_BROWSER", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_MASTER_BROWSER)));
	PyModule_AddObject(m, "SV_TYPE_DOMAIN_MASTER", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_DOMAIN_MASTER)));
	PyModule_AddObject(m, "SV_TYPE_SERVER_OSF", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_SERVER_OSF)));
	PyModule_AddObject(m, "SV_TYPE_SERVER_VMS", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_SERVER_VMS)));
	PyModule_AddObject(m, "SV_TYPE_WIN95_PLUS", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_WIN95_PLUS)));
	PyModule_AddObject(m, "SV_TYPE_DFS_SERVER", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_DFS_SERVER)));
	PyModule_AddObject(m, "SV_TYPE_ALTERNATE_XPORT", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_ALTERNATE_XPORT)));
	PyModule_AddObject(m, "SV_TYPE_LOCAL_LIST_ONLY", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_LOCAL_LIST_ONLY)));
	PyModule_AddObject(m, "SV_TYPE_DOMAIN_ENUM", PyLong_FromUnsignedLongLong((uint32_t)(SV_TYPE_DOMAIN_ENUM)));
	Py_INCREF((PyObject *)(void *)&GUID_Type);
	PyModule_AddObject(m, "GUID", (PyObject *)(void *)&GUID_Type);
	Py_INCREF((PyObject *)(void *)&ndr_syntax_id_Type);
	PyModule_AddObject(m, "ndr_syntax_id", (PyObject *)(void *)&ndr_syntax_id_Type);
	Py_INCREF((PyObject *)(void *)&policy_handle_Type);
	PyModule_AddObject(m, "policy_handle", (PyObject *)(void *)&policy_handle_Type);
	Py_INCREF((PyObject *)(void *)&winreg_Data_Type);
	PyModule_AddObject(m, "winreg_Data", (PyObject *)(void *)&winreg_Data_Type);
	Py_INCREF((PyObject *)(void *)&winreg_Data_GPO_Type);
	PyModule_AddObject(m, "winreg_Data_GPO", (PyObject *)(void *)&winreg_Data_GPO_Type);
#ifdef PY_MOD_MISC_PATCH
	PY_MOD_MISC_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_talloc);
	return m;

}
