/* book-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from book-view.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* FIXME: When scrolling, copy existing render sideways?*/
/* FIXME: Only render pages that change and only the part that changed*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BOOK_VIEW (book_view_get_type ())
#define BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK_VIEW, BookView))
#define BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK_VIEW, BookViewClass))
#define IS_BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK_VIEW))
#define IS_BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK_VIEW))
#define BOOK_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK_VIEW, BookViewClass))

typedef struct _BookView BookView;
typedef struct _BookViewClass BookViewClass;
typedef struct _BookViewPrivate BookViewPrivate;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_PAGE_VIEW (page_view_get_type ())
#define PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_VIEW, PageView))
#define PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_VIEW, PageViewClass))
#define IS_PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_VIEW))
#define IS_PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_VIEW))
#define PAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_VIEW, PageViewClass))

typedef struct _PageView PageView;
typedef struct _PageViewClass PageViewClass;
enum  {
	BOOK_VIEW_0_PROPERTY,
	BOOK_VIEW_BOOK_PROPERTY,
	BOOK_VIEW_SELECTED_PAGE_PROPERTY,
	BOOK_VIEW_X_OFFSET_PROPERTY,
	BOOK_VIEW_NUM_PROPERTIES
};
static GParamSpec* book_view_properties[BOOK_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BOOK_VIEW_PAGE_SELECTED_SIGNAL,
	BOOK_VIEW_SHOW_PAGE_SIGNAL,
	BOOK_VIEW_SHOW_MENU_SIGNAL,
	BOOK_VIEW_NUM_SIGNALS
};
static guint book_view_signals[BOOK_VIEW_NUM_SIGNALS] = {0};

struct _BookView {
	GtkBox parent_instance;
	BookViewPrivate * priv;
};

struct _BookViewClass {
	GtkBoxClass parent_class;
};

struct _BookViewPrivate {
	Book* _book;
	GHashTable* page_data;
	gboolean need_layout;
	gboolean laying_out;
	gboolean show_selected_page;
	PageView* selected_page_view;
	GtkScrolledWindow* scrolled_window;
	GtkDrawingArea* drawing_area;
	gchar* cursor;
	GtkEventControllerMotion* motion_controller;
	GtkEventControllerScroll* cursor_scroll_controller;
	GtkEventControllerKey* key_controller;
	GtkGestureClick* primary_click_gesture;
	GtkGestureClick* secondary_click_gesture;
	GtkEventControllerFocus* focus_controller;
	gint _x_offset;
};

static gint BookView_private_offset;
static gpointer book_view_parent_class = NULL;

VALA_EXTERN GType book_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookView, g_object_unref)
VALA_EXTERN GType book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Book, g_object_unref)
VALA_EXTERN GType page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Page, g_object_unref)
VALA_EXTERN GType page_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageView, g_object_unref)
VALA_EXTERN Book* book_view_get_book (BookView* self);
static void book_view_add_cb (BookView* self,
                       Book* book,
                       Page* page);
static void _book_view_add_cb_book_page_added (Book* _sender,
                                        Page* page,
                                        gpointer self);
static void book_view_remove_cb (BookView* self,
                          Book* book,
                          Page* page);
static void _book_view_remove_cb_book_page_removed (Book* _sender,
                                             Page* page,
                                             gpointer self);
static void book_view_reorder_cb (BookView* self,
                           Book* book);
static void _book_view_reorder_cb_book_reordered (Book* _sender,
                                           gpointer self);
static void book_view_clear_cb (BookView* self,
                         Book* book);
static void _book_view_clear_cb_book_cleared (Book* _sender,
                                       gpointer self);
VALA_EXTERN void book_view_drawing_area_resize_cb (BookView* self);
static void _book_view_drawing_area_resize_cb_gtk_drawing_area_resize (GtkDrawingArea* _sender,
                                                                gint width,
                                                                gint height,
                                                                gpointer self);
static void book_view_motion_cb (BookView* self,
                          GtkEventControllerMotion* controler,
                          gdouble dx,
                          gdouble dy);
static void _book_view_motion_cb_gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                              gdouble x,
                                                              gdouble y,
                                                              gpointer self);
static gboolean book_view_cursor_scroll_cb (BookView* self,
                                     GtkEventControllerScroll* controller,
                                     gdouble dx,
                                     gdouble dy);
static gboolean _book_view_cursor_scroll_cb_gtk_event_controller_scroll_scroll (GtkEventControllerScroll* _sender,
                                                                         gdouble dx,
                                                                         gdouble dy,
                                                                         gpointer self);
static gboolean book_view_key_cb (BookView* self,
                           GtkEventControllerKey* controler,
                           guint keyval,
                           guint keycode,
                           GdkModifierType state);
static gboolean _book_view_key_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                 guint keyval,
                                                                 guint keycode,
                                                                 GdkModifierType state,
                                                                 gpointer self);
static void book_view_primary_pressed_cb (BookView* self,
                                   GtkGestureClick* controler,
                                   gint n_press,
                                   gdouble x,
                                   gdouble y);
static void _book_view_primary_pressed_cb_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                              gint n_press,
                                                              gdouble x,
                                                              gdouble y,
                                                              gpointer self);
static void book_view_primary_released_cb (BookView* self,
                                    GtkGestureClick* controler,
                                    gint n_press,
                                    gdouble x,
                                    gdouble y);
static void _book_view_primary_released_cb_gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                gint n_press,
                                                                gdouble x,
                                                                gdouble y,
                                                                gpointer self);
static void book_view_secondary_pressed_cb (BookView* self,
                                     GtkGestureClick* controler,
                                     gint n_press,
                                     gdouble x,
                                     gdouble y);
static void _book_view_secondary_pressed_cb_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                gint n_press,
                                                                gdouble x,
                                                                gdouble y,
                                                                gpointer self);
static void book_view_secondary_released_cb (BookView* self,
                                      GtkGestureClick* controler,
                                      gint n_press,
                                      gdouble x,
                                      gdouble y);
static void _book_view_secondary_released_cb_gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                  gint n_press,
                                                                  gdouble x,
                                                                  gdouble y,
                                                                  gpointer self);
static void book_view_focus_cb (BookView* self,
                         GtkEventControllerFocus* controler);
static void _book_view_focus_cb_gtk_event_controller_focus_enter (GtkEventControllerFocus* _sender,
                                                           gpointer self);
static void _book_view_focus_cb_gtk_event_controller_focus_leave (GtkEventControllerFocus* _sender,
                                                           gpointer self);
VALA_EXTERN BookView* book_view_new (Book* book);
VALA_EXTERN BookView* book_view_construct (GType object_type,
                               Book* book);
static void book_view_set_book (BookView* self,
                         Book* value);
VALA_EXTERN guint book_get_n_pages (Book* self);
VALA_EXTERN Page* book_get_page (Book* self,
                     gint page_number);
VALA_EXTERN void book_view_set_selected_page (BookView* self,
                                  Page* value);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN void book_view_draw_cb (BookView* self,
                        GtkDrawingArea* drawing_area,
                        cairo_t* context,
                        gint width,
                        gint height);
static void _book_view_draw_cb_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                    cairo_t* cr,
                                                    gint width,
                                                    gint height,
                                                    gpointer self);
static PageView* book_view_get_nth_page (BookView* self,
                                  gint n);
static PageView* book_view_get_next_page (BookView* self,
                                   PageView* page);
VALA_EXTERN Page* page_view_get_page (PageView* self);
static PageView* book_view_get_prev_page (BookView* self,
                                   PageView* page);
static void book_view_page_view_changed_cb (BookView* self,
                                     PageView* page);
VALA_EXTERN void book_view_redraw (BookView* self);
static void book_view_page_view_size_changed_cb (BookView* self,
                                          PageView* page);
VALA_EXTERN PageView* page_view_new (Page* page);
VALA_EXTERN PageView* page_view_construct (GType object_type,
                               Page* page);
static void _book_view_page_view_changed_cb_page_view_changed (PageView* _sender,
                                                        gpointer self);
static void _book_view_page_view_size_changed_cb_page_view_size_changed (PageView* _sender,
                                                                  gpointer self);
static void book_view_set_selected_page_view (BookView* self,
                                       PageView* page);
VALA_EXTERN void page_view_set_selected (PageView* self,
                             gboolean value);
static void book_view_show_page_view (BookView* self,
                               PageView* page);
VALA_EXTERN gint page_view_get_x_offset (PageView* self);
VALA_EXTERN gint page_view_get_width (PageView* self);
VALA_EXTERN gint book_view_get_x_offset (BookView* self);
VALA_EXTERN void book_view_set_x_offset (BookView* self,
                             gint value);
static void book_view_select_page_view (BookView* self,
                                 PageView* page);
VALA_EXTERN Page* book_view_get_selected_page (BookView* self);
static void book_view_layout (BookView* self);
static void book_view_layout_into (BookView* self,
                            gint width,
                            gint height,
                            gint* book_width,
                            gint* book_height);
VALA_EXTERN gint page_get_dpi (Page* self);
VALA_EXTERN gint page_get_width (Page* self);
VALA_EXTERN gint page_get_height (Page* self);
VALA_EXTERN void page_view_set_width (PageView* self,
                          gint value);
VALA_EXTERN void page_view_set_height (PageView* self,
                           gint value);
VALA_EXTERN gint page_view_get_height (PageView* self);
VALA_EXTERN void page_view_set_x_offset (PageView* self,
                             gint value);
VALA_EXTERN void page_view_set_y_offset (PageView* self,
                             gint value);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN void page_view_render (PageView* self,
                       cairo_t* context,
                       GdkRGBA* ruler_color);
VALA_EXTERN gboolean page_view_get_selected (PageView* self);
VALA_EXTERN gint page_view_get_y_offset (PageView* self);
static PageView* book_view_get_page_at (BookView* self,
                                 gint x,
                                 gint y,
                                 gint* x_,
                                 gint* y_);
static void book_view_button_cb (BookView* self,
                          GtkGestureClick* controler,
                          gint button,
                          gboolean press,
                          gint n_press,
                          gdouble dx,
                          gdouble dy);
VALA_EXTERN void page_view_button_press (PageView* self,
                             gint x,
                             gint y);
VALA_EXTERN void page_view_button_release (PageView* self,
                               gint x,
                               gint y);
static void book_view_set_cursor (BookView* self,
                           const gchar* cursor);
VALA_EXTERN void page_view_motion (PageView* self,
                       gint x,
                       gint y);
VALA_EXTERN const gchar* page_view_get_cursor (PageView* self);
VALA_EXTERN void book_view_select_next_page (BookView* self);
VALA_EXTERN void book_view_select_prev_page (BookView* self);
static void g_cclosure_user_marshal_VOID__OBJECT_DOUBLE_DOUBLE (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data);
static void book_view_finalize (GObject * obj);
static GType book_view_get_type_once (void);
static void _vala_book_view_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_book_view_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
book_view_get_instance_private (BookView* self)
{
	return G_STRUCT_MEMBER_P (self, BookView_private_offset);
}

static void
_book_view_add_cb_book_page_added (Book* _sender,
                                   Page* page,
                                   gpointer self)
{
	book_view_add_cb ((BookView*) self, _sender, page);
}

static void
_book_view_remove_cb_book_page_removed (Book* _sender,
                                        Page* page,
                                        gpointer self)
{
	book_view_remove_cb ((BookView*) self, _sender, page);
}

static void
_book_view_reorder_cb_book_reordered (Book* _sender,
                                      gpointer self)
{
	book_view_reorder_cb ((BookView*) self, _sender);
}

static void
_book_view_clear_cb_book_cleared (Book* _sender,
                                  gpointer self)
{
	book_view_clear_cb ((BookView*) self, _sender);
}

static void
_book_view_drawing_area_resize_cb_gtk_drawing_area_resize (GtkDrawingArea* _sender,
                                                           gint width,
                                                           gint height,
                                                           gpointer self)
{
	book_view_drawing_area_resize_cb ((BookView*) self);
}

static void
_book_view_motion_cb_gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                         gdouble x,
                                                         gdouble y,
                                                         gpointer self)
{
	book_view_motion_cb ((BookView*) self, _sender, x, y);
}

static gboolean
_book_view_cursor_scroll_cb_gtk_event_controller_scroll_scroll (GtkEventControllerScroll* _sender,
                                                                gdouble dx,
                                                                gdouble dy,
                                                                gpointer self)
{
	gboolean result;
	result = book_view_cursor_scroll_cb ((BookView*) self, _sender, dx, dy);
	return result;
}

static gboolean
_book_view_key_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                        guint keyval,
                                                        guint keycode,
                                                        GdkModifierType state,
                                                        gpointer self)
{
	gboolean result;
	result = book_view_key_cb ((BookView*) self, _sender, keyval, keycode, state);
	return result;
}

static void
_book_view_primary_pressed_cb_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                         gint n_press,
                                                         gdouble x,
                                                         gdouble y,
                                                         gpointer self)
{
	book_view_primary_pressed_cb ((BookView*) self, _sender, n_press, x, y);
}

static void
_book_view_primary_released_cb_gtk_gesture_click_released (GtkGestureClick* _sender,
                                                           gint n_press,
                                                           gdouble x,
                                                           gdouble y,
                                                           gpointer self)
{
	book_view_primary_released_cb ((BookView*) self, _sender, n_press, x, y);
}

static void
_book_view_secondary_pressed_cb_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                           gint n_press,
                                                           gdouble x,
                                                           gdouble y,
                                                           gpointer self)
{
	book_view_secondary_pressed_cb ((BookView*) self, _sender, n_press, x, y);
}

static void
_book_view_secondary_released_cb_gtk_gesture_click_released (GtkGestureClick* _sender,
                                                             gint n_press,
                                                             gdouble x,
                                                             gdouble y,
                                                             gpointer self)
{
	book_view_secondary_released_cb ((BookView*) self, _sender, n_press, x, y);
}

static void
_book_view_focus_cb_gtk_event_controller_focus_enter (GtkEventControllerFocus* _sender,
                                                      gpointer self)
{
	book_view_focus_cb ((BookView*) self, _sender);
}

static void
_book_view_focus_cb_gtk_event_controller_focus_leave (GtkEventControllerFocus* _sender,
                                                      gpointer self)
{
	book_view_focus_cb ((BookView*) self, _sender);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_book_view_draw_cb_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                               cairo_t* cr,
                                               gint width,
                                               gint height,
                                               gpointer self)
{
	book_view_draw_cb ((BookView*) self, drawing_area, cr, width, height);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BookView*
book_view_construct (GType object_type,
                     Book* book)
{
	BookView * self = NULL;
	Page* _tmp6_;
	Page* _tmp7_;
	GHashFunc _tmp8_;
	GEqualFunc _tmp9_;
	GHashTable* _tmp10_;
	gchar* _tmp11_;
	GtkDrawingArea* _tmp12_;
	GtkDrawingArea* _tmp13_;
	GtkDrawingArea* _tmp14_;
	GtkDrawingArea* _tmp15_;
	GtkDrawingArea* _tmp16_;
	GtkDrawingArea* _tmp17_;
	GtkScrolledWindow* _tmp18_;
	GtkScrolledWindow* _tmp19_;
	GtkScrolledWindow* _tmp20_;
	GtkDrawingArea* _tmp21_;
	GtkScrolledWindow* _tmp22_;
	GtkScrolledWindow* _tmp23_;
	GtkScrolledWindow* _tmp24_;
	GtkDrawingArea* _tmp25_;
	GtkEventControllerMotion* _tmp26_;
	GtkEventControllerMotion* _tmp27_;
	GtkDrawingArea* _tmp28_;
	GtkEventControllerMotion* _tmp29_;
	GtkEventController* _tmp30_;
	GtkEventControllerScroll* _tmp31_;
	GtkEventControllerScroll* _tmp32_;
	GtkDrawingArea* _tmp33_;
	GtkEventControllerScroll* _tmp34_;
	GtkEventController* _tmp35_;
	GtkEventControllerKey* _tmp36_;
	GtkEventControllerKey* _tmp37_;
	GtkDrawingArea* _tmp38_;
	GtkEventControllerKey* _tmp39_;
	GtkEventController* _tmp40_;
	GtkGestureClick* _tmp41_;
	GtkGestureClick* _tmp42_;
	GtkGestureClick* _tmp43_;
	GtkGestureClick* _tmp44_;
	GtkDrawingArea* _tmp45_;
	GtkGestureClick* _tmp46_;
	GtkEventController* _tmp47_;
	GtkGestureClick* _tmp48_;
	GtkGestureClick* _tmp49_;
	GtkGestureClick* _tmp50_;
	GtkGestureClick* _tmp51_;
	GtkDrawingArea* _tmp52_;
	GtkGestureClick* _tmp53_;
	GtkEventController* _tmp54_;
	GtkEventControllerFocus* _tmp55_;
	GtkEventControllerFocus* _tmp56_;
	GtkEventControllerFocus* _tmp57_;
	GtkDrawingArea* _tmp58_;
	GtkEventControllerFocus* _tmp59_;
	GtkEventController* _tmp60_;
	GtkDrawingArea* _tmp61_;
	g_return_val_if_fail (book != NULL, NULL);
	self = (BookView*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, NULL);
	book_view_set_book (self, book);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp2_;
				guint _tmp3_;
				Page* page = NULL;
				Page* _tmp4_;
				Page* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = book_get_n_pages (book);
				_tmp3_ = _tmp2_;
				if (!(((guint) i) < _tmp3_)) {
					break;
				}
				_tmp4_ = book_get_page (book, i);
				page = _tmp4_;
				_tmp5_ = page;
				book_view_add_cb (self, book, _tmp5_);
				_g_object_unref0 (page);
			}
		}
	}
	_tmp6_ = book_get_page (book, 0);
	_tmp7_ = _tmp6_;
	book_view_set_selected_page (self, _tmp7_);
	_g_object_unref0 (_tmp7_);
	g_signal_connect_object (book, "page-added", (GCallback) _book_view_add_cb_book_page_added, self, 0);
	g_signal_connect_object (book, "page-removed", (GCallback) _book_view_remove_cb_book_page_removed, self, 0);
	g_signal_connect_object (book, "reordered", (GCallback) _book_view_reorder_cb_book_reordered, self, 0);
	g_signal_connect_object (book, "cleared", (GCallback) _book_view_clear_cb_book_cleared, self, 0);
	self->priv->need_layout = TRUE;
	_tmp8_ = g_direct_hash;
	_tmp9_ = g_direct_equal;
	_tmp10_ = g_hash_table_new_full (_tmp8_, _tmp9_, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->page_data);
	self->priv->page_data = _tmp10_;
	_tmp11_ = g_strdup ("arrow");
	_g_free0 (self->priv->cursor);
	self->priv->cursor = _tmp11_;
	_tmp12_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->drawing_area);
	self->priv->drawing_area = _tmp12_;
	_tmp13_ = self->priv->drawing_area;
	gtk_widget_set_size_request ((GtkWidget*) _tmp13_, 200, 100);
	_tmp14_ = self->priv->drawing_area;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp14_, TRUE);
	_tmp15_ = self->priv->drawing_area;
	gtk_widget_set_focusable ((GtkWidget*) _tmp15_, TRUE);
	_tmp16_ = self->priv->drawing_area;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp16_, TRUE);
	_tmp17_ = self->priv->drawing_area;
	gtk_drawing_area_set_draw_func (_tmp17_, _book_view_draw_cb_gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	_tmp18_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->scrolled_window);
	self->priv->scrolled_window = _tmp18_;
	_tmp19_ = self->priv->scrolled_window;
	gtk_scrolled_window_set_policy (_tmp19_, GTK_POLICY_AUTOMATIC, GTK_POLICY_NEVER);
	_tmp20_ = self->priv->scrolled_window;
	_tmp21_ = self->priv->drawing_area;
	gtk_scrolled_window_set_child (_tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = self->priv->scrolled_window;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp22_, TRUE);
	_tmp23_ = self->priv->scrolled_window;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp23_, TRUE);
	_tmp24_ = self->priv->scrolled_window;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp24_);
	_tmp25_ = self->priv->drawing_area;
	g_signal_connect_object (_tmp25_, "resize", (GCallback) _book_view_drawing_area_resize_cb_gtk_drawing_area_resize, self, 0);
	_tmp26_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ();
	_g_object_unref0 (self->priv->motion_controller);
	self->priv->motion_controller = _tmp26_;
	_tmp27_ = self->priv->motion_controller;
	g_signal_connect_object (_tmp27_, "motion", (GCallback) _book_view_motion_cb_gtk_event_controller_motion_motion, self, 0);
	_tmp28_ = self->priv->drawing_area;
	_tmp29_ = self->priv->motion_controller;
	_tmp30_ = _g_object_ref0 ((GtkEventController*) _tmp29_);
	gtk_widget_add_controller ((GtkWidget*) _tmp28_, _tmp30_);
	_tmp31_ = (GtkEventControllerScroll*) gtk_event_controller_scroll_new (GTK_EVENT_CONTROLLER_SCROLL_BOTH_AXES | GTK_EVENT_CONTROLLER_SCROLL_DISCRETE);
	_g_object_unref0 (self->priv->cursor_scroll_controller);
	self->priv->cursor_scroll_controller = _tmp31_;
	_tmp32_ = self->priv->cursor_scroll_controller;
	g_signal_connect_object (_tmp32_, "scroll", (GCallback) _book_view_cursor_scroll_cb_gtk_event_controller_scroll_scroll, self, 0);
	_tmp33_ = self->priv->drawing_area;
	_tmp34_ = self->priv->cursor_scroll_controller;
	_tmp35_ = _g_object_ref0 ((GtkEventController*) _tmp34_);
	gtk_widget_add_controller ((GtkWidget*) _tmp33_, _tmp35_);
	_tmp36_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp36_;
	_tmp37_ = self->priv->key_controller;
	g_signal_connect_object (_tmp37_, "key-pressed", (GCallback) _book_view_key_cb_gtk_event_controller_key_key_pressed, self, 0);
	_tmp38_ = self->priv->drawing_area;
	_tmp39_ = self->priv->key_controller;
	_tmp40_ = _g_object_ref0 ((GtkEventController*) _tmp39_);
	gtk_widget_add_controller ((GtkWidget*) _tmp38_, _tmp40_);
	_tmp41_ = (GtkGestureClick*) gtk_gesture_click_new ();
	_g_object_unref0 (self->priv->primary_click_gesture);
	self->priv->primary_click_gesture = _tmp41_;
	_tmp42_ = self->priv->primary_click_gesture;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp42_, (guint) GDK_BUTTON_PRIMARY);
	_tmp43_ = self->priv->primary_click_gesture;
	g_signal_connect_object (_tmp43_, "pressed", (GCallback) _book_view_primary_pressed_cb_gtk_gesture_click_pressed, self, 0);
	_tmp44_ = self->priv->primary_click_gesture;
	g_signal_connect_object (_tmp44_, "released", (GCallback) _book_view_primary_released_cb_gtk_gesture_click_released, self, 0);
	_tmp45_ = self->priv->drawing_area;
	_tmp46_ = self->priv->primary_click_gesture;
	_tmp47_ = _g_object_ref0 ((GtkEventController*) _tmp46_);
	gtk_widget_add_controller ((GtkWidget*) _tmp45_, _tmp47_);
	_tmp48_ = (GtkGestureClick*) gtk_gesture_click_new ();
	_g_object_unref0 (self->priv->secondary_click_gesture);
	self->priv->secondary_click_gesture = _tmp48_;
	_tmp49_ = self->priv->secondary_click_gesture;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp49_, (guint) GDK_BUTTON_SECONDARY);
	_tmp50_ = self->priv->secondary_click_gesture;
	g_signal_connect_object (_tmp50_, "pressed", (GCallback) _book_view_secondary_pressed_cb_gtk_gesture_click_pressed, self, 0);
	_tmp51_ = self->priv->secondary_click_gesture;
	g_signal_connect_object (_tmp51_, "released", (GCallback) _book_view_secondary_released_cb_gtk_gesture_click_released, self, 0);
	_tmp52_ = self->priv->drawing_area;
	_tmp53_ = self->priv->secondary_click_gesture;
	_tmp54_ = _g_object_ref0 ((GtkEventController*) _tmp53_);
	gtk_widget_add_controller ((GtkWidget*) _tmp52_, _tmp54_);
	_tmp55_ = (GtkEventControllerFocus*) gtk_event_controller_focus_new ();
	_g_object_unref0 (self->priv->focus_controller);
	self->priv->focus_controller = _tmp55_;
	_tmp56_ = self->priv->focus_controller;
	g_signal_connect_object (_tmp56_, "enter", (GCallback) _book_view_focus_cb_gtk_event_controller_focus_enter, self, G_CONNECT_AFTER);
	_tmp57_ = self->priv->focus_controller;
	g_signal_connect_object (_tmp57_, "leave", (GCallback) _book_view_focus_cb_gtk_event_controller_focus_leave, self, G_CONNECT_AFTER);
	_tmp58_ = self->priv->drawing_area;
	_tmp59_ = self->priv->focus_controller;
	_tmp60_ = _g_object_ref0 ((GtkEventController*) _tmp59_);
	gtk_widget_add_controller ((GtkWidget*) _tmp58_, _tmp60_);
	_tmp61_ = self->priv->drawing_area;
	gtk_widget_set_visible ((GtkWidget*) _tmp61_, TRUE);
	return self;
}

BookView*
book_view_new (Book* book)
{
	return book_view_construct (TYPE_BOOK_VIEW, book);
}

static PageView*
book_view_get_nth_page (BookView* self,
                        gint n)
{
	Page* page = NULL;
	Book* _tmp0_;
	Page* _tmp1_;
	GHashTable* _tmp2_;
	gconstpointer _tmp3_;
	PageView* _tmp4_;
	PageView* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_book;
	_tmp1_ = book_get_page (_tmp0_, n);
	page = _tmp1_;
	_tmp2_ = self->priv->page_data;
	_tmp3_ = g_hash_table_lookup (_tmp2_, page);
	_tmp4_ = _g_object_ref0 ((PageView*) _tmp3_);
	result = _tmp4_;
	_g_object_unref0 (page);
	return result;
}

static PageView*
book_view_get_next_page (BookView* self,
                         PageView* page)
{
	PageView* _tmp15_;
	PageView* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (page != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Page* p = NULL;
				Book* _tmp2_;
				Page* _tmp3_;
				Page* _tmp4_;
				Page* _tmp5_;
				Page* _tmp6_;
				Page* _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_book;
				_tmp3_ = book_get_page (_tmp2_, i);
				p = _tmp3_;
				_tmp4_ = p;
				if (_tmp4_ == NULL) {
					_g_object_unref0 (p);
					break;
				}
				_tmp5_ = p;
				_tmp6_ = page_view_get_page (page);
				_tmp7_ = _tmp6_;
				if (_tmp5_ == _tmp7_) {
					Book* _tmp8_;
					Page* _tmp9_;
					Page* _tmp10_;
					_tmp8_ = self->priv->_book;
					_tmp9_ = book_get_page (_tmp8_, i + 1);
					_g_object_unref0 (p);
					p = _tmp9_;
					_tmp10_ = p;
					if (_tmp10_ != NULL) {
						GHashTable* _tmp11_;
						Page* _tmp12_;
						gconstpointer _tmp13_;
						PageView* _tmp14_;
						_tmp11_ = self->priv->page_data;
						_tmp12_ = p;
						_tmp13_ = g_hash_table_lookup (_tmp11_, _tmp12_);
						_tmp14_ = _g_object_ref0 ((PageView*) _tmp13_);
						result = _tmp14_;
						_g_object_unref0 (p);
						return result;
					}
				}
				_g_object_unref0 (p);
			}
		}
	}
	_tmp15_ = _g_object_ref0 (page);
	result = _tmp15_;
	return result;
}

static PageView*
book_view_get_prev_page (BookView* self,
                         PageView* page)
{
	PageView* prev_page = NULL;
	PageView* _tmp0_;
	PageView* _tmp13_;
	PageView* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (page != NULL, NULL);
	_tmp0_ = _g_object_ref0 (page);
	prev_page = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				Page* p = NULL;
				Book* _tmp3_;
				Page* _tmp4_;
				Page* _tmp5_;
				Page* _tmp6_;
				Page* _tmp7_;
				Page* _tmp8_;
				GHashTable* _tmp9_;
				Page* _tmp10_;
				gconstpointer _tmp11_;
				PageView* _tmp12_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->_book;
				_tmp4_ = book_get_page (_tmp3_, i);
				p = _tmp4_;
				_tmp5_ = p;
				if (_tmp5_ == NULL) {
					_g_object_unref0 (p);
					break;
				}
				_tmp6_ = p;
				_tmp7_ = page_view_get_page (page);
				_tmp8_ = _tmp7_;
				if (_tmp6_ == _tmp8_) {
					result = prev_page;
					_g_object_unref0 (p);
					return result;
				}
				_tmp9_ = self->priv->page_data;
				_tmp10_ = p;
				_tmp11_ = g_hash_table_lookup (_tmp9_, _tmp10_);
				_tmp12_ = _g_object_ref0 ((PageView*) _tmp11_);
				_g_object_unref0 (prev_page);
				prev_page = _tmp12_;
				_g_object_unref0 (p);
			}
		}
	}
	_tmp13_ = _g_object_ref0 (page);
	result = _tmp13_;
	_g_object_unref0 (prev_page);
	return result;
}

static void
book_view_page_view_changed_cb (BookView* self,
                                PageView* page)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	book_view_redraw (self);
}

static void
book_view_page_view_size_changed_cb (BookView* self,
                                     PageView* page)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	self->priv->need_layout = TRUE;
	book_view_redraw (self);
}

static void
_book_view_page_view_changed_cb_page_view_changed (PageView* _sender,
                                                   gpointer self)
{
	book_view_page_view_changed_cb ((BookView*) self, _sender);
}

static void
_book_view_page_view_size_changed_cb_page_view_size_changed (PageView* _sender,
                                                             gpointer self)
{
	book_view_page_view_size_changed_cb ((BookView*) self, _sender);
}

static void
book_view_add_cb (BookView* self,
                  Book* book,
                  Page* page)
{
	PageView* page_view = NULL;
	PageView* _tmp0_;
	GHashTable* _tmp1_;
	Page* _tmp2_;
	PageView* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page_view_new (page);
	page_view = _tmp0_;
	g_signal_connect_object (page_view, "changed", (GCallback) _book_view_page_view_changed_cb_page_view_changed, self, 0);
	g_signal_connect_object (page_view, "size-changed", (GCallback) _book_view_page_view_size_changed_cb_page_view_size_changed, self, 0);
	_tmp1_ = self->priv->page_data;
	_tmp2_ = _g_object_ref0 (page);
	_tmp3_ = _g_object_ref0 (page_view);
	g_hash_table_insert (_tmp1_, _tmp2_, _tmp3_);
	self->priv->need_layout = TRUE;
	book_view_redraw (self);
	_g_object_unref0 (page_view);
}

static void
book_view_set_selected_page_view (BookView* self,
                                  PageView* page)
{
	gboolean _tmp0_ = FALSE;
	PageView* _tmp1_;
	PageView* _tmp4_;
	PageView* _tmp5_;
	GtkDrawingArea* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->selected_page_view;
	if (_tmp1_ != NULL) {
		PageView* _tmp2_;
		_tmp2_ = self->priv->selected_page_view;
		_tmp0_ = page != _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		PageView* _tmp3_;
		_tmp3_ = self->priv->selected_page_view;
		page_view_set_selected (_tmp3_, TRUE);
	}
	_tmp4_ = _g_object_ref0 (page);
	_g_object_unref0 (self->priv->selected_page_view);
	self->priv->selected_page_view = _tmp4_;
	book_view_redraw (self);
	_tmp5_ = self->priv->selected_page_view;
	if (_tmp5_ == NULL) {
		return;
	}
	_tmp6_ = self->priv->drawing_area;
	g_object_get ((GtkWidget*) _tmp6_, "has-focus", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	if (!_tmp8_) {
		PageView* _tmp9_;
		_tmp9_ = self->priv->selected_page_view;
		page_view_set_selected (_tmp9_, FALSE);
	} else {
		PageView* _tmp10_;
		_tmp10_ = self->priv->selected_page_view;
		page_view_set_selected (_tmp10_, TRUE);
	}
}

static void
book_view_show_page_view (BookView* self,
                          PageView* page)
{
	gint allocation_width = 0;
	GtkDrawingArea* _tmp0_;
	gint left_edge = 0;
	gint _tmp1_;
	gint _tmp2_;
	gint right_edge = 0;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	if (page == NULL) {
		return;
	}
	_tmp0_ = self->priv->drawing_area;
	allocation_width = gtk_widget_get_allocated_width ((GtkWidget*) _tmp0_);
	_tmp1_ = page_view_get_x_offset (page);
	_tmp2_ = _tmp1_;
	left_edge = _tmp2_;
	_tmp3_ = page_view_get_x_offset (page);
	_tmp4_ = _tmp3_;
	_tmp5_ = page_view_get_width (page);
	_tmp6_ = _tmp5_;
	right_edge = _tmp4_ + _tmp6_;
	_tmp7_ = self->priv->_x_offset;
	if ((left_edge - _tmp7_) < 0) {
		book_view_set_x_offset (self, left_edge);
	} else {
		gint _tmp8_;
		_tmp8_ = self->priv->_x_offset;
		if ((right_edge - _tmp8_) > allocation_width) {
			book_view_set_x_offset (self, right_edge - allocation_width);
		}
	}
}

static void
book_view_select_page_view (BookView* self,
                            PageView* page)
{
	Page* p = NULL;
	PageView* _tmp0_;
	Page* _tmp4_;
	g_return_if_fail (self != NULL);
	p = NULL;
	_tmp0_ = self->priv->selected_page_view;
	if (_tmp0_ == page) {
		_g_object_unref0 (p);
		return;
	}
	book_view_set_selected_page_view (self, page);
	if (self->priv->need_layout) {
		self->priv->show_selected_page = TRUE;
	} else {
		book_view_show_page_view (self, page);
	}
	if (page != NULL) {
		Page* _tmp1_;
		Page* _tmp2_;
		Page* _tmp3_;
		_tmp1_ = page_view_get_page (page);
		_tmp2_ = _tmp1_;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (p);
		p = _tmp3_;
	}
	_tmp4_ = p;
	g_signal_emit (self, book_view_signals[BOOK_VIEW_PAGE_SELECTED_SIGNAL], 0, _tmp4_);
	_g_object_unref0 (p);
}

static void
book_view_remove_cb (BookView* self,
                     Book* book,
                     Page* page)
{
	PageView* new_selection = NULL;
	PageView* _tmp0_;
	PageView* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	PageView* page_view = NULL;
	GHashTable* _tmp10_;
	gconstpointer _tmp11_;
	PageView* _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	GHashTable* _tmp15_;
	PageView* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = self->priv->selected_page_view;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	new_selection = _tmp1_;
	_tmp2_ = book_view_get_selected_page (self);
	_tmp3_ = _tmp2_;
	if (page == _tmp3_) {
		PageView* _tmp4_;
		PageView* _tmp5_;
		PageView* _tmp6_;
		PageView* _tmp7_;
		_tmp4_ = self->priv->selected_page_view;
		_tmp5_ = book_view_get_prev_page (self, _tmp4_);
		_g_object_unref0 (new_selection);
		new_selection = _tmp5_;
		_tmp6_ = new_selection;
		_tmp7_ = self->priv->selected_page_view;
		if (_tmp6_ == _tmp7_) {
			PageView* _tmp8_;
			PageView* _tmp9_;
			_tmp8_ = self->priv->selected_page_view;
			_tmp9_ = book_view_get_next_page (self, _tmp8_);
			_g_object_unref0 (new_selection);
			new_selection = _tmp9_;
		}
		_g_object_unref0 (self->priv->selected_page_view);
		self->priv->selected_page_view = NULL;
	}
	_tmp10_ = self->priv->page_data;
	_tmp11_ = g_hash_table_lookup (_tmp10_, page);
	_tmp12_ = _g_object_ref0 ((PageView*) _tmp11_);
	page_view = _tmp12_;
	g_signal_parse_name ("changed", TYPE_PAGE_VIEW, &_tmp13_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (page_view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _book_view_page_view_changed_cb_page_view_changed, self);
	g_signal_parse_name ("size-changed", TYPE_PAGE_VIEW, &_tmp14_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (page_view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _book_view_page_view_size_changed_cb_page_view_size_changed, self);
	_tmp15_ = self->priv->page_data;
	g_hash_table_remove (_tmp15_, page);
	_tmp16_ = new_selection;
	book_view_select_page_view (self, _tmp16_);
	self->priv->need_layout = TRUE;
	book_view_redraw (self);
	_g_object_unref0 (page_view);
	_g_object_unref0 (new_selection);
}

static void
book_view_reorder_cb (BookView* self,
                      Book* book)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	self->priv->need_layout = TRUE;
	book_view_redraw (self);
}

static void
book_view_clear_cb (BookView* self,
                    Book* book)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	_tmp0_ = self->priv->page_data;
	g_hash_table_remove_all (_tmp0_);
	_g_object_unref0 (self->priv->selected_page_view);
	self->priv->selected_page_view = NULL;
	g_signal_emit (self, book_view_signals[BOOK_VIEW_PAGE_SELECTED_SIGNAL], 0, NULL);
	self->priv->need_layout = TRUE;
	book_view_redraw (self);
}

void
book_view_drawing_area_resize_cb (BookView* self)
{
	g_return_if_fail (self != NULL);
	self->priv->need_layout = TRUE;
	book_view_layout (self);
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
book_view_layout_into (BookView* self,
                       gint width,
                       gint height,
                       gint* book_width,
                       gint* book_height)
{
	gint _vala_book_width = 0;
	gint _vala_book_height = 0;
	GList* pages = NULL;
	gint max_dpi = 0;
	GList* _tmp6_;
	gint max_width = 0;
	gint max_height = 0;
	GList* _tmp18_;
	gdouble aspect = 0.0;
	gdouble max_aspect = 0.0;
	gint spacing = 0;
	GList* _tmp36_;
	GList* _tmp62_;
	gint x_offset_local = 0;
	GList* _tmp63_;
	g_return_if_fail (self != NULL);
	pages = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Book* _tmp2_;
				guint _tmp3_;
				guint _tmp4_;
				PageView* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_book;
				_tmp3_ = book_get_n_pages (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(((guint) i) < _tmp4_)) {
					break;
				}
				_tmp5_ = book_view_get_nth_page (self, i);
				pages = g_list_append (pages, _tmp5_);
			}
		}
	}
	max_dpi = 0;
	_tmp6_ = pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp6_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			PageView* _tmp7_;
			PageView* page = NULL;
			_tmp7_ = _g_object_ref0 ((PageView*) page_it->data);
			page = _tmp7_;
			{
				Page* p = NULL;
				PageView* _tmp8_;
				Page* _tmp9_;
				Page* _tmp10_;
				Page* _tmp11_;
				Page* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				_tmp8_ = page;
				_tmp9_ = page_view_get_page (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = _g_object_ref0 (_tmp10_);
				p = _tmp11_;
				_tmp12_ = p;
				_tmp13_ = page_get_dpi (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_ > max_dpi) {
					Page* _tmp15_;
					gint _tmp16_;
					gint _tmp17_;
					_tmp15_ = p;
					_tmp16_ = page_get_dpi (_tmp15_);
					_tmp17_ = _tmp16_;
					max_dpi = _tmp17_;
				}
				_g_object_unref0 (p);
				_g_object_unref0 (page);
			}
		}
	}
	max_width = 0;
	max_height = 0;
	_tmp18_ = pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp18_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			PageView* _tmp19_;
			PageView* page = NULL;
			_tmp19_ = _g_object_ref0 ((PageView*) page_it->data);
			page = _tmp19_;
			{
				Page* p = NULL;
				PageView* _tmp20_;
				Page* _tmp21_;
				Page* _tmp22_;
				Page* _tmp23_;
				gint w = 0;
				Page* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				gint h = 0;
				Page* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				Page* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				Page* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				_tmp20_ = page;
				_tmp21_ = page_view_get_page (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = _g_object_ref0 (_tmp22_);
				p = _tmp23_;
				_tmp24_ = p;
				_tmp25_ = page_get_width (_tmp24_);
				_tmp26_ = _tmp25_;
				w = _tmp26_;
				_tmp27_ = p;
				_tmp28_ = page_get_height (_tmp27_);
				_tmp29_ = _tmp28_;
				h = _tmp29_;
				_tmp30_ = p;
				_tmp31_ = page_get_dpi (_tmp30_);
				_tmp32_ = _tmp31_;
				w = (gint) (((((gdouble) w) * max_dpi) / _tmp32_) + 0.5);
				_tmp33_ = p;
				_tmp34_ = page_get_dpi (_tmp33_);
				_tmp35_ = _tmp34_;
				h = (gint) (((((gdouble) h) * max_dpi) / _tmp35_) + 0.5);
				if (w > max_width) {
					max_width = w;
				}
				if (h > max_height) {
					max_height = h;
				}
				_g_object_unref0 (p);
				_g_object_unref0 (page);
			}
		}
	}
	aspect = ((gdouble) width) / height;
	max_aspect = ((gdouble) max_width) / max_height;
	spacing = 12;
	_vala_book_width = 0;
	_vala_book_height = 0;
	_tmp36_ = pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp36_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			PageView* _tmp37_;
			PageView* page = NULL;
			_tmp37_ = _g_object_ref0 ((PageView*) page_it->data);
			page = _tmp37_;
			{
				Page* p = NULL;
				PageView* _tmp38_;
				Page* _tmp39_;
				Page* _tmp40_;
				Page* _tmp41_;
				gint h = 0;
				PageView* _tmp56_;
				gint _tmp57_;
				gint _tmp58_;
				PageView* _tmp59_;
				gint _tmp60_;
				gint _tmp61_;
				_tmp38_ = page;
				_tmp39_ = page_view_get_page (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = _g_object_ref0 (_tmp40_);
				p = _tmp41_;
				if (max_aspect > aspect) {
					gint w = 0;
					Page* _tmp42_;
					gint _tmp43_;
					gint _tmp44_;
					Page* _tmp45_;
					gint _tmp46_;
					gint _tmp47_;
					PageView* _tmp48_;
					_tmp42_ = p;
					_tmp43_ = page_get_width (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = p;
					_tmp46_ = page_get_dpi (_tmp45_);
					_tmp47_ = _tmp46_;
					w = (gint) (((((gdouble) _tmp44_) * max_dpi) * width) / (_tmp47_ * max_width));
					_tmp48_ = page;
					page_view_set_width (_tmp48_, w);
				} else {
					gint h = 0;
					Page* _tmp49_;
					gint _tmp50_;
					gint _tmp51_;
					Page* _tmp52_;
					gint _tmp53_;
					gint _tmp54_;
					PageView* _tmp55_;
					_tmp49_ = p;
					_tmp50_ = page_get_height (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = p;
					_tmp53_ = page_get_dpi (_tmp52_);
					_tmp54_ = _tmp53_;
					h = (gint) (((((gdouble) _tmp51_) * max_dpi) * height) / (_tmp54_ * max_height));
					_tmp55_ = page;
					page_view_set_height (_tmp55_, h);
				}
				_tmp56_ = page;
				_tmp57_ = page_view_get_height (_tmp56_);
				_tmp58_ = _tmp57_;
				h = _tmp58_;
				if (h > _vala_book_height) {
					_vala_book_height = h;
				}
				_tmp59_ = page;
				_tmp60_ = page_view_get_width (_tmp59_);
				_tmp61_ = _tmp60_;
				_vala_book_width = _vala_book_width + (_tmp61_ + spacing);
				_g_object_unref0 (p);
				_g_object_unref0 (page);
			}
		}
	}
	_tmp62_ = pages;
	if (_tmp62_ != NULL) {
		_vala_book_width = _vala_book_width - spacing;
	}
	x_offset_local = 0;
	_tmp63_ = pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp63_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			PageView* _tmp64_;
			PageView* page = NULL;
			_tmp64_ = _g_object_ref0 ((PageView*) page_it->data);
			page = _tmp64_;
			{
				PageView* _tmp65_;
				PageView* _tmp66_;
				gint _tmp67_;
				gint _tmp68_;
				PageView* _tmp69_;
				PageView* _tmp70_;
				gint _tmp71_;
				gint _tmp72_;
				_tmp65_ = page;
				page_view_set_x_offset (_tmp65_, x_offset_local);
				_tmp66_ = page;
				_tmp67_ = page_view_get_width (_tmp66_);
				_tmp68_ = _tmp67_;
				x_offset_local += _tmp68_ + spacing;
				_tmp69_ = page;
				_tmp70_ = page;
				_tmp71_ = page_view_get_height (_tmp70_);
				_tmp72_ = _tmp71_;
				page_view_set_y_offset (_tmp69_, (height - _tmp72_) / 2);
				_g_object_unref0 (page);
			}
		}
	}
	(pages == NULL) ? NULL : (pages = (_g_list_free__g_object_unref0_ (pages), NULL));
	if (book_width) {
		*book_width = _vala_book_width;
	}
	if (book_height) {
		*book_height = _vala_book_height;
	}
}

static void
book_view_layout (BookView* self)
{
	gint width = 0;
	GtkDrawingArea* _tmp0_;
	gint height = 0;
	gint book_width = 0;
	gint book_height = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkDrawingArea* _tmp3_;
	g_return_if_fail (self != NULL);
	if (!self->priv->need_layout) {
		return;
	}
	self->priv->laying_out = TRUE;
	_tmp0_ = self->priv->drawing_area;
	width = gtk_widget_get_allocated_width ((GtkWidget*) _tmp0_);
	height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	book_view_layout_into (self, width, height, &_tmp1_, &_tmp2_);
	book_width = _tmp1_;
	book_height = _tmp2_;
	_tmp3_ = self->priv->drawing_area;
	gtk_widget_set_size_request ((GtkWidget*) _tmp3_, book_width, -1);
	if (self->priv->show_selected_page) {
		PageView* _tmp4_;
		_tmp4_ = self->priv->selected_page_view;
		book_view_show_page_view (self, _tmp4_);
	}
	self->priv->need_layout = FALSE;
	self->priv->show_selected_page = FALSE;
	self->priv->laying_out = FALSE;
}

void
book_view_draw_cb (BookView* self,
                   GtkDrawingArea* drawing_area,
                   cairo_t* context,
                   gint width,
                   gint height)
{
	gdouble left = 0.0;
	gdouble top = 0.0;
	gdouble right = 0.0;
	gdouble bottom = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GList* pages = NULL;
	GdkRGBA ruler_color = {0};
	GtkStyleContext* _tmp10_;
	GdkRGBA _tmp11_ = {0};
	GdkRGBA ruler_color_selected = {0};
	GdkRGBA _tmp12_ = {0};
	GList* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (drawing_area != NULL);
	g_return_if_fail (context != NULL);
	book_view_layout (self);
	cairo_clip_extents (context, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	left = _tmp0_;
	top = _tmp1_;
	right = _tmp2_;
	bottom = _tmp3_;
	pages = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				Book* _tmp6_;
				guint _tmp7_;
				guint _tmp8_;
				PageView* _tmp9_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = self->priv->_book;
				_tmp7_ = book_get_n_pages (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(((guint) i) < _tmp8_)) {
					break;
				}
				_tmp9_ = book_view_get_nth_page (self, i);
				pages = g_list_append (pages, _tmp9_);
			}
		}
	}
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_get_color (_tmp10_, &_tmp11_);
	ruler_color = _tmp11_;
	ruler_color_selected = _tmp12_;
	gdk_rgba_parse (&ruler_color_selected, "#3584e4");
	_tmp13_ = pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp13_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			PageView* _tmp14_;
			PageView* page = NULL;
			_tmp14_ = _g_object_ref0 ((PageView*) page_it->data);
			page = _tmp14_;
			{
				gint left_edge = 0;
				PageView* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gint right_edge = 0;
				PageView* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				PageView* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gboolean _tmp26_ = FALSE;
				gint _tmp27_;
				GdkRGBA _tmp28_ = {0};
				PageView* _tmp29_;
				PageView* _tmp30_;
				PageView* _tmp33_;
				PageView* _tmp34_;
				gboolean _tmp35_;
				gboolean _tmp36_;
				_tmp15_ = page;
				_tmp16_ = page_view_get_x_offset (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = self->priv->_x_offset;
				left_edge = _tmp17_ - _tmp18_;
				_tmp19_ = page;
				_tmp20_ = page_view_get_x_offset (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = page;
				_tmp23_ = page_view_get_width (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = self->priv->_x_offset;
				right_edge = (_tmp21_ + _tmp24_) - _tmp25_;
				if (((gdouble) right_edge) < left) {
					_tmp26_ = TRUE;
				} else {
					_tmp26_ = ((gdouble) left_edge) > right;
				}
				if (_tmp26_) {
					_g_object_unref0 (page);
					continue;
				}
				cairo_save (context);
				_tmp27_ = self->priv->_x_offset;
				cairo_translate (context, (gdouble) (-_tmp27_), (gdouble) 0);
				_tmp29_ = page;
				_tmp30_ = self->priv->selected_page_view;
				if (_tmp29_ == _tmp30_) {
					GdkRGBA _tmp31_;
					_tmp31_ = ruler_color_selected;
					_tmp28_ = _tmp31_;
				} else {
					GdkRGBA _tmp32_;
					_tmp32_ = ruler_color;
					_tmp28_ = _tmp32_;
				}
				_tmp33_ = page;
				page_view_render (_tmp33_, context, &_tmp28_);
				cairo_restore (context);
				_tmp34_ = page;
				_tmp35_ = page_view_get_selected (_tmp34_);
				_tmp36_ = _tmp35_;
				if (_tmp36_) {
					GtkStyleContext* _tmp37_;
					PageView* _tmp38_;
					gint _tmp39_;
					gint _tmp40_;
					gint _tmp41_;
					PageView* _tmp42_;
					gint _tmp43_;
					gint _tmp44_;
					PageView* _tmp45_;
					gint _tmp46_;
					gint _tmp47_;
					PageView* _tmp48_;
					gint _tmp49_;
					gint _tmp50_;
					_tmp37_ = gtk_widget_get_style_context ((GtkWidget*) drawing_area);
					_tmp38_ = page;
					_tmp39_ = page_view_get_x_offset (_tmp38_);
					_tmp40_ = _tmp39_;
					_tmp41_ = self->priv->_x_offset;
					_tmp42_ = page;
					_tmp43_ = page_view_get_y_offset (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = page;
					_tmp46_ = page_view_get_width (_tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = page;
					_tmp49_ = page_view_get_height (_tmp48_);
					_tmp50_ = _tmp49_;
					gtk_render_focus (_tmp37_, context, (gdouble) (_tmp40_ - _tmp41_), (gdouble) _tmp44_, (gdouble) _tmp47_, (gdouble) _tmp50_);
				}
				_g_object_unref0 (page);
			}
		}
	}
	(pages == NULL) ? NULL : (pages = (_g_list_free__g_object_unref0_ (pages), NULL));
}

static PageView*
book_view_get_page_at (BookView* self,
                       gint x,
                       gint y,
                       gint* x_,
                       gint* y_)
{
	gint _vala_x_ = 0;
	gint _vala_y_ = 0;
	PageView* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_y_ = 0;
	_vala_x_ = _vala_y_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Book* _tmp2_;
				guint _tmp3_;
				guint _tmp4_;
				PageView* page = NULL;
				PageView* _tmp5_;
				gint left = 0;
				PageView* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				gint right = 0;
				PageView* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gint top = 0;
				PageView* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gint bottom = 0;
				PageView* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_ = FALSE;
				gboolean _tmp20_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_book;
				_tmp3_ = book_get_n_pages (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(((guint) i) < _tmp4_)) {
					break;
				}
				_tmp5_ = book_view_get_nth_page (self, i);
				page = _tmp5_;
				_tmp6_ = page;
				_tmp7_ = page_view_get_x_offset (_tmp6_);
				_tmp8_ = _tmp7_;
				left = _tmp8_;
				_tmp9_ = page;
				_tmp10_ = page_view_get_width (_tmp9_);
				_tmp11_ = _tmp10_;
				right = left + _tmp11_;
				_tmp12_ = page;
				_tmp13_ = page_view_get_y_offset (_tmp12_);
				_tmp14_ = _tmp13_;
				top = _tmp14_;
				_tmp15_ = page;
				_tmp16_ = page_view_get_height (_tmp15_);
				_tmp17_ = _tmp16_;
				bottom = top + _tmp17_;
				if (x >= left) {
					_tmp20_ = x <= right;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					_tmp19_ = y >= top;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					_tmp18_ = y <= bottom;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					_vala_x_ = x - left;
					_vala_y_ = y - top;
					result = page;
					if (x_) {
						*x_ = _vala_x_;
					}
					if (y_) {
						*y_ = _vala_y_;
					}
					return result;
				}
				_g_object_unref0 (page);
			}
		}
	}
	result = NULL;
	if (x_) {
		*x_ = _vala_x_;
	}
	if (y_) {
		*y_ = _vala_y_;
	}
	return result;
}

static void
book_view_primary_pressed_cb (BookView* self,
                              GtkGestureClick* controler,
                              gint n_press,
                              gdouble x,
                              gdouble y)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (controler != NULL);
	book_view_button_cb (self, controler, GDK_BUTTON_PRIMARY, TRUE, n_press, x, y);
}

static void
book_view_primary_released_cb (BookView* self,
                               GtkGestureClick* controler,
                               gint n_press,
                               gdouble x,
                               gdouble y)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (controler != NULL);
	book_view_button_cb (self, controler, GDK_BUTTON_PRIMARY, FALSE, n_press, x, y);
}

static void
book_view_secondary_pressed_cb (BookView* self,
                                GtkGestureClick* controler,
                                gint n_press,
                                gdouble x,
                                gdouble y)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (controler != NULL);
	book_view_button_cb (self, controler, GDK_BUTTON_SECONDARY, TRUE, n_press, x, y);
}

static void
book_view_secondary_released_cb (BookView* self,
                                 GtkGestureClick* controler,
                                 gint n_press,
                                 gdouble x,
                                 gdouble y)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (controler != NULL);
	book_view_button_cb (self, controler, GDK_BUTTON_SECONDARY, FALSE, n_press, x, y);
}

static void
book_view_button_cb (BookView* self,
                     GtkGestureClick* controler,
                     gint button,
                     gboolean press,
                     gint n_press,
                     gdouble dx,
                     gdouble dy)
{
	GtkDrawingArea* _tmp0_;
	gint x = 0;
	gint y = 0;
	PageView* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (controler != NULL);
	book_view_layout (self);
	_tmp0_ = self->priv->drawing_area;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	x = 0;
	y = 0;
	if (press) {
		gint _tmp1_;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		PageView* _tmp4_;
		PageView* _tmp5_;
		_tmp1_ = self->priv->_x_offset;
		_tmp4_ = book_view_get_page_at (self, (gint) (((gint) dx) + _tmp1_), (gint) dy, &_tmp2_, &_tmp3_);
		x = _tmp2_;
		y = _tmp3_;
		_tmp5_ = _tmp4_;
		book_view_select_page_view (self, _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	_tmp6_ = self->priv->selected_page_view;
	if (_tmp6_ == NULL) {
		return;
	}
	if (button == GDK_BUTTON_PRIMARY) {
		if (press) {
			PageView* _tmp7_;
			_tmp7_ = self->priv->selected_page_view;
			page_view_button_press (_tmp7_, x, y);
		} else {
			gboolean _tmp8_ = FALSE;
			if (press) {
				_tmp8_ = n_press == 2;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				Page* _tmp9_;
				Page* _tmp10_;
				_tmp9_ = book_view_get_selected_page (self);
				_tmp10_ = _tmp9_;
				g_signal_emit (self, book_view_signals[BOOK_VIEW_SHOW_PAGE_SIGNAL], 0, _tmp10_);
			} else {
				if (!press) {
					PageView* _tmp11_;
					_tmp11_ = self->priv->selected_page_view;
					page_view_button_release (_tmp11_, x, y);
				}
			}
		}
	}
	if (button == GDK_BUTTON_SECONDARY) {
		GtkDrawingArea* _tmp12_;
		_tmp12_ = self->priv->drawing_area;
		g_signal_emit (self, book_view_signals[BOOK_VIEW_SHOW_MENU_SIGNAL], 0, (GtkWidget*) _tmp12_, dx, dy);
	}
}

static void
book_view_set_cursor (BookView* self,
                      const gchar* cursor)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GdkCursor* c = NULL;
	GdkCursor* _tmp2_;
	GtkDrawingArea* _tmp3_;
	GdkCursor* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cursor != NULL);
	_tmp0_ = self->priv->cursor;
	if (g_strcmp0 (_tmp0_, cursor) == 0) {
		return;
	}
	_tmp1_ = g_strdup (cursor);
	_g_free0 (self->priv->cursor);
	self->priv->cursor = _tmp1_;
	_tmp2_ = gdk_cursor_new_from_name (cursor, NULL);
	c = _tmp2_;
	_tmp3_ = self->priv->drawing_area;
	_tmp4_ = c;
	gtk_widget_set_cursor ((GtkWidget*) _tmp3_, _tmp4_);
	_g_object_unref0 (c);
}

static void
book_view_motion_cb (BookView* self,
                     GtkEventControllerMotion* controler,
                     gdouble dx,
                     gdouble dy)
{
	gchar* cursor = NULL;
	gchar* _tmp0_;
	gint event_x = 0;
	gint event_y = 0;
	GdkModifierType event_state = 0U;
	gboolean _tmp1_ = FALSE;
	PageView* _tmp2_;
	const gchar* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (controler != NULL);
	_tmp0_ = g_strdup ("arrow");
	cursor = _tmp0_;
	event_x = (gint) dx;
	event_y = (gint) dy;
	event_state = gtk_event_controller_get_current_event_state ((GtkEventController*) controler);
	_tmp2_ = self->priv->selected_page_view;
	if (_tmp2_ != NULL) {
		_tmp1_ = (event_state & GDK_BUTTON1_MASK) != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint x = 0;
		gint _tmp3_;
		PageView* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint y = 0;
		PageView* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		PageView* _tmp10_;
		PageView* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp3_ = self->priv->_x_offset;
		_tmp4_ = self->priv->selected_page_view;
		_tmp5_ = page_view_get_x_offset (_tmp4_);
		_tmp6_ = _tmp5_;
		x = (gint) ((event_x + _tmp3_) - _tmp6_);
		_tmp7_ = self->priv->selected_page_view;
		_tmp8_ = page_view_get_y_offset (_tmp7_);
		_tmp9_ = _tmp8_;
		y = (gint) (event_y - _tmp9_);
		_tmp10_ = self->priv->selected_page_view;
		page_view_motion (_tmp10_, x, y);
		_tmp11_ = self->priv->selected_page_view;
		_tmp12_ = page_view_get_cursor (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (cursor);
		cursor = _tmp14_;
	} else {
		gint x = 0;
		gint y = 0;
		PageView* over_page = NULL;
		gint _tmp15_;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		PageView* _tmp18_;
		PageView* _tmp19_;
		_tmp15_ = self->priv->_x_offset;
		_tmp18_ = book_view_get_page_at (self, (gint) (event_x + _tmp15_), (gint) event_y, &_tmp16_, &_tmp17_);
		x = _tmp16_;
		y = _tmp17_;
		over_page = _tmp18_;
		_tmp19_ = over_page;
		if (_tmp19_ != NULL) {
			PageView* _tmp20_;
			PageView* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp20_ = over_page;
			page_view_motion (_tmp20_, x, y);
			_tmp21_ = over_page;
			_tmp22_ = page_view_get_cursor (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strdup (_tmp23_);
			_g_free0 (cursor);
			cursor = _tmp24_;
		}
		_g_object_unref0 (over_page);
	}
	_tmp25_ = cursor;
	book_view_set_cursor (self, _tmp25_);
	_g_free0 (cursor);
}

static gboolean
book_view_key_cb (BookView* self,
                  GtkEventControllerKey* controler,
                  guint keyval,
                  guint keycode,
                  GdkModifierType state)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (controler != NULL, FALSE);
	switch (keyval) {
		case GDK_KEY_Home:
		{
			Book* _tmp0_;
			Page* _tmp1_;
			Page* _tmp2_;
			_tmp0_ = self->priv->_book;
			_tmp1_ = book_get_page (_tmp0_, 0);
			_tmp2_ = _tmp1_;
			book_view_set_selected_page (self, _tmp2_);
			_g_object_unref0 (_tmp2_);
			result = TRUE;
			return result;
		}
		case GDK_KEY_Left:
		{
			PageView* _tmp3_;
			PageView* _tmp4_;
			PageView* _tmp5_;
			_tmp3_ = self->priv->selected_page_view;
			_tmp4_ = book_view_get_prev_page (self, _tmp3_);
			_tmp5_ = _tmp4_;
			book_view_select_page_view (self, _tmp5_);
			_g_object_unref0 (_tmp5_);
			result = TRUE;
			return result;
		}
		case GDK_KEY_Right:
		{
			PageView* _tmp6_;
			PageView* _tmp7_;
			PageView* _tmp8_;
			_tmp6_ = self->priv->selected_page_view;
			_tmp7_ = book_view_get_next_page (self, _tmp6_);
			_tmp8_ = _tmp7_;
			book_view_select_page_view (self, _tmp8_);
			_g_object_unref0 (_tmp8_);
			result = TRUE;
			return result;
		}
		case GDK_KEY_End:
		{
			Book* _tmp9_;
			Book* _tmp10_;
			guint _tmp11_;
			guint _tmp12_;
			Page* _tmp13_;
			Page* _tmp14_;
			_tmp9_ = self->priv->_book;
			_tmp10_ = self->priv->_book;
			_tmp11_ = book_get_n_pages (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = book_get_page (_tmp9_, ((gint) _tmp12_) - 1);
			_tmp14_ = _tmp13_;
			book_view_set_selected_page (self, _tmp14_);
			_g_object_unref0 (_tmp14_);
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static void
book_view_focus_cb (BookView* self,
                    GtkEventControllerFocus* controler)
{
	PageView* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (controler != NULL);
	_tmp0_ = self->priv->selected_page_view;
	book_view_set_selected_page_view (self, _tmp0_);
}

static gboolean
book_view_cursor_scroll_cb (BookView* self,
                            GtkEventControllerScroll* controller,
                            gdouble dx,
                            gdouble dy)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (controller != NULL, FALSE);
	if (dx == ((gdouble) 0)) {
		_tmp0_ = dy == ((gdouble) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (dy >= ((gdouble) 0)) {
			_tmp1_ = dx >= ((gdouble) 0);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			book_view_select_next_page (self);
		} else {
			gboolean _tmp2_ = FALSE;
			if (dy <= ((gdouble) 0)) {
				_tmp2_ = dx <= ((gdouble) 0);
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				book_view_select_prev_page (self);
			}
		}
	}
	result = TRUE;
	return result;
}

void
book_view_redraw (BookView* self)
{
	GtkDrawingArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->drawing_area;
	gtk_widget_queue_draw ((GtkWidget*) _tmp0_);
}

void
book_view_select_next_page (BookView* self)
{
	PageView* _tmp0_;
	PageView* _tmp1_;
	PageView* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_page_view;
	_tmp1_ = book_view_get_next_page (self, _tmp0_);
	_tmp2_ = _tmp1_;
	book_view_select_page_view (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

void
book_view_select_prev_page (BookView* self)
{
	PageView* _tmp0_;
	PageView* _tmp1_;
	PageView* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_page_view;
	_tmp1_ = book_view_get_prev_page (self, _tmp0_);
	_tmp2_ = _tmp1_;
	book_view_select_page_view (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

Book*
book_view_get_book (BookView* self)
{
	Book* result;
	Book* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_book;
	result = _tmp0_;
	return result;
}

static void
book_view_set_book (BookView* self,
                    Book* value)
{
	Book* old_value;
	g_return_if_fail (self != NULL);
	old_value = book_view_get_book (self);
	if (old_value != value) {
		Book* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_book);
		self->priv->_book = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, book_view_properties[BOOK_VIEW_BOOK_PROPERTY]);
	}
}

Page*
book_view_get_selected_page (BookView* self)
{
	Page* result;
	PageView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->selected_page_view;
	if (_tmp0_ != NULL) {
		PageView* _tmp1_;
		Page* _tmp2_;
		Page* _tmp3_;
		_tmp1_ = self->priv->selected_page_view;
		_tmp2_ = page_view_get_page (_tmp1_);
		_tmp3_ = _tmp2_;
		result = _tmp3_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

void
book_view_set_selected_page (BookView* self,
                             Page* value)
{
	Page* _tmp0_;
	Page* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = book_view_get_selected_page (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	if (value != NULL) {
		GHashTable* _tmp2_;
		gconstpointer _tmp3_;
		_tmp2_ = self->priv->page_data;
		_tmp3_ = g_hash_table_lookup (_tmp2_, value);
		book_view_select_page_view (self, (PageView*) _tmp3_);
	} else {
		book_view_select_page_view (self, NULL);
	}
	g_object_notify_by_pspec ((GObject *) self, book_view_properties[BOOK_VIEW_SELECTED_PAGE_PROPERTY]);
}

gint
book_view_get_x_offset (BookView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_x_offset;
	return result;
}

void
book_view_set_x_offset (BookView* self,
                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = book_view_get_x_offset (self);
	if (old_value != value) {
		self->priv->_x_offset = value;
		g_object_notify_by_pspec ((GObject *) self, book_view_properties[BOOK_VIEW_X_OFFSET_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_DOUBLE_DOUBLE (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_DOUBLE_DOUBLE) (gpointer data1, gpointer arg_1, gdouble arg_2, gdouble arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_DOUBLE_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_DOUBLE_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_double (param_values + 2), g_value_get_double (param_values + 3), data2);
}

static void
book_view_class_init (BookViewClass * klass,
                      gpointer klass_data)
{
	book_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BookView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_book_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_book_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = book_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOK_VIEW_BOOK_PROPERTY, book_view_properties[BOOK_VIEW_BOOK_PROPERTY] = g_param_spec_object ("book", "book", "book", TYPE_BOOK, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOK_VIEW_SELECTED_PAGE_PROPERTY, book_view_properties[BOOK_VIEW_SELECTED_PAGE_PROPERTY] = g_param_spec_object ("selected-page", "selected-page", "selected-page", TYPE_PAGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOOK_VIEW_X_OFFSET_PROPERTY, book_view_properties[BOOK_VIEW_X_OFFSET_PROPERTY] = g_param_spec_int ("x-offset", "x-offset", "x-offset", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	book_view_signals[BOOK_VIEW_PAGE_SELECTED_SIGNAL] = g_signal_new ("page-selected", TYPE_BOOK_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_PAGE);
	book_view_signals[BOOK_VIEW_SHOW_PAGE_SIGNAL] = g_signal_new ("show-page", TYPE_BOOK_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_PAGE);
	book_view_signals[BOOK_VIEW_SHOW_MENU_SIGNAL] = g_signal_new ("show-menu", TYPE_BOOK_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_DOUBLE_DOUBLE, G_TYPE_NONE, 3, gtk_widget_get_type (), G_TYPE_DOUBLE, G_TYPE_DOUBLE);
}

static void
book_view_instance_init (BookView * self,
                         gpointer klass)
{
	self->priv = book_view_get_instance_private (self);
	self->priv->selected_page_view = NULL;
}

static void
book_view_finalize (GObject * obj)
{
	BookView * self;
	Book* _tmp0_;
	guint _tmp1_;
	Book* _tmp2_;
	guint _tmp3_;
	Book* _tmp4_;
	guint _tmp5_;
	Book* _tmp6_;
	guint _tmp7_;
	GtkDrawingArea* _tmp8_;
	guint _tmp9_;
	GtkEventControllerMotion* _tmp10_;
	guint _tmp11_;
	GtkEventControllerScroll* _tmp12_;
	guint _tmp13_;
	GtkEventControllerKey* _tmp14_;
	guint _tmp15_;
	GtkGestureClick* _tmp16_;
	guint _tmp17_;
	GtkGestureClick* _tmp18_;
	guint _tmp19_;
	GtkGestureClick* _tmp20_;
	guint _tmp21_;
	GtkGestureClick* _tmp22_;
	guint _tmp23_;
	GtkEventControllerFocus* _tmp24_;
	guint _tmp25_;
	GtkEventControllerFocus* _tmp26_;
	guint _tmp27_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOK_VIEW, BookView);
	_tmp0_ = self->priv->_book;
	g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _book_view_add_cb_book_page_added, self);
	_tmp2_ = self->priv->_book;
	g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_view_remove_cb_book_page_removed, self);
	_tmp4_ = self->priv->_book;
	g_signal_parse_name ("reordered", TYPE_BOOK, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_view_reorder_cb_book_reordered, self);
	_tmp6_ = self->priv->_book;
	g_signal_parse_name ("cleared", TYPE_BOOK, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _book_view_clear_cb_book_cleared, self);
	_tmp8_ = self->priv->drawing_area;
	g_signal_parse_name ("resize", gtk_drawing_area_get_type (), &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _book_view_drawing_area_resize_cb_gtk_drawing_area_resize, self);
	_tmp10_ = self->priv->motion_controller;
	g_signal_parse_name ("motion", gtk_event_controller_motion_get_type (), &_tmp11_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _book_view_motion_cb_gtk_event_controller_motion_motion, self);
	_tmp12_ = self->priv->cursor_scroll_controller;
	g_signal_parse_name ("scroll", gtk_event_controller_scroll_get_type (), &_tmp13_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _book_view_cursor_scroll_cb_gtk_event_controller_scroll_scroll, self);
	_tmp14_ = self->priv->key_controller;
	g_signal_parse_name ("key-pressed", gtk_event_controller_key_get_type (), &_tmp15_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _book_view_key_cb_gtk_event_controller_key_key_pressed, self);
	_tmp16_ = self->priv->primary_click_gesture;
	g_signal_parse_name ("pressed", gtk_gesture_click_get_type (), &_tmp17_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _book_view_primary_pressed_cb_gtk_gesture_click_pressed, self);
	_tmp18_ = self->priv->primary_click_gesture;
	g_signal_parse_name ("released", gtk_gesture_click_get_type (), &_tmp19_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp18_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp19_, 0, NULL, (GCallback) _book_view_primary_released_cb_gtk_gesture_click_released, self);
	_tmp20_ = self->priv->secondary_click_gesture;
	g_signal_parse_name ("pressed", gtk_gesture_click_get_type (), &_tmp21_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp20_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp21_, 0, NULL, (GCallback) _book_view_secondary_pressed_cb_gtk_gesture_click_pressed, self);
	_tmp22_ = self->priv->secondary_click_gesture;
	g_signal_parse_name ("released", gtk_gesture_click_get_type (), &_tmp23_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp23_, 0, NULL, (GCallback) _book_view_secondary_released_cb_gtk_gesture_click_released, self);
	_tmp24_ = self->priv->focus_controller;
	g_signal_parse_name ("enter", gtk_event_controller_focus_get_type (), &_tmp25_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp24_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp25_, 0, NULL, (GCallback) _book_view_focus_cb_gtk_event_controller_focus_enter, self);
	_tmp26_ = self->priv->focus_controller;
	g_signal_parse_name ("leave", gtk_event_controller_focus_get_type (), &_tmp27_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp26_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp27_, 0, NULL, (GCallback) _book_view_focus_cb_gtk_event_controller_focus_leave, self);
	_g_object_unref0 (self->priv->_book);
	_g_hash_table_unref0 (self->priv->page_data);
	_g_object_unref0 (self->priv->selected_page_view);
	_g_object_unref0 (self->priv->scrolled_window);
	_g_object_unref0 (self->priv->drawing_area);
	_g_free0 (self->priv->cursor);
	_g_object_unref0 (self->priv->motion_controller);
	_g_object_unref0 (self->priv->cursor_scroll_controller);
	_g_object_unref0 (self->priv->key_controller);
	_g_object_unref0 (self->priv->primary_click_gesture);
	_g_object_unref0 (self->priv->secondary_click_gesture);
	_g_object_unref0 (self->priv->focus_controller);
	G_OBJECT_CLASS (book_view_parent_class)->finalize (obj);
}

static GType
book_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BookViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) book_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookView), 0, (GInstanceInitFunc) book_view_instance_init, NULL };
	GType book_view_type_id;
	book_view_type_id = g_type_register_static (gtk_box_get_type (), "BookView", &g_define_type_info, 0);
	BookView_private_offset = g_type_add_instance_private (book_view_type_id, sizeof (BookViewPrivate));
	return book_view_type_id;
}

GType
book_view_get_type (void)
{
	static volatile gsize book_view_type_id__once = 0;
	if (g_once_init_enter (&book_view_type_id__once)) {
		GType book_view_type_id;
		book_view_type_id = book_view_get_type_once ();
		g_once_init_leave (&book_view_type_id__once, book_view_type_id);
	}
	return book_view_type_id__once;
}

static void
_vala_book_view_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	BookView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOOK_VIEW, BookView);
	switch (property_id) {
		case BOOK_VIEW_BOOK_PROPERTY:
		g_value_set_object (value, book_view_get_book (self));
		break;
		case BOOK_VIEW_SELECTED_PAGE_PROPERTY:
		g_value_set_object (value, book_view_get_selected_page (self));
		break;
		case BOOK_VIEW_X_OFFSET_PROPERTY:
		g_value_set_int (value, book_view_get_x_offset (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_book_view_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	BookView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BOOK_VIEW, BookView);
	switch (property_id) {
		case BOOK_VIEW_BOOK_PROPERTY:
		book_view_set_book (self, g_value_get_object (value));
		break;
		case BOOK_VIEW_SELECTED_PAGE_PROPERTY:
		book_view_set_selected_page (self, g_value_get_object (value));
		break;
		case BOOK_VIEW_X_OFFSET_PROPERTY:
		book_view_set_x_offset (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

