/* GioDownloadFile.c generated by valac 0.56.17, the Vala compiler
 * generated from GioDownloadFile.vala, do not modify */

/*
    GioDownloadFile.vala
    Copyright (C) 2010 Maia Kozheva <sikon@ubuntu.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <stdio.h>

#define STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_SPEED_UPDATE_SEC 2.0
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE (steadyflow_core_idownload_file_get_type ())
#define STEADYFLOW_CORE_IDOWNLOAD_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, SteadyflowCoreIDownloadFile))
#define STEADYFLOW_CORE_IS_IDOWNLOAD_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE))
#define STEADYFLOW_CORE_IDOWNLOAD_FILE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, SteadyflowCoreIDownloadFileIface))

typedef struct _SteadyflowCoreIDownloadFile SteadyflowCoreIDownloadFile;
typedef struct _SteadyflowCoreIDownloadFileIface SteadyflowCoreIDownloadFileIface;
typedef enum  {
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_CONNECTING = 0,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_DOWNLOADING,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_PAUSED,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_FINISHED,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_NETWORK_ERROR
} SteadyflowCoreIDownloadFileStatus;

#define STEADYFLOW_CORE_IDOWNLOAD_FILE_TYPE_STATUS (steadyflow_core_idownload_file_status_get_type ())
typedef enum  {
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_DO_NOTHING = 0,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_OPEN_FILE,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_OPEN_FOLDER,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_RUN_COMMAND
} SteadyflowCoreIDownloadFileFinishAction;

#define STEADYFLOW_CORE_IDOWNLOAD_FILE_TYPE_FINISH_ACTION (steadyflow_core_idownload_file_finish_action_get_type ())

#define STEADYFLOW_CORE_TYPE_GIO_DOWNLOAD_FILE (steadyflow_core_gio_download_file_get_type ())
#define STEADYFLOW_CORE_GIO_DOWNLOAD_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_CORE_TYPE_GIO_DOWNLOAD_FILE, SteadyflowCoreGioDownloadFile))
#define STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), STEADYFLOW_CORE_TYPE_GIO_DOWNLOAD_FILE, SteadyflowCoreGioDownloadFileClass))
#define STEADYFLOW_CORE_IS_GIO_DOWNLOAD_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_CORE_TYPE_GIO_DOWNLOAD_FILE))
#define STEADYFLOW_CORE_IS_GIO_DOWNLOAD_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), STEADYFLOW_CORE_TYPE_GIO_DOWNLOAD_FILE))
#define STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), STEADYFLOW_CORE_TYPE_GIO_DOWNLOAD_FILE, SteadyflowCoreGioDownloadFileClass))

typedef struct _SteadyflowCoreGioDownloadFile SteadyflowCoreGioDownloadFile;
typedef struct _SteadyflowCoreGioDownloadFileClass SteadyflowCoreGioDownloadFileClass;
typedef struct _SteadyflowCoreGioDownloadFilePrivate SteadyflowCoreGioDownloadFilePrivate;
enum  {
	STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_0_PROPERTY,
	STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_STATUS_PROPERTY,
	STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_UID_PROPERTY,
	STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_URL_PROPERTY,
	STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_LOCAL_NAME_PROPERTY,
	STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_LOCAL_BASENAME_PROPERTY,
	STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_SIZE_PROPERTY,
	STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_DOWNLOADED_SIZE_PROPERTY,
	STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_SPEED_PROPERTY,
	STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_ICON_NAME_PROPERTY,
	STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_FINISH_ACTION_PROPERTY,
	STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_FINISH_COMMAND_PROPERTY,
	STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_ERROR_PROPERTY,
	STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_NUM_PROPERTIES
};
static GParamSpec* steadyflow_core_gio_download_file_properties[STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SteadyflowCoreGioDownloadFileDoDownloadData SteadyflowCoreGioDownloadFileDoDownloadData;

struct _SteadyflowCoreIDownloadFileIface {
	GTypeInterface parent_iface;
	void (*start) (SteadyflowCoreIDownloadFile* self, gboolean resume);
	void (*pause) (SteadyflowCoreIDownloadFile* self);
	void (*serialize) (SteadyflowCoreIDownloadFile* self, GKeyFile* file);
	SteadyflowCoreIDownloadFileStatus (*get_status) (SteadyflowCoreIDownloadFile* self);
	gint (*get_uid) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_url) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_local_name) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_local_basename) (SteadyflowCoreIDownloadFile* self);
	gint64 (*get_size) (SteadyflowCoreIDownloadFile* self);
	gint64 (*get_downloaded_size) (SteadyflowCoreIDownloadFile* self);
	gint (*get_speed) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_icon_name) (SteadyflowCoreIDownloadFile* self);
	SteadyflowCoreIDownloadFileFinishAction (*get_finish_action) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_finish_command) (SteadyflowCoreIDownloadFile* self);
	GError* (*get_error) (SteadyflowCoreIDownloadFile* self);
};

struct _SteadyflowCoreGioDownloadFile {
	GObject parent_instance;
	SteadyflowCoreGioDownloadFilePrivate * priv;
};

struct _SteadyflowCoreGioDownloadFileClass {
	GObjectClass parent_class;
};

struct _SteadyflowCoreGioDownloadFilePrivate {
	gchar* _url;
	gchar* _local_name;
	gchar* _local_basename;
	gint _uid;
	gchar* _icon;
	gint64 _size;
	gint64 _old_downloaded_size;
	gint64 _downloaded_size;
	gint _speed;
	SteadyflowCoreIDownloadFileFinishAction _finish_action;
	gchar* _finish_command;
	SteadyflowCoreIDownloadFileStatus _status;
	GError* _error;
	GTimer* timer;
};

struct _SteadyflowCoreGioDownloadFileDoDownloadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SteadyflowCoreGioDownloadFile* self;
	GFile* remote;
	GFile* local;
	gboolean resume;
	GFileProgressCallback on_progress;
	gpointer on_progress_target;
	GMount* _tmp0_;
	GMount* _tmp1_;
	GMountOperation* mount_op;
	GMountOperation* _tmp2_;
	GMountOperation* _tmp3_;
	GFileInfo* info;
	GFileInfo* _tmp4_;
	GFileInfo* _tmp5_;
	FILE* _tmp6_;
	GFileInputStream* input;
	GFileInputStream* _tmp7_;
	GFileOutputStream* output;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GFileInputStream* _tmp10_;
	GFileOutputStream* _tmp11_;
	GFileOutputStream* _tmp12_;
	GFileOutputStream* _tmp13_;
	GFileOutputStream* _tmp14_;
	GFileOutputStream* _tmp15_;
	GFileInputStream* _tmp16_;
	GFileOutputStream* _tmp17_;
	GFileOutputStream* _tmp18_;
	GFileOutputStream* _tmp19_;
	guint8* buf;
	guint8* _tmp20_;
	gint buf_length1;
	gint _buf_size_;
	SteadyflowCoreIDownloadFileStatus _tmp21_;
	SteadyflowCoreIDownloadFileStatus _tmp22_;
	gssize read;
	GFileInputStream* _tmp23_;
	guint8* _tmp24_;
	gint _tmp24__length1;
	GTimer* _tmp25_;
	GFileOutputStream* _tmp26_;
	guint8* _tmp27_;
	gint _tmp27__length1;
	GError* e;
	GError* _tmp28_;
	GError* _tmp29_;
	GTimer* _tmp30_;
	GError* _inner_error0_;
};

static gint SteadyflowCoreGioDownloadFile_private_offset;
static gpointer steadyflow_core_gio_download_file_parent_class = NULL;
static SteadyflowCoreIDownloadFileIface * steadyflow_core_gio_download_file_steadyflow_core_idownload_file_parent_iface = NULL;

VALA_EXTERN GType steadyflow_core_idownload_file_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType steadyflow_core_idownload_file_finish_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType steadyflow_core_idownload_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowCoreIDownloadFile, g_object_unref)
VALA_EXTERN GType steadyflow_core_gio_download_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowCoreGioDownloadFile, g_object_unref)
VALA_EXTERN SteadyflowCoreGioDownloadFile* steadyflow_core_gio_download_file_new (const gchar* url,
                                                                      const gchar* local_name,
                                                                      gint uid,
                                                                      SteadyflowCoreIDownloadFileFinishAction finish_action,
                                                                      const gchar* finish_command);
VALA_EXTERN SteadyflowCoreGioDownloadFile* steadyflow_core_gio_download_file_construct (GType object_type,
                                                                            const gchar* url,
                                                                            const gchar* local_name,
                                                                            gint uid,
                                                                            SteadyflowCoreIDownloadFileFinishAction finish_action,
                                                                            const gchar* finish_command);
static void steadyflow_core_gio_download_file_set_status (SteadyflowCoreGioDownloadFile* self,
                                                   SteadyflowCoreIDownloadFileStatus new_status);
static void steadyflow_core_gio_download_file_on_download_progress (SteadyflowCoreGioDownloadFile* self,
                                                             gint64 current,
                                                             gint64 total);
static void steadyflow_core_gio_download_file_real_start (SteadyflowCoreIDownloadFile* base,
                                                   gboolean resume);
VALA_EXTERN gboolean steadyflow_core_idownload_file_can_start (SteadyflowCoreIDownloadFile* self);
static void steadyflow_core_gio_download_file_do_download (SteadyflowCoreGioDownloadFile* self,
                                                    GFile* remote,
                                                    GFile* local,
                                                    gboolean resume,
                                                    GFileProgressCallback on_progress,
                                                    gpointer on_progress_target,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static void steadyflow_core_gio_download_file_do_download_finish (SteadyflowCoreGioDownloadFile* self,
                                                           GAsyncResult* _res_);
static void _steadyflow_core_gio_download_file_on_download_progress_gfile_progress_callback (gint64 current_num_bytes,
                                                                                      gint64 total_num_bytes,
                                                                                      gpointer self);
static void steadyflow_core_gio_download_file_do_download_data_free (gpointer _data);
static gboolean steadyflow_core_gio_download_file_do_download_co (SteadyflowCoreGioDownloadFileDoDownloadData* _data_);
static void steadyflow_core_gio_download_file_do_download_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
VALA_EXTERN SteadyflowCoreIDownloadFileStatus steadyflow_core_idownload_file_get_status (SteadyflowCoreIDownloadFile* self);
static void steadyflow_core_gio_download_file_real_pause (SteadyflowCoreIDownloadFile* base);
VALA_EXTERN gboolean steadyflow_core_idownload_file_can_pause (SteadyflowCoreIDownloadFile* self);
static void steadyflow_core_gio_download_file_real_serialize (SteadyflowCoreIDownloadFile* base,
                                                       GKeyFile* keys);
VALA_EXTERN gint steadyflow_core_idownload_file_get_uid (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN const gchar* steadyflow_core_idownload_file_get_url (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN const gchar* steadyflow_core_idownload_file_get_local_name (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN gint64 steadyflow_core_idownload_file_get_size (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN SteadyflowCoreIDownloadFileFinishAction steadyflow_core_idownload_file_get_finish_action (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN const gchar* steadyflow_core_idownload_file_get_finish_command (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN SteadyflowCoreIDownloadFile* steadyflow_core_gio_download_file_deserialize (GKeyFile* keys,
                                                                            gint uid,
                                                                            gboolean* should_start,
                                                                            GError** error);
VALA_EXTERN void steadyflow_core_idownload_file_start (SteadyflowCoreIDownloadFile* self,
                                           gboolean resume);
VALA_EXTERN void steadyflow_core_idownload_file_pause (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN void steadyflow_core_idownload_file_serialize (SteadyflowCoreIDownloadFile* self,
                                               GKeyFile* file);
VALA_EXTERN const gchar* steadyflow_core_idownload_file_get_local_basename (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN gint64 steadyflow_core_idownload_file_get_downloaded_size (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN gint steadyflow_core_idownload_file_get_speed (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN const gchar* steadyflow_core_idownload_file_get_icon_name (SteadyflowCoreIDownloadFile* self);
VALA_EXTERN GError* steadyflow_core_idownload_file_get_error (SteadyflowCoreIDownloadFile* self);
static void steadyflow_core_gio_download_file_finalize (GObject * obj);
static GType steadyflow_core_gio_download_file_get_type_once (void);
static void _vala_steadyflow_core_gio_download_file_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec);
static gssize _vala_array_length (gpointer array);

static inline gpointer
steadyflow_core_gio_download_file_get_instance_private (SteadyflowCoreGioDownloadFile* self)
{
	return G_STRUCT_MEMBER_P (self, SteadyflowCoreGioDownloadFile_private_offset);
}

SteadyflowCoreGioDownloadFile*
steadyflow_core_gio_download_file_construct (GType object_type,
                                             const gchar* url,
                                             const gchar* local_name,
                                             gint uid,
                                             SteadyflowCoreIDownloadFileFinishAction finish_action,
                                             const gchar* finish_command)
{
	SteadyflowCoreGioDownloadFile * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* local_file = NULL;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	GFile* remote_file = NULL;
	GFile* _tmp7_;
	guchar* data = NULL;
	gint data_length1;
	gint _data_size_;
	gchar* content_type = NULL;
	GFile* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	guchar* _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GIcon* icon = NULL;
	const gchar* _tmp14_;
	GIcon* _tmp15_;
	GIcon* _tmp16_;
	GTimer* _tmp23_;
	g_return_val_if_fail (url != NULL, NULL);
	g_return_val_if_fail (local_name != NULL, NULL);
	self = (SteadyflowCoreGioDownloadFile*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (url);
	_g_free0 (self->priv->_url);
	self->priv->_url = _tmp0_;
	_tmp1_ = g_strdup (local_name);
	_g_free0 (self->priv->_local_name);
	self->priv->_local_name = _tmp1_;
	self->priv->_uid = uid;
	self->priv->_finish_action = finish_action;
	_tmp2_ = g_strdup (finish_command);
	_g_free0 (self->priv->_finish_command);
	self->priv->_finish_command = _tmp2_;
	_tmp3_ = self->priv->_local_name;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	local_file = _tmp4_;
	_tmp5_ = local_file;
	_tmp6_ = g_file_get_basename (_tmp5_);
	_g_free0 (self->priv->_local_basename);
	self->priv->_local_basename = _tmp6_;
	_tmp7_ = g_file_new_for_uri (url);
	remote_file = _tmp7_;
	data = NULL;
	data_length1 = 0;
	_data_size_ = data_length1;
	_tmp8_ = remote_file;
	_tmp9_ = g_file_get_basename (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = data;
	_tmp11__length1 = data_length1;
	_tmp12_ = g_content_type_guess (_tmp10_, _tmp11_, (gsize) _tmp11__length1, NULL);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp10_);
	content_type = _tmp13_;
	_tmp14_ = content_type;
	_tmp15_ = g_content_type_get_icon (_tmp14_);
	icon = _tmp15_;
	_tmp16_ = icon;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, g_themed_icon_get_type ())) {
		GIcon* _tmp17_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		gchar** _tmp19_;
		gint _tmp19__length1;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp17_ = icon;
		_tmp18_ = g_themed_icon_get_names (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, g_themed_icon_get_type ()) ? ((GThemedIcon*) _tmp17_) : NULL);
		_tmp18__length1 = _vala_array_length (_tmp18_);
		_tmp19_ = _tmp18_;
		_tmp19__length1 = _tmp18__length1;
		_tmp20_ = _tmp19_[0];
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (self->priv->_icon);
		self->priv->_icon = _tmp21_;
	} else {
		gchar* _tmp22_;
		_tmp22_ = g_strdup ("text-x-generic");
		_g_free0 (self->priv->_icon);
		self->priv->_icon = _tmp22_;
	}
	self->priv->_downloaded_size = (gint64) 0;
	self->priv->_old_downloaded_size = (gint64) 0;
	self->priv->_speed = 0;
	self->priv->_status = STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_PAUSED;
	_tmp23_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->timer);
	self->priv->timer = _tmp23_;
	_g_object_unref0 (icon);
	_g_free0 (content_type);
	data = (g_free (data), NULL);
	_g_object_unref0 (remote_file);
	_g_object_unref0 (local_file);
	return self;
}

SteadyflowCoreGioDownloadFile*
steadyflow_core_gio_download_file_new (const gchar* url,
                                       const gchar* local_name,
                                       gint uid,
                                       SteadyflowCoreIDownloadFileFinishAction finish_action,
                                       const gchar* finish_command)
{
	return steadyflow_core_gio_download_file_construct (STEADYFLOW_CORE_TYPE_GIO_DOWNLOAD_FILE, url, local_name, uid, finish_action, finish_command);
}

static void
steadyflow_core_gio_download_file_set_status (SteadyflowCoreGioDownloadFile* self,
                                              SteadyflowCoreIDownloadFileStatus new_status)
{
	SteadyflowCoreIDownloadFileStatus old_status = 0;
	g_return_if_fail (self != NULL);
	old_status = self->priv->_status;
	self->priv->_status = new_status;
	if (new_status != STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_NETWORK_ERROR) {
		_g_error_free0 (self->priv->_error);
		self->priv->_error = NULL;
	}
	if (old_status != new_status) {
		g_signal_emit_by_name ((SteadyflowCoreIDownloadFile*) self, "status-changed", old_status);
	}
}

static void
steadyflow_core_gio_download_file_on_download_progress (SteadyflowCoreGioDownloadFile* self,
                                                        gint64 current,
                                                        gint64 total)
{
	gdouble elapsed = 0.0;
	GTimer* _tmp0_;
	gint64 old_size = 0LL;
	g_return_if_fail (self != NULL);
	self->priv->_size = total;
	_tmp0_ = self->priv->timer;
	elapsed = g_timer_elapsed (_tmp0_, NULL);
	if (elapsed >= STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_SPEED_UPDATE_SEC) {
		GTimer* _tmp1_;
		self->priv->_speed = (gint) ((current - self->priv->_old_downloaded_size) / elapsed);
		_tmp1_ = self->priv->timer;
		g_timer_start (_tmp1_);
		self->priv->_old_downloaded_size = current;
	}
	old_size = self->priv->_downloaded_size;
	self->priv->_downloaded_size = current;
	g_signal_emit_by_name ((SteadyflowCoreIDownloadFile*) self, "download-progressed", old_size);
}

static void
_steadyflow_core_gio_download_file_on_download_progress_gfile_progress_callback (gint64 current_num_bytes,
                                                                                 gint64 total_num_bytes,
                                                                                 gpointer self)
{
	steadyflow_core_gio_download_file_on_download_progress ((SteadyflowCoreGioDownloadFile*) self, current_num_bytes, total_num_bytes);
}

static void
steadyflow_core_gio_download_file_real_start (SteadyflowCoreIDownloadFile* base,
                                              gboolean resume)
{
	SteadyflowCoreGioDownloadFile * self;
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GTimer* _tmp2_;
	GFile* _tmp3_;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	self = (SteadyflowCoreGioDownloadFile*) base;
	if (!steadyflow_core_idownload_file_can_start ((SteadyflowCoreIDownloadFile*) self)) {
		return;
	}
	steadyflow_core_gio_download_file_set_status (self, STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_CONNECTING);
	_tmp0_ = self->priv->_url;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	file = _tmp1_;
	_tmp2_ = self->priv->timer;
	g_timer_start (_tmp2_);
	_tmp3_ = file;
	_tmp4_ = self->priv->_local_name;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	_tmp6_ = _tmp5_;
	steadyflow_core_gio_download_file_do_download (self, _tmp3_, _tmp6_, resume, _steadyflow_core_gio_download_file_on_download_progress_gfile_progress_callback, self, NULL, NULL);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (file);
}

static void
steadyflow_core_gio_download_file_do_download_data_free (gpointer _data)
{
	SteadyflowCoreGioDownloadFileDoDownloadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->remote);
	_g_object_unref0 (_data_->local);
	_g_object_unref0 (_data_->self);
	g_slice_free (SteadyflowCoreGioDownloadFileDoDownloadData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
steadyflow_core_gio_download_file_do_download (SteadyflowCoreGioDownloadFile* self,
                                               GFile* remote,
                                               GFile* local,
                                               gboolean resume,
                                               GFileProgressCallback on_progress,
                                               gpointer on_progress_target,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	SteadyflowCoreGioDownloadFileDoDownloadData* _data_;
	SteadyflowCoreGioDownloadFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (remote != NULL);
	g_return_if_fail (local != NULL);
	_data_ = g_slice_new0 (SteadyflowCoreGioDownloadFileDoDownloadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, steadyflow_core_gio_download_file_do_download_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (remote);
	_g_object_unref0 (_data_->remote);
	_data_->remote = _tmp1_;
	_tmp2_ = _g_object_ref0 (local);
	_g_object_unref0 (_data_->local);
	_data_->local = _tmp2_;
	_data_->resume = resume;
	_data_->on_progress = on_progress;
	_data_->on_progress_target = on_progress_target;
	steadyflow_core_gio_download_file_do_download_co (_data_);
}

static void
steadyflow_core_gio_download_file_do_download_finish (SteadyflowCoreGioDownloadFile* self,
                                                      GAsyncResult* _res_)
{
	SteadyflowCoreGioDownloadFileDoDownloadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
steadyflow_core_gio_download_file_do_download_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	SteadyflowCoreGioDownloadFileDoDownloadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	steadyflow_core_gio_download_file_do_download_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
steadyflow_core_gio_download_file_do_download_co (SteadyflowCoreGioDownloadFileDoDownloadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		case 8:
		goto _state_8;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		{
			_data_->_state_ = 1;
			g_file_find_enclosing_mount_async (_data_->remote, 0, NULL, steadyflow_core_gio_download_file_do_download_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp0_ = g_file_find_enclosing_mount_finish (_data_->remote, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp1_ = _data_->_tmp0_;
			_g_object_unref0 (_data_->_tmp1_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == G_IO_ERROR) {
					goto __catch1_g_io_error;
				}
				goto __finally1;
			}
		}
		goto __finally1;
		__catch1_g_io_error:
		{
			g_clear_error (&_data_->_inner_error0_);
			_data_->_tmp2_ = NULL;
			g_signal_emit_by_name ((SteadyflowCoreIDownloadFile*) _data_->self, "get-mount-operation", &_data_->_tmp2_);
			_g_object_unref0 (_data_->mount_op);
			_data_->mount_op = _data_->_tmp2_;
			{
				_data_->_tmp3_ = _data_->mount_op;
				_data_->_state_ = 2;
				g_file_mount_enclosing_volume (_data_->remote, G_MOUNT_MOUNT_NONE, _data_->_tmp3_, NULL, steadyflow_core_gio_download_file_do_download_ready, _data_);
				return FALSE;
				_state_2:
				g_file_mount_enclosing_volume_finish (_data_->remote, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				g_clear_error (&_data_->_inner_error0_);
			}
			__finally2:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->mount_op);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->mount_op);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			_data_->_state_ = 3;
			g_file_query_info_async (_data_->remote, G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, 0, NULL, steadyflow_core_gio_download_file_do_download_ready, _data_);
			return FALSE;
			_state_3:
			_data_->_tmp4_ = g_file_query_info_finish (_data_->remote, _data_->_res_, &_data_->_inner_error0_);
			_data_->info = _data_->_tmp4_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == G_IO_ERROR) {
					goto __catch3_g_io_error;
				}
				goto __finally3;
			}
			_data_->_tmp5_ = _data_->info;
			_data_->self->priv->_size = (gint64) g_file_info_get_attribute_uint64 (_data_->_tmp5_, G_FILE_ATTRIBUTE_STANDARD_SIZE);
			_g_object_unref0 (_data_->info);
		}
		goto __finally3;
		__catch3_g_io_error:
		{
			g_clear_error (&_data_->_inner_error0_);
			_data_->_tmp6_ = stderr;
			fprintf (_data_->_tmp6_, "Cannot query file size, continuing with an unknown size\n");
		}
		__finally3:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_state_ = 4;
		g_file_read_async (_data_->remote, G_PRIORITY_DEFAULT, NULL, steadyflow_core_gio_download_file_do_download_ready, _data_);
		return FALSE;
		_state_4:
		_data_->_tmp7_ = g_file_read_finish (_data_->remote, _data_->_res_, &_data_->_inner_error0_);
		_data_->input = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_data_->resume) {
			_data_->_tmp10_ = _data_->input;
			_data_->_tmp9_ = G_TYPE_INSTANCE_GET_CLASS (_data_->_tmp10_, g_file_input_stream_get_type (), GFileInputStreamClass)->can_seek (_data_->_tmp10_);
		} else {
			_data_->_tmp9_ = FALSE;
		}
		if (_data_->_tmp9_) {
			_data_->_tmp8_ = g_file_query_exists (_data_->local, NULL);
		} else {
			_data_->_tmp8_ = FALSE;
		}
		if (_data_->_tmp8_) {
			_data_->_state_ = 5;
			g_file_append_to_async (_data_->local, G_FILE_CREATE_NONE, 0, NULL, steadyflow_core_gio_download_file_do_download_ready, _data_);
			return FALSE;
			_state_5:
			_data_->_tmp12_ = g_file_append_to_finish (_data_->local, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp11_ = _data_->_tmp12_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->output);
				_g_object_unref0 (_data_->input);
				goto __catch0_g_error;
			}
			_data_->_tmp13_ = _data_->_tmp11_;
			_data_->_tmp11_ = NULL;
			_g_object_unref0 (_data_->output);
			_data_->output = _data_->_tmp13_;
			_data_->_tmp14_ = _data_->output;
			G_TYPE_INSTANCE_GET_CLASS (_data_->_tmp14_, g_file_output_stream_get_type (), GFileOutputStreamClass)->seek (_data_->_tmp14_, (gint64) 0, G_SEEK_END, NULL, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->_tmp11_);
				_g_object_unref0 (_data_->output);
				_g_object_unref0 (_data_->input);
				goto __catch0_g_error;
			}
			_data_->_tmp15_ = _data_->output;
			_data_->self->priv->_downloaded_size = G_TYPE_INSTANCE_GET_CLASS (_data_->_tmp15_, g_file_output_stream_get_type (), GFileOutputStreamClass)->tell (_data_->_tmp15_);
			_data_->_tmp16_ = _data_->input;
			G_TYPE_INSTANCE_GET_CLASS (_data_->_tmp16_, g_file_input_stream_get_type (), GFileInputStreamClass)->seek (_data_->_tmp16_, _data_->self->priv->_downloaded_size, G_SEEK_SET, NULL, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->_tmp11_);
				_g_object_unref0 (_data_->output);
				_g_object_unref0 (_data_->input);
				goto __catch0_g_error;
			}
			_g_object_unref0 (_data_->_tmp11_);
		} else {
			_data_->_state_ = 6;
			g_file_replace_async (_data_->local, NULL, FALSE, G_FILE_CREATE_NONE, 0, NULL, steadyflow_core_gio_download_file_do_download_ready, _data_);
			return FALSE;
			_state_6:
			_data_->_tmp18_ = g_file_replace_finish (_data_->local, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp17_ = _data_->_tmp18_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->output);
				_g_object_unref0 (_data_->input);
				goto __catch0_g_error;
			}
			_data_->_tmp19_ = _data_->_tmp17_;
			_data_->_tmp17_ = NULL;
			_g_object_unref0 (_data_->output);
			_data_->output = _data_->_tmp19_;
			_g_object_unref0 (_data_->_tmp17_);
		}
		steadyflow_core_gio_download_file_set_status (_data_->self, STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_DOWNLOADING);
		_data_->_tmp20_ = g_new0 (guint8, 4096);
		_data_->buf = _data_->_tmp20_;
		_data_->buf_length1 = 4096;
		_data_->_buf_size_ = _data_->buf_length1;
		while (TRUE) {
			_data_->_tmp21_ = steadyflow_core_idownload_file_get_status ((SteadyflowCoreIDownloadFile*) _data_->self);
			_data_->_tmp22_ = _data_->_tmp21_;
			if (!(_data_->_tmp22_ == STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_DOWNLOADING)) {
				break;
			}
			_data_->_tmp23_ = _data_->input;
			_data_->_tmp24_ = _data_->buf;
			_data_->_tmp24__length1 = _data_->buf_length1;
			_data_->_state_ = 7;
			g_input_stream_read_async ((GInputStream*) _data_->_tmp23_, _data_->_tmp24_, (gsize) _data_->_tmp24__length1, G_PRIORITY_DEFAULT, NULL, steadyflow_core_gio_download_file_do_download_ready, _data_);
			return FALSE;
			_state_7:
			_data_->read = g_input_stream_read_finish ((GInputStream*) _data_->_tmp23_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_data_->buf = (g_free (_data_->buf), NULL);
				_g_object_unref0 (_data_->output);
				_g_object_unref0 (_data_->input);
				goto __catch0_g_error;
			}
			if (_data_->read == ((gssize) 0)) {
				_data_->_tmp25_ = _data_->self->priv->timer;
				g_timer_stop (_data_->_tmp25_);
				steadyflow_core_gio_download_file_set_status (_data_->self, STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_FINISHED);
				break;
			}
			_data_->_tmp26_ = _data_->output;
			_data_->_tmp27_ = _data_->buf;
			_data_->_tmp27__length1 = _data_->buf_length1;
			_data_->_state_ = 8;
			g_output_stream_write_async ((GOutputStream*) _data_->_tmp26_, _data_->_tmp27_ + 0, (gsize) (((gint) _data_->read) - 0), G_PRIORITY_DEFAULT, NULL, steadyflow_core_gio_download_file_do_download_ready, _data_);
			return FALSE;
			_state_8:
			g_output_stream_write_finish ((GOutputStream*) _data_->_tmp26_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_data_->buf = (g_free (_data_->buf), NULL);
				_g_object_unref0 (_data_->output);
				_g_object_unref0 (_data_->input);
				goto __catch0_g_error;
			}
			steadyflow_core_gio_download_file_on_download_progress (_data_->self, _data_->self->priv->_downloaded_size + _data_->read, _data_->self->priv->_size);
		}
		_data_->buf = (g_free (_data_->buf), NULL);
		_g_object_unref0 (_data_->output);
		_g_object_unref0 (_data_->input);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp28_ = _data_->e;
		_data_->_tmp29_ = _g_error_copy0 (_data_->_tmp28_);
		_g_error_free0 (_data_->self->priv->_error);
		_data_->self->priv->_error = _data_->_tmp29_;
		steadyflow_core_gio_download_file_set_status (_data_->self, STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_NETWORK_ERROR);
		_data_->_tmp30_ = _data_->self->priv->timer;
		g_timer_stop (_data_->_tmp30_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
steadyflow_core_gio_download_file_real_pause (SteadyflowCoreIDownloadFile* base)
{
	SteadyflowCoreGioDownloadFile * self;
	self = (SteadyflowCoreGioDownloadFile*) base;
	if (steadyflow_core_idownload_file_can_pause ((SteadyflowCoreIDownloadFile*) self)) {
		GTimer* _tmp0_;
		steadyflow_core_gio_download_file_set_status (self, STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_PAUSED);
		_tmp0_ = self->priv->timer;
		g_timer_stop (_tmp0_);
	}
}

static void
steadyflow_core_gio_download_file_real_serialize (SteadyflowCoreIDownloadFile* base,
                                                  GKeyFile* keys)
{
	SteadyflowCoreGioDownloadFile * self;
	gchar* group = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint64 _tmp10_;
	gint64 _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	SteadyflowCoreIDownloadFileStatus _tmp15_;
	SteadyflowCoreIDownloadFileStatus _tmp16_;
	const gchar* _tmp17_;
	SteadyflowCoreIDownloadFileFinishAction _tmp18_;
	SteadyflowCoreIDownloadFileFinishAction _tmp19_;
	SteadyflowCoreIDownloadFileFinishAction _tmp20_;
	SteadyflowCoreIDownloadFileFinishAction _tmp21_;
	self = (SteadyflowCoreGioDownloadFile*) base;
	g_return_if_fail (keys != NULL);
	_tmp0_ = steadyflow_core_idownload_file_get_uid ((SteadyflowCoreIDownloadFile*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%i", _tmp1_);
	group = _tmp2_;
	_tmp3_ = group;
	_tmp4_ = steadyflow_core_idownload_file_get_url ((SteadyflowCoreIDownloadFile*) self);
	_tmp5_ = _tmp4_;
	g_key_file_set_string (keys, _tmp3_, "url", _tmp5_);
	_tmp6_ = group;
	_tmp7_ = steadyflow_core_idownload_file_get_local_name ((SteadyflowCoreIDownloadFile*) self);
	_tmp8_ = _tmp7_;
	g_key_file_set_string (keys, _tmp6_, "local_name", _tmp8_);
	_tmp9_ = group;
	_tmp10_ = steadyflow_core_idownload_file_get_size ((SteadyflowCoreIDownloadFile*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp11_);
	_tmp13_ = _tmp12_;
	g_key_file_set_string (keys, _tmp9_, "size", _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = group;
	_tmp15_ = steadyflow_core_idownload_file_get_status ((SteadyflowCoreIDownloadFile*) self);
	_tmp16_ = _tmp15_;
	g_key_file_set_integer (keys, _tmp14_, "status", (gint) _tmp16_);
	_tmp17_ = group;
	_tmp18_ = steadyflow_core_idownload_file_get_finish_action ((SteadyflowCoreIDownloadFile*) self);
	_tmp19_ = _tmp18_;
	g_key_file_set_integer (keys, _tmp17_, "finish_action", (gint) _tmp19_);
	_tmp20_ = steadyflow_core_idownload_file_get_finish_action ((SteadyflowCoreIDownloadFile*) self);
	_tmp21_ = _tmp20_;
	if (_tmp21_ == STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_RUN_COMMAND) {
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		_tmp22_ = group;
		_tmp23_ = steadyflow_core_idownload_file_get_finish_command ((SteadyflowCoreIDownloadFile*) self);
		_tmp24_ = _tmp23_;
		g_key_file_set_string (keys, _tmp22_, "finish_command", _tmp24_);
	}
	_g_free0 (group);
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

SteadyflowCoreIDownloadFile*
steadyflow_core_gio_download_file_deserialize (GKeyFile* keys,
                                               gint uid,
                                               gboolean* should_start,
                                               GError** error)
{
	gboolean _vala_should_start = FALSE;
	gchar* group = NULL;
	gchar* _tmp0_;
	gchar* url = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* local_name = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gint64 size = 0LL;
	gint _tmp8_ = 0;
	const gchar* _tmp9_;
	SteadyflowCoreIDownloadFileStatus status = 0;
	gint _tmp10_ = 0;
	const gchar* _tmp11_;
	SteadyflowCoreIDownloadFileFinishAction finish_action = 0;
	gchar* finish_command = NULL;
	SteadyflowCoreGioDownloadFile* file = NULL;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	SteadyflowCoreGioDownloadFile* _tmp19_;
	SteadyflowCoreGioDownloadFile* _tmp20_;
	SteadyflowCoreGioDownloadFile* _tmp21_;
	SteadyflowCoreGioDownloadFile* _tmp22_;
	GError* _inner_error0_ = NULL;
	SteadyflowCoreIDownloadFile* result;
	g_return_val_if_fail (keys != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%i", uid);
	group = _tmp0_;
	_tmp1_ = group;
	_tmp2_ = g_key_file_get_string (keys, _tmp1_, "url", &_inner_error0_);
	url = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (group);
		return NULL;
	}
	_tmp3_ = group;
	_tmp4_ = g_key_file_get_string (keys, _tmp3_, "local_name", &_inner_error0_);
	local_name = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (url);
		_g_free0 (group);
		return NULL;
	}
	_tmp6_ = group;
	_tmp7_ = g_key_file_get_string (keys, _tmp6_, "size", &_inner_error0_);
	_tmp5_ = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (local_name);
		_g_free0 (url);
		_g_free0 (group);
		return NULL;
	}
	size = int64_parse (_tmp5_, (guint) 0);
	_tmp9_ = group;
	_tmp8_ = g_key_file_get_integer (keys, _tmp9_, "status", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp5_);
		_g_free0 (local_name);
		_g_free0 (url);
		_g_free0 (group);
		return NULL;
	}
	status = (SteadyflowCoreIDownloadFileStatus) _tmp8_;
	_tmp11_ = group;
	_tmp10_ = g_key_file_get_integer (keys, _tmp11_, "finish_action", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp5_);
		_g_free0 (local_name);
		_g_free0 (url);
		_g_free0 (group);
		return NULL;
	}
	finish_action = (SteadyflowCoreIDownloadFileFinishAction) _tmp10_;
	finish_command = NULL;
	if (finish_action == STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_RUN_COMMAND) {
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp13_ = group;
		_tmp14_ = g_key_file_get_string (keys, _tmp13_, "finish_command", &_inner_error0_);
		_tmp12_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (finish_command);
			_g_free0 (_tmp5_);
			_g_free0 (local_name);
			_g_free0 (url);
			_g_free0 (group);
			return NULL;
		}
		_tmp15_ = _tmp12_;
		_tmp12_ = NULL;
		_g_free0 (finish_command);
		finish_command = _tmp15_;
		_g_free0 (_tmp12_);
	}
	_tmp16_ = url;
	_tmp17_ = local_name;
	_tmp18_ = finish_command;
	_tmp19_ = steadyflow_core_gio_download_file_new (_tmp16_, _tmp17_, uid, finish_action, _tmp18_);
	file = _tmp19_;
	_tmp20_ = file;
	_tmp20_->priv->_size = size;
	_tmp21_ = file;
	_tmp21_->priv->_status = status;
	_tmp22_ = file;
	if (steadyflow_core_idownload_file_can_pause ((SteadyflowCoreIDownloadFile*) _tmp22_)) {
		SteadyflowCoreGioDownloadFile* _tmp23_;
		_tmp23_ = file;
		_tmp23_->priv->_status = STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_PAUSED;
		_vala_should_start = TRUE;
	} else {
		_vala_should_start = FALSE;
	}
	{
		GFile* local_file = NULL;
		const gchar* _tmp24_;
		GFile* _tmp25_;
		GFileInfo* info = NULL;
		GFile* _tmp26_;
		GFileInfo* _tmp27_;
		SteadyflowCoreGioDownloadFile* _tmp28_;
		GFileInfo* _tmp29_;
		_tmp24_ = local_name;
		_tmp25_ = g_file_new_for_path (_tmp24_);
		local_file = _tmp25_;
		_tmp26_ = local_file;
		_tmp27_ = g_file_query_info (_tmp26_, G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp27_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (local_file);
			goto __catch0_g_error;
		}
		_tmp28_ = file;
		_tmp29_ = info;
		_tmp28_->priv->_downloaded_size = (gint64) g_file_info_get_attribute_uint64 (_tmp29_, G_FILE_ATTRIBUTE_STANDARD_SIZE);
		_g_object_unref0 (info);
		_g_object_unref0 (local_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		_g_free0 (finish_command);
		_g_free0 (_tmp5_);
		_g_free0 (local_name);
		_g_free0 (url);
		_g_free0 (group);
		return NULL;
	}
	result = (SteadyflowCoreIDownloadFile*) file;
	_g_free0 (finish_command);
	_g_free0 (_tmp5_);
	_g_free0 (local_name);
	_g_free0 (url);
	_g_free0 (group);
	if (should_start) {
		*should_start = _vala_should_start;
	}
	return result;
}

static SteadyflowCoreIDownloadFileStatus
steadyflow_core_gio_download_file_real_get_status (SteadyflowCoreIDownloadFile* base)
{
	SteadyflowCoreIDownloadFileStatus result;
	SteadyflowCoreGioDownloadFile* self;
	self = (SteadyflowCoreGioDownloadFile*) base;
	result = self->priv->_status;
	return result;
}

static gint
steadyflow_core_gio_download_file_real_get_uid (SteadyflowCoreIDownloadFile* base)
{
	gint result;
	SteadyflowCoreGioDownloadFile* self;
	self = (SteadyflowCoreGioDownloadFile*) base;
	result = self->priv->_uid;
	return result;
}

static const gchar*
steadyflow_core_gio_download_file_real_get_url (SteadyflowCoreIDownloadFile* base)
{
	const gchar* result;
	SteadyflowCoreGioDownloadFile* self;
	const gchar* _tmp0_;
	self = (SteadyflowCoreGioDownloadFile*) base;
	_tmp0_ = self->priv->_url;
	result = _tmp0_;
	return result;
}

static const gchar*
steadyflow_core_gio_download_file_real_get_local_name (SteadyflowCoreIDownloadFile* base)
{
	const gchar* result;
	SteadyflowCoreGioDownloadFile* self;
	const gchar* _tmp0_;
	self = (SteadyflowCoreGioDownloadFile*) base;
	_tmp0_ = self->priv->_local_name;
	result = _tmp0_;
	return result;
}

static const gchar*
steadyflow_core_gio_download_file_real_get_local_basename (SteadyflowCoreIDownloadFile* base)
{
	const gchar* result;
	SteadyflowCoreGioDownloadFile* self;
	const gchar* _tmp0_;
	self = (SteadyflowCoreGioDownloadFile*) base;
	_tmp0_ = self->priv->_local_basename;
	result = _tmp0_;
	return result;
}

static gint64
steadyflow_core_gio_download_file_real_get_size (SteadyflowCoreIDownloadFile* base)
{
	gint64 result;
	SteadyflowCoreGioDownloadFile* self;
	self = (SteadyflowCoreGioDownloadFile*) base;
	result = self->priv->_size;
	return result;
}

static gint64
steadyflow_core_gio_download_file_real_get_downloaded_size (SteadyflowCoreIDownloadFile* base)
{
	gint64 result;
	SteadyflowCoreGioDownloadFile* self;
	self = (SteadyflowCoreGioDownloadFile*) base;
	result = self->priv->_downloaded_size;
	return result;
}

static gint
steadyflow_core_gio_download_file_real_get_speed (SteadyflowCoreIDownloadFile* base)
{
	gint result;
	SteadyflowCoreGioDownloadFile* self;
	self = (SteadyflowCoreGioDownloadFile*) base;
	result = self->priv->_speed;
	return result;
}

static const gchar*
steadyflow_core_gio_download_file_real_get_icon_name (SteadyflowCoreIDownloadFile* base)
{
	const gchar* result;
	SteadyflowCoreGioDownloadFile* self;
	const gchar* _tmp0_;
	self = (SteadyflowCoreGioDownloadFile*) base;
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

static SteadyflowCoreIDownloadFileFinishAction
steadyflow_core_gio_download_file_real_get_finish_action (SteadyflowCoreIDownloadFile* base)
{
	SteadyflowCoreIDownloadFileFinishAction result;
	SteadyflowCoreGioDownloadFile* self;
	self = (SteadyflowCoreGioDownloadFile*) base;
	result = self->priv->_finish_action;
	return result;
}

static const gchar*
steadyflow_core_gio_download_file_real_get_finish_command (SteadyflowCoreIDownloadFile* base)
{
	const gchar* result;
	SteadyflowCoreGioDownloadFile* self;
	const gchar* _tmp0_;
	self = (SteadyflowCoreGioDownloadFile*) base;
	_tmp0_ = self->priv->_finish_command;
	result = _tmp0_;
	return result;
}

static GError*
steadyflow_core_gio_download_file_real_get_error (SteadyflowCoreIDownloadFile* base)
{
	GError* result;
	SteadyflowCoreGioDownloadFile* self;
	GError* _tmp0_;
	self = (SteadyflowCoreGioDownloadFile*) base;
	_tmp0_ = self->priv->_error;
	result = _tmp0_;
	return result;
}

static void
steadyflow_core_gio_download_file_class_init (SteadyflowCoreGioDownloadFileClass * klass,
                                              gpointer klass_data)
{
	steadyflow_core_gio_download_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SteadyflowCoreGioDownloadFile_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_steadyflow_core_gio_download_file_get_property;
	G_OBJECT_CLASS (klass)->finalize = steadyflow_core_gio_download_file_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_STATUS_PROPERTY, steadyflow_core_gio_download_file_properties[STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_STATUS_PROPERTY] = g_param_spec_enum ("status", "status", "status", STEADYFLOW_CORE_IDOWNLOAD_FILE_TYPE_STATUS, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_UID_PROPERTY, steadyflow_core_gio_download_file_properties[STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_UID_PROPERTY] = g_param_spec_int ("uid", "uid", "uid", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_URL_PROPERTY, steadyflow_core_gio_download_file_properties[STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_URL_PROPERTY] = g_param_spec_string ("url", "url", "url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_LOCAL_NAME_PROPERTY, steadyflow_core_gio_download_file_properties[STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_LOCAL_NAME_PROPERTY] = g_param_spec_string ("local-name", "local-name", "local-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_LOCAL_BASENAME_PROPERTY, steadyflow_core_gio_download_file_properties[STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_LOCAL_BASENAME_PROPERTY] = g_param_spec_string ("local-basename", "local-basename", "local-basename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_SIZE_PROPERTY, steadyflow_core_gio_download_file_properties[STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_SIZE_PROPERTY] = g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_DOWNLOADED_SIZE_PROPERTY, steadyflow_core_gio_download_file_properties[STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_DOWNLOADED_SIZE_PROPERTY] = g_param_spec_int64 ("downloaded-size", "downloaded-size", "downloaded-size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_SPEED_PROPERTY, steadyflow_core_gio_download_file_properties[STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_SPEED_PROPERTY] = g_param_spec_int ("speed", "speed", "speed", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_ICON_NAME_PROPERTY, steadyflow_core_gio_download_file_properties[STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_FINISH_ACTION_PROPERTY, steadyflow_core_gio_download_file_properties[STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_FINISH_ACTION_PROPERTY] = g_param_spec_enum ("finish-action", "finish-action", "finish-action", STEADYFLOW_CORE_IDOWNLOAD_FILE_TYPE_FINISH_ACTION, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_FINISH_COMMAND_PROPERTY, steadyflow_core_gio_download_file_properties[STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_FINISH_COMMAND_PROPERTY] = g_param_spec_string ("finish-command", "finish-command", "finish-command", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_ERROR_PROPERTY, steadyflow_core_gio_download_file_properties[STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_ERROR_PROPERTY] = g_param_spec_boxed ("error", "error", "error", G_TYPE_ERROR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
steadyflow_core_gio_download_file_steadyflow_core_idownload_file_interface_init (SteadyflowCoreIDownloadFileIface * iface,
                                                                                 gpointer iface_data)
{
	steadyflow_core_gio_download_file_steadyflow_core_idownload_file_parent_iface = g_type_interface_peek_parent (iface);
	iface->start = (void (*) (SteadyflowCoreIDownloadFile*, gboolean)) steadyflow_core_gio_download_file_real_start;
	iface->pause = (void (*) (SteadyflowCoreIDownloadFile*)) steadyflow_core_gio_download_file_real_pause;
	iface->serialize = (void (*) (SteadyflowCoreIDownloadFile*, GKeyFile*)) steadyflow_core_gio_download_file_real_serialize;
	iface->get_status = steadyflow_core_gio_download_file_real_get_status;
	iface->get_uid = steadyflow_core_gio_download_file_real_get_uid;
	iface->get_url = steadyflow_core_gio_download_file_real_get_url;
	iface->get_local_name = steadyflow_core_gio_download_file_real_get_local_name;
	iface->get_local_basename = steadyflow_core_gio_download_file_real_get_local_basename;
	iface->get_size = steadyflow_core_gio_download_file_real_get_size;
	iface->get_downloaded_size = steadyflow_core_gio_download_file_real_get_downloaded_size;
	iface->get_speed = steadyflow_core_gio_download_file_real_get_speed;
	iface->get_icon_name = steadyflow_core_gio_download_file_real_get_icon_name;
	iface->get_finish_action = steadyflow_core_gio_download_file_real_get_finish_action;
	iface->get_finish_command = steadyflow_core_gio_download_file_real_get_finish_command;
	iface->get_error = steadyflow_core_gio_download_file_real_get_error;
}

static void
steadyflow_core_gio_download_file_instance_init (SteadyflowCoreGioDownloadFile * self,
                                                 gpointer klass)
{
	self->priv = steadyflow_core_gio_download_file_get_instance_private (self);
}

static void
steadyflow_core_gio_download_file_finalize (GObject * obj)
{
	SteadyflowCoreGioDownloadFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, STEADYFLOW_CORE_TYPE_GIO_DOWNLOAD_FILE, SteadyflowCoreGioDownloadFile);
	_g_free0 (self->priv->_url);
	_g_free0 (self->priv->_local_name);
	_g_free0 (self->priv->_local_basename);
	_g_free0 (self->priv->_icon);
	_g_free0 (self->priv->_finish_command);
	_g_error_free0 (self->priv->_error);
	_g_timer_destroy0 (self->priv->timer);
	G_OBJECT_CLASS (steadyflow_core_gio_download_file_parent_class)->finalize (obj);
}

static GType
steadyflow_core_gio_download_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SteadyflowCoreGioDownloadFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) steadyflow_core_gio_download_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SteadyflowCoreGioDownloadFile), 0, (GInstanceInitFunc) steadyflow_core_gio_download_file_instance_init, NULL };
	static const GInterfaceInfo steadyflow_core_idownload_file_info = { (GInterfaceInitFunc) steadyflow_core_gio_download_file_steadyflow_core_idownload_file_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType steadyflow_core_gio_download_file_type_id;
	steadyflow_core_gio_download_file_type_id = g_type_register_static (G_TYPE_OBJECT, "SteadyflowCoreGioDownloadFile", &g_define_type_info, 0);
	g_type_add_interface_static (steadyflow_core_gio_download_file_type_id, STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, &steadyflow_core_idownload_file_info);
	SteadyflowCoreGioDownloadFile_private_offset = g_type_add_instance_private (steadyflow_core_gio_download_file_type_id, sizeof (SteadyflowCoreGioDownloadFilePrivate));
	return steadyflow_core_gio_download_file_type_id;
}

GType
steadyflow_core_gio_download_file_get_type (void)
{
	static volatile gsize steadyflow_core_gio_download_file_type_id__once = 0;
	if (g_once_init_enter (&steadyflow_core_gio_download_file_type_id__once)) {
		GType steadyflow_core_gio_download_file_type_id;
		steadyflow_core_gio_download_file_type_id = steadyflow_core_gio_download_file_get_type_once ();
		g_once_init_leave (&steadyflow_core_gio_download_file_type_id__once, steadyflow_core_gio_download_file_type_id);
	}
	return steadyflow_core_gio_download_file_type_id__once;
}

static void
_vala_steadyflow_core_gio_download_file_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec)
{
	SteadyflowCoreGioDownloadFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, STEADYFLOW_CORE_TYPE_GIO_DOWNLOAD_FILE, SteadyflowCoreGioDownloadFile);
	switch (property_id) {
		case STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_STATUS_PROPERTY:
		g_value_set_enum (value, steadyflow_core_idownload_file_get_status ((SteadyflowCoreIDownloadFile*) self));
		break;
		case STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_UID_PROPERTY:
		g_value_set_int (value, steadyflow_core_idownload_file_get_uid ((SteadyflowCoreIDownloadFile*) self));
		break;
		case STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_URL_PROPERTY:
		g_value_set_string (value, steadyflow_core_idownload_file_get_url ((SteadyflowCoreIDownloadFile*) self));
		break;
		case STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_LOCAL_NAME_PROPERTY:
		g_value_set_string (value, steadyflow_core_idownload_file_get_local_name ((SteadyflowCoreIDownloadFile*) self));
		break;
		case STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_LOCAL_BASENAME_PROPERTY:
		g_value_set_string (value, steadyflow_core_idownload_file_get_local_basename ((SteadyflowCoreIDownloadFile*) self));
		break;
		case STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_SIZE_PROPERTY:
		g_value_set_int64 (value, steadyflow_core_idownload_file_get_size ((SteadyflowCoreIDownloadFile*) self));
		break;
		case STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_DOWNLOADED_SIZE_PROPERTY:
		g_value_set_int64 (value, steadyflow_core_idownload_file_get_downloaded_size ((SteadyflowCoreIDownloadFile*) self));
		break;
		case STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_SPEED_PROPERTY:
		g_value_set_int (value, steadyflow_core_idownload_file_get_speed ((SteadyflowCoreIDownloadFile*) self));
		break;
		case STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_ICON_NAME_PROPERTY:
		g_value_set_string (value, steadyflow_core_idownload_file_get_icon_name ((SteadyflowCoreIDownloadFile*) self));
		break;
		case STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_FINISH_ACTION_PROPERTY:
		g_value_set_enum (value, steadyflow_core_idownload_file_get_finish_action ((SteadyflowCoreIDownloadFile*) self));
		break;
		case STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_FINISH_COMMAND_PROPERTY:
		g_value_set_string (value, steadyflow_core_idownload_file_get_finish_command ((SteadyflowCoreIDownloadFile*) self));
		break;
		case STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_ERROR_PROPERTY:
		g_value_set_boxed (value, steadyflow_core_idownload_file_get_error ((SteadyflowCoreIDownloadFile*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

