/* App.c generated by valac 0.56.17, the Vala compiler
 * generated from App.vala, do not modify */

/*
* Copyright 2020 elementary, Inc. (https://elementary.io)
*           2020 Martin Abente Lahaye
*           2021 Justin Haygood (jhaygood86@gmail.com)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Marius Meisenzahl <mariusmeisenzahl@gmail.com>
*/

#include "applications.h"
#include <flatpak.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gdesktopappinfo.h>
#include <glib/gi18n-lib.h>

#define PERMISSIONS_BACKEND_APP_GROUP "Context"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PERMISSIONS_BACKEND_APP_0_PROPERTY,
	PERMISSIONS_BACKEND_APP_INSTALLED_REF_PROPERTY,
	PERMISSIONS_BACKEND_APP_ID_PROPERTY,
	PERMISSIONS_BACKEND_APP_NAME_PROPERTY,
	PERMISSIONS_BACKEND_APP_DESCRIPTION_PROPERTY,
	PERMISSIONS_BACKEND_APP_ICON_PROPERTY,
	PERMISSIONS_BACKEND_APP_NUM_PROPERTIES
};
static GParamSpec* permissions_backend_app_properties[PERMISSIONS_BACKEND_APP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

struct _PermissionsBackendAppPrivate {
	FlatpakInstalledRef* _installed_ref;
	gchar* _id;
	gchar* _name;
	gchar* _description;
	GIcon* _icon;
};

struct _Block5Data {
	int _ref_count_;
	PermissionsBackendApp* self;
	GPtrArray* permissions;
	GPtrArray* current_permissions;
};

static gint PermissionsBackendApp_private_offset;
static gpointer permissions_backend_app_parent_class = NULL;
static GHashTable* permissions_backend_app__permission_names;
static GHashTable* permissions_backend_app__permission_names = NULL;

static gchar* permissions_backend_app_get_overrides_path (PermissionsBackendApp* self);
static gboolean permissions_backend_app_is_permission_overridden (PermissionsBackendApp* self,
                                                           GPtrArray* overrides,
                                                           const gchar* permission);
static GPtrArray* permissions_backend_app_get_permissions_for_keyfile (PermissionsBackendApp* self,
                                                                GKeyFile* key_file);
static void _g_free0_ (gpointer var);
static void permissions_backend_app_set_id (PermissionsBackendApp* self,
                                     const gchar* value);
static void permissions_backend_app_set_name (PermissionsBackendApp* self,
                                       const gchar* value);
static void permissions_backend_app_set_description (PermissionsBackendApp* self,
                                              const gchar* value);
static void permissions_backend_app_set_icon (PermissionsBackendApp* self,
                                       GIcon* value);
static void permissions_backend_app_set_permission_names (GHashTable* value);
static GObject * permissions_backend_app_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void _g_object_unref0_ (gpointer var);
static void _permissions_backend_app___lambda4_ (Block5Data* _data5_,
                                          const gchar* key);
static void __permissions_backend_app___lambda4__gh_func (gconstpointer key,
                                                   gconstpointer value,
                                                   gpointer self);
static void _permissions_backend_app_save_overrides_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void permissions_backend_app_finalize (GObject * obj);
static GType permissions_backend_app_get_type_once (void);
static void _vala_permissions_backend_app_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_permissions_backend_app_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
permissions_backend_app_get_instance_private (PermissionsBackendApp* self)
{
	return G_STRUCT_MEMBER_P (self, PermissionsBackendApp_private_offset);
}

PermissionsBackendApp*
permissions_backend_app_construct (GType object_type,
                                   FlatpakInstalledRef* installed_ref)
{
	PermissionsBackendApp * self = NULL;
	g_return_val_if_fail (installed_ref != NULL, NULL);
	self = (PermissionsBackendApp*) g_object_new (object_type, "installed-ref", installed_ref, NULL);
	return self;
}

PermissionsBackendApp*
permissions_backend_app_new (FlatpakInstalledRef* installed_ref)
{
	return permissions_backend_app_construct (PERMISSIONS_BACKEND_TYPE_APP, installed_ref);
}

static gchar*
permissions_backend_app_get_overrides_path (PermissionsBackendApp* self)
{
	gchar* overrides_folder_path = NULL;
	PermissionsBackendFlatpakManager* _tmp0_;
	PermissionsBackendFlatpakManager* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* overrides_folder = NULL;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = permissions_backend_flatpak_manager_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = permissions_backend_flatpak_manager_get_user_installation_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_build_path (G_DIR_SEPARATOR_S, _tmp3_, "overrides", NULL);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp1_);
	overrides_folder_path = _tmp5_;
	_tmp6_ = overrides_folder_path;
	_tmp7_ = g_file_new_for_path (_tmp6_);
	overrides_folder = _tmp7_;
	_tmp8_ = overrides_folder;
	if (!g_file_query_exists (_tmp8_, NULL)) {
		{
			GFile* _tmp9_;
			_tmp9_ = overrides_folder;
			g_file_make_directory (_tmp9_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_critical ("App.vala:160: Couldn't create overrides folder: %s", _tmp11_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (overrides_folder);
			_g_free0 (overrides_folder_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp12_ = overrides_folder_path;
	_tmp13_ = self->priv->_id;
	_tmp14_ = g_build_path (G_DIR_SEPARATOR_S, _tmp12_, _tmp13_, NULL);
	result = _tmp14_;
	_g_object_unref0 (overrides_folder);
	_g_free0 (overrides_folder_path);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static gboolean
permissions_backend_app_is_permission_overridden (PermissionsBackendApp* self,
                                                  GPtrArray* overrides,
                                                  const gchar* permission)
{
	gchar* _tmp0_ = NULL;
	gchar* negated_permission = NULL;
	gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (overrides != NULL, FALSE);
	g_return_val_if_fail (permission != NULL, FALSE);
	if (string_contains (permission, "=!")) {
		gchar* _tmp1_;
		_tmp1_ = string_replace (permission, "=!", "=");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = string_replace (permission, "=", "=!");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = g_strdup (_tmp0_);
	negated_permission = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				gchar* o = NULL;
				gconstpointer _tmp8_;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = vala_g_ptr_array_get_length (overrides);
				_tmp7_ = _tmp6_;
				if (!(i < _tmp7_)) {
					break;
				}
				_tmp8_ = g_ptr_array_index (overrides, (guint) i);
				_tmp9_ = g_strdup ((const gchar*) _tmp8_);
				o = _tmp9_;
				_tmp10_ = o;
				_tmp11_ = negated_permission;
				if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
					result = TRUE;
					_g_free0 (o);
					_g_free0 (negated_permission);
					_g_free0 (_tmp0_);
					return result;
				}
				_g_free0 (o);
			}
		}
	}
	result = FALSE;
	_g_free0 (negated_permission);
	_g_free0 (_tmp0_);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
permissions_backend_app_reset_settings_to_standard (PermissionsBackendApp* self)
{
	gchar* overrides_path = NULL;
	gchar* _tmp12_;
	GKeyFile* key_file = NULL;
	GKeyFile* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				PermissionsBackendPermissionSettings* setting = NULL;
				GPtrArray* _tmp5_;
				gconstpointer _tmp6_;
				PermissionsBackendPermissionSettings* _tmp7_;
				PermissionsBackendPermissionSettings* _tmp8_;
				PermissionsBackendPermissionSettings* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->settings;
				_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->settings;
				_tmp6_ = g_ptr_array_index (_tmp5_, (guint) i);
				_tmp7_ = _g_object_ref0 ((PermissionsBackendPermissionSettings*) _tmp6_);
				setting = _tmp7_;
				_tmp8_ = setting;
				_tmp9_ = setting;
				_tmp10_ = permissions_backend_permission_settings_get_standard (_tmp9_);
				_tmp11_ = _tmp10_;
				permissions_backend_permission_settings_set_enabled (_tmp8_, _tmp11_);
				_g_object_unref0 (setting);
			}
		}
	}
	_tmp12_ = permissions_backend_app_get_overrides_path (self);
	overrides_path = _tmp12_;
	_tmp13_ = g_key_file_new ();
	key_file = _tmp13_;
	{
		GKeyFile* _tmp14_;
		const gchar* _tmp15_;
		_tmp14_ = key_file;
		_tmp15_ = overrides_path;
		g_key_file_load_from_file (_tmp14_, _tmp15_, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_key_file_unref0 (key_file);
			_g_free0 (overrides_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_debug ("App.vala:199: Couldn't create overrides keyfile: %s", _tmp17_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_debug ("App.vala:201: Couldn't load overrides file: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (key_file);
		_g_free0 (overrides_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GKeyFile* _tmp43_;
		const gchar* _tmp44_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp20_ = FALSE;
				_tmp20_ = TRUE;
				while (TRUE) {
					GPtrArray* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					PermissionsBackendPermissionSettings* setting = NULL;
					GPtrArray* _tmp25_;
					gconstpointer _tmp26_;
					PermissionsBackendPermissionSettings* _tmp27_;
					gchar** key_value_pair = NULL;
					PermissionsBackendPermissionSettings* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					gchar** _tmp31_;
					gchar** _tmp32_;
					gint key_value_pair_length1;
					gint _key_value_pair_size_;
					gchar* key = NULL;
					gchar** _tmp33_;
					gint _tmp33__length1;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					gboolean _tmp36_ = FALSE;
					GKeyFile* _tmp37_;
					if (!_tmp20_) {
						gint _tmp21_;
						_tmp21_ = i;
						i = _tmp21_ + 1;
					}
					_tmp20_ = FALSE;
					_tmp22_ = self->settings;
					_tmp23_ = vala_g_ptr_array_get_length (_tmp22_);
					_tmp24_ = _tmp23_;
					if (!(i < _tmp24_)) {
						break;
					}
					_tmp25_ = self->settings;
					_tmp26_ = g_ptr_array_index (_tmp25_, (guint) i);
					_tmp27_ = _g_object_ref0 ((PermissionsBackendPermissionSettings*) _tmp26_);
					setting = _tmp27_;
					_tmp28_ = setting;
					_tmp29_ = permissions_backend_permission_settings_get_context (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp32_ = _tmp31_ = g_strsplit (_tmp30_, "=", 0);
					key_value_pair = _tmp32_;
					key_value_pair_length1 = _vala_array_length (_tmp31_);
					_key_value_pair_size_ = key_value_pair_length1;
					_tmp33_ = key_value_pair;
					_tmp33__length1 = key_value_pair_length1;
					_tmp34_ = _tmp33_[0];
					_tmp35_ = g_strdup (_tmp34_);
					key = _tmp35_;
					_tmp37_ = key_file;
					if (g_key_file_has_group (_tmp37_, PERMISSIONS_BACKEND_APP_GROUP)) {
						gboolean _tmp38_ = FALSE;
						GKeyFile* _tmp39_;
						const gchar* _tmp40_;
						_tmp39_ = key_file;
						_tmp40_ = key;
						_tmp38_ = g_key_file_has_key (_tmp39_, PERMISSIONS_BACKEND_APP_GROUP, _tmp40_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (key);
							key_value_pair = (_vala_array_free (key_value_pair, key_value_pair_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (setting);
							if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
								goto __catch1_g_key_file_error;
							}
							if (_inner_error0_->domain == G_FILE_ERROR) {
								goto __catch1_g_file_error;
							}
							_g_key_file_unref0 (key_file);
							_g_free0 (overrides_path);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
						_tmp36_ = _tmp38_;
					} else {
						_tmp36_ = FALSE;
					}
					if (_tmp36_) {
						GKeyFile* _tmp41_;
						const gchar* _tmp42_;
						_tmp41_ = key_file;
						_tmp42_ = key;
						g_key_file_remove_key (_tmp41_, PERMISSIONS_BACKEND_APP_GROUP, _tmp42_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (key);
							key_value_pair = (_vala_array_free (key_value_pair, key_value_pair_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (setting);
							if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
								goto __catch1_g_key_file_error;
							}
							if (_inner_error0_->domain == G_FILE_ERROR) {
								goto __catch1_g_file_error;
							}
							_g_key_file_unref0 (key_file);
							_g_free0 (overrides_path);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					_g_free0 (key);
					key_value_pair = (_vala_array_free (key_value_pair, key_value_pair_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (setting);
				}
			}
		}
		_tmp43_ = key_file;
		_tmp44_ = overrides_path;
		g_key_file_save_to_file (_tmp43_, _tmp44_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			_g_key_file_unref0 (key_file);
			_g_free0 (overrides_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp45_;
		const gchar* _tmp46_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp45_ = e;
		_tmp46_ = _tmp45_->message;
		g_debug ("App.vala:218: Couldn't remove key from overrides keyfile: %s", _tmp46_);
		_g_error_free0 (e);
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp47_;
		const gchar* _tmp48_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp47_ = e;
		_tmp48_ = _tmp47_->message;
		g_debug ("App.vala:220: %s", _tmp48_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (key_file);
		_g_free0 (overrides_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_key_file_unref0 (key_file);
	_g_free0 (overrides_path);
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

void
permissions_backend_app_save_overrides (PermissionsBackendApp* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* overrides_path = NULL;
		gchar* _tmp0_;
		GKeyFile* key_file = NULL;
		GKeyFile* _tmp1_;
		GKeyFile* _tmp97_;
		const gchar* _tmp98_;
		_tmp0_ = permissions_backend_app_get_overrides_path (self);
		overrides_path = _tmp0_;
		_tmp1_ = g_key_file_new ();
		key_file = _tmp1_;
		{
			GKeyFile* _tmp2_;
			const gchar* _tmp3_;
			_tmp2_ = key_file;
			_tmp3_ = overrides_path;
			g_key_file_load_from_file (_tmp2_, _tmp3_, G_KEY_FILE_NONE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch1_g_key_file_error;
				}
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch1_g_file_error;
				}
				_g_key_file_unref0 (key_file);
				_g_free0 (overrides_path);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally1;
		__catch1_g_key_file_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_debug ("App.vala:233: Couldn't create overrides keyfile: %s", _tmp5_);
			_g_error_free0 (e);
		}
		goto __finally1;
		__catch1_g_file_error:
		{
			GError* e = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			g_debug ("App.vala:235: Couldn't load overrides file: %s", _tmp7_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (key_file);
			_g_free0 (overrides_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp8_ = FALSE;
				_tmp8_ = TRUE;
				while (TRUE) {
					GPtrArray* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					PermissionsBackendPermissionSettings* setting = NULL;
					GPtrArray* _tmp13_;
					gconstpointer _tmp14_;
					PermissionsBackendPermissionSettings* _tmp15_;
					gchar** key_value_pair = NULL;
					PermissionsBackendPermissionSettings* _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					gchar** _tmp19_;
					gchar** _tmp20_;
					gint key_value_pair_length1;
					gint _key_value_pair_size_;
					gchar* key = NULL;
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* value = NULL;
					gchar** _tmp24_;
					gint _tmp24__length1;
					const gchar* _tmp25_;
					gchar* _tmp26_;
					gboolean _tmp27_ = FALSE;
					GKeyFile* _tmp28_;
					if (!_tmp8_) {
						gint _tmp9_;
						_tmp9_ = i;
						i = _tmp9_ + 1;
					}
					_tmp8_ = FALSE;
					_tmp10_ = self->settings;
					_tmp11_ = vala_g_ptr_array_get_length (_tmp10_);
					_tmp12_ = _tmp11_;
					if (!(i < _tmp12_)) {
						break;
					}
					_tmp13_ = self->settings;
					_tmp14_ = g_ptr_array_index (_tmp13_, (guint) i);
					_tmp15_ = _g_object_ref0 ((PermissionsBackendPermissionSettings*) _tmp14_);
					setting = _tmp15_;
					_tmp16_ = setting;
					_tmp17_ = permissions_backend_permission_settings_get_context (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, "=", 0);
					key_value_pair = _tmp20_;
					key_value_pair_length1 = _vala_array_length (_tmp19_);
					_key_value_pair_size_ = key_value_pair_length1;
					_tmp21_ = key_value_pair;
					_tmp21__length1 = key_value_pair_length1;
					_tmp22_ = _tmp21_[0];
					_tmp23_ = g_strdup (_tmp22_);
					key = _tmp23_;
					_tmp24_ = key_value_pair;
					_tmp24__length1 = key_value_pair_length1;
					_tmp25_ = _tmp24_[1];
					_tmp26_ = g_strdup (_tmp25_);
					value = _tmp26_;
					_tmp28_ = key_file;
					if (g_key_file_has_group (_tmp28_, PERMISSIONS_BACKEND_APP_GROUP)) {
						gboolean _tmp29_ = FALSE;
						GKeyFile* _tmp30_;
						const gchar* _tmp31_;
						_tmp30_ = key_file;
						_tmp31_ = key;
						_tmp29_ = g_key_file_has_key (_tmp30_, PERMISSIONS_BACKEND_APP_GROUP, _tmp31_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (value);
							_g_free0 (key);
							key_value_pair = (_vala_array_free (key_value_pair, key_value_pair_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (setting);
							_g_key_file_unref0 (key_file);
							_g_free0 (overrides_path);
							if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
								goto __catch0_g_key_file_error;
							}
							if (_inner_error0_->domain == G_FILE_ERROR) {
								goto __catch0_g_file_error;
							}
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
						_tmp27_ = _tmp29_;
					} else {
						_tmp27_ = FALSE;
					}
					if (_tmp27_) {
						{
							gchar* existing_value = NULL;
							GKeyFile* _tmp32_;
							const gchar* _tmp33_;
							gchar* _tmp34_;
							gchar** existing_values = NULL;
							const gchar* _tmp35_;
							gchar** _tmp36_;
							gchar** _tmp37_;
							gint existing_values_length1;
							gint _existing_values_size_;
							GeeHashSet* values_list = NULL;
							GeeHashSet* _tmp38_;
							gchar** _tmp39_;
							gint _tmp39__length1;
							gboolean _tmp46_ = FALSE;
							GeeHashSet* _tmp47_;
							const gchar* _tmp48_;
							gchar** new_values = NULL;
							GeeHashSet* _tmp68_;
							gint _tmp69_ = 0;
							gpointer* _tmp70_;
							gint new_values_length1;
							gint _new_values_size_;
							gchar* new_value = NULL;
							gchar** _tmp71_;
							gint _tmp71__length1;
							gchar* _tmp72_;
							const gchar* _tmp73_;
							gint _tmp74_;
							gint _tmp75_;
							_tmp32_ = key_file;
							_tmp33_ = key;
							_tmp34_ = g_key_file_get_value (_tmp32_, PERMISSIONS_BACKEND_APP_GROUP, _tmp33_, &_inner_error0_);
							existing_value = _tmp34_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
									goto __catch2_g_key_file_error;
								}
								_g_free0 (value);
								_g_free0 (key);
								key_value_pair = (_vala_array_free (key_value_pair, key_value_pair_length1, (GDestroyNotify) g_free), NULL);
								_g_object_unref0 (setting);
								_g_key_file_unref0 (key_file);
								_g_free0 (overrides_path);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
							_tmp35_ = existing_value;
							_tmp37_ = _tmp36_ = g_strsplit (_tmp35_, ";", 0);
							existing_values = _tmp37_;
							existing_values_length1 = _vala_array_length (_tmp36_);
							_existing_values_size_ = existing_values_length1;
							_tmp38_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
							values_list = _tmp38_;
							_tmp39_ = existing_values;
							_tmp39__length1 = existing_values_length1;
							{
								gchar** existing_value_entry_collection = NULL;
								gint existing_value_entry_collection_length1 = 0;
								gint _existing_value_entry_collection_size_ = 0;
								gint existing_value_entry_it = 0;
								existing_value_entry_collection = _tmp39_;
								existing_value_entry_collection_length1 = _tmp39__length1;
								for (existing_value_entry_it = 0; existing_value_entry_it < existing_value_entry_collection_length1; existing_value_entry_it = existing_value_entry_it + 1) {
									gchar* _tmp40_;
									gchar* existing_value_entry = NULL;
									_tmp40_ = g_strdup (existing_value_entry_collection[existing_value_entry_it]);
									existing_value_entry = _tmp40_;
									{
										const gchar* _tmp41_;
										gint _tmp42_;
										gint _tmp43_;
										_tmp41_ = existing_value_entry;
										_tmp42_ = strlen (_tmp41_);
										_tmp43_ = _tmp42_;
										if (_tmp43_ > 0) {
											GeeHashSet* _tmp44_;
											const gchar* _tmp45_;
											_tmp44_ = values_list;
											_tmp45_ = existing_value_entry;
											gee_abstract_collection_add ((GeeAbstractCollection*) _tmp44_, _tmp45_);
										}
										_g_free0 (existing_value_entry);
									}
								}
							}
							_tmp47_ = values_list;
							_tmp48_ = value;
							if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp47_, _tmp48_)) {
								PermissionsBackendPermissionSettings* _tmp49_;
								gboolean _tmp50_;
								gboolean _tmp51_;
								PermissionsBackendPermissionSettings* _tmp52_;
								gboolean _tmp53_;
								gboolean _tmp54_;
								_tmp49_ = setting;
								_tmp50_ = permissions_backend_permission_settings_get_enabled (_tmp49_);
								_tmp51_ = _tmp50_;
								_tmp52_ = setting;
								_tmp53_ = permissions_backend_permission_settings_get_standard (_tmp52_);
								_tmp54_ = _tmp53_;
								_tmp46_ = _tmp51_ == _tmp54_;
							} else {
								_tmp46_ = FALSE;
							}
							if (_tmp46_) {
								GeeHashSet* _tmp55_;
								const gchar* _tmp56_;
								_tmp55_ = values_list;
								_tmp56_ = value;
								gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp55_, _tmp56_);
							} else {
								gboolean _tmp57_ = FALSE;
								GeeHashSet* _tmp58_;
								const gchar* _tmp59_;
								_tmp58_ = values_list;
								_tmp59_ = value;
								if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp58_, _tmp59_)) {
									PermissionsBackendPermissionSettings* _tmp60_;
									gboolean _tmp61_;
									gboolean _tmp62_;
									PermissionsBackendPermissionSettings* _tmp63_;
									gboolean _tmp64_;
									gboolean _tmp65_;
									_tmp60_ = setting;
									_tmp61_ = permissions_backend_permission_settings_get_enabled (_tmp60_);
									_tmp62_ = _tmp61_;
									_tmp63_ = setting;
									_tmp64_ = permissions_backend_permission_settings_get_standard (_tmp63_);
									_tmp65_ = _tmp64_;
									_tmp57_ = _tmp62_ != _tmp65_;
								} else {
									_tmp57_ = FALSE;
								}
								if (_tmp57_) {
									GeeHashSet* _tmp66_;
									const gchar* _tmp67_;
									_tmp66_ = values_list;
									_tmp67_ = value;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, _tmp67_);
								}
							}
							_tmp68_ = values_list;
							_tmp70_ = gee_collection_to_array ((GeeCollection*) _tmp68_, &_tmp69_);
							new_values = _tmp70_;
							new_values_length1 = _tmp69_;
							_new_values_size_ = new_values_length1;
							_tmp71_ = new_values;
							_tmp71__length1 = new_values_length1;
							_tmp72_ = _vala_g_strjoinv (";", _tmp71_, (gint) _tmp71__length1);
							new_value = _tmp72_;
							_tmp73_ = new_value;
							_tmp74_ = strlen (_tmp73_);
							_tmp75_ = _tmp74_;
							if (_tmp75_ > 0) {
								GKeyFile* _tmp76_;
								const gchar* _tmp77_;
								const gchar* _tmp78_;
								_tmp76_ = key_file;
								_tmp77_ = key;
								_tmp78_ = new_value;
								g_key_file_set_value (_tmp76_, PERMISSIONS_BACKEND_APP_GROUP, _tmp77_, _tmp78_);
							} else {
								GKeyFile* _tmp79_;
								const gchar* _tmp80_;
								gchar** _tmp81_ = NULL;
								GKeyFile* _tmp82_;
								gsize _tmp83_ = 0;
								gchar** _tmp84_;
								gint _tmp81__length1;
								gint __tmp81__size_;
								_tmp79_ = key_file;
								_tmp80_ = key;
								g_key_file_remove_key (_tmp79_, PERMISSIONS_BACKEND_APP_GROUP, _tmp80_, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									_g_free0 (new_value);
									new_values = (_vala_array_free (new_values, new_values_length1, (GDestroyNotify) g_free), NULL);
									_g_object_unref0 (values_list);
									existing_values = (_vala_array_free (existing_values, existing_values_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (existing_value);
									if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
										goto __catch2_g_key_file_error;
									}
									_g_free0 (value);
									_g_free0 (key);
									key_value_pair = (_vala_array_free (key_value_pair, key_value_pair_length1, (GDestroyNotify) g_free), NULL);
									_g_object_unref0 (setting);
									_g_key_file_unref0 (key_file);
									_g_free0 (overrides_path);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return;
								}
								_tmp82_ = key_file;
								_tmp84_ = g_key_file_get_keys (_tmp82_, PERMISSIONS_BACKEND_APP_GROUP, &_tmp83_, &_inner_error0_);
								_tmp81_ = _tmp84_;
								_tmp81__length1 = _tmp83_;
								__tmp81__size_ = _tmp81__length1;
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									_g_free0 (new_value);
									new_values = (_vala_array_free (new_values, new_values_length1, (GDestroyNotify) g_free), NULL);
									_g_object_unref0 (values_list);
									existing_values = (_vala_array_free (existing_values, existing_values_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (existing_value);
									if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
										goto __catch2_g_key_file_error;
									}
									_g_free0 (value);
									_g_free0 (key);
									key_value_pair = (_vala_array_free (key_value_pair, key_value_pair_length1, (GDestroyNotify) g_free), NULL);
									_g_object_unref0 (setting);
									_g_key_file_unref0 (key_file);
									_g_free0 (overrides_path);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return;
								}
								if (_tmp81__length1 == 0) {
									GKeyFile* _tmp85_;
									_tmp85_ = key_file;
									g_key_file_remove_group (_tmp85_, PERMISSIONS_BACKEND_APP_GROUP, &_inner_error0_);
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										_tmp81_ = (_vala_array_free (_tmp81_, _tmp81__length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (new_value);
										new_values = (_vala_array_free (new_values, new_values_length1, (GDestroyNotify) g_free), NULL);
										_g_object_unref0 (values_list);
										existing_values = (_vala_array_free (existing_values, existing_values_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (existing_value);
										if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
											goto __catch2_g_key_file_error;
										}
										_g_free0 (value);
										_g_free0 (key);
										key_value_pair = (_vala_array_free (key_value_pair, key_value_pair_length1, (GDestroyNotify) g_free), NULL);
										_g_object_unref0 (setting);
										_g_key_file_unref0 (key_file);
										_g_free0 (overrides_path);
										g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return;
									}
								}
								_tmp81_ = (_vala_array_free (_tmp81_, _tmp81__length1, (GDestroyNotify) g_free), NULL);
							}
							_g_free0 (new_value);
							new_values = (_vala_array_free (new_values, new_values_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (values_list);
							existing_values = (_vala_array_free (existing_values, existing_values_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (existing_value);
						}
						goto __finally2;
						__catch2_g_key_file_error:
						{
							GError* e = NULL;
							GError* _tmp86_;
							const gchar* _tmp87_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp86_ = e;
							_tmp87_ = _tmp86_->message;
							g_debug ("App.vala:278: %s", _tmp87_);
							_g_error_free0 (e);
						}
						__finally2:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (value);
							_g_free0 (key);
							key_value_pair = (_vala_array_free (key_value_pair, key_value_pair_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (setting);
							_g_key_file_unref0 (key_file);
							_g_free0 (overrides_path);
							if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
								goto __catch0_g_key_file_error;
							}
							if (_inner_error0_->domain == G_FILE_ERROR) {
								goto __catch0_g_file_error;
							}
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					} else {
						PermissionsBackendPermissionSettings* _tmp88_;
						gboolean _tmp89_;
						gboolean _tmp90_;
						PermissionsBackendPermissionSettings* _tmp91_;
						gboolean _tmp92_;
						gboolean _tmp93_;
						_tmp88_ = setting;
						_tmp89_ = permissions_backend_permission_settings_get_enabled (_tmp88_);
						_tmp90_ = _tmp89_;
						_tmp91_ = setting;
						_tmp92_ = permissions_backend_permission_settings_get_standard (_tmp91_);
						_tmp93_ = _tmp92_;
						if (_tmp90_ != _tmp93_) {
							GKeyFile* _tmp94_;
							const gchar* _tmp95_;
							const gchar* _tmp96_;
							_tmp94_ = key_file;
							_tmp95_ = key;
							_tmp96_ = value;
							g_key_file_set_value (_tmp94_, PERMISSIONS_BACKEND_APP_GROUP, _tmp95_, _tmp96_);
						}
					}
					_g_free0 (value);
					_g_free0 (key);
					key_value_pair = (_vala_array_free (key_value_pair, key_value_pair_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (setting);
				}
			}
		}
		_tmp97_ = key_file;
		_tmp98_ = overrides_path;
		g_key_file_save_to_file (_tmp97_, _tmp98_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (key_file);
			_g_free0 (overrides_path);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_key_file_unref0 (key_file);
		_g_free0 (overrides_path);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp99_;
		const gchar* _tmp100_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp99_ = e;
		_tmp100_ = _tmp99_->message;
		g_debug ("App.vala:289: Couldn't save overrides keyfile: %s", _tmp100_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp101_;
		const gchar* _tmp102_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp101_ = e;
		_tmp102_ = _tmp101_->message;
		g_debug ("App.vala:291: %s", _tmp102_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GPtrArray*
permissions_backend_app_get_permissions_for_keyfile (PermissionsBackendApp* self,
                                                     GKeyFile* key_file)
{
	GPtrArray* permissions = NULL;
	GPtrArray* _tmp0_;
	GError* _inner_error0_ = NULL;
	GPtrArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key_file != NULL, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	permissions = _tmp0_;
	if (!g_key_file_has_group (key_file, PERMISSIONS_BACKEND_APP_GROUP)) {
		result = permissions;
		return result;
	}
	{
		gchar** keys = NULL;
		gsize _tmp1_ = 0;
		gchar** _tmp2_;
		gint keys_length1;
		gint _keys_size_;
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = g_key_file_get_keys (key_file, PERMISSIONS_BACKEND_APP_GROUP, &_tmp1_, &_inner_error0_);
		keys = _tmp2_;
		keys_length1 = _tmp1_;
		_keys_size_ = keys_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = keys;
		_tmp3__length1 = keys_length1;
		{
			gchar** key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
			key_collection = _tmp3_;
			key_collection_length1 = _tmp3__length1;
			for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
				const gchar* key = NULL;
				key = key_collection[key_it];
				{
					gchar** values = NULL;
					const gchar* _tmp4_;
					gsize _tmp5_ = 0;
					gchar** _tmp6_;
					gint values_length1;
					gint _values_size_;
					gchar** _tmp7_;
					gint _tmp7__length1;
					_tmp4_ = key;
					_tmp6_ = g_key_file_get_string_list (key_file, PERMISSIONS_BACKEND_APP_GROUP, _tmp4_, &_tmp5_, &_inner_error0_);
					values = _tmp6_;
					values_length1 = _tmp5_;
					_values_size_ = values_length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
						goto __catch0_g_error;
					}
					_tmp7_ = values;
					_tmp7__length1 = values_length1;
					{
						gchar** value_collection = NULL;
						gint value_collection_length1 = 0;
						gint _value_collection_size_ = 0;
						gint value_it = 0;
						value_collection = _tmp7_;
						value_collection_length1 = _tmp7__length1;
						for (value_it = 0; value_it < value_collection_length1; value_it = value_it + 1) {
							const gchar* value = NULL;
							value = value_collection[value_it];
							{
								const gchar* _tmp8_;
								gint _tmp9_;
								gint _tmp10_;
								GPtrArray* _tmp11_;
								const gchar* _tmp12_;
								const gchar* _tmp13_;
								gchar* _tmp14_;
								_tmp8_ = value;
								_tmp9_ = strlen (_tmp8_);
								_tmp10_ = _tmp9_;
								if (_tmp10_ == 0) {
									break;
								}
								_tmp11_ = permissions;
								_tmp12_ = key;
								_tmp13_ = value;
								_tmp14_ = g_strdup_printf ("%s=%s", _tmp12_, _tmp13_);
								g_ptr_array_add (_tmp11_, _tmp14_);
							}
						}
					}
					values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_critical ("App.vala:316: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_ptr_array_unref0 (permissions);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = permissions;
	return result;
}

FlatpakInstalledRef*
permissions_backend_app_get_installed_ref (PermissionsBackendApp* self)
{
	FlatpakInstalledRef* result;
	FlatpakInstalledRef* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_installed_ref;
	result = _tmp0_;
	return result;
}

static void
permissions_backend_app_set_installed_ref (PermissionsBackendApp* self,
                                           FlatpakInstalledRef* value)
{
	FlatpakInstalledRef* old_value;
	g_return_if_fail (self != NULL);
	old_value = permissions_backend_app_get_installed_ref (self);
	if (old_value != value) {
		FlatpakInstalledRef* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_installed_ref);
		self->priv->_installed_ref = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, permissions_backend_app_properties[PERMISSIONS_BACKEND_APP_INSTALLED_REF_PROPERTY]);
	}
}

const gchar*
permissions_backend_app_get_id (PermissionsBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
permissions_backend_app_set_id (PermissionsBackendApp* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = permissions_backend_app_get_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, permissions_backend_app_properties[PERMISSIONS_BACKEND_APP_ID_PROPERTY]);
	}
}

const gchar*
permissions_backend_app_get_name (PermissionsBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
permissions_backend_app_set_name (PermissionsBackendApp* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = permissions_backend_app_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, permissions_backend_app_properties[PERMISSIONS_BACKEND_APP_NAME_PROPERTY]);
	}
}

const gchar*
permissions_backend_app_get_description (PermissionsBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
permissions_backend_app_set_description (PermissionsBackendApp* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = permissions_backend_app_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, permissions_backend_app_properties[PERMISSIONS_BACKEND_APP_DESCRIPTION_PROPERTY]);
	}
}

GIcon*
permissions_backend_app_get_icon (PermissionsBackendApp* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

static void
permissions_backend_app_set_icon (PermissionsBackendApp* self,
                                  GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = permissions_backend_app_get_icon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, permissions_backend_app_properties[PERMISSIONS_BACKEND_APP_ICON_PROPERTY]);
	}
}

GHashTable*
permissions_backend_app_get_permission_names (void)
{
	GHashTable* result;
	GHashTable* _tmp0_;
	_tmp0_ = permissions_backend_app__permission_names;
	result = _tmp0_;
	return result;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
permissions_backend_app_set_permission_names (GHashTable* value)
{
	GHashTable* _tmp0_;
	_tmp0_ = _g_hash_table_ref0 (value);
	_g_hash_table_unref0 (permissions_backend_app__permission_names);
	permissions_backend_app__permission_names = _tmp0_;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		PermissionsBackendApp* self;
		self = _data5_->self;
		_g_ptr_array_unref0 (_data5_->current_permissions);
		_g_ptr_array_unref0 (_data5_->permissions);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_permissions_backend_app___lambda4_ (Block5Data* _data5_,
                                     const gchar* key)
{
	PermissionsBackendApp* self;
	gboolean standard = FALSE;
	gboolean enabled = FALSE;
	PermissionsBackendPermissionSettings* s = NULL;
	PermissionsBackendPermissionSettings* _tmp18_ = NULL;
	GPtrArray* _tmp19_;
	PermissionsBackendPermissionSettings* _tmp20_;
	PermissionsBackendPermissionSettings* _tmp21_;
	self = _data5_->self;
	g_return_if_fail (key != NULL);
	standard = FALSE;
	enabled = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				gchar* permission = NULL;
				GPtrArray* _tmp5_;
				gconstpointer _tmp6_;
				gchar* _tmp7_;
				const gchar* _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = _data5_->permissions;
				_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = _data5_->permissions;
				_tmp6_ = g_ptr_array_index (_tmp5_, (guint) i);
				_tmp7_ = g_strdup ((const gchar*) _tmp6_);
				permission = _tmp7_;
				_tmp8_ = permission;
				if (g_strcmp0 (key, _tmp8_) == 0) {
					standard = TRUE;
					_g_free0 (permission);
					break;
				}
				_g_free0 (permission);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gchar* permission = NULL;
				GPtrArray* _tmp14_;
				gconstpointer _tmp15_;
				gchar* _tmp16_;
				const gchar* _tmp17_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = _data5_->current_permissions;
				_tmp12_ = vala_g_ptr_array_get_length (_tmp11_);
				_tmp13_ = _tmp12_;
				if (!(i < _tmp13_)) {
					break;
				}
				_tmp14_ = _data5_->current_permissions;
				_tmp15_ = g_ptr_array_index (_tmp14_, (guint) i);
				_tmp16_ = g_strdup ((const gchar*) _tmp15_);
				permission = _tmp16_;
				_tmp17_ = permission;
				if (g_strcmp0 (key, _tmp17_) == 0) {
					enabled = TRUE;
					_g_free0 (permission);
					break;
				}
				_g_free0 (permission);
			}
		}
	}
	_tmp18_ = permissions_backend_permission_settings_new (key, standard);
	permissions_backend_permission_settings_set_enabled (_tmp18_, enabled);
	s = _tmp18_;
	_tmp19_ = self->settings;
	_tmp20_ = s;
	_tmp21_ = _g_object_ref0 (_tmp20_);
	g_ptr_array_add (_tmp19_, _tmp21_);
	_g_object_unref0 (s);
}

static void
__permissions_backend_app___lambda4__gh_func (gconstpointer key,
                                              gconstpointer value,
                                              gpointer self)
{
	_permissions_backend_app___lambda4_ (self, (const gchar*) key);
}

static void
_permissions_backend_app_save_overrides_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	permissions_backend_app_save_overrides ((PermissionsBackendApp*) self);
}

static GObject *
permissions_backend_app_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PermissionsBackendApp * self;
	Block5Data* _data5_;
	FlatpakInstalledRef* _tmp0_;
	const gchar* _tmp1_;
	GDesktopAppInfo* appinfo = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GDesktopAppInfo* _tmp5_;
	GDesktopAppInfo* _tmp6_;
	GDesktopAppInfo* _tmp7_;
	GPtrArray* _tmp20_;
	GPtrArray* _tmp21_;
	GPtrArray* overrides = NULL;
	GPtrArray* _tmp35_;
	GPtrArray* _tmp46_;
	GHashTable* _tmp72_;
	GHashTable* _tmp73_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (permissions_backend_app_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PERMISSIONS_BACKEND_TYPE_APP, PermissionsBackendApp);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = self->priv->_installed_ref;
	_tmp1_ = flatpak_ref_get_name ((FlatpakRef*) _tmp0_);
	permissions_backend_app_set_id (self, _tmp1_);
	_tmp2_ = self->priv->_id;
	_tmp3_ = g_strconcat (_tmp2_, ".desktop", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_desktop_app_info_new (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	appinfo = _tmp6_;
	_tmp7_ = appinfo;
	if (_tmp7_ != NULL) {
		GDesktopAppInfo* _tmp8_;
		const gchar* _tmp9_;
		GIcon* _tmp10_ = NULL;
		GDesktopAppInfo* _tmp11_;
		GIcon* _tmp12_;
		GIcon* _tmp13_;
		GDesktopAppInfo* _tmp15_;
		const gchar* _tmp16_;
		_tmp8_ = appinfo;
		_tmp9_ = g_app_info_get_name ((GAppInfo*) _tmp8_);
		permissions_backend_app_set_name (self, _tmp9_);
		_tmp11_ = appinfo;
		_tmp12_ = g_app_info_get_icon ((GAppInfo*) _tmp11_);
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_tmp10_ = _tmp13_;
		if (_tmp10_ == NULL) {
			GThemedIcon* _tmp14_;
			_tmp14_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
			_g_object_unref0 (_tmp10_);
			_tmp10_ = (GIcon*) _tmp14_;
		}
		permissions_backend_app_set_icon (self, _tmp10_);
		_tmp15_ = appinfo;
		_tmp16_ = g_app_info_get_description ((GAppInfo*) _tmp15_);
		permissions_backend_app_set_description (self, _tmp16_);
		_g_object_unref0 (_tmp10_);
	} else {
		GThemedIcon* _tmp17_;
		GThemedIcon* _tmp18_;
		const gchar* _tmp19_;
		_tmp17_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
		_tmp18_ = _tmp17_;
		permissions_backend_app_set_icon (self, (GIcon*) _tmp18_);
		_g_object_unref0 (_tmp18_);
		_tmp19_ = self->priv->_id;
		permissions_backend_app_set_name (self, _tmp19_);
	}
	_tmp20_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_g_ptr_array_unref0 (self->settings);
	self->settings = _tmp20_;
	_tmp21_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_data5_->permissions = _tmp21_;
	{
		GBytes* metadata = NULL;
		FlatpakInstalledRef* _tmp22_;
		GBytes* _tmp23_;
		_tmp22_ = self->priv->_installed_ref;
		_tmp23_ = flatpak_installed_ref_load_metadata (_tmp22_, NULL, &_inner_error0_);
		metadata = _tmp23_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			GKeyFile* key_file = NULL;
			GKeyFile* _tmp24_;
			GKeyFile* _tmp25_;
			GBytes* _tmp26_;
			GKeyFile* _tmp27_;
			GPtrArray* _tmp28_;
			_tmp24_ = g_key_file_new ();
			key_file = _tmp24_;
			_tmp25_ = key_file;
			_tmp26_ = metadata;
			g_key_file_load_from_bytes (_tmp25_, _tmp26_, G_KEY_FILE_NONE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_key_file_unref0 (key_file);
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch1_g_key_file_error;
				}
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch1_g_file_error;
				}
				_g_bytes_unref0 (metadata);
				_g_object_unref0 (appinfo);
				block5_data_unref (_data5_);
				_data5_ = NULL;
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
			}
			_tmp27_ = key_file;
			_tmp28_ = permissions_backend_app_get_permissions_for_keyfile (self, _tmp27_);
			_g_ptr_array_unref0 (_data5_->permissions);
			_data5_->permissions = _tmp28_;
			_g_key_file_unref0 (key_file);
		}
		goto __finally1;
		__catch1_g_key_file_error:
		{
			GError* e = NULL;
			GError* _tmp29_;
			const gchar* _tmp30_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp29_ = e;
			_tmp30_ = _tmp29_->message;
			g_debug ("App.vala:76: Couldn't create permissions keyfile: %s", _tmp30_);
			_g_error_free0 (e);
		}
		goto __finally1;
		__catch1_g_file_error:
		{
			GError* e = NULL;
			GError* _tmp31_;
			const gchar* _tmp32_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp31_ = e;
			_tmp32_ = _tmp31_->message;
			g_debug ("App.vala:78: Couldn't load permissions file: %s", _tmp32_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_bytes_unref0 (metadata);
			goto __catch0_g_error;
		}
		_g_bytes_unref0 (metadata);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp33_;
		const gchar* _tmp34_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		g_critical ("App.vala:81: Couldn't load metadata: %s", _tmp34_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (appinfo);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp35_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	overrides = _tmp35_;
	{
		GKeyFile* key_file = NULL;
		GKeyFile* _tmp36_;
		GKeyFile* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		GKeyFile* _tmp40_;
		GPtrArray* _tmp41_;
		_tmp36_ = g_key_file_new ();
		key_file = _tmp36_;
		_tmp37_ = key_file;
		_tmp38_ = permissions_backend_app_get_overrides_path (self);
		_tmp39_ = _tmp38_;
		g_key_file_load_from_file (_tmp37_, _tmp39_, G_KEY_FILE_NONE, &_inner_error0_);
		_g_free0 (_tmp39_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_key_file_unref0 (key_file);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch2_g_key_file_error;
			}
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			_g_ptr_array_unref0 (overrides);
			_g_object_unref0 (appinfo);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp40_ = key_file;
		_tmp41_ = permissions_backend_app_get_permissions_for_keyfile (self, _tmp40_);
		_g_ptr_array_unref0 (overrides);
		overrides = _tmp41_;
		_g_key_file_unref0 (key_file);
	}
	goto __finally2;
	__catch2_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp42_;
		const gchar* _tmp43_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp42_ = e;
		_tmp43_ = _tmp42_->message;
		g_debug ("App.vala:91: Couldn't create overrides keyfile: %s", _tmp43_);
		_g_error_free0 (e);
	}
	goto __finally2;
	__catch2_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp44_;
		const gchar* _tmp45_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp44_ = e;
		_tmp45_ = _tmp44_->message;
		g_debug ("App.vala:93: Couldn't load overrides file: %s", _tmp45_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_ptr_array_unref0 (overrides);
		_g_object_unref0 (appinfo);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp46_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_data5_->current_permissions = _tmp46_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp47_ = FALSE;
			_tmp47_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
				gchar* permission = NULL;
				GPtrArray* _tmp52_;
				gconstpointer _tmp53_;
				gchar* _tmp54_;
				GPtrArray* _tmp55_;
				const gchar* _tmp56_;
				GPtrArray* _tmp57_;
				const gchar* _tmp58_;
				gchar* _tmp59_;
				if (!_tmp47_) {
					gint _tmp48_;
					_tmp48_ = i;
					i = _tmp48_ + 1;
				}
				_tmp47_ = FALSE;
				_tmp49_ = _data5_->permissions;
				_tmp50_ = vala_g_ptr_array_get_length (_tmp49_);
				_tmp51_ = _tmp50_;
				if (!(i < _tmp51_)) {
					break;
				}
				_tmp52_ = _data5_->permissions;
				_tmp53_ = g_ptr_array_index (_tmp52_, (guint) i);
				_tmp54_ = g_strdup ((const gchar*) _tmp53_);
				permission = _tmp54_;
				_tmp55_ = overrides;
				_tmp56_ = permission;
				if (permissions_backend_app_is_permission_overridden (self, _tmp55_, _tmp56_)) {
					_g_free0 (permission);
					continue;
				}
				_tmp57_ = _data5_->current_permissions;
				_tmp58_ = permission;
				_tmp59_ = g_strdup (_tmp58_);
				g_ptr_array_add (_tmp57_, _tmp59_);
				_g_free0 (permission);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp60_ = FALSE;
			_tmp60_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp62_;
				gint _tmp63_;
				gint _tmp64_;
				gchar* permission = NULL;
				GPtrArray* _tmp65_;
				gconstpointer _tmp66_;
				gchar* _tmp67_;
				const gchar* _tmp68_;
				GPtrArray* _tmp69_;
				const gchar* _tmp70_;
				gchar* _tmp71_;
				if (!_tmp60_) {
					gint _tmp61_;
					_tmp61_ = i;
					i = _tmp61_ + 1;
				}
				_tmp60_ = FALSE;
				_tmp62_ = overrides;
				_tmp63_ = vala_g_ptr_array_get_length (_tmp62_);
				_tmp64_ = _tmp63_;
				if (!(i < _tmp64_)) {
					break;
				}
				_tmp65_ = overrides;
				_tmp66_ = g_ptr_array_index (_tmp65_, (guint) i);
				_tmp67_ = g_strdup ((const gchar*) _tmp66_);
				permission = _tmp67_;
				_tmp68_ = permission;
				if (string_contains (_tmp68_, "=!")) {
					_g_free0 (permission);
					continue;
				}
				_tmp69_ = _data5_->current_permissions;
				_tmp70_ = permission;
				_tmp71_ = g_strdup (_tmp70_);
				g_ptr_array_add (_tmp69_, _tmp71_);
				_g_free0 (permission);
			}
		}
	}
	_tmp72_ = permissions_backend_app_get_permission_names ();
	_tmp73_ = _tmp72_;
	g_hash_table_foreach (_tmp73_, __permissions_backend_app___lambda4__gh_func, _data5_);
	g_signal_connect_object ((GObject*) self, "notify::settings", (GCallback) _permissions_backend_app_save_overrides_g_object_notify, self, 0);
	permissions_backend_app_save_overrides (self);
	_g_ptr_array_unref0 (overrides);
	_g_object_unref0 (appinfo);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return obj;
}

static void
permissions_backend_app_class_init (PermissionsBackendAppClass * klass,
                                    gpointer klass_data)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	GHashTable* _tmp7_;
	GHashTable* _tmp8_;
	GHashTable* _tmp9_;
	GHashTable* _tmp10_;
	GHashTable* _tmp11_;
	GHashTable* _tmp12_;
	GHashTable* _tmp13_;
	GHashTable* _tmp14_;
	GHashTable* _tmp15_;
	GHashTable* _tmp16_;
	GHashTable* _tmp17_;
	GHashTable* _tmp18_;
	GHashTable* _tmp19_;
	permissions_backend_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PermissionsBackendApp_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_permissions_backend_app_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_permissions_backend_app_set_property;
	G_OBJECT_CLASS (klass)->constructor = permissions_backend_app_constructor;
	G_OBJECT_CLASS (klass)->finalize = permissions_backend_app_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PERMISSIONS_BACKEND_APP_INSTALLED_REF_PROPERTY, permissions_backend_app_properties[PERMISSIONS_BACKEND_APP_INSTALLED_REF_PROPERTY] = g_param_spec_object ("installed-ref", "installed-ref", "installed-ref", flatpak_installed_ref_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PERMISSIONS_BACKEND_APP_ID_PROPERTY, permissions_backend_app_properties[PERMISSIONS_BACKEND_APP_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PERMISSIONS_BACKEND_APP_NAME_PROPERTY, permissions_backend_app_properties[PERMISSIONS_BACKEND_APP_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PERMISSIONS_BACKEND_APP_DESCRIPTION_PROPERTY, permissions_backend_app_properties[PERMISSIONS_BACKEND_APP_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PERMISSIONS_BACKEND_APP_ICON_PROPERTY, permissions_backend_app_properties[PERMISSIONS_BACKEND_APP_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, NULL);
	_tmp3_ = _tmp2_;
	permissions_backend_app_set_permission_names (_tmp3_);
	_g_hash_table_unref0 (_tmp3_);
	_tmp4_ = permissions_backend_app_get_permission_names ();
	_tmp5_ = _tmp4_;
	g_hash_table_insert (_tmp5_, "filesystems=home", _ ("Home Folder"));
	_tmp6_ = permissions_backend_app_get_permission_names ();
	_tmp7_ = _tmp6_;
	g_hash_table_insert (_tmp7_, "filesystems=host", _ ("System Folders"));
	_tmp8_ = permissions_backend_app_get_permission_names ();
	_tmp9_ = _tmp8_;
	g_hash_table_insert (_tmp9_, "devices=all", _ ("Devices"));
	_tmp10_ = permissions_backend_app_get_permission_names ();
	_tmp11_ = _tmp10_;
	g_hash_table_insert (_tmp11_, "shared=network", _ ("Network"));
	_tmp12_ = permissions_backend_app_get_permission_names ();
	_tmp13_ = _tmp12_;
	g_hash_table_insert (_tmp13_, "features=bluetooth", _ ("Bluetooth"));
	_tmp14_ = permissions_backend_app_get_permission_names ();
	_tmp15_ = _tmp14_;
	g_hash_table_insert (_tmp15_, "sockets=cups", _ ("Printing"));
	_tmp16_ = permissions_backend_app_get_permission_names ();
	_tmp17_ = _tmp16_;
	g_hash_table_insert (_tmp17_, "sockets=ssh-auth", _ ("Secure Shell Agent"));
	_tmp18_ = permissions_backend_app_get_permission_names ();
	_tmp19_ = _tmp18_;
	g_hash_table_insert (_tmp19_, "devices=dri", _ ("GPU Acceleration"));
}

static void
permissions_backend_app_instance_init (PermissionsBackendApp * self,
                                       gpointer klass)
{
	self->priv = permissions_backend_app_get_instance_private (self);
	self->priv->_description = NULL;
}

static void
permissions_backend_app_finalize (GObject * obj)
{
	PermissionsBackendApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PERMISSIONS_BACKEND_TYPE_APP, PermissionsBackendApp);
	_g_object_unref0 (self->priv->_installed_ref);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->_icon);
	_g_ptr_array_unref0 (self->settings);
	G_OBJECT_CLASS (permissions_backend_app_parent_class)->finalize (obj);
}

static GType
permissions_backend_app_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PermissionsBackendAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) permissions_backend_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PermissionsBackendApp), 0, (GInstanceInitFunc) permissions_backend_app_instance_init, NULL };
	GType permissions_backend_app_type_id;
	permissions_backend_app_type_id = g_type_register_static (G_TYPE_OBJECT, "PermissionsBackendApp", &g_define_type_info, 0);
	PermissionsBackendApp_private_offset = g_type_add_instance_private (permissions_backend_app_type_id, sizeof (PermissionsBackendAppPrivate));
	return permissions_backend_app_type_id;
}

GType
permissions_backend_app_get_type (void)
{
	static volatile gsize permissions_backend_app_type_id__once = 0;
	if (g_once_init_enter (&permissions_backend_app_type_id__once)) {
		GType permissions_backend_app_type_id;
		permissions_backend_app_type_id = permissions_backend_app_get_type_once ();
		g_once_init_leave (&permissions_backend_app_type_id__once, permissions_backend_app_type_id);
	}
	return permissions_backend_app_type_id__once;
}

static void
_vala_permissions_backend_app_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	PermissionsBackendApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PERMISSIONS_BACKEND_TYPE_APP, PermissionsBackendApp);
	switch (property_id) {
		case PERMISSIONS_BACKEND_APP_INSTALLED_REF_PROPERTY:
		g_value_set_object (value, permissions_backend_app_get_installed_ref (self));
		break;
		case PERMISSIONS_BACKEND_APP_ID_PROPERTY:
		g_value_set_string (value, permissions_backend_app_get_id (self));
		break;
		case PERMISSIONS_BACKEND_APP_NAME_PROPERTY:
		g_value_set_string (value, permissions_backend_app_get_name (self));
		break;
		case PERMISSIONS_BACKEND_APP_DESCRIPTION_PROPERTY:
		g_value_set_string (value, permissions_backend_app_get_description (self));
		break;
		case PERMISSIONS_BACKEND_APP_ICON_PROPERTY:
		g_value_set_object (value, permissions_backend_app_get_icon (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_permissions_backend_app_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	PermissionsBackendApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PERMISSIONS_BACKEND_TYPE_APP, PermissionsBackendApp);
	switch (property_id) {
		case PERMISSIONS_BACKEND_APP_INSTALLED_REF_PROPERTY:
		permissions_backend_app_set_installed_ref (self, g_value_get_object (value));
		break;
		case PERMISSIONS_BACKEND_APP_ID_PROPERTY:
		permissions_backend_app_set_id (self, g_value_get_string (value));
		break;
		case PERMISSIONS_BACKEND_APP_NAME_PROPERTY:
		permissions_backend_app_set_name (self, g_value_get_string (value));
		break;
		case PERMISSIONS_BACKEND_APP_DESCRIPTION_PROPERTY:
		permissions_backend_app_set_description (self, g_value_get_string (value));
		break;
		case PERMISSIONS_BACKEND_APP_ICON_PROPERTY:
		permissions_backend_app_set_icon (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

