/* Monitor.c generated by valac 0.56.17, the Vala compiler
 * generated from Monitor.vala, do not modify */

/*
* Copyright 2013-2017 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Julien Spautz <spautz.julien@gmail.com>
*/

#include "applications.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	STARTUP_BACKEND_MONITOR_0_PROPERTY,
	STARTUP_BACKEND_MONITOR_NUM_PROPERTIES
};
static GParamSpec* startup_backend_monitor_properties[STARTUP_BACKEND_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	STARTUP_BACKEND_MONITOR_FILE_CREATED_SIGNAL,
	STARTUP_BACKEND_MONITOR_FILE_DELETED_SIGNAL,
	STARTUP_BACKEND_MONITOR_FILE_EDITED_SIGNAL,
	STARTUP_BACKEND_MONITOR_NUM_SIGNALS
};
static guint startup_backend_monitor_signals[STARTUP_BACKEND_MONITOR_NUM_SIGNALS] = {0};

struct _StartupBackendMonitorPrivate {
	GFileMonitor* monitor;
};

static gint StartupBackendMonitor_private_offset;
static gpointer startup_backend_monitor_parent_class = NULL;

static void startup_backend_monitor_on_change_occurred (StartupBackendMonitor* self,
                                                 GFile* file,
                                                 GFile* dest,
                                                 GFileMonitorEvent event);
static GObject * startup_backend_monitor_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _startup_backend_monitor_on_change_occurred_g_file_monitor_changed (GFileMonitor* _sender,
                                                                         GFile* file,
                                                                         GFile* other_file,
                                                                         GFileMonitorEvent event_type,
                                                                         gpointer self);
static void startup_backend_monitor_finalize (GObject * obj);
static GType startup_backend_monitor_get_type_once (void);

static inline gpointer
startup_backend_monitor_get_instance_private (StartupBackendMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, StartupBackendMonitor_private_offset);
}

static void
startup_backend_monitor_on_change_occurred (StartupBackendMonitor* self,
                                            GFile* file,
                                            GFile* dest,
                                            GFileMonitorEvent event)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_path (file);
	path = _tmp0_;
	_tmp1_ = path;
	if (startup_utils_is_desktop_file (_tmp1_) == FALSE) {
		_g_free0 (path);
		return;
	}
	switch (event) {
		case G_FILE_MONITOR_EVENT_CREATED:
		{
			const gchar* _tmp2_;
			_tmp2_ = path;
			g_signal_emit (self, startup_backend_monitor_signals[STARTUP_BACKEND_MONITOR_FILE_CREATED_SIGNAL], 0, _tmp2_);
			break;
		}
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			const gchar* _tmp3_;
			_tmp3_ = path;
			g_signal_emit (self, startup_backend_monitor_signals[STARTUP_BACKEND_MONITOR_FILE_DELETED_SIGNAL], 0, _tmp3_);
			break;
		}
		case G_FILE_MONITOR_EVENT_CHANGED:
		{
			const gchar* _tmp4_;
			_tmp4_ = path;
			g_signal_emit (self, startup_backend_monitor_signals[STARTUP_BACKEND_MONITOR_FILE_EDITED_SIGNAL], 0, _tmp4_);
			break;
		}
		default:
		break;
	}
	_g_free0 (path);
}

StartupBackendMonitor*
startup_backend_monitor_construct (GType object_type)
{
	StartupBackendMonitor * self = NULL;
	self = (StartupBackendMonitor*) g_object_new (object_type, NULL);
	return self;
}

StartupBackendMonitor*
startup_backend_monitor_new (void)
{
	return startup_backend_monitor_construct (STARTUP_BACKEND_TYPE_MONITOR);
}

static void
_startup_backend_monitor_on_change_occurred_g_file_monitor_changed (GFileMonitor* _sender,
                                                                    GFile* file,
                                                                    GFile* other_file,
                                                                    GFileMonitorEvent event_type,
                                                                    gpointer self)
{
	startup_backend_monitor_on_change_occurred ((StartupBackendMonitor*) self, file, other_file, event_type);
}

static GObject *
startup_backend_monitor_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	StartupBackendMonitor * self;
	gchar* startup_dir = NULL;
	gchar* _tmp0_;
	GFile* file = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (startup_backend_monitor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, STARTUP_BACKEND_TYPE_MONITOR, StartupBackendMonitor);
	_tmp0_ = startup_utils_get_user_startup_dir ();
	startup_dir = _tmp0_;
	_tmp1_ = startup_dir;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	file = _tmp2_;
	{
		GFileMonitor* _tmp3_ = NULL;
		GFile* _tmp4_;
		GFileMonitor* _tmp5_;
		GFileMonitor* _tmp6_;
		GFileMonitor* _tmp7_;
		_tmp4_ = file;
		_tmp5_ = g_file_monitor (_tmp4_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (self->priv->monitor);
		self->priv->monitor = _tmp6_;
		_tmp7_ = self->priv->monitor;
		g_signal_connect_object (_tmp7_, "changed", (GCallback) _startup_backend_monitor_on_change_occurred_g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = startup_dir;
		g_critical ("Monitor.vala:36: Failed monitoring startup directory: %s", _tmp8_);
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_critical ("Monitor.vala:37: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		_g_free0 (startup_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_g_object_unref0 (file);
	_g_free0 (startup_dir);
	return obj;
}

static void
startup_backend_monitor_class_init (StartupBackendMonitorClass * klass,
                                    gpointer klass_data)
{
	startup_backend_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &StartupBackendMonitor_private_offset);
	G_OBJECT_CLASS (klass)->constructor = startup_backend_monitor_constructor;
	G_OBJECT_CLASS (klass)->finalize = startup_backend_monitor_finalize;
	startup_backend_monitor_signals[STARTUP_BACKEND_MONITOR_FILE_CREATED_SIGNAL] = g_signal_new ("file-created", STARTUP_BACKEND_TYPE_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	startup_backend_monitor_signals[STARTUP_BACKEND_MONITOR_FILE_DELETED_SIGNAL] = g_signal_new ("file-deleted", STARTUP_BACKEND_TYPE_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	startup_backend_monitor_signals[STARTUP_BACKEND_MONITOR_FILE_EDITED_SIGNAL] = g_signal_new ("file-edited", STARTUP_BACKEND_TYPE_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
startup_backend_monitor_instance_init (StartupBackendMonitor * self,
                                       gpointer klass)
{
	self->priv = startup_backend_monitor_get_instance_private (self);
}

static void
startup_backend_monitor_finalize (GObject * obj)
{
	StartupBackendMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, STARTUP_BACKEND_TYPE_MONITOR, StartupBackendMonitor);
	_g_object_unref0 (self->priv->monitor);
	G_OBJECT_CLASS (startup_backend_monitor_parent_class)->finalize (obj);
}

static GType
startup_backend_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (StartupBackendMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) startup_backend_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StartupBackendMonitor), 0, (GInstanceInitFunc) startup_backend_monitor_instance_init, NULL };
	GType startup_backend_monitor_type_id;
	startup_backend_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "StartupBackendMonitor", &g_define_type_info, 0);
	StartupBackendMonitor_private_offset = g_type_add_instance_private (startup_backend_monitor_type_id, sizeof (StartupBackendMonitorPrivate));
	return startup_backend_monitor_type_id;
}

GType
startup_backend_monitor_get_type (void)
{
	static volatile gsize startup_backend_monitor_type_id__once = 0;
	if (g_once_init_enter (&startup_backend_monitor_type_id__once)) {
		GType startup_backend_monitor_type_id;
		startup_backend_monitor_type_id = startup_backend_monitor_get_type_once ();
		g_once_init_leave (&startup_backend_monitor_type_id__once, startup_backend_monitor_type_id);
	}
	return startup_backend_monitor_type_id__once;
}

