/* Plug.c generated by valac 0.56.17, the Vala compiler
 * generated from Plug.vala, do not modify */

/*
 * Copyright 2014-2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 */

#include "datetime.h"
#include <gtk/gtk.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <adwaita.h>
#include <granite-7.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DATE_TIME_PLUG_0_PROPERTY,
	DATE_TIME_PLUG_NUM_PROPERTIES
};
static GParamSpec* date_time_plug_properties[DATE_TIME_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DateTimePlugSearchData DateTimePlugSearchData;

struct _DateTimePlugPrivate {
	GtkBox* box;
};

struct _DateTimePlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DateTimePlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* search_results;
	GCompareFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeTreeMap* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
};

static gint DateTimePlug_private_offset;
static gpointer date_time_plug_parent_class = NULL;

static GtkWidget* date_time_plug_real_get_widget (SwitchboardPlug* base);
static void date_time_plug_real_shown (SwitchboardPlug* base);
static void date_time_plug_real_hidden (SwitchboardPlug* base);
static void date_time_plug_real_search_callback (SwitchboardPlug* base,
                                          const gchar* location);
static void date_time_plug_real_search_data_free (gpointer _data);
static void date_time_plug_real_search (SwitchboardPlug* base,
                                 const gchar* search,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static gboolean date_time_plug_real_search_co (DateTimePlugSearchData* _data_);
static void date_time_plug_finalize (GObject * obj);
static GType date_time_plug_get_type_once (void);

static inline gpointer
date_time_plug_get_instance_private (DateTimePlug* self)
{
	return G_STRUCT_MEMBER_P (self, DateTimePlug_private_offset);
}

DateTimePlug*
date_time_plug_construct (GType object_type)
{
	DateTimePlug * self = NULL;
	GeeTreeMap* settings = NULL;
	GeeTreeMap* _tmp0_;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	settings = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) settings, "time", NULL);
	gee_abstract_map_set ((GeeAbstractMap*) settings, "date", NULL);
	self = (DateTimePlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_SYSTEM, "code-name", "io.elementary.settings.datetime", "display-name", _ ("Date & Time"), "description", _ ("Configure date, time, and select time zone"), "icon", "preferences-system-time", "supported-settings", settings, NULL);
	_g_object_unref0 (settings);
	return self;
}

DateTimePlug*
date_time_plug_new (void)
{
	return date_time_plug_construct (DATE_TIME_TYPE_PLUG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
date_time_plug_real_get_widget (SwitchboardPlug* base)
{
	DateTimePlug * self;
	GtkBox* _tmp0_;
	GtkBox* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* result;
	self = (DateTimePlug*) base;
	_tmp0_ = self->priv->box;
	if (_tmp0_ == NULL) {
		AdwHeaderBar* headerbar = NULL;
		AdwHeaderBar* _tmp1_ = NULL;
		AdwHeaderBar* _tmp2_;
		DateTimeMainView* main_view = NULL;
		DateTimeMainView* _tmp3_ = NULL;
		GtkBox* _tmp4_;
		GtkBox* _tmp5_;
		AdwHeaderBar* _tmp6_;
		GtkBox* _tmp7_;
		DateTimeMainView* _tmp8_;
		_tmp1_ = (AdwHeaderBar*) adw_header_bar_new ();
		adw_header_bar_set_show_title (_tmp1_, FALSE);
		g_object_ref_sink (_tmp1_);
		headerbar = _tmp1_;
		_tmp2_ = headerbar;
		gtk_widget_add_css_class ((GtkWidget*) _tmp2_, GRANITE_STYLE_CLASS_FLAT);
		_tmp3_ = date_time_main_view_new ();
		gtk_widget_set_vexpand ((GtkWidget*) _tmp3_, TRUE);
		g_object_ref_sink (_tmp3_);
		main_view = _tmp3_;
		_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (self->priv->box);
		self->priv->box = _tmp4_;
		_tmp5_ = self->priv->box;
		_tmp6_ = headerbar;
		gtk_box_append (_tmp5_, (GtkWidget*) _tmp6_);
		_tmp7_ = self->priv->box;
		_tmp8_ = main_view;
		gtk_box_append (_tmp7_, (GtkWidget*) _tmp8_);
		_g_object_unref0 (main_view);
		_g_object_unref0 (headerbar);
	}
	_tmp9_ = self->priv->box;
	_tmp10_ = _g_object_ref0 ((GtkWidget*) _tmp9_);
	result = _tmp10_;
	return result;
}

static void
date_time_plug_real_shown (SwitchboardPlug* base)
{
	DateTimePlug * self;
	self = (DateTimePlug*) base;
}

static void
date_time_plug_real_hidden (SwitchboardPlug* base)
{
	DateTimePlug * self;
	self = (DateTimePlug*) base;
}

static void
date_time_plug_real_search_callback (SwitchboardPlug* base,
                                     const gchar* location)
{
	DateTimePlug * self;
	self = (DateTimePlug*) base;
	g_return_if_fail (location != NULL);
}

static void
date_time_plug_real_search_data_free (gpointer _data)
{
	DateTimePlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (DateTimePlugSearchData, _data_);
}

static void
date_time_plug_real_search (SwitchboardPlug* base,
                            const gchar* search,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	DateTimePlug * self;
	DateTimePlugSearchData* _data_;
	DateTimePlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (DateTimePlug*) base;
	_data_ = g_slice_new0 (DateTimePlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, date_time_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	date_time_plug_real_search_co (_data_);
}

static GeeTreeMap*
date_time_plug_search_finish (SwitchboardPlug* base,
                              GAsyncResult* _res_)
{
	GeeTreeMap* result;
	DateTimePlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
date_time_plug_real_search_co (DateTimePlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((GCompareFunc) g_strcmp0);
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, (GCompareDataFunc) _data_->_tmp0_, NULL, NULL, (GeeEqualDataFunc) _data_->_tmp1_, NULL, NULL);
	_data_->search_results = _data_->_tmp2_;
	_data_->_tmp3_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = g_strdup_printf ("%s → %s", _data_->_tmp4_, _ ("Time Format"));
	_data_->_tmp6_ = _data_->_tmp5_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp6_, "");
	_g_free0 (_data_->_tmp6_);
	_data_->_tmp7_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_strdup_printf ("%s → %s", _data_->_tmp8_, _ ("Time Zone"));
	_data_->_tmp10_ = _data_->_tmp9_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp10_, "");
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp11_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = g_strdup_printf ("%s → %s", _data_->_tmp12_, _ ("Network Time"));
	_data_->_tmp14_ = _data_->_tmp13_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp14_, "");
	_g_free0 (_data_->_tmp14_);
	_data_->_tmp15_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = g_strdup_printf ("%s → %s", _data_->_tmp16_, _ ("Show Week Numbers"));
	_data_->_tmp18_ = _data_->_tmp17_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp18_, "");
	_g_free0 (_data_->_tmp18_);
	_data_->result = _data_->search_results;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
date_time_plug_class_init (DateTimePlugClass * klass,
                           gpointer klass_data)
{
	date_time_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DateTimePlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) date_time_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) date_time_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) date_time_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) date_time_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) date_time_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) date_time_plug_search_finish;
	G_OBJECT_CLASS (klass)->finalize = date_time_plug_finalize;
}

static void
date_time_plug_instance_init (DateTimePlug * self,
                              gpointer klass)
{
	self->priv = date_time_plug_get_instance_private (self);
}

static void
date_time_plug_finalize (GObject * obj)
{
	DateTimePlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATE_TIME_TYPE_PLUG, DateTimePlug);
	_g_object_unref0 (self->priv->box);
	G_OBJECT_CLASS (date_time_plug_parent_class)->finalize (obj);
}

static GType
date_time_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DateTimePlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) date_time_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DateTimePlug), 0, (GInstanceInitFunc) date_time_plug_instance_init, NULL };
	GType date_time_plug_type_id;
	date_time_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "DateTimePlug", &g_define_type_info, 0);
	DateTimePlug_private_offset = g_type_add_instance_private (date_time_plug_type_id, sizeof (DateTimePlugPrivate));
	return date_time_plug_type_id;
}

GType
date_time_plug_get_type (void)
{
	static volatile gsize date_time_plug_type_id__once = 0;
	if (g_once_init_enter (&date_time_plug_type_id__once)) {
		GType date_time_plug_type_id;
		date_time_plug_type_id = date_time_plug_get_type_once ();
		g_once_init_leave (&date_time_plug_type_id__once, date_time_plug_type_id);
	}
	return date_time_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	DateTimePlug* plug = NULL;
	DateTimePlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Plug.vala:78: Activating Date & Time plug");
	_tmp0_ = date_time_plug_new ();
	plug = _tmp0_;
	result = (SwitchboardPlug*) plug;
	return result;
}

