/* Appearance.c generated by valac 0.56.17, the Vala compiler
 * generated from Appearance.vala, do not modify */

/*
* Copyright 2018–2021 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
*/

#include "desktop.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <granite-7.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <switchboard.h>

#define PANTHEON_SHELL_APPEARANCE_INTERFACE_SCHEMA "org.gnome.desktop.interface"
#define PANTHEON_SHELL_APPEARANCE_STYLESHEET_KEY "gtk-theme"
#define PANTHEON_SHELL_APPEARANCE_STYLESHEET_PREFIX "io.elementary.stylesheet."
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PANTHEON_SHELL_APPEARANCE_0_PROPERTY,
	PANTHEON_SHELL_APPEARANCE_NUM_PROPERTIES
};
static GParamSpec* pantheon_shell_appearance_properties[PANTHEON_SHELL_APPEARANCE_NUM_PROPERTIES];
typedef enum  {
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_NO_PREFERENCE,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_RED,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_ORANGE,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_YELLOW,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GREEN,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_MINT,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BLUE,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PURPLE,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PINK,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BROWN,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GRAY
} PantheonShellAppearanceAccentColor;

#define PANTHEON_SHELL_APPEARANCE_TYPE_ACCENT_COLOR (pantheon_shell_appearance_accent_color_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON (pantheon_shell_appearance_prefers_accent_color_button_get_type ())
#define PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON, PantheonShellAppearancePrefersAccentColorButton))
#define PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON, PantheonShellAppearancePrefersAccentColorButtonClass))
#define PANTHEON_SHELL_APPEARANCE_IS_PREFERS_ACCENT_COLOR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON))
#define PANTHEON_SHELL_APPEARANCE_IS_PREFERS_ACCENT_COLOR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON))
#define PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON, PantheonShellAppearancePrefersAccentColorButtonClass))

typedef struct _PantheonShellAppearancePrefersAccentColorButton PantheonShellAppearancePrefersAccentColorButton;
typedef struct _PantheonShellAppearancePrefersAccentColorButtonClass PantheonShellAppearancePrefersAccentColorButtonClass;
typedef struct _PantheonShellAppearancePrefersAccentColorButtonPrivate PantheonShellAppearancePrefersAccentColorButtonPrivate;

#define PANTHEON_SHELL_PANTHEON_TYPE_ACCOUNTS_SERVICE (pantheon_shell_pantheon_accounts_service_get_type ())
#define PANTHEON_SHELL_PANTHEON_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_SHELL_PANTHEON_TYPE_ACCOUNTS_SERVICE, PantheonShellPantheonAccountsService))
#define PANTHEON_SHELL_PANTHEON_IS_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_SHELL_PANTHEON_TYPE_ACCOUNTS_SERVICE))
#define PANTHEON_SHELL_PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PANTHEON_SHELL_PANTHEON_TYPE_ACCOUNTS_SERVICE, PantheonShellPantheonAccountsServiceIface))

typedef struct _PantheonShellPantheonAccountsService PantheonShellPantheonAccountsService;
typedef struct _PantheonShellPantheonAccountsServiceIface PantheonShellPantheonAccountsServiceIface;

#define PANTHEON_SHELL_PANTHEON_TYPE_ACCOUNTS_SERVICE_PROXY (pantheon_shell_pantheon_accounts_service_proxy_get_type ())
enum  {
	PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_0_PROPERTY,
	PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_COLOR_PROPERTY,
	PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_PANTHEON_ACT_PROPERTY,
	PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_NUM_PROPERTIES
};
static GParamSpec* pantheon_shell_appearance_prefers_accent_color_button_properties[PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define PANTHEON_SHELL_APPEARANCE_TYPE_DESKTOP_PREVIEW (pantheon_shell_appearance_desktop_preview_get_type ())
#define PANTHEON_SHELL_APPEARANCE_DESKTOP_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_SHELL_APPEARANCE_TYPE_DESKTOP_PREVIEW, PantheonShellAppearanceDesktopPreview))
#define PANTHEON_SHELL_APPEARANCE_DESKTOP_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHEON_SHELL_APPEARANCE_TYPE_DESKTOP_PREVIEW, PantheonShellAppearanceDesktopPreviewClass))
#define PANTHEON_SHELL_APPEARANCE_IS_DESKTOP_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_SHELL_APPEARANCE_TYPE_DESKTOP_PREVIEW))
#define PANTHEON_SHELL_APPEARANCE_IS_DESKTOP_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHEON_SHELL_APPEARANCE_TYPE_DESKTOP_PREVIEW))
#define PANTHEON_SHELL_APPEARANCE_DESKTOP_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHEON_SHELL_APPEARANCE_TYPE_DESKTOP_PREVIEW, PantheonShellAppearanceDesktopPreviewClass))

typedef struct _PantheonShellAppearanceDesktopPreview PantheonShellAppearanceDesktopPreview;
typedef struct _PantheonShellAppearanceDesktopPreviewClass PantheonShellAppearanceDesktopPreviewClass;
typedef struct _PantheonShellAppearanceDesktopPreviewPrivate PantheonShellAppearanceDesktopPreviewPrivate;
enum  {
	PANTHEON_SHELL_APPEARANCE_DESKTOP_PREVIEW_0_PROPERTY,
	PANTHEON_SHELL_APPEARANCE_DESKTOP_PREVIEW_NUM_PROPERTIES
};
static GParamSpec* pantheon_shell_appearance_desktop_preview_properties[PANTHEON_SHELL_APPEARANCE_DESKTOP_PREVIEW_NUM_PROPERTIES];
typedef struct _Block1Data Block1Data;

#define PANTHEON_SHELL_FDO_TYPE_ACCOUNTS (pantheon_shell_fdo_accounts_get_type ())
#define PANTHEON_SHELL_FDO_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_SHELL_FDO_TYPE_ACCOUNTS, PantheonShellFDOAccounts))
#define PANTHEON_SHELL_FDO_IS_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_SHELL_FDO_TYPE_ACCOUNTS))
#define PANTHEON_SHELL_FDO_ACCOUNTS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PANTHEON_SHELL_FDO_TYPE_ACCOUNTS, PantheonShellFDOAccountsIface))

typedef struct _PantheonShellFDOAccounts PantheonShellFDOAccounts;
typedef struct _PantheonShellFDOAccountsIface PantheonShellFDOAccountsIface;

#define PANTHEON_SHELL_FDO_TYPE_ACCOUNTS_PROXY (pantheon_shell_fdo_accounts_proxy_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _PantheonShellAppearancePrefersAccentColorButton {
	GtkCheckButton parent_instance;
	PantheonShellAppearancePrefersAccentColorButtonPrivate * priv;
};

struct _PantheonShellAppearancePrefersAccentColorButtonClass {
	GtkCheckButtonClass parent_class;
};

struct _PantheonShellPantheonAccountsServiceIface {
	GTypeInterface parent_iface;
	gint (*get_prefers_accent_color) (PantheonShellPantheonAccountsService* self);
	void (*set_prefers_accent_color) (PantheonShellPantheonAccountsService* self, gint value);
	gint (*get_prefers_color_scheme) (PantheonShellPantheonAccountsService* self);
	void (*set_prefers_color_scheme) (PantheonShellPantheonAccountsService* self, gint value);
};

struct _PantheonShellAppearancePrefersAccentColorButtonPrivate {
	PantheonShellAppearanceAccentColor _color;
	PantheonShellPantheonAccountsService* _pantheon_act;
};

struct _PantheonShellAppearanceDesktopPreview {
	GtkWidget parent_instance;
	PantheonShellAppearanceDesktopPreviewPrivate * priv;
};

struct _PantheonShellAppearanceDesktopPreviewClass {
	GtkWidgetClass parent_class;
};

struct _PantheonShellAppearanceDesktopPreviewPrivate {
	GtkPicture* picture;
};

struct _Block1Data {
	int _ref_count_;
	PantheonShellAppearance* self;
	GtkCheckButton* prefer_default_radio;
	GtkCheckButton* prefer_dark_radio;
	GtkCheckButton* schedule_disabled_radio;
	GraniteTimePicker* from_time;
	GraniteTimePicker* to_time;
	PantheonShellPantheonAccountsService* pantheon_act;
};

struct _PantheonShellFDOAccountsIface {
	GTypeInterface parent_iface;
	gchar* (*find_user_by_name) (PantheonShellFDOAccounts* self, const gchar* username, GError** error);
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GSettings* settings;
};

static gpointer pantheon_shell_appearance_parent_class = NULL;
static gint PantheonShellAppearancePrefersAccentColorButton_private_offset;
static gpointer pantheon_shell_appearance_prefers_accent_color_button_parent_class = NULL;
static GSettings* pantheon_shell_appearance_prefers_accent_color_button_interface_settings;
static GSettings* pantheon_shell_appearance_prefers_accent_color_button_interface_settings = NULL;
static gint PantheonShellAppearanceDesktopPreview_private_offset;
static gpointer pantheon_shell_appearance_desktop_preview_parent_class = NULL;
static GSettings* pantheon_shell_appearance_desktop_preview_pantheon_settings;
static GSettings* pantheon_shell_appearance_desktop_preview_pantheon_settings = NULL;
static GSettings* pantheon_shell_appearance_desktop_preview_gnome_settings;
static GSettings* pantheon_shell_appearance_desktop_preview_gnome_settings = NULL;

static GType pantheon_shell_appearance_accent_color_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gchar* pantheon_shell_appearance_accent_color_to_string (PantheonShellAppearanceAccentColor self);
static GDateTime* pantheon_shell_appearance_double_date_time (gdouble dbl);
static gdouble pantheon_shell_appearance_date_time_double (GDateTime* date_time);
static GType pantheon_shell_appearance_prefers_accent_color_button_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN GType pantheon_shell_pantheon_accounts_service_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pantheon_shell_pantheon_accounts_service_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pantheon_shell_pantheon_accounts_service_register_object (void* object,
                                                                GDBusConnection* connection,
                                                                const gchar* path,
                                                                GError** error);
static PantheonShellAppearancePrefersAccentColorButton* pantheon_shell_appearance_prefers_accent_color_button_new (PantheonShellPantheonAccountsService* pantheon_act,
                                                                                                            PantheonShellAppearanceAccentColor color,
                                                                                                            GtkCheckButton* group_member);
static PantheonShellAppearancePrefersAccentColorButton* pantheon_shell_appearance_prefers_accent_color_button_construct (GType object_type,
                                                                                                                  PantheonShellPantheonAccountsService* pantheon_act,
                                                                                                                  PantheonShellAppearanceAccentColor color,
                                                                                                                  GtkCheckButton* group_member);
static PantheonShellAppearanceAccentColor pantheon_shell_appearance_prefers_accent_color_button_get_color (PantheonShellAppearancePrefersAccentColorButton* self);
static void pantheon_shell_appearance_prefers_accent_color_button_set_color (PantheonShellAppearancePrefersAccentColorButton* self,
                                                                      PantheonShellAppearanceAccentColor value);
static PantheonShellPantheonAccountsService* pantheon_shell_appearance_prefers_accent_color_button_get_pantheon_act (PantheonShellAppearancePrefersAccentColorButton* self);
static void pantheon_shell_appearance_prefers_accent_color_button_set_pantheon_act (PantheonShellAppearancePrefersAccentColorButton* self,
                                                                             PantheonShellPantheonAccountsService* value);
static GObject * pantheon_shell_appearance_prefers_accent_color_button_constructor (GType type,
                                                                             guint n_construct_properties,
                                                                             GObjectConstructParam * construct_properties);
static void _pantheon_shell_appearance_prefers_accent_color_button___lambda48_ (PantheonShellAppearancePrefersAccentColorButton* self);
VALA_EXTERN gint pantheon_shell_pantheon_accounts_service_get_prefers_accent_color (PantheonShellPantheonAccountsService* self);
static void __lambda49_ (PantheonShellAppearancePrefersAccentColorButton* self);
VALA_EXTERN void pantheon_shell_pantheon_accounts_service_set_prefers_accent_color (PantheonShellPantheonAccountsService* self,
                                                                        gint value);
static void ___lambda49__gtk_check_button_toggled (GtkCheckButton* _sender,
                                            gpointer self);
static void __pantheon_shell_appearance_prefers_accent_color_button___lambda48__gtk_widget_realize (GtkWidget* _sender,
                                                                                             gpointer self);
static void pantheon_shell_appearance_prefers_accent_color_button_finalize (GObject * obj);
static GType pantheon_shell_appearance_prefers_accent_color_button_get_type_once (void);
static void _vala_pantheon_shell_appearance_prefers_accent_color_button_get_property (GObject * object,
                                                                               guint property_id,
                                                                               GValue * value,
                                                                               GParamSpec * pspec);
static void _vala_pantheon_shell_appearance_prefers_accent_color_button_set_property (GObject * object,
                                                                               guint property_id,
                                                                               const GValue * value,
                                                                               GParamSpec * pspec);
static GType pantheon_shell_appearance_desktop_preview_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PantheonShellAppearanceDesktopPreview* pantheon_shell_appearance_desktop_preview_new (const gchar* style_class);
static PantheonShellAppearanceDesktopPreview* pantheon_shell_appearance_desktop_preview_construct (GType object_type,
                                                                                            const gchar* style_class);
static void pantheon_shell_appearance_desktop_preview_update_picture (PantheonShellAppearanceDesktopPreview* self);
static void _pantheon_shell_appearance_desktop_preview_update_picture_g_settings_changed (GSettings* _sender,
                                                                                   const gchar* key,
                                                                                   gpointer self);
static void pantheon_shell_appearance_desktop_preview_update_dim (PantheonShellAppearanceDesktopPreview* self);
static void _pantheon_shell_appearance_desktop_preview_update_dim_g_settings_changed (GSettings* _sender,
                                                                               const gchar* key,
                                                                               gpointer self);
static void pantheon_shell_appearance_desktop_preview_finalize (GObject * obj);
static GType pantheon_shell_appearance_desktop_preview_get_type_once (void);
static GObject * pantheon_shell_appearance_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN GType pantheon_shell_fdo_accounts_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pantheon_shell_fdo_accounts_register_object (void* object,
                                                   GDBusConnection* connection,
                                                   const gchar* path,
                                                   GError** error);
VALA_EXTERN GType pantheon_shell_fdo_accounts_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* pantheon_shell_fdo_accounts_find_user_by_name (PantheonShellFDOAccounts* self,
                                                      const gchar* username,
                                                      GError** error);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN gint pantheon_shell_pantheon_accounts_service_get_prefers_color_scheme (PantheonShellPantheonAccountsService* self);
static gboolean _pantheon_shell_appearance____lambda35_ (GValue* value,
                                                  GVariant* variant,
                                                  void* user_data);
static gboolean __pantheon_shell_appearance____lambda35__gsettings_bind_get_mapping (GValue* value,
                                                                              GVariant* variant,
                                                                              void* user_data);
static GVariant* _pantheon_shell_appearance____lambda36_ (GValue* value,
                                                   const GVariantType* expected_type,
                                                   void* user_data);
static GVariant* __pantheon_shell_appearance____lambda36__gsettings_bind_set_mapping (GValue* value,
                                                                               const GVariantType* expected_type,
                                                                               void* user_data);
static gboolean _pantheon_shell_appearance____lambda37_ (GValue* value,
                                                  GVariant* variant,
                                                  void* user_data);
static gboolean __pantheon_shell_appearance____lambda37__gsettings_bind_get_mapping (GValue* value,
                                                                              GVariant* variant,
                                                                              void* user_data);
static GVariant* _pantheon_shell_appearance____lambda38_ (GValue* value,
                                                   const GVariantType* expected_type,
                                                   void* user_data);
static GVariant* __pantheon_shell_appearance____lambda38__gsettings_bind_set_mapping (GValue* value,
                                                                               const GVariantType* expected_type,
                                                                               void* user_data);
static gboolean _pantheon_shell_appearance____lambda39_ (GValue* value,
                                                  GVariant* variant,
                                                  void* user_data);
static gboolean __pantheon_shell_appearance____lambda39__gsettings_bind_get_mapping (GValue* value,
                                                                              GVariant* variant,
                                                                              void* user_data);
static GVariant* _pantheon_shell_appearance____lambda40_ (GValue* value,
                                                   const GVariantType* expected_type,
                                                   void* user_data);
static GVariant* __pantheon_shell_appearance____lambda40__gsettings_bind_set_mapping (GValue* value,
                                                                               const GVariantType* expected_type,
                                                                               void* user_data);
static void _pantheon_shell_appearance____lambda41_ (Block2Data* _data2_);
VALA_EXTERN void pantheon_shell_pantheon_accounts_service_set_prefers_color_scheme (PantheonShellPantheonAccountsService* self,
                                                                        gint value);
static void __pantheon_shell_appearance____lambda41__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                        gpointer self);
static void _pantheon_shell_appearance____lambda42_ (Block2Data* _data2_);
static void __pantheon_shell_appearance____lambda42__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                        gpointer self);
static void _pantheon_shell_appearance____lambda43_ (Block2Data* _data2_);
static void __pantheon_shell_appearance____lambda43__gtk_event_controller_focus_enter (GtkEventControllerFocus* _sender,
                                                                                gpointer self);
static void _pantheon_shell_appearance____lambda44_ (Block2Data* _data2_);
static void __pantheon_shell_appearance____lambda44__gtk_event_controller_focus_enter (GtkEventControllerFocus* _sender,
                                                                                gpointer self);
static void _pantheon_shell_appearance____lambda45_ (Block2Data* _data2_,
                                              GVariant* changed,
                                              gchar** invalid);
static void __pantheon_shell_appearance____lambda45__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                                 GVariant* changed_properties,
                                                                                 gchar** invalidated_properties,
                                                                                 gpointer self);
static void _pantheon_shell_appearance____lambda46_ (Block2Data* _data2_);
static void __pantheon_shell_appearance____lambda46__granite_time_picker_time_changed (GraniteTimePicker* _sender,
                                                                                gpointer self);
static void _pantheon_shell_appearance____lambda47_ (Block2Data* _data2_);
static void __pantheon_shell_appearance____lambda47__granite_time_picker_time_changed (GraniteTimePicker* _sender,
                                                                                gpointer self);
static GType pantheon_shell_appearance_get_type_once (void);

static gchar*
pantheon_shell_appearance_accent_color_to_string (PantheonShellAppearanceAccentColor self)
{
	gchar* _tmp10_;
	gchar* result;
	switch (self) {
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_RED:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("strawberry");
			result = _tmp0_;
			return result;
		}
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_ORANGE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("orange");
			result = _tmp1_;
			return result;
		}
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_YELLOW:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("banana");
			result = _tmp2_;
			return result;
		}
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GREEN:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("lime");
			result = _tmp3_;
			return result;
		}
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_MINT:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("mint");
			result = _tmp4_;
			return result;
		}
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BLUE:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("blueberry");
			result = _tmp5_;
			return result;
		}
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PURPLE:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("grape");
			result = _tmp6_;
			return result;
		}
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PINK:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("bubblegum");
			result = _tmp7_;
			return result;
		}
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BROWN:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("cocoa");
			result = _tmp8_;
			return result;
		}
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GRAY:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("slate");
			result = _tmp9_;
			return result;
		}
		default:
		break;
	}
	_tmp10_ = g_strdup ("auto");
	result = _tmp10_;
	return result;
}

static GType
pantheon_shell_appearance_accent_color_get_type_once (void)
{
	static const GEnumValue values[] = {{PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_NO_PREFERENCE, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_NO_PREFERENCE", "no-preference"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_RED, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_RED", "red"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_ORANGE, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_ORANGE", "orange"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_YELLOW, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_YELLOW", "yellow"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GREEN, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GREEN", "green"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_MINT, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_MINT", "mint"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BLUE, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BLUE", "blue"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PURPLE, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PURPLE", "purple"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PINK, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PINK", "pink"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BROWN, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BROWN", "brown"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GRAY, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GRAY", "gray"}, {0, NULL, NULL}};
	GType pantheon_shell_appearance_accent_color_type_id;
	pantheon_shell_appearance_accent_color_type_id = g_enum_register_static ("PantheonShellAppearanceAccentColor", values);
	return pantheon_shell_appearance_accent_color_type_id;
}

static GType
pantheon_shell_appearance_accent_color_get_type (void)
{
	static volatile gsize pantheon_shell_appearance_accent_color_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_appearance_accent_color_type_id__once)) {
		GType pantheon_shell_appearance_accent_color_type_id;
		pantheon_shell_appearance_accent_color_type_id = pantheon_shell_appearance_accent_color_get_type_once ();
		g_once_init_leave (&pantheon_shell_appearance_accent_color_type_id__once, pantheon_shell_appearance_accent_color_type_id);
	}
	return pantheon_shell_appearance_accent_color_type_id__once;
}

PantheonShellAppearance*
pantheon_shell_appearance_construct (GType object_type)
{
	PantheonShellAppearance * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("preferences-desktop-theme");
	_tmp1_ = _tmp0_;
	self = (PantheonShellAppearance*) g_object_new (object_type, "title", _ ("Appearance"), "description", _ ("Apps may follow these preferences, but can choose their own accents or" \
" style."), "icon", _tmp1_, "show-end-title-buttons", TRUE, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

PantheonShellAppearance*
pantheon_shell_appearance_new (void)
{
	return pantheon_shell_appearance_construct (PANTHEON_SHELL_TYPE_APPEARANCE);
}

static GDateTime*
pantheon_shell_appearance_double_date_time (gdouble dbl)
{
	gint hours = 0;
	gint minutes = 0;
	GDateTime* date_time = NULL;
	GDateTime* _tmp0_;
	GDateTime* result;
	hours = (gint) dbl;
	minutes = (gint) round ((dbl - hours) * 60);
	_tmp0_ = g_date_time_new_local (1, 1, 1, hours, minutes, 0.0);
	date_time = _tmp0_;
	result = date_time;
	return result;
}

static gdouble
pantheon_shell_appearance_date_time_double (GDateTime* date_time)
{
	gdouble time_double = 0.0;
	gdouble result;
	g_return_val_if_fail (date_time != NULL, 0.0);
	time_double = (gdouble) 0;
	time_double += (gdouble) g_date_time_get_hour (date_time);
	time_double += ((gdouble) g_date_time_get_minute (date_time)) / 60;
	result = time_double;
	return result;
}

static inline gpointer
pantheon_shell_appearance_prefers_accent_color_button_get_instance_private (PantheonShellAppearancePrefersAccentColorButton* self)
{
	return G_STRUCT_MEMBER_P (self, PantheonShellAppearancePrefersAccentColorButton_private_offset);
}

static PantheonShellAppearancePrefersAccentColorButton*
pantheon_shell_appearance_prefers_accent_color_button_construct (GType object_type,
                                                                 PantheonShellPantheonAccountsService* pantheon_act,
                                                                 PantheonShellAppearanceAccentColor color,
                                                                 GtkCheckButton* group_member)
{
	PantheonShellAppearancePrefersAccentColorButton * self = NULL;
	self = (PantheonShellAppearancePrefersAccentColorButton*) g_object_new (object_type, "pantheon-act", pantheon_act, "color", color, "group", group_member, NULL);
	return self;
}

static PantheonShellAppearancePrefersAccentColorButton*
pantheon_shell_appearance_prefers_accent_color_button_new (PantheonShellPantheonAccountsService* pantheon_act,
                                                           PantheonShellAppearanceAccentColor color,
                                                           GtkCheckButton* group_member)
{
	return pantheon_shell_appearance_prefers_accent_color_button_construct (PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON, pantheon_act, color, group_member);
}

static PantheonShellAppearanceAccentColor
pantheon_shell_appearance_prefers_accent_color_button_get_color (PantheonShellAppearancePrefersAccentColorButton* self)
{
	PantheonShellAppearanceAccentColor result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_color;
	return result;
}

static void
pantheon_shell_appearance_prefers_accent_color_button_set_color (PantheonShellAppearancePrefersAccentColorButton* self,
                                                                 PantheonShellAppearanceAccentColor value)
{
	PantheonShellAppearanceAccentColor old_value;
	g_return_if_fail (self != NULL);
	old_value = pantheon_shell_appearance_prefers_accent_color_button_get_color (self);
	if (old_value != value) {
		self->priv->_color = value;
		g_object_notify_by_pspec ((GObject *) self, pantheon_shell_appearance_prefers_accent_color_button_properties[PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_COLOR_PROPERTY]);
	}
}

static PantheonShellPantheonAccountsService*
pantheon_shell_appearance_prefers_accent_color_button_get_pantheon_act (PantheonShellAppearancePrefersAccentColorButton* self)
{
	PantheonShellPantheonAccountsService* result;
	PantheonShellPantheonAccountsService* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pantheon_act;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pantheon_shell_appearance_prefers_accent_color_button_set_pantheon_act (PantheonShellAppearancePrefersAccentColorButton* self,
                                                                        PantheonShellPantheonAccountsService* value)
{
	PantheonShellPantheonAccountsService* old_value;
	g_return_if_fail (self != NULL);
	old_value = pantheon_shell_appearance_prefers_accent_color_button_get_pantheon_act (self);
	if (old_value != value) {
		PantheonShellPantheonAccountsService* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_pantheon_act);
		self->priv->_pantheon_act = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pantheon_shell_appearance_prefers_accent_color_button_properties[PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_PANTHEON_ACT_PROPERTY]);
	}
}

static void
__lambda49_ (PantheonShellAppearancePrefersAccentColorButton* self)
{
	PantheonShellAppearanceAccentColor _tmp0_;
	PantheonShellPantheonAccountsService* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	gboolean _tmp10_;
	_tmp0_ = self->priv->_color;
	if (_tmp0_ != PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_NO_PREFERENCE) {
		GSettings* _tmp1_;
		PantheonShellAppearanceAccentColor _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = pantheon_shell_appearance_prefers_accent_color_button_interface_settings;
		_tmp2_ = self->priv->_color;
		_tmp3_ = pantheon_shell_appearance_accent_color_to_string (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (PANTHEON_SHELL_APPEARANCE_STYLESHEET_PREFIX, _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		g_settings_set_string (_tmp1_, PANTHEON_SHELL_APPEARANCE_STYLESHEET_KEY, _tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
	}
	_tmp7_ = self->priv->_pantheon_act;
	_tmp8_ = g_dbus_proxy_get_cached_property (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_dbus_proxy_get_type (), GDBusProxy), "PrefersAccentColor");
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_ != NULL;
	_g_variant_unref0 (_tmp9_);
	if (_tmp10_) {
		PantheonShellPantheonAccountsService* _tmp11_;
		PantheonShellAppearanceAccentColor _tmp12_;
		_tmp11_ = self->priv->_pantheon_act;
		_tmp12_ = self->priv->_color;
		pantheon_shell_pantheon_accounts_service_set_prefers_accent_color (_tmp11_, (gint) _tmp12_);
	}
}

static void
___lambda49__gtk_check_button_toggled (GtkCheckButton* _sender,
                                       gpointer self)
{
	__lambda49_ ((PantheonShellAppearancePrefersAccentColorButton*) self);
}

static void
_pantheon_shell_appearance_prefers_accent_color_button___lambda48_ (PantheonShellAppearancePrefersAccentColorButton* self)
{
	PantheonShellAppearanceAccentColor _tmp0_;
	PantheonShellPantheonAccountsService* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = self->priv->_color;
	_tmp1_ = self->priv->_pantheon_act;
	_tmp2_ = pantheon_shell_pantheon_accounts_service_get_prefers_accent_color (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_check_button_set_active ((GtkCheckButton*) self, _tmp0_ == _tmp3_);
	g_signal_connect_object ((GtkCheckButton*) self, "toggled", (GCallback) ___lambda49__gtk_check_button_toggled, self, 0);
}

static void
__pantheon_shell_appearance_prefers_accent_color_button___lambda48__gtk_widget_realize (GtkWidget* _sender,
                                                                                        gpointer self)
{
	_pantheon_shell_appearance_prefers_accent_color_button___lambda48_ ((PantheonShellAppearancePrefersAccentColorButton*) self);
}

static GObject *
pantheon_shell_appearance_prefers_accent_color_button_constructor (GType type,
                                                                   guint n_construct_properties,
                                                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PantheonShellAppearancePrefersAccentColorButton * self;
	PantheonShellAppearanceAccentColor _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	parent_class = G_OBJECT_CLASS (pantheon_shell_appearance_prefers_accent_color_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON, PantheonShellAppearancePrefersAccentColorButton);
	gtk_widget_add_css_class ((GtkWidget*) self, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp0_ = self->priv->_color;
	_tmp1_ = pantheon_shell_appearance_accent_color_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_widget_add_css_class ((GtkWidget*) self, _tmp2_);
	_g_free0 (_tmp2_);
	g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) __pantheon_shell_appearance_prefers_accent_color_button___lambda48__gtk_widget_realize, self, 0);
	return obj;
}

static void
pantheon_shell_appearance_prefers_accent_color_button_class_init (PantheonShellAppearancePrefersAccentColorButtonClass * klass,
                                                                  gpointer klass_data)
{
	GSettings* _tmp0_;
	gchar* current_stylesheet = NULL;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	pantheon_shell_appearance_prefers_accent_color_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantheonShellAppearancePrefersAccentColorButton_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pantheon_shell_appearance_prefers_accent_color_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pantheon_shell_appearance_prefers_accent_color_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = pantheon_shell_appearance_prefers_accent_color_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = pantheon_shell_appearance_prefers_accent_color_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_COLOR_PROPERTY, pantheon_shell_appearance_prefers_accent_color_button_properties[PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_COLOR_PROPERTY] = g_param_spec_enum ("color", "color", "color", PANTHEON_SHELL_APPEARANCE_TYPE_ACCENT_COLOR, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_PANTHEON_ACT_PROPERTY, pantheon_shell_appearance_prefers_accent_color_button_properties[PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_PANTHEON_ACT_PROPERTY] = g_param_spec_object ("pantheon-act", "pantheon-act", "pantheon-act", PANTHEON_SHELL_PANTHEON_TYPE_ACCOUNTS_SERVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = g_settings_new (PANTHEON_SHELL_APPEARANCE_INTERFACE_SCHEMA);
	_g_object_unref0 (pantheon_shell_appearance_prefers_accent_color_button_interface_settings);
	pantheon_shell_appearance_prefers_accent_color_button_interface_settings = _tmp0_;
	_tmp1_ = pantheon_shell_appearance_prefers_accent_color_button_interface_settings;
	_tmp2_ = g_settings_get_string (_tmp1_, PANTHEON_SHELL_APPEARANCE_STYLESHEET_KEY);
	current_stylesheet = _tmp2_;
	_g_free0 (current_stylesheet);
}

static void
pantheon_shell_appearance_prefers_accent_color_button_instance_init (PantheonShellAppearancePrefersAccentColorButton * self,
                                                                     gpointer klass)
{
	self->priv = pantheon_shell_appearance_prefers_accent_color_button_get_instance_private (self);
	self->priv->_pantheon_act = NULL;
}

static void
pantheon_shell_appearance_prefers_accent_color_button_finalize (GObject * obj)
{
	PantheonShellAppearancePrefersAccentColorButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON, PantheonShellAppearancePrefersAccentColorButton);
	_g_object_unref0 (self->priv->_pantheon_act);
	G_OBJECT_CLASS (pantheon_shell_appearance_prefers_accent_color_button_parent_class)->finalize (obj);
}

static GType
pantheon_shell_appearance_prefers_accent_color_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellAppearancePrefersAccentColorButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_appearance_prefers_accent_color_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonShellAppearancePrefersAccentColorButton), 0, (GInstanceInitFunc) pantheon_shell_appearance_prefers_accent_color_button_instance_init, NULL };
	GType pantheon_shell_appearance_prefers_accent_color_button_type_id;
	pantheon_shell_appearance_prefers_accent_color_button_type_id = g_type_register_static (gtk_check_button_get_type (), "PantheonShellAppearancePrefersAccentColorButton", &g_define_type_info, 0);
	PantheonShellAppearancePrefersAccentColorButton_private_offset = g_type_add_instance_private (pantheon_shell_appearance_prefers_accent_color_button_type_id, sizeof (PantheonShellAppearancePrefersAccentColorButtonPrivate));
	return pantheon_shell_appearance_prefers_accent_color_button_type_id;
}

static GType
pantheon_shell_appearance_prefers_accent_color_button_get_type (void)
{
	static volatile gsize pantheon_shell_appearance_prefers_accent_color_button_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_appearance_prefers_accent_color_button_type_id__once)) {
		GType pantheon_shell_appearance_prefers_accent_color_button_type_id;
		pantheon_shell_appearance_prefers_accent_color_button_type_id = pantheon_shell_appearance_prefers_accent_color_button_get_type_once ();
		g_once_init_leave (&pantheon_shell_appearance_prefers_accent_color_button_type_id__once, pantheon_shell_appearance_prefers_accent_color_button_type_id);
	}
	return pantheon_shell_appearance_prefers_accent_color_button_type_id__once;
}

static void
_vala_pantheon_shell_appearance_prefers_accent_color_button_get_property (GObject * object,
                                                                          guint property_id,
                                                                          GValue * value,
                                                                          GParamSpec * pspec)
{
	PantheonShellAppearancePrefersAccentColorButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON, PantheonShellAppearancePrefersAccentColorButton);
	switch (property_id) {
		case PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_COLOR_PROPERTY:
		g_value_set_enum (value, pantheon_shell_appearance_prefers_accent_color_button_get_color (self));
		break;
		case PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_PANTHEON_ACT_PROPERTY:
		g_value_set_object (value, pantheon_shell_appearance_prefers_accent_color_button_get_pantheon_act (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pantheon_shell_appearance_prefers_accent_color_button_set_property (GObject * object,
                                                                          guint property_id,
                                                                          const GValue * value,
                                                                          GParamSpec * pspec)
{
	PantheonShellAppearancePrefersAccentColorButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON, PantheonShellAppearancePrefersAccentColorButton);
	switch (property_id) {
		case PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_COLOR_PROPERTY:
		pantheon_shell_appearance_prefers_accent_color_button_set_color (self, g_value_get_enum (value));
		break;
		case PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_PANTHEON_ACT_PROPERTY:
		pantheon_shell_appearance_prefers_accent_color_button_set_pantheon_act (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
pantheon_shell_appearance_desktop_preview_get_instance_private (PantheonShellAppearanceDesktopPreview* self)
{
	return G_STRUCT_MEMBER_P (self, PantheonShellAppearanceDesktopPreview_private_offset);
}

static void
_pantheon_shell_appearance_desktop_preview_update_picture_g_settings_changed (GSettings* _sender,
                                                                              const gchar* key,
                                                                              gpointer self)
{
	pantheon_shell_appearance_desktop_preview_update_picture ((PantheonShellAppearanceDesktopPreview*) self);
}

static void
_pantheon_shell_appearance_desktop_preview_update_dim_g_settings_changed (GSettings* _sender,
                                                                          const gchar* key,
                                                                          gpointer self)
{
	pantheon_shell_appearance_desktop_preview_update_dim ((PantheonShellAppearanceDesktopPreview*) self);
}

static PantheonShellAppearanceDesktopPreview*
pantheon_shell_appearance_desktop_preview_construct (GType object_type,
                                                     const gchar* style_class)
{
	PantheonShellAppearanceDesktopPreview * self = NULL;
	GtkPicture* _tmp0_ = NULL;
	GtkBox* window_back = NULL;
	GtkBox* _tmp1_ = NULL;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkBox* window_front = NULL;
	GtkBox* _tmp4_ = NULL;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkBox* shell = NULL;
	GtkBox* _tmp7_;
	GtkBox* _tmp8_;
	GtkOverlay* overlay = NULL;
	GtkPicture* _tmp9_;
	GtkWidget* _tmp10_;
	GtkOverlay* _tmp11_ = NULL;
	GtkOverlay* _tmp12_;
	GtkBox* _tmp13_;
	GtkOverlay* _tmp14_;
	GtkBox* _tmp15_;
	GtkOverlay* _tmp16_;
	GtkBox* _tmp17_;
	GtkOverlay* _tmp18_;
	GtkOverlay* _tmp19_;
	GdkMonitor* monitor = NULL;
	GdkDisplay* _tmp20_;
	GApplication* _tmp21_;
	GtkWindow* _tmp22_;
	GtkWindow* _tmp23_;
	GdkSurface* _tmp24_;
	GdkMonitor* _tmp25_;
	GdkMonitor* _tmp26_;
	gfloat monitor_ratio = 0.0F;
	GdkMonitor* _tmp27_;
	GdkRectangle _tmp28_ = {0};
	GdkRectangle _tmp29_;
	GdkMonitor* _tmp30_;
	GdkRectangle _tmp31_ = {0};
	GdkRectangle _tmp32_;
	GtkAspectFrame* frame = NULL;
	GtkOverlay* _tmp33_;
	GtkWidget* _tmp34_;
	GtkAspectFrame* _tmp35_ = NULL;
	GtkAspectFrame* _tmp36_;
	GSettings* _tmp37_;
	g_return_val_if_fail (style_class != NULL, NULL);
	self = (PantheonShellAppearanceDesktopPreview*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkPicture*) gtk_picture_new ();
	gtk_picture_set_content_fit (_tmp0_, GTK_CONTENT_FIT_COVER);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->picture);
	self->priv->picture = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp1_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp1_);
	window_back = _tmp1_;
	_tmp2_ = window_back;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, "window");
	_tmp3_ = window_back;
	gtk_widget_add_css_class ((GtkWidget*) _tmp3_, "back");
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp4_);
	window_front = _tmp4_;
	_tmp5_ = window_front;
	gtk_widget_add_css_class ((GtkWidget*) _tmp5_, "window");
	_tmp6_ = window_front;
	gtk_widget_add_css_class ((GtkWidget*) _tmp6_, "front");
	_tmp7_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp7_);
	shell = _tmp7_;
	_tmp8_ = shell;
	gtk_widget_add_css_class ((GtkWidget*) _tmp8_, "shell");
	_tmp9_ = self->priv->picture;
	_tmp10_ = _g_object_ref0 ((GtkWidget*) _tmp9_);
	_tmp11_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_overlay_set_child (_tmp11_, _tmp10_);
	_g_object_unref0 (_tmp10_);
	gtk_widget_set_overflow ((GtkWidget*) _tmp11_, GTK_OVERFLOW_HIDDEN);
	g_object_ref_sink (_tmp11_);
	overlay = _tmp11_;
	_tmp12_ = overlay;
	_tmp13_ = shell;
	gtk_overlay_add_overlay (_tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = overlay;
	_tmp15_ = window_back;
	gtk_overlay_add_overlay (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = overlay;
	_tmp17_ = window_front;
	gtk_overlay_add_overlay (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = overlay;
	gtk_widget_add_css_class ((GtkWidget*) _tmp18_, GRANITE_STYLE_CLASS_CARD);
	_tmp19_ = overlay;
	gtk_widget_add_css_class ((GtkWidget*) _tmp19_, GRANITE_STYLE_CLASS_ROUNDED);
	_tmp20_ = gdk_display_get_default ();
	_tmp21_ = g_application_get_default ();
	_tmp22_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_application_get_type (), GtkApplication));
	_tmp23_ = _tmp22_;
	_tmp24_ = gtk_native_get_surface ((GtkNative*) _tmp23_);
	_tmp25_ = gdk_display_get_monitor_at_surface (_tmp20_, _tmp24_);
	_tmp26_ = _g_object_ref0 (_tmp25_);
	monitor = _tmp26_;
	_tmp27_ = monitor;
	gdk_monitor_get_geometry (_tmp27_, &_tmp28_);
	_tmp29_ = _tmp28_;
	_tmp30_ = monitor;
	gdk_monitor_get_geometry (_tmp30_, &_tmp31_);
	_tmp32_ = _tmp31_;
	monitor_ratio = ((gfloat) _tmp29_.width) / _tmp32_.height;
	_tmp33_ = overlay;
	_tmp34_ = _g_object_ref0 ((GtkWidget*) _tmp33_);
	_tmp35_ = (GtkAspectFrame*) gtk_aspect_frame_new (0.5f, 0.5f, monitor_ratio, FALSE);
	gtk_aspect_frame_set_child (_tmp35_, _tmp34_);
	_g_object_unref0 (_tmp34_);
	g_object_ref_sink (_tmp35_);
	frame = _tmp35_;
	_tmp36_ = frame;
	gtk_widget_set_parent ((GtkWidget*) _tmp36_, (GtkWidget*) self);
	gtk_widget_add_css_class ((GtkWidget*) self, style_class);
	pantheon_shell_appearance_desktop_preview_update_picture (self);
	_tmp37_ = pantheon_shell_appearance_desktop_preview_gnome_settings;
	g_signal_connect_object (_tmp37_, "changed", (GCallback) _pantheon_shell_appearance_desktop_preview_update_picture_g_settings_changed, self, 0);
	if (gtk_widget_has_css_class ((GtkWidget*) self, "dark")) {
		GSettings* _tmp38_;
		pantheon_shell_appearance_desktop_preview_update_dim (self);
		_tmp38_ = pantheon_shell_appearance_desktop_preview_pantheon_settings;
		g_signal_connect_object (_tmp38_, "changed", (GCallback) _pantheon_shell_appearance_desktop_preview_update_dim_g_settings_changed, self, 0);
	}
	_g_object_unref0 (frame);
	_g_object_unref0 (monitor);
	_g_object_unref0 (overlay);
	_g_object_unref0 (shell);
	_g_object_unref0 (window_front);
	_g_object_unref0 (window_back);
	return self;
}

static PantheonShellAppearanceDesktopPreview*
pantheon_shell_appearance_desktop_preview_new (const gchar* style_class)
{
	return pantheon_shell_appearance_desktop_preview_construct (PANTHEON_SHELL_APPEARANCE_TYPE_DESKTOP_PREVIEW, style_class);
}

static void
pantheon_shell_appearance_desktop_preview_update_dim (PantheonShellAppearanceDesktopPreview* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pantheon_shell_appearance_desktop_preview_pantheon_settings;
	if (g_settings_get_boolean (_tmp0_, "dim-wallpaper-in-dark-style")) {
		gtk_widget_add_css_class ((GtkWidget*) self, "dim");
	} else {
		gtk_widget_remove_css_class ((GtkWidget*) self, "dim");
	}
}

static void
pantheon_shell_appearance_desktop_preview_update_picture (PantheonShellAppearanceDesktopPreview* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	GtkPicture* _tmp23_;
	GSettings* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GFile* _tmp27_;
	GFile* _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pantheon_shell_appearance_desktop_preview_gnome_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "picture-options");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "none") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		GdkRGBA rgba = {0};
		GdkRGBA _tmp4_ = {0};
		GSettings* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GdkPixbuf* pixbuf = NULL;
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkRGBA _tmp10_;
		GtkPicture* _tmp11_;
		GdkPixbuf* _tmp12_;
		GdkTexture* _tmp13_;
		GdkTexture* _tmp14_;
		rgba = _tmp4_;
		_tmp5_ = pantheon_shell_appearance_desktop_preview_gnome_settings;
		_tmp6_ = g_settings_get_string (_tmp5_, "primary-color");
		_tmp7_ = _tmp6_;
		gdk_rgba_parse (&rgba, _tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, 500, 500);
		pixbuf = _tmp8_;
		_tmp9_ = pixbuf;
		_tmp10_ = rgba;
		gdk_pixbuf_fill (_tmp9_, pantheon_shell_solid_color_container_rgba_to_pixel (&_tmp10_));
		_tmp11_ = self->priv->picture;
		_tmp12_ = pixbuf;
		_tmp13_ = gdk_texture_new_for_pixbuf (_tmp12_);
		_tmp14_ = _tmp13_;
		gtk_picture_set_paintable (_tmp11_, (GdkPaintable*) _tmp14_);
		_g_object_unref0 (_tmp14_);
		_g_object_unref0 (pixbuf);
		return;
	}
	if (gtk_widget_has_css_class ((GtkWidget*) self, "dark")) {
		GFile* dark_file = NULL;
		GSettings* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		GFile* _tmp20_;
		_tmp15_ = pantheon_shell_appearance_desktop_preview_gnome_settings;
		_tmp16_ = g_settings_get_string (_tmp15_, "picture-uri-dark");
		_tmp17_ = _tmp16_;
		_tmp18_ = g_file_new_for_uri (_tmp17_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		dark_file = _tmp19_;
		_tmp20_ = dark_file;
		if (g_file_query_exists (_tmp20_, NULL)) {
			GtkPicture* _tmp21_;
			GFile* _tmp22_;
			_tmp21_ = self->priv->picture;
			_tmp22_ = dark_file;
			gtk_picture_set_file (_tmp21_, _tmp22_);
			_g_object_unref0 (dark_file);
			return;
		}
		_g_object_unref0 (dark_file);
	}
	_tmp23_ = self->priv->picture;
	_tmp24_ = pantheon_shell_appearance_desktop_preview_gnome_settings;
	_tmp25_ = g_settings_get_string (_tmp24_, "picture-uri");
	_tmp26_ = _tmp25_;
	_tmp27_ = g_file_new_for_uri (_tmp26_);
	_tmp28_ = _tmp27_;
	gtk_picture_set_file (_tmp23_, _tmp28_);
	_g_object_unref0 (_tmp28_);
	_g_free0 (_tmp26_);
}

static void
pantheon_shell_appearance_desktop_preview_base_init (PantheonShellAppearanceDesktopPreviewClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "desktop-preview");
}

static void
pantheon_shell_appearance_desktop_preview_class_init (PantheonShellAppearanceDesktopPreviewClass * klass,
                                                      gpointer klass_data)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	pantheon_shell_appearance_desktop_preview_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantheonShellAppearanceDesktopPreview_private_offset);
	G_OBJECT_CLASS (klass)->finalize = pantheon_shell_appearance_desktop_preview_finalize;
	gtk_widget_class_set_layout_manager_type (GTK_WIDGET_CLASS (klass), gtk_bin_layout_get_type ());
	_tmp0_ = g_settings_new ("io.elementary.desktop.background");
	_g_object_unref0 (pantheon_shell_appearance_desktop_preview_pantheon_settings);
	pantheon_shell_appearance_desktop_preview_pantheon_settings = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.desktop.background");
	_g_object_unref0 (pantheon_shell_appearance_desktop_preview_gnome_settings);
	pantheon_shell_appearance_desktop_preview_gnome_settings = _tmp1_;
}

static void
pantheon_shell_appearance_desktop_preview_instance_init (PantheonShellAppearanceDesktopPreview * self,
                                                         gpointer klass)
{
	self->priv = pantheon_shell_appearance_desktop_preview_get_instance_private (self);
}

static void
pantheon_shell_appearance_desktop_preview_finalize (GObject * obj)
{
	PantheonShellAppearanceDesktopPreview * self;
	GtkWidget* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_APPEARANCE_TYPE_DESKTOP_PREVIEW, PantheonShellAppearanceDesktopPreview);
	_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
	gtk_widget_unparent (_tmp0_);
	_g_object_unref0 (self->priv->picture);
	G_OBJECT_CLASS (pantheon_shell_appearance_desktop_preview_parent_class)->finalize (obj);
}

static GType
pantheon_shell_appearance_desktop_preview_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellAppearanceDesktopPreviewClass), (GBaseInitFunc) pantheon_shell_appearance_desktop_preview_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_appearance_desktop_preview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonShellAppearanceDesktopPreview), 0, (GInstanceInitFunc) pantheon_shell_appearance_desktop_preview_instance_init, NULL };
	GType pantheon_shell_appearance_desktop_preview_type_id;
	pantheon_shell_appearance_desktop_preview_type_id = g_type_register_static (gtk_widget_get_type (), "PantheonShellAppearanceDesktopPreview", &g_define_type_info, 0);
	PantheonShellAppearanceDesktopPreview_private_offset = g_type_add_instance_private (pantheon_shell_appearance_desktop_preview_type_id, sizeof (PantheonShellAppearanceDesktopPreviewPrivate));
	return pantheon_shell_appearance_desktop_preview_type_id;
}

static GType
pantheon_shell_appearance_desktop_preview_get_type (void)
{
	static volatile gsize pantheon_shell_appearance_desktop_preview_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_appearance_desktop_preview_type_id__once)) {
		GType pantheon_shell_appearance_desktop_preview_type_id;
		pantheon_shell_appearance_desktop_preview_type_id = pantheon_shell_appearance_desktop_preview_get_type_once ();
		g_once_init_leave (&pantheon_shell_appearance_desktop_preview_type_id__once, pantheon_shell_appearance_desktop_preview_type_id);
	}
	return pantheon_shell_appearance_desktop_preview_type_id__once;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		PantheonShellAppearance* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->pantheon_act);
		_g_object_unref0 (_data1_->to_time);
		_g_object_unref0 (_data1_->from_time);
		_g_object_unref0 (_data1_->schedule_disabled_radio);
		_g_object_unref0 (_data1_->prefer_dark_radio);
		_g_object_unref0 (_data1_->prefer_default_radio);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		PantheonShellAppearance* self;
		self = _data2_->_data1_->self;
		_g_object_unref0 (_data2_->settings);
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
_pantheon_shell_appearance____lambda35_ (GValue* value,
                                         GVariant* variant,
                                         void* user_data)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (value != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = g_variant_get_string (variant, NULL);
	g_value_set_boolean (value, g_strcmp0 (_tmp0_, "disabled") == 0);
	result = TRUE;
	return result;
}

static gboolean
__pantheon_shell_appearance____lambda35__gsettings_bind_get_mapping (GValue* value,
                                                                     GVariant* variant,
                                                                     void* user_data)
{
	gboolean result;
	result = _pantheon_shell_appearance____lambda35_ (value, variant, user_data);
	return result;
}

static GVariant*
_pantheon_shell_appearance____lambda36_ (GValue* value,
                                         const GVariantType* expected_type,
                                         void* user_data)
{
	GVariant* result;
	g_return_val_if_fail (value != NULL, NULL);
	g_return_val_if_fail (expected_type != NULL, NULL);
	if (g_value_get_boolean (value)) {
		GVariant* _tmp0_;
		_tmp0_ = g_variant_new ("s", "disabled", NULL);
		g_variant_ref_sink (_tmp0_);
		result = _tmp0_;
		return result;
	}
	result = NULL;
	return result;
}

static GVariant*
__pantheon_shell_appearance____lambda36__gsettings_bind_set_mapping (GValue* value,
                                                                     const GVariantType* expected_type,
                                                                     void* user_data)
{
	GVariant* result;
	result = _pantheon_shell_appearance____lambda36_ (value, expected_type, user_data);
	return result;
}

static gboolean
_pantheon_shell_appearance____lambda37_ (GValue* value,
                                         GVariant* variant,
                                         void* user_data)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (value != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = g_variant_get_string (variant, NULL);
	g_value_set_boolean (value, g_strcmp0 (_tmp0_, "manual") == 0);
	result = TRUE;
	return result;
}

static gboolean
__pantheon_shell_appearance____lambda37__gsettings_bind_get_mapping (GValue* value,
                                                                     GVariant* variant,
                                                                     void* user_data)
{
	gboolean result;
	result = _pantheon_shell_appearance____lambda37_ (value, variant, user_data);
	return result;
}

static GVariant*
_pantheon_shell_appearance____lambda38_ (GValue* value,
                                         const GVariantType* expected_type,
                                         void* user_data)
{
	GVariant* result;
	g_return_val_if_fail (value != NULL, NULL);
	g_return_val_if_fail (expected_type != NULL, NULL);
	if (g_value_get_boolean (value)) {
		GVariant* _tmp0_;
		_tmp0_ = g_variant_new ("s", "manual", NULL);
		g_variant_ref_sink (_tmp0_);
		result = _tmp0_;
		return result;
	}
	result = NULL;
	return result;
}

static GVariant*
__pantheon_shell_appearance____lambda38__gsettings_bind_set_mapping (GValue* value,
                                                                     const GVariantType* expected_type,
                                                                     void* user_data)
{
	GVariant* result;
	result = _pantheon_shell_appearance____lambda38_ (value, expected_type, user_data);
	return result;
}

static gboolean
_pantheon_shell_appearance____lambda39_ (GValue* value,
                                         GVariant* variant,
                                         void* user_data)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (value != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = g_variant_get_string (variant, NULL);
	g_value_set_boolean (value, g_strcmp0 (_tmp0_, "sunset-to-sunrise") == 0);
	result = TRUE;
	return result;
}

static gboolean
__pantheon_shell_appearance____lambda39__gsettings_bind_get_mapping (GValue* value,
                                                                     GVariant* variant,
                                                                     void* user_data)
{
	gboolean result;
	result = _pantheon_shell_appearance____lambda39_ (value, variant, user_data);
	return result;
}

static GVariant*
_pantheon_shell_appearance____lambda40_ (GValue* value,
                                         const GVariantType* expected_type,
                                         void* user_data)
{
	GVariant* result;
	g_return_val_if_fail (value != NULL, NULL);
	g_return_val_if_fail (expected_type != NULL, NULL);
	if (g_value_get_boolean (value)) {
		GVariant* _tmp0_;
		_tmp0_ = g_variant_new ("s", "sunset-to-sunrise", NULL);
		g_variant_ref_sink (_tmp0_);
		result = _tmp0_;
		return result;
	}
	result = NULL;
	return result;
}

static GVariant*
__pantheon_shell_appearance____lambda40__gsettings_bind_set_mapping (GValue* value,
                                                                     const GVariantType* expected_type,
                                                                     void* user_data)
{
	GVariant* result;
	result = _pantheon_shell_appearance____lambda40_ (value, expected_type, user_data);
	return result;
}

static void
_pantheon_shell_appearance____lambda41_ (Block2Data* _data2_)
{
	Block1Data* _data1_;
	PantheonShellAppearance* self;
	PantheonShellPantheonAccountsService* _tmp0_;
	GSettings* mutter_settings = NULL;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	_tmp0_ = _data1_->pantheon_act;
	pantheon_shell_pantheon_accounts_service_set_prefers_color_scheme (_tmp0_, (gint) GRANITE_SETTINGS_COLOR_SCHEME_NO_PREFERENCE);
	_tmp1_ = g_settings_new ("org.gnome.desktop.interface");
	mutter_settings = _tmp1_;
	_tmp2_ = mutter_settings;
	g_settings_set_enum (_tmp2_, "color-scheme", (gint) GRANITE_SETTINGS_COLOR_SCHEME_NO_PREFERENCE);
	_g_object_unref0 (mutter_settings);
}

static void
__pantheon_shell_appearance____lambda41__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                   gpointer self)
{
	_pantheon_shell_appearance____lambda41_ (self);
}

static void
_pantheon_shell_appearance____lambda42_ (Block2Data* _data2_)
{
	Block1Data* _data1_;
	PantheonShellAppearance* self;
	PantheonShellPantheonAccountsService* _tmp0_;
	GSettings* mutter_settings = NULL;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	_tmp0_ = _data1_->pantheon_act;
	pantheon_shell_pantheon_accounts_service_set_prefers_color_scheme (_tmp0_, (gint) GRANITE_SETTINGS_COLOR_SCHEME_DARK);
	_tmp1_ = g_settings_new ("org.gnome.desktop.interface");
	mutter_settings = _tmp1_;
	_tmp2_ = mutter_settings;
	g_settings_set_enum (_tmp2_, "color-scheme", (gint) GRANITE_SETTINGS_COLOR_SCHEME_DARK);
	_g_object_unref0 (mutter_settings);
}

static void
__pantheon_shell_appearance____lambda42__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                   gpointer self)
{
	_pantheon_shell_appearance____lambda42_ (self);
}

static void
_pantheon_shell_appearance____lambda43_ (Block2Data* _data2_)
{
	Block1Data* _data1_;
	PantheonShellAppearance* self;
	PantheonShellPantheonAccountsService* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	_tmp0_ = _data1_->pantheon_act;
	_tmp1_ = pantheon_shell_pantheon_accounts_service_get_prefers_color_scheme (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != ((gint) GRANITE_SETTINGS_COLOR_SCHEME_NO_PREFERENCE)) {
		GtkCheckButton* _tmp3_;
		_tmp3_ = _data1_->schedule_disabled_radio;
		gtk_check_button_set_active (_tmp3_, TRUE);
	}
}

static void
__pantheon_shell_appearance____lambda43__gtk_event_controller_focus_enter (GtkEventControllerFocus* _sender,
                                                                           gpointer self)
{
	_pantheon_shell_appearance____lambda43_ (self);
}

static void
_pantheon_shell_appearance____lambda44_ (Block2Data* _data2_)
{
	Block1Data* _data1_;
	PantheonShellAppearance* self;
	PantheonShellPantheonAccountsService* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	_tmp0_ = _data1_->pantheon_act;
	_tmp1_ = pantheon_shell_pantheon_accounts_service_get_prefers_color_scheme (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != ((gint) GRANITE_SETTINGS_COLOR_SCHEME_DARK)) {
		GtkCheckButton* _tmp3_;
		_tmp3_ = _data1_->schedule_disabled_radio;
		gtk_check_button_set_active (_tmp3_, TRUE);
	}
}

static void
__pantheon_shell_appearance____lambda44__gtk_event_controller_focus_enter (GtkEventControllerFocus* _sender,
                                                                           gpointer self)
{
	_pantheon_shell_appearance____lambda44_ (self);
}

static void
_pantheon_shell_appearance____lambda45_ (Block2Data* _data2_,
                                         GVariant* changed,
                                         gchar** invalid)
{
	Block1Data* _data1_;
	PantheonShellAppearance* self;
	GVariant* color_scheme = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_if_fail (changed != NULL);
	_tmp0_ = g_variant_type_new ("i");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed, "PrefersColorScheme", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	color_scheme = _tmp3_;
	_tmp4_ = color_scheme;
	if (_tmp4_ != NULL) {
		GVariant* _tmp5_;
		_tmp5_ = color_scheme;
		switch ((GraniteSettingsColorScheme) g_variant_get_int32 (_tmp5_)) {
			case GRANITE_SETTINGS_COLOR_SCHEME_DARK:
			{
				GtkCheckButton* _tmp6_;
				_tmp6_ = _data1_->prefer_dark_radio;
				gtk_check_button_set_active (_tmp6_, TRUE);
				break;
			}
			default:
			{
				GtkCheckButton* _tmp7_;
				_tmp7_ = _data1_->prefer_default_radio;
				gtk_check_button_set_active (_tmp7_, TRUE);
				break;
			}
		}
	}
	_g_variant_unref0 (color_scheme);
}

static void
__pantheon_shell_appearance____lambda45__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                            GVariant* changed_properties,
                                                                            gchar** invalidated_properties,
                                                                            gpointer self)
{
	_pantheon_shell_appearance____lambda45_ (self, changed_properties, invalidated_properties);
}

static void
_pantheon_shell_appearance____lambda46_ (Block2Data* _data2_)
{
	Block1Data* _data1_;
	PantheonShellAppearance* self;
	GSettings* _tmp0_;
	GraniteTimePicker* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	_tmp0_ = _data2_->settings;
	_tmp1_ = _data1_->from_time;
	_tmp2_ = granite_time_picker_get_time (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_double (_tmp0_, "prefer-dark-schedule-from", pantheon_shell_appearance_date_time_double (_tmp3_));
}

static void
__pantheon_shell_appearance____lambda46__granite_time_picker_time_changed (GraniteTimePicker* _sender,
                                                                           gpointer self)
{
	_pantheon_shell_appearance____lambda46_ (self);
}

static void
_pantheon_shell_appearance____lambda47_ (Block2Data* _data2_)
{
	Block1Data* _data1_;
	PantheonShellAppearance* self;
	GSettings* _tmp0_;
	GraniteTimePicker* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	_tmp0_ = _data2_->settings;
	_tmp1_ = _data1_->to_time;
	_tmp2_ = granite_time_picker_get_time (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_double (_tmp0_, "prefer-dark-schedule-to", pantheon_shell_appearance_date_time_double (_tmp3_));
}

static void
__pantheon_shell_appearance____lambda47__granite_time_picker_time_changed (GraniteTimePicker* _sender,
                                                                           gpointer self)
{
	_pantheon_shell_appearance____lambda47_ (self);
}

static GObject *
pantheon_shell_appearance_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PantheonShellAppearance * self;
	Block1Data* _data1_;
	PantheonShellAppearanceDesktopPreview* default_preview = NULL;
	PantheonShellAppearanceDesktopPreview* _tmp0_;
	GtkCheckButton* _tmp1_;
	GtkCheckButton* _tmp2_;
	GtkGrid* prefer_default_grid = NULL;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	PantheonShellAppearanceDesktopPreview* _tmp5_;
	GtkGrid* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkGrid* _tmp9_;
	GtkCheckButton* _tmp10_;
	PantheonShellAppearanceDesktopPreview* dark_preview = NULL;
	PantheonShellAppearanceDesktopPreview* _tmp11_;
	GtkCheckButton* _tmp12_;
	GtkCheckButton* _tmp13_;
	GtkCheckButton* _tmp14_ = NULL;
	GtkCheckButton* _tmp15_;
	GtkGrid* prefer_dark_grid = NULL;
	GtkGrid* _tmp16_;
	GtkGrid* _tmp17_;
	PantheonShellAppearanceDesktopPreview* _tmp18_;
	GtkGrid* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	GtkGrid* _tmp22_;
	GtkCheckButton* _tmp23_;
	GtkBox* prefer_style_box = NULL;
	GtkBox* _tmp24_;
	GtkBox* _tmp25_;
	GtkCheckButton* _tmp26_;
	GtkBox* _tmp27_;
	GtkCheckButton* _tmp28_;
	GtkSwitch* dim_switch = NULL;
	GtkSwitch* _tmp29_ = NULL;
	GraniteHeaderLabel* dim_label = NULL;
	GtkSwitch* _tmp30_;
	GtkWidget* _tmp31_;
	GraniteHeaderLabel* _tmp32_ = NULL;
	GtkBox* dim_box = NULL;
	GtkBox* _tmp33_ = NULL;
	GtkBox* _tmp34_;
	GraniteHeaderLabel* _tmp35_;
	GtkBox* _tmp36_;
	GtkSwitch* _tmp37_;
	GtkCheckButton* _tmp38_ = NULL;
	GtkCheckButton* schedule_sunset_radio = NULL;
	GtkCheckButton* _tmp39_;
	GtkCheckButton* _tmp40_;
	GtkCheckButton* _tmp41_ = NULL;
	GtkLabel* from_label = NULL;
	GtkLabel* _tmp42_;
	GraniteTimePicker* _tmp43_ = NULL;
	GtkLabel* to_label = NULL;
	GtkLabel* _tmp44_;
	GraniteTimePicker* _tmp45_ = NULL;
	GtkBox* schedule_manual_box = NULL;
	GtkBox* _tmp46_;
	GtkBox* _tmp47_;
	GtkLabel* _tmp48_;
	GtkBox* _tmp49_;
	GraniteTimePicker* _tmp50_;
	GtkBox* _tmp51_;
	GtkLabel* _tmp52_;
	GtkBox* _tmp53_;
	GraniteTimePicker* _tmp54_;
	GtkCheckButton* schedule_manual_radio = NULL;
	GtkBox* _tmp55_;
	GtkWidget* _tmp56_;
	GtkCheckButton* _tmp57_;
	GtkCheckButton* _tmp58_;
	GtkCheckButton* _tmp59_ = NULL;
	GtkBox* schedule_box = NULL;
	GtkBox* _tmp60_ = NULL;
	GtkBox* _tmp61_;
	GtkCheckButton* _tmp62_;
	GtkBox* _tmp63_;
	GtkCheckButton* _tmp64_;
	GtkBox* _tmp65_;
	GtkCheckButton* _tmp66_;
	GraniteHeaderLabel* schedule_label = NULL;
	GtkBox* _tmp67_;
	GtkWidget* _tmp68_;
	GraniteHeaderLabel* _tmp69_ = NULL;
	gchar* user_path = NULL;
	const gchar* _tmp78_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp83_ = NULL;
	PantheonShellPantheonAccountsService* _tmp84_;
	GVariant* _tmp85_;
	GVariant* _tmp86_;
	gboolean _tmp87_;
	GSettings* interface_settings = NULL;
	GSettings* _tmp133_;
	gchar* current_stylesheet = NULL;
	GSettings* _tmp134_;
	gchar* _tmp135_;
	const gchar* _tmp136_;
	const gchar* _tmp137_;
	GtkSwitch* animations_switch = NULL;
	GtkSwitch* _tmp211_ = NULL;
	GraniteHeaderLabel* animations_label = NULL;
	GtkSwitch* _tmp212_;
	GtkWidget* _tmp213_;
	gchar* _tmp214_;
	GraniteHeaderLabel* _tmp215_ = NULL;
	GtkBox* animations_box = NULL;
	GtkBox* _tmp216_ = NULL;
	GtkBox* _tmp217_;
	GraniteHeaderLabel* _tmp218_;
	GtkBox* _tmp219_;
	GtkSwitch* _tmp220_;
	GtkSwitch* scrollbar_switch = NULL;
	GtkSwitch* _tmp221_ = NULL;
	GraniteHeaderLabel* scrollbar_label = NULL;
	GtkSwitch* _tmp222_;
	GtkWidget* _tmp223_;
	gchar* _tmp224_;
	GraniteHeaderLabel* _tmp225_ = NULL;
	GtkBox* scrollbar_box = NULL;
	GtkBox* _tmp226_ = NULL;
	GtkBox* _tmp227_;
	GraniteHeaderLabel* _tmp228_;
	GtkBox* _tmp229_;
	GtkSwitch* _tmp230_;
	GtkGrid* _tmp231_;
	GtkBox* _tmp232_;
	GtkGrid* _tmp233_;
	GtkBox* _tmp234_;
	GtkGrid* _tmp235_;
	GSettings* animations_settings = NULL;
	GSettings* _tmp236_;
	GSettings* _tmp237_;
	GtkSwitch* _tmp238_;
	GSettings* _tmp239_;
	GtkSwitch* _tmp240_;
	GSettings* background_settings = NULL;
	GSettings* _tmp241_;
	GSettings* _tmp242_;
	GtkSwitch* _tmp243_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (pantheon_shell_appearance_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_TYPE_APPEARANCE, PantheonShellAppearance);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = pantheon_shell_appearance_desktop_preview_new ("default");
	g_object_ref_sink (_tmp0_);
	default_preview = _tmp0_;
	_tmp1_ = (GtkCheckButton*) gtk_check_button_new ();
	g_object_ref_sink (_tmp1_);
	_data1_->prefer_default_radio = _tmp1_;
	_tmp2_ = _data1_->prefer_default_radio;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, "image-button");
	_tmp3_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp3_);
	prefer_default_grid = _tmp3_;
	_tmp4_ = prefer_default_grid;
	_tmp5_ = default_preview;
	gtk_grid_attach (_tmp4_, (GtkWidget*) _tmp5_, 0, 0, 1, 1);
	_tmp6_ = prefer_default_grid;
	_tmp7_ = (GtkLabel*) gtk_label_new (_ ("Default"));
	g_object_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	gtk_grid_attach (_tmp6_, (GtkWidget*) _tmp8_, 0, 1, 1, 1);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = prefer_default_grid;
	_tmp10_ = _data1_->prefer_default_radio;
	gtk_widget_set_parent ((GtkWidget*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = pantheon_shell_appearance_desktop_preview_new ("dark");
	g_object_ref_sink (_tmp11_);
	dark_preview = _tmp11_;
	_tmp12_ = _data1_->prefer_default_radio;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_tmp14_ = (GtkCheckButton*) gtk_check_button_new ();
	gtk_check_button_set_group (_tmp14_, _tmp13_);
	_g_object_unref0 (_tmp13_);
	g_object_ref_sink (_tmp14_);
	_data1_->prefer_dark_radio = _tmp14_;
	_tmp15_ = _data1_->prefer_dark_radio;
	gtk_widget_add_css_class ((GtkWidget*) _tmp15_, "image-button");
	_tmp16_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp16_);
	prefer_dark_grid = _tmp16_;
	_tmp17_ = prefer_dark_grid;
	_tmp18_ = dark_preview;
	gtk_grid_attach (_tmp17_, (GtkWidget*) _tmp18_, 0, 0, 1, 1);
	_tmp19_ = prefer_dark_grid;
	_tmp20_ = (GtkLabel*) gtk_label_new (_ ("Dark"));
	g_object_ref_sink (_tmp20_);
	_tmp21_ = _tmp20_;
	gtk_grid_attach (_tmp19_, (GtkWidget*) _tmp21_, 0, 1, 1, 1);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = prefer_dark_grid;
	_tmp23_ = _data1_->prefer_dark_radio;
	gtk_widget_set_parent ((GtkWidget*) _tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp24_);
	prefer_style_box = _tmp24_;
	_tmp25_ = prefer_style_box;
	_tmp26_ = _data1_->prefer_default_radio;
	gtk_box_append (_tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = prefer_style_box;
	_tmp28_ = _data1_->prefer_dark_radio;
	gtk_box_append (_tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp29_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp29_);
	dim_switch = _tmp29_;
	_tmp30_ = dim_switch;
	_tmp31_ = _g_object_ref0 ((GtkWidget*) _tmp30_);
	_tmp32_ = granite_header_label_new (_ ("Dim Wallpaper With Dark Style"));
	gtk_widget_set_hexpand ((GtkWidget*) _tmp32_, TRUE);
	granite_header_label_set_mnemonic_widget (_tmp32_, _tmp31_);
	_g_object_unref0 (_tmp31_);
	g_object_ref_sink (_tmp32_);
	dim_label = _tmp32_;
	_tmp33_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp33_, 18);
	g_object_ref_sink (_tmp33_);
	dim_box = _tmp33_;
	_tmp34_ = dim_box;
	_tmp35_ = dim_label;
	gtk_box_append (_tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = dim_box;
	_tmp37_ = dim_switch;
	gtk_box_append (_tmp36_, (GtkWidget*) _tmp37_);
	_tmp38_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Disabled"));
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp38_, 3);
	g_object_ref_sink (_tmp38_);
	_data1_->schedule_disabled_radio = _tmp38_;
	_tmp39_ = _data1_->schedule_disabled_radio;
	_tmp40_ = _g_object_ref0 (_tmp39_);
	_tmp41_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Sunset to Sunrise"));
	gtk_check_button_set_group (_tmp41_, _tmp40_);
	_g_object_unref0 (_tmp40_);
	g_object_ref_sink (_tmp41_);
	schedule_sunset_radio = _tmp41_;
	_tmp42_ = (GtkLabel*) gtk_label_new (_ ("From:"));
	g_object_ref_sink (_tmp42_);
	from_label = _tmp42_;
	_tmp43_ = granite_time_picker_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp43_, TRUE);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp43_, 6);
	g_object_ref_sink (_tmp43_);
	_data1_->from_time = _tmp43_;
	_tmp44_ = (GtkLabel*) gtk_label_new (_ ("To:"));
	g_object_ref_sink (_tmp44_);
	to_label = _tmp44_;
	_tmp45_ = granite_time_picker_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp45_, TRUE);
	g_object_ref_sink (_tmp45_);
	_data1_->to_time = _tmp45_;
	_tmp46_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp46_);
	schedule_manual_box = _tmp46_;
	_tmp47_ = schedule_manual_box;
	_tmp48_ = from_label;
	gtk_box_append (_tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = schedule_manual_box;
	_tmp50_ = _data1_->from_time;
	gtk_box_append (_tmp49_, (GtkWidget*) _tmp50_);
	_tmp51_ = schedule_manual_box;
	_tmp52_ = to_label;
	gtk_box_append (_tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = schedule_manual_box;
	_tmp54_ = _data1_->to_time;
	gtk_box_append (_tmp53_, (GtkWidget*) _tmp54_);
	_tmp55_ = schedule_manual_box;
	_tmp56_ = _g_object_ref0 ((GtkWidget*) _tmp55_);
	_tmp57_ = _data1_->schedule_disabled_radio;
	_tmp58_ = _g_object_ref0 (_tmp57_);
	_tmp59_ = (GtkCheckButton*) gtk_check_button_new ();
	gtk_check_button_set_child (_tmp59_, _tmp56_);
	_g_object_unref0 (_tmp56_);
	gtk_check_button_set_group (_tmp59_, _tmp58_);
	_g_object_unref0 (_tmp58_);
	g_object_ref_sink (_tmp59_);
	schedule_manual_radio = _tmp59_;
	_tmp60_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
	g_object_set ((GtkAccessible*) _tmp60_, "accessible-role", GTK_ACCESSIBLE_ROLE_LIST, NULL);
	g_object_ref_sink (_tmp60_);
	schedule_box = _tmp60_;
	_tmp61_ = schedule_box;
	_tmp62_ = _data1_->schedule_disabled_radio;
	gtk_box_append (_tmp61_, (GtkWidget*) _tmp62_);
	_tmp63_ = schedule_box;
	_tmp64_ = schedule_sunset_radio;
	gtk_box_append (_tmp63_, (GtkWidget*) _tmp64_);
	_tmp65_ = schedule_box;
	_tmp66_ = schedule_manual_radio;
	gtk_box_append (_tmp65_, (GtkWidget*) _tmp66_);
	_tmp67_ = schedule_box;
	_tmp68_ = _g_object_ref0 ((GtkWidget*) _tmp67_);
	_tmp69_ = granite_header_label_new (_ ("Schedule"));
	granite_header_label_set_mnemonic_widget (_tmp69_, _tmp68_);
	_g_object_unref0 (_tmp68_);
	g_object_ref_sink (_tmp69_);
	schedule_label = _tmp69_;
	_data1_->pantheon_act = NULL;
	user_path = NULL;
	{
		PantheonShellFDOAccounts* accounts_service = NULL;
		PantheonShellFDOAccounts* _tmp70_;
		gchar* _tmp71_ = NULL;
		PantheonShellFDOAccounts* _tmp72_;
		const gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		_tmp70_ = (PantheonShellFDOAccounts*) g_initable_new (PANTHEON_SHELL_FDO_TYPE_ACCOUNTS_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/Accounts", "g-interface-name", "org.freedesktop.Accounts", NULL);
		accounts_service = (PantheonShellFDOAccounts*) _tmp70_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp72_ = accounts_service;
		_tmp73_ = g_get_user_name ();
		_tmp74_ = pantheon_shell_fdo_accounts_find_user_by_name (_tmp72_, _tmp73_, &_inner_error0_);
		_tmp71_ = _tmp74_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (accounts_service);
			goto __catch0_g_error;
		}
		_tmp75_ = _tmp71_;
		_tmp71_ = NULL;
		_g_free0 (user_path);
		user_path = _tmp75_;
		_g_free0 (_tmp71_);
		_g_object_unref0 (accounts_service);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp76_;
		const gchar* _tmp77_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp76_ = e;
		_tmp77_ = _tmp76_->message;
		g_critical ("Appearance.vala:175: %s", _tmp77_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (user_path);
		_g_object_unref0 (schedule_label);
		_g_object_unref0 (schedule_box);
		_g_object_unref0 (schedule_manual_radio);
		_g_object_unref0 (schedule_manual_box);
		_g_object_unref0 (to_label);
		_g_object_unref0 (from_label);
		_g_object_unref0 (schedule_sunset_radio);
		_g_object_unref0 (dim_box);
		_g_object_unref0 (dim_label);
		_g_object_unref0 (dim_switch);
		_g_object_unref0 (prefer_style_box);
		_g_object_unref0 (prefer_dark_grid);
		_g_object_unref0 (dark_preview);
		_g_object_unref0 (prefer_default_grid);
		_g_object_unref0 (default_preview);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp78_ = user_path;
	if (_tmp78_ != NULL) {
		{
			PantheonShellPantheonAccountsService* _tmp79_ = NULL;
			const gchar* _tmp80_;
			PantheonShellPantheonAccountsService* _tmp81_;
			PantheonShellPantheonAccountsService* _tmp82_;
			_tmp80_ = user_path;
			_tmp81_ = (PantheonShellPantheonAccountsService*) g_initable_new (PANTHEON_SHELL_PANTHEON_TYPE_ACCOUNTS_SERVICE_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp80_, "g-interface-name", "io.elementary.pantheon.AccountsService", NULL);
			_tmp79_ = (PantheonShellPantheonAccountsService*) _tmp81_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp82_ = _tmp79_;
			_tmp79_ = NULL;
			_g_object_unref0 (_data1_->pantheon_act);
			_data1_->pantheon_act = _tmp82_;
			_g_object_unref0 (_tmp79_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
			g_warning ("Appearance.vala:187: Unable to get AccountsService proxy, color scheme" \
" preference may be incorrect");
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (user_path);
			_g_object_unref0 (schedule_label);
			_g_object_unref0 (schedule_box);
			_g_object_unref0 (schedule_manual_radio);
			_g_object_unref0 (schedule_manual_box);
			_g_object_unref0 (to_label);
			_g_object_unref0 (from_label);
			_g_object_unref0 (schedule_sunset_radio);
			_g_object_unref0 (dim_box);
			_g_object_unref0 (dim_label);
			_g_object_unref0 (dim_switch);
			_g_object_unref0 (prefer_style_box);
			_g_object_unref0 (prefer_dark_grid);
			_g_object_unref0 (dark_preview);
			_g_object_unref0 (prefer_default_grid);
			_g_object_unref0 (default_preview);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
	}
	_tmp83_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_row_spacing (_tmp83_, 6);
	g_object_ref_sink (_tmp83_);
	grid = _tmp83_;
	_tmp84_ = _data1_->pantheon_act;
	_tmp85_ = g_dbus_proxy_get_cached_property (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, g_dbus_proxy_get_type (), GDBusProxy), "PrefersColorScheme");
	_tmp86_ = _tmp85_;
	_tmp87_ = _tmp86_ != NULL;
	_g_variant_unref0 (_tmp86_);
	if (_tmp87_) {
		Block2Data* _data2_;
		GtkGrid* _tmp88_;
		GtkBox* _tmp89_;
		GtkGrid* _tmp90_;
		GtkBox* _tmp91_;
		GtkGrid* _tmp92_;
		GraniteHeaderLabel* _tmp93_;
		GtkGrid* _tmp94_;
		GtkBox* _tmp95_;
		PantheonShellPantheonAccountsService* _tmp96_;
		gint _tmp97_;
		gint _tmp98_;
		GSettings* _tmp101_;
		GSettings* _tmp102_;
		GtkCheckButton* _tmp103_;
		GSettings* _tmp104_;
		GtkCheckButton* _tmp105_;
		GSettings* _tmp106_;
		GtkCheckButton* _tmp107_;
		GtkCheckButton* _tmp108_;
		GtkCheckButton* _tmp109_;
		GtkEventControllerFocus* prefer_default_radio_controller = NULL;
		GtkEventControllerFocus* _tmp110_;
		GtkCheckButton* _tmp111_;
		GtkEventControllerFocus* _tmp112_;
		GtkEventController* _tmp113_;
		GtkEventControllerFocus* _tmp114_;
		GtkEventControllerFocus* prefer_dark_radio_controller = NULL;
		GtkEventControllerFocus* _tmp115_;
		GtkCheckButton* _tmp116_;
		GtkEventControllerFocus* _tmp117_;
		GtkEventController* _tmp118_;
		GtkEventControllerFocus* _tmp119_;
		PantheonShellPantheonAccountsService* _tmp120_;
		GraniteTimePicker* _tmp121_;
		GSettings* _tmp122_;
		GDateTime* _tmp123_;
		GDateTime* _tmp124_;
		GraniteTimePicker* _tmp125_;
		GraniteTimePicker* _tmp126_;
		GSettings* _tmp127_;
		GDateTime* _tmp128_;
		GDateTime* _tmp129_;
		GraniteTimePicker* _tmp130_;
		GtkCheckButton* _tmp131_;
		GtkBox* _tmp132_;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_data2_->_data1_ = block1_data_ref (_data1_);
		_tmp88_ = grid;
		_tmp89_ = prefer_style_box;
		gtk_grid_attach (_tmp88_, (GtkWidget*) _tmp89_, 0, 2, 2, 1);
		_tmp90_ = grid;
		_tmp91_ = dim_box;
		gtk_grid_attach (_tmp90_, (GtkWidget*) _tmp91_, 0, 3, 2, 1);
		_tmp92_ = grid;
		_tmp93_ = schedule_label;
		gtk_grid_attach (_tmp92_, (GtkWidget*) _tmp93_, 0, 4, 2, 1);
		_tmp94_ = grid;
		_tmp95_ = schedule_box;
		gtk_grid_attach (_tmp94_, (GtkWidget*) _tmp95_, 0, 5, 2, 1);
		_tmp96_ = _data1_->pantheon_act;
		_tmp97_ = pantheon_shell_pantheon_accounts_service_get_prefers_color_scheme (_tmp96_);
		_tmp98_ = _tmp97_;
		switch (_tmp98_) {
			case GRANITE_SETTINGS_COLOR_SCHEME_DARK:
			{
				GtkCheckButton* _tmp99_;
				_tmp99_ = _data1_->prefer_dark_radio;
				gtk_check_button_set_active (_tmp99_, TRUE);
				break;
			}
			default:
			{
				GtkCheckButton* _tmp100_;
				_tmp100_ = _data1_->prefer_default_radio;
				gtk_check_button_set_active (_tmp100_, TRUE);
				break;
			}
		}
		_tmp101_ = g_settings_new ("io.elementary.settings-daemon.prefers-color-scheme");
		_data2_->settings = _tmp101_;
		_tmp102_ = _data2_->settings;
		_tmp103_ = _data1_->schedule_disabled_radio;
		g_settings_bind_with_mapping (_tmp102_, "prefer-dark-schedule", (GObject*) _tmp103_, "active", G_SETTINGS_BIND_DEFAULT, __pantheon_shell_appearance____lambda35__gsettings_bind_get_mapping, __pantheon_shell_appearance____lambda36__gsettings_bind_set_mapping, NULL, NULL);
		_tmp104_ = _data2_->settings;
		_tmp105_ = schedule_manual_radio;
		g_settings_bind_with_mapping (_tmp104_, "prefer-dark-schedule", (GObject*) _tmp105_, "active", G_SETTINGS_BIND_DEFAULT, __pantheon_shell_appearance____lambda37__gsettings_bind_get_mapping, __pantheon_shell_appearance____lambda38__gsettings_bind_set_mapping, NULL, NULL);
		_tmp106_ = _data2_->settings;
		_tmp107_ = schedule_sunset_radio;
		g_settings_bind_with_mapping (_tmp106_, "prefer-dark-schedule", (GObject*) _tmp107_, "active", G_SETTINGS_BIND_DEFAULT, __pantheon_shell_appearance____lambda39__gsettings_bind_get_mapping, __pantheon_shell_appearance____lambda40__gsettings_bind_set_mapping, NULL, NULL);
		_tmp108_ = _data1_->prefer_default_radio;
		g_signal_connect_data (_tmp108_, "toggled", (GCallback) __pantheon_shell_appearance____lambda41__gtk_check_button_toggled, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp109_ = _data1_->prefer_dark_radio;
		g_signal_connect_data (_tmp109_, "toggled", (GCallback) __pantheon_shell_appearance____lambda42__gtk_check_button_toggled, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp110_ = (GtkEventControllerFocus*) gtk_event_controller_focus_new ();
		prefer_default_radio_controller = _tmp110_;
		_tmp111_ = _data1_->prefer_default_radio;
		_tmp112_ = prefer_default_radio_controller;
		_tmp113_ = _g_object_ref0 ((GtkEventController*) _tmp112_);
		gtk_widget_add_controller ((GtkWidget*) _tmp111_, _tmp113_);
		_tmp114_ = prefer_default_radio_controller;
		g_signal_connect_data (_tmp114_, "enter", (GCallback) __pantheon_shell_appearance____lambda43__gtk_event_controller_focus_enter, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp115_ = (GtkEventControllerFocus*) gtk_event_controller_focus_new ();
		prefer_dark_radio_controller = _tmp115_;
		_tmp116_ = _data1_->prefer_dark_radio;
		_tmp117_ = prefer_dark_radio_controller;
		_tmp118_ = _g_object_ref0 ((GtkEventController*) _tmp117_);
		gtk_widget_add_controller ((GtkWidget*) _tmp116_, _tmp118_);
		_tmp119_ = prefer_dark_radio_controller;
		g_signal_connect_data (_tmp119_, "enter", (GCallback) __pantheon_shell_appearance____lambda44__gtk_event_controller_focus_enter, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp120_ = _data1_->pantheon_act;
		g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) __pantheon_shell_appearance____lambda45__g_dbus_proxy_g_properties_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp121_ = _data1_->from_time;
		_tmp122_ = _data2_->settings;
		_tmp123_ = pantheon_shell_appearance_double_date_time (g_settings_get_double (_tmp122_, "prefer-dark-schedule-from"));
		_tmp124_ = _tmp123_;
		granite_time_picker_set_time (_tmp121_, _tmp124_);
		_g_date_time_unref0 (_tmp124_);
		_tmp125_ = _data1_->from_time;
		g_signal_connect_data (_tmp125_, "time-changed", (GCallback) __pantheon_shell_appearance____lambda46__granite_time_picker_time_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp126_ = _data1_->to_time;
		_tmp127_ = _data2_->settings;
		_tmp128_ = pantheon_shell_appearance_double_date_time (g_settings_get_double (_tmp127_, "prefer-dark-schedule-to"));
		_tmp129_ = _tmp128_;
		granite_time_picker_set_time (_tmp126_, _tmp129_);
		_g_date_time_unref0 (_tmp129_);
		_tmp130_ = _data1_->to_time;
		g_signal_connect_data (_tmp130_, "time-changed", (GCallback) __pantheon_shell_appearance____lambda47__granite_time_picker_time_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp131_ = schedule_manual_radio;
		_tmp132_ = schedule_manual_box;
		g_object_bind_property_with_closures ((GObject*) _tmp131_, "active", (GObject*) _tmp132_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_g_object_unref0 (prefer_dark_radio_controller);
		_g_object_unref0 (prefer_default_radio_controller);
		block2_data_unref (_data2_);
		_data2_ = NULL;
	}
	_tmp133_ = g_settings_new (PANTHEON_SHELL_APPEARANCE_INTERFACE_SCHEMA);
	interface_settings = _tmp133_;
	_tmp134_ = interface_settings;
	_tmp135_ = g_settings_get_string (_tmp134_, PANTHEON_SHELL_APPEARANCE_STYLESHEET_KEY);
	current_stylesheet = _tmp135_;
	_tmp136_ = current_stylesheet;
	g_debug ("Appearance.vala:324: Current stylesheet: %s", _tmp136_);
	_tmp137_ = current_stylesheet;
	if (g_str_has_prefix (_tmp137_, PANTHEON_SHELL_APPEARANCE_STYLESHEET_PREFIX)) {
		PantheonShellAppearancePrefersAccentColorButton* blueberry_button = NULL;
		PantheonShellPantheonAccountsService* _tmp138_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp139_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp140_;
		PantheonShellAppearancePrefersAccentColorButton* mint_button = NULL;
		PantheonShellPantheonAccountsService* _tmp141_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp142_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp143_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp144_;
		PantheonShellAppearancePrefersAccentColorButton* lime_button = NULL;
		PantheonShellPantheonAccountsService* _tmp145_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp146_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp147_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp148_;
		PantheonShellAppearancePrefersAccentColorButton* banana_button = NULL;
		PantheonShellPantheonAccountsService* _tmp149_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp150_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp151_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp152_;
		PantheonShellAppearancePrefersAccentColorButton* orange_button = NULL;
		PantheonShellPantheonAccountsService* _tmp153_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp154_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp155_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp156_;
		PantheonShellAppearancePrefersAccentColorButton* strawberry_button = NULL;
		PantheonShellPantheonAccountsService* _tmp157_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp158_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp159_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp160_;
		PantheonShellAppearancePrefersAccentColorButton* bubblegum_button = NULL;
		PantheonShellPantheonAccountsService* _tmp161_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp162_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp163_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp164_;
		PantheonShellAppearancePrefersAccentColorButton* grape_button = NULL;
		PantheonShellPantheonAccountsService* _tmp165_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp166_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp167_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp168_;
		PantheonShellAppearancePrefersAccentColorButton* cocoa_button = NULL;
		PantheonShellPantheonAccountsService* _tmp169_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp170_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp171_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp172_;
		PantheonShellAppearancePrefersAccentColorButton* slate_button = NULL;
		PantheonShellPantheonAccountsService* _tmp173_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp174_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp175_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp176_;
		PantheonShellAppearancePrefersAccentColorButton* auto_button = NULL;
		PantheonShellPantheonAccountsService* _tmp177_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp178_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp179_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp180_;
		GtkBox* accent_box = NULL;
		GtkBox* _tmp181_ = NULL;
		GtkBox* _tmp182_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp183_;
		GtkBox* _tmp184_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp185_;
		GtkBox* _tmp186_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp187_;
		GtkBox* _tmp188_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp189_;
		GtkBox* _tmp190_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp191_;
		GtkBox* _tmp192_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp193_;
		GtkBox* _tmp194_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp195_;
		GtkBox* _tmp196_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp197_;
		GtkBox* _tmp198_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp199_;
		GtkBox* _tmp200_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp201_;
		GtkBox* _tmp202_;
		PantheonShellAppearancePrefersAccentColorButton* _tmp203_;
		GraniteHeaderLabel* accent_label = NULL;
		GtkBox* _tmp204_;
		GtkWidget* _tmp205_;
		GraniteHeaderLabel* _tmp206_ = NULL;
		GtkGrid* _tmp207_;
		GraniteHeaderLabel* _tmp208_;
		GtkGrid* _tmp209_;
		GtkBox* _tmp210_;
		_tmp138_ = _data1_->pantheon_act;
		_tmp139_ = pantheon_shell_appearance_prefers_accent_color_button_new (_tmp138_, PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BLUE, NULL);
		g_object_ref_sink (_tmp139_);
		blueberry_button = _tmp139_;
		_tmp140_ = blueberry_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp140_, _ ("Blueberry"));
		_tmp141_ = _data1_->pantheon_act;
		_tmp142_ = blueberry_button;
		_tmp143_ = pantheon_shell_appearance_prefers_accent_color_button_new (_tmp141_, PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_MINT, (GtkCheckButton*) _tmp142_);
		g_object_ref_sink (_tmp143_);
		mint_button = _tmp143_;
		_tmp144_ = mint_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp144_, _ ("Mint"));
		_tmp145_ = _data1_->pantheon_act;
		_tmp146_ = blueberry_button;
		_tmp147_ = pantheon_shell_appearance_prefers_accent_color_button_new (_tmp145_, PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GREEN, (GtkCheckButton*) _tmp146_);
		g_object_ref_sink (_tmp147_);
		lime_button = _tmp147_;
		_tmp148_ = lime_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp148_, _ ("Lime"));
		_tmp149_ = _data1_->pantheon_act;
		_tmp150_ = blueberry_button;
		_tmp151_ = pantheon_shell_appearance_prefers_accent_color_button_new (_tmp149_, PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_YELLOW, (GtkCheckButton*) _tmp150_);
		g_object_ref_sink (_tmp151_);
		banana_button = _tmp151_;
		_tmp152_ = banana_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp152_, _ ("Banana"));
		_tmp153_ = _data1_->pantheon_act;
		_tmp154_ = blueberry_button;
		_tmp155_ = pantheon_shell_appearance_prefers_accent_color_button_new (_tmp153_, PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_ORANGE, (GtkCheckButton*) _tmp154_);
		g_object_ref_sink (_tmp155_);
		orange_button = _tmp155_;
		_tmp156_ = orange_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp156_, _ ("Orange"));
		_tmp157_ = _data1_->pantheon_act;
		_tmp158_ = blueberry_button;
		_tmp159_ = pantheon_shell_appearance_prefers_accent_color_button_new (_tmp157_, PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_RED, (GtkCheckButton*) _tmp158_);
		g_object_ref_sink (_tmp159_);
		strawberry_button = _tmp159_;
		_tmp160_ = strawberry_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp160_, _ ("Strawberry"));
		_tmp161_ = _data1_->pantheon_act;
		_tmp162_ = blueberry_button;
		_tmp163_ = pantheon_shell_appearance_prefers_accent_color_button_new (_tmp161_, PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PINK, (GtkCheckButton*) _tmp162_);
		g_object_ref_sink (_tmp163_);
		bubblegum_button = _tmp163_;
		_tmp164_ = bubblegum_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp164_, _ ("Bubblegum"));
		_tmp165_ = _data1_->pantheon_act;
		_tmp166_ = blueberry_button;
		_tmp167_ = pantheon_shell_appearance_prefers_accent_color_button_new (_tmp165_, PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PURPLE, (GtkCheckButton*) _tmp166_);
		g_object_ref_sink (_tmp167_);
		grape_button = _tmp167_;
		_tmp168_ = grape_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp168_, _ ("Grape"));
		_tmp169_ = _data1_->pantheon_act;
		_tmp170_ = blueberry_button;
		_tmp171_ = pantheon_shell_appearance_prefers_accent_color_button_new (_tmp169_, PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BROWN, (GtkCheckButton*) _tmp170_);
		g_object_ref_sink (_tmp171_);
		cocoa_button = _tmp171_;
		_tmp172_ = cocoa_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp172_, _ ("Cocoa"));
		_tmp173_ = _data1_->pantheon_act;
		_tmp174_ = blueberry_button;
		_tmp175_ = pantheon_shell_appearance_prefers_accent_color_button_new (_tmp173_, PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GRAY, (GtkCheckButton*) _tmp174_);
		g_object_ref_sink (_tmp175_);
		slate_button = _tmp175_;
		_tmp176_ = slate_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp176_, _ ("Slate"));
		_tmp177_ = _data1_->pantheon_act;
		_tmp178_ = blueberry_button;
		_tmp179_ = pantheon_shell_appearance_prefers_accent_color_button_new (_tmp177_, PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_NO_PREFERENCE, (GtkCheckButton*) _tmp178_);
		g_object_ref_sink (_tmp179_);
		auto_button = _tmp179_;
		_tmp180_ = auto_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp180_, _ ("Automatic based on wallpaper"));
		_tmp181_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
		g_object_set ((GtkAccessible*) _tmp181_, "accessible-role", GTK_ACCESSIBLE_ROLE_LIST, NULL);
		g_object_ref_sink (_tmp181_);
		accent_box = _tmp181_;
		_tmp182_ = accent_box;
		_tmp183_ = blueberry_button;
		gtk_box_append (_tmp182_, (GtkWidget*) _tmp183_);
		_tmp184_ = accent_box;
		_tmp185_ = mint_button;
		gtk_box_append (_tmp184_, (GtkWidget*) _tmp185_);
		_tmp186_ = accent_box;
		_tmp187_ = lime_button;
		gtk_box_append (_tmp186_, (GtkWidget*) _tmp187_);
		_tmp188_ = accent_box;
		_tmp189_ = banana_button;
		gtk_box_append (_tmp188_, (GtkWidget*) _tmp189_);
		_tmp190_ = accent_box;
		_tmp191_ = orange_button;
		gtk_box_append (_tmp190_, (GtkWidget*) _tmp191_);
		_tmp192_ = accent_box;
		_tmp193_ = strawberry_button;
		gtk_box_append (_tmp192_, (GtkWidget*) _tmp193_);
		_tmp194_ = accent_box;
		_tmp195_ = bubblegum_button;
		gtk_box_append (_tmp194_, (GtkWidget*) _tmp195_);
		_tmp196_ = accent_box;
		_tmp197_ = grape_button;
		gtk_box_append (_tmp196_, (GtkWidget*) _tmp197_);
		_tmp198_ = accent_box;
		_tmp199_ = cocoa_button;
		gtk_box_append (_tmp198_, (GtkWidget*) _tmp199_);
		_tmp200_ = accent_box;
		_tmp201_ = slate_button;
		gtk_box_append (_tmp200_, (GtkWidget*) _tmp201_);
		_tmp202_ = accent_box;
		_tmp203_ = auto_button;
		gtk_box_append (_tmp202_, (GtkWidget*) _tmp203_);
		_tmp204_ = accent_box;
		_tmp205_ = _g_object_ref0 ((GtkWidget*) _tmp204_);
		_tmp206_ = granite_header_label_new (_ ("Accent Color"));
		gtk_widget_set_margin_top ((GtkWidget*) _tmp206_, 18);
		granite_header_label_set_mnemonic_widget (_tmp206_, _tmp205_);
		_g_object_unref0 (_tmp205_);
		g_object_ref_sink (_tmp206_);
		accent_label = _tmp206_;
		_tmp207_ = grid;
		_tmp208_ = accent_label;
		gtk_grid_attach (_tmp207_, (GtkWidget*) _tmp208_, 0, 8, 2, 1);
		_tmp209_ = grid;
		_tmp210_ = accent_box;
		gtk_grid_attach (_tmp209_, (GtkWidget*) _tmp210_, 0, 9, 2, 1);
		_g_object_unref0 (accent_label);
		_g_object_unref0 (accent_box);
		_g_object_unref0 (auto_button);
		_g_object_unref0 (slate_button);
		_g_object_unref0 (cocoa_button);
		_g_object_unref0 (grape_button);
		_g_object_unref0 (bubblegum_button);
		_g_object_unref0 (strawberry_button);
		_g_object_unref0 (orange_button);
		_g_object_unref0 (banana_button);
		_g_object_unref0 (lime_button);
		_g_object_unref0 (mint_button);
		_g_object_unref0 (blueberry_button);
	}
	_tmp211_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp211_, GTK_ALIGN_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp211_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp211_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp211_);
	animations_switch = _tmp211_;
	_tmp212_ = animations_switch;
	_tmp213_ = _g_object_ref0 ((GtkWidget*) _tmp212_);
	_tmp214_ = g_strdup (_ ("Disable animations in the window manager and some other interface elem" \
"ents."));
	_tmp215_ = granite_header_label_new (_ ("Reduce Motion"));
	granite_header_label_set_mnemonic_widget (_tmp215_, _tmp213_);
	_g_object_unref0 (_tmp213_);
	granite_header_label_set_secondary_text (_tmp215_, _tmp214_);
	_g_free0 (_tmp214_);
	g_object_ref_sink (_tmp215_);
	animations_label = _tmp215_;
	_tmp216_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp216_, 18);
	g_object_ref_sink (_tmp216_);
	animations_box = _tmp216_;
	_tmp217_ = animations_box;
	_tmp218_ = animations_label;
	gtk_box_append (_tmp217_, (GtkWidget*) _tmp218_);
	_tmp219_ = animations_box;
	_tmp220_ = animations_switch;
	gtk_box_append (_tmp219_, (GtkWidget*) _tmp220_);
	_tmp221_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp221_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp221_);
	scrollbar_switch = _tmp221_;
	_tmp222_ = scrollbar_switch;
	_tmp223_ = _g_object_ref0 ((GtkWidget*) _tmp222_);
	_tmp224_ = g_strdup (_ ("Scrollbars will take up space, even when not in use."));
	_tmp225_ = granite_header_label_new (_ ("Always Show Scrollbars"));
	gtk_widget_set_hexpand ((GtkWidget*) _tmp225_, TRUE);
	granite_header_label_set_mnemonic_widget (_tmp225_, _tmp223_);
	_g_object_unref0 (_tmp223_);
	granite_header_label_set_secondary_text (_tmp225_, _tmp224_);
	_g_free0 (_tmp224_);
	g_object_ref_sink (_tmp225_);
	scrollbar_label = _tmp225_;
	_tmp226_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp226_, 18);
	g_object_ref_sink (_tmp226_);
	scrollbar_box = _tmp226_;
	_tmp227_ = scrollbar_box;
	_tmp228_ = scrollbar_label;
	gtk_box_append (_tmp227_, (GtkWidget*) _tmp228_);
	_tmp229_ = scrollbar_box;
	_tmp230_ = scrollbar_switch;
	gtk_box_append (_tmp229_, (GtkWidget*) _tmp230_);
	_tmp231_ = grid;
	_tmp232_ = animations_box;
	gtk_grid_attach (_tmp231_, (GtkWidget*) _tmp232_, 0, 10, 2, 1);
	_tmp233_ = grid;
	_tmp234_ = scrollbar_box;
	gtk_grid_attach (_tmp233_, (GtkWidget*) _tmp234_, 0, 11, 2, 1);
	_tmp235_ = grid;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp235_);
	gtk_widget_add_css_class ((GtkWidget*) self, "appearance-view");
	_tmp236_ = g_settings_new ("io.elementary.desktop.wm.animations");
	animations_settings = _tmp236_;
	_tmp237_ = animations_settings;
	_tmp238_ = animations_switch;
	g_settings_bind (_tmp237_, "enable-animations", (GObject*) _tmp238_, "active", G_SETTINGS_BIND_INVERT_BOOLEAN);
	_tmp239_ = interface_settings;
	_tmp240_ = scrollbar_switch;
	g_settings_bind (_tmp239_, "overlay-scrolling", (GObject*) _tmp240_, "active", G_SETTINGS_BIND_INVERT_BOOLEAN);
	_tmp241_ = g_settings_new ("io.elementary.desktop.background");
	background_settings = _tmp241_;
	_tmp242_ = background_settings;
	_tmp243_ = dim_switch;
	g_settings_bind (_tmp242_, "dim-wallpaper-in-dark-style", (GObject*) _tmp243_, "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (background_settings);
	_g_object_unref0 (animations_settings);
	_g_object_unref0 (scrollbar_box);
	_g_object_unref0 (scrollbar_label);
	_g_object_unref0 (scrollbar_switch);
	_g_object_unref0 (animations_box);
	_g_object_unref0 (animations_label);
	_g_object_unref0 (animations_switch);
	_g_free0 (current_stylesheet);
	_g_object_unref0 (interface_settings);
	_g_object_unref0 (grid);
	_g_free0 (user_path);
	_g_object_unref0 (schedule_label);
	_g_object_unref0 (schedule_box);
	_g_object_unref0 (schedule_manual_radio);
	_g_object_unref0 (schedule_manual_box);
	_g_object_unref0 (to_label);
	_g_object_unref0 (from_label);
	_g_object_unref0 (schedule_sunset_radio);
	_g_object_unref0 (dim_box);
	_g_object_unref0 (dim_label);
	_g_object_unref0 (dim_switch);
	_g_object_unref0 (prefer_style_box);
	_g_object_unref0 (prefer_dark_grid);
	_g_object_unref0 (dark_preview);
	_g_object_unref0 (prefer_default_grid);
	_g_object_unref0 (default_preview);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return obj;
}

static void
pantheon_shell_appearance_class_init (PantheonShellAppearanceClass * klass,
                                      gpointer klass_data)
{
	pantheon_shell_appearance_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = pantheon_shell_appearance_constructor;
}

static void
pantheon_shell_appearance_instance_init (PantheonShellAppearance * self,
                                         gpointer klass)
{
}

static GType
pantheon_shell_appearance_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellAppearanceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_appearance_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonShellAppearance), 0, (GInstanceInitFunc) pantheon_shell_appearance_instance_init, NULL };
	GType pantheon_shell_appearance_type_id;
	pantheon_shell_appearance_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "PantheonShellAppearance", &g_define_type_info, 0);
	return pantheon_shell_appearance_type_id;
}

GType
pantheon_shell_appearance_get_type (void)
{
	static volatile gsize pantheon_shell_appearance_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_appearance_type_id__once)) {
		GType pantheon_shell_appearance_type_id;
		pantheon_shell_appearance_type_id = pantheon_shell_appearance_get_type_once ();
		g_once_init_leave (&pantheon_shell_appearance_type_id__once, pantheon_shell_appearance_type_id);
	}
	return pantheon_shell_appearance_type_id__once;
}

